const _ = require('lodash');
const bcrypt = require('bcryptjs');
const Model = require('../General/Model');
const H = require('../General/Helper');
const UserRule = require('../Users/Rule');
const config     = require('../config');
const UPLOAD_URL = config.avatarUrl;

const Admin = {};

/*
 * Upload a Avatar
*/
Admin.uploadAvatar = function(name, avatar, callback){
	let fullAvatar = UPLOAD_URL + avatar;
	Model.query('UPDATE users SET avatar = $1 WHERE name = $2', [fullAvatar, name], function (err, result) {
		if (err) {
			console.log('error admin role: 18', err)
			return callback(false);
		}
		return callback({ status: true, file: name });
	});
}

/*
 * Mute a User
*/
Admin.changeMute = function(name, callback){
    UserRule.getUserInfoByName(name, (result, error) => {
        let id = _.toNumber(result.id);
        let muted = result.muted;
        let set;

        if(muted){
            set = false
        }
        else {
            set = true
        }
        Model.query('UPDATE users SET muted = $1 WHERE id = $2', [set, id], (err, results) => {
            if(err){
                console.log('error muted: ', err);
                callback(false, true)
            }
            else callback(true, false)
        })
    })
}


/*
 * Add a Chat
*/
Admin.addChat = function (name, country, message, callback) {
	country = _.lowerCase(country);

    UserRule.getIdByName(name, (id, err) => {
        if(err) return;
        
        id = _.toNumber(id);
        
    	Model.query('SELECT avatar, level FROM users WHERE id = $1', [id], function (err, results) {
    		if (err){
    			console.log('error on admin: 14', err)
    			return callback(false, true);
    		}

            if(results === 'undefined') return;

            let time = H.getCurrentTime(new Date());
            let sorter = _.toNumber(new Date().getTime());
            let avatar = results.rows[0].avatar;
            let level = results.rows[0].level;
    		let table = 'chat_' + country;
			
			level = (level !== undefined) ? level : 1;

    		Model.query('INSERT INTO ' + table + '(name, uid, avatar, message, time, sorter, level) VALUES($1, $2, $3, $4, $5, $6, $7)',
    		[name, id, avatar, message, time, sorter, level],
    		 function (err, result) {
    		 	if(err){
    		 		return callback(false, true)
    		 	}
    		 	else 
    		 	{
                    callback({
                        country: country,
                        message: message,
                        name: name,
                        uid: id,
                        avatar: avatar,
                        time: time,
                        date: H.getCurrentDate(new Date()),
                        sorter: sorter,
                        level: level
                    }, false);
    		 	}
    		});
        });
    });
};

/*
 * Create User
*/
function CreateUser(data, callback){
    let { username, email, password, avatar } = data;

    let PROFIT = { "btc": '0.00000000', eth: '0.00000000', usdt: '0.00000000', bch: '0.00000000', ltc: '0.00000000', trx: '0.00000000', nc: '0.00000900', doge: '0.00000000', ada: '0.00000000', xrp: '0.00000000', bnb: '0.00000000', usdp: '0.00000000', nexo: '0.00000000', mkr: '0.00000000', tusd: '0.00000000',
    usdc: '0.00000000', busd: '0.00000000' };

    const WALLET = { "btc": null, eth: null, ltc: null, bch: null, usdt: null, trx: null, nc: null, doge: null, ada: null, xrp: null, bnb: null, usdp: null, nexo: null, 
    mkr: null, tusd: null, usdc: null, busd: null };

    bcrypt.hash(password, 10, (err, hash) => {
        var id = _.toNumber(H.randomIntger(7)),
            friends = "Support",
            balance = JSON.stringify(PROFIT),
            wallet  = JSON.stringify(WALLET),
            profit_high = JSON.stringify(PROFIT),
            profit_low = JSON.stringify(PROFIT),
            profit = JSON.stringify(PROFIT);

        Model.query('INSERT INTO users(name, email, password, avatar, id, friends, balance, wallet, profit_high, profit_low, profit) VALUES($1, $2, $3, $4, $5, $6, $7, $8, $9, $10, $11)',
         [username, email, hash, avatar, id, friends, balance, wallet, profit_high, profit_low, profit], function (err, result) {
            if (err){
                console.log('error on adminRule: 123', err)
                return callback(false, true);
            }
            else callback(id, false);
        });
    });
}

/*
 * Run A Custom Database Query
*/
Admin.runQuery = function(query, callback){
    Model.query(query, function (error, result) {
        callback({error, result});
    })
}

module.exports = Admin