const pg = require('../General/Model');

 const getPaymentDetails = async (req, res) => {
    try {
        const { coin_type } = req.params;
  const query = `
    SELECT 
        id,
        coin_type,
        bank_name,
        account_number,
        ifsc_code,
        account_holder_name,
        qr_image,
        upi_id,
        created_at,
        updated_at,
        is_active
    FROM currency_payment_details 
    WHERE coin_type = $1 AND is_active = true
`;
        const result = await pg.query(query, [coin_type.toUpperCase()]);
        res.json(result.rows);
    } catch (error) {
        res.status(500).json({ error: error.message });
    }
};

 const addPaymentDetail = async (req, res) => {
    try {
        const { coin_type } = req.params;
        const {
            bank_name,
            account_number,
            ifsc_code,
            account_holder_name,
            upi_id
        } = req.body;

        let qr_image = null;
        if (req.file) {
            qr_image = req.file.buffer;
        }

        const query = `
            INSERT INTO currency_payment_details 
            (coin_type, bank_name, account_number, ifsc_code, 
             account_holder_name, qr_image, upi_id)
            VALUES ($1, $2, $3, $4, $5, $6, $7)
            RETURNING *
        `;

        const result = await pg.query(query, [
            coin_type.toUpperCase(),
            bank_name,
            account_number,
            ifsc_code,
            account_holder_name,
            qr_image,
            upi_id
        ]);

        res.status(201).json(result.rows[0]);
    } catch (error) {
        res.status(500).json({ error: error.message });
    }
};

 const updatePaymentDetail = async (req, res) => {
    try {
        const { id, coin_type } = req.params;
        const {
            bank_name,
            account_number,
            ifsc_code,
            account_holder_name,
            upi_id
        } = req.body;

        let updateFields = [];
        let values = [id];
        let valueCount = 2;

        if (bank_name) {
            updateFields.push(`bank_name = $${valueCount++}`);
            values.push(bank_name);
        }
        if (account_number) {
            updateFields.push(`account_number = $${valueCount++}`);
            values.push(account_number);
        }
        if (ifsc_code) {
            updateFields.push(`ifsc_code = $${valueCount++}`);
            values.push(ifsc_code);
        }
        if (account_holder_name) {
            updateFields.push(`account_holder_name = $${valueCount++}`);
            values.push(account_holder_name);
        }
        if (upi_id) {
            updateFields.push(`upi_id = $${valueCount++}`);
            values.push(upi_id);
        }
        if (req.file) {
            updateFields.push(`qr_image = $${valueCount++}`);
            values.push(req.file.buffer);
        }

        const query = `
            UPDATE currency_payment_details 
            SET ${updateFields.join(', ')}
            WHERE id = $1 AND coin_type = $${valueCount}
            RETURNING *
        `;
        values.push(coin_type.toUpperCase());

        const result = await pg.query(query, values);
        if (result.rows.length === 0) {
            return res.status(404).json({ error: 'Payment detail not found' });
        }
        res.json(result.rows[0]);
    } catch (error) {
        res.status(500).json({ error: error.message });
    }
};

const deletePaymentDetail = async (req, res) => {
    try {
        const { id, coin_type } = req.params;

        const query = `
            UPDATE currency_payment_details 
            SET is_active = false
            WHERE id = $1 AND coin_type = $2
            RETURNING *
        `;

        const result = await pg.query(query, [id, coin_type.toUpperCase()]);
        
        if (result.rows.length === 0) {
            return res.status(404).json({ error: 'Payment detail not found' });
        }
        
        res.json({ message: 'Payment detail deleted successfully' });
    } catch (error) {
        res.status(500).json({ error: error.message });
    }
};
module.exports = {
    getPaymentDetails,
    addPaymentDetail,
    updatePaymentDetail,
    deletePaymentDetail
};