// const assert = require('assert');
const assert = () => {}
const _ = require('lodash');
const Rule = require('../Rule');
const Hash = require('../Hash');
const Queue = require('../../General/Queue');
const { encode } = require('../../General/Buffer');
const C = require('../../General/Constant');
const H = require('../../General/Helper');

class Blackjack {
    constructor(io, client, data, id){
        this.io = io
        this.client = client
        this.data = data
        this.id = _.toNumber(id)
    }

    /*
 	 * Send Data To Client
    */
    emit(data){
		this.client.emit(C.PLAY_BLACKJACK, encode(data))
    }

    /*
	 * Intialize Game
    */
    init(){
		let { command } = this.data;

		switch(command)
		{
			case 'play':
				return this.play();
				
			case 'busted':
				return this.busted();
		}
    }

    /*
     * Play Game
    */
    play(){
    	let self = this;

		Rule.CanPlay(self.id, self.data, self.client, 'blackjack', (status, err) => {
			if(status !== true)
            {
				return this.emit({ command: 'error', uid: self.id, message: status, code: err })
			}

			Rule.preparePlay(self.client, self.id, 'blackjack', self.data, (isOk) => {
				if(!isOk){
					console.log('Error Blackjack Playing: 56')
					return false;
				}
				
				//Generate Random Hash and Result
	            let rand = Hash.make();
	            let hash = rand.hash;
	            // let result = rand.result;

	            let amount = self.data.amount;

	            //Update Queue and Save Result
	            // Queue.update(self.id, 'uid', 'result', result);
	            Queue.update(self.id, 'uid', 'hash', hash);
	            Queue.update(self.id, 'uid', 'amount', amount);

				//Send Play Game
				this.emit({ command: 'play' })
			})
		})
    }

    /*
	 * Busted Game
    */
    busted(){
    	let self = this;

		let { profit, coin, pCards, dCards } = self.data;

		//Get The Client Game Info
		let info = Queue.getOne('uid', self.id)

		if(!info) {
			console.log('Client Not Playing!', self.id)
			return false;
		}

		let result = { pCards, dCards }

	    let hash = info.hash;
	    let amount = info.amount;

	    let isWinner = true;

	    if(_.toNumber(profit) === 0.00000000)
		{
	    	isWinner = false;
		    profit = -amount;}
	    else {
	    	profit = H.CryptoSet(_.toNumber(amount) , coin);
	    }

	    Rule.prepareBusted(self.client, self.io, self.id, 'blackjack', info.data, profit, result, hash, isWinner, (res) => {
	    	if(res){
				self.emit({ command: 'busted',profit:profit })
	    	}
	    })
    }
}

module.exports = Blackjack;