"use strict";

// Required Libraries
var SHA256 = require("crypto-js/sha256");

const Result = {};

// 30% Win Logic Implementation

Result.make = function (canProfit, payout, type) {
  let hash, result;
  console.log('Result.make called with canProfit:', canProfit, 'payout:', payout, 'type:', type);
  
  const winChance = 0.3; // 30% win
  let shouldWin;
  
  // Determine win/loss based on type parameter
  if (type === 'force_win') {
    shouldWin = true;
  } else if (type === 'force_loss') {
    shouldWin = false;
  } else {
    // If type is NaN, null, undefined, or any other value, use random logic
    const random = Math.random();
    shouldWin = random <= winChance;
  }
  
  if (shouldWin) {
    // Force win: generate result <= payout
    do {
      hash = makeHash();
      result = makeResult(hash);
    } while (parseFloat(result) < parseFloat(payout));
  } else {
    // Force loss: generate result > payout
    console.log('Generating result for loss');
    do {
      hash = makeHash();
      result = makeResult(hash);
    } while (parseFloat(result) >= parseFloat(payout));
  }
console.log('Generated hash:', hash, 'result:', result);

  return { hash, result };
};

function makeHash() {
  var key = "00000000000000" + randomString(50);
  return SHA256(key).toString();
}

function makeResult(seed) {
  let hash = SHA256(seed).toString();
  let h = parseInt(hash.slice(0, 13), 16);
  let e = Math.pow(2, 52);
  let result = Math.floor((98 * e) / (e - h));
  return (result / 100).toFixed(2);
}

function randomString(length) {
  var chars = "0123456789abcdefghiklmnopqrstuvwxyz".split("");
  var str = "";
  for (var i = 0; i < length; i++) {
    str += chars[Math.floor(Math.random() * chars.length)];
  }
  return str;
}

// Export the module
module.exports = Result;