const assert = require("assert");
const _ = require("lodash");
const Rule = require("../Rule");
const Buffer = require("../../General/Buffer");
const C = require("../../General/Constant");
const H = require("../../General/Helper");
const Result = require("./Result");
const { decide ,roundCompleted} = require('../../gameEngine/GameOutcomeEngine');

class Limbo {
  constructor(io, client, data, id) {
    this.io = io;
    this.client = client;
    this.data = data;
    this.id = _.toNumber(id);
  }

  /*
   * Send Data To Client
   */
  emit(data) {
    this.client.emit(C.PLAY_LIMBO, Buffer.encode(data));
  }

  /*
   * Intialize Game
   */
  init() {
    return this.play();
  }

  /*
   * Play Game
   */
  play() {
    let self = this;

    Rule.CanPlay(self.id, self.data, self.client, "limbo", (can, err) => {
      if (can !== true) {
        return self.emit({
          command: "error",
          uid: self.id,
          message: can,
          code: err,
        });
      }
      console.log('Limbo Play Data:', self.data);

      Rule.checkLimited(self.id, self.data.coin, (status) => {
        Rule.preparePlay(self.client, self.id, "limbo", self.data, async (isOk) => {
          if (!isOk) {
            console.log("Error Limbo Playing: 50");
            return false;
          }
           console.log('Limbo Play Data:', self.data);
          //Game Bet Amount / Payout
          let { amount, payout } = self.data;
          const type = await decide(self.id, 'limbo', self.data.coin);
          
          if (!amount && !payout) return;

          amount = _.toNumber(amount);

          payout = parseFloat(payout);
          payout = payout.toFixed(2);

          if (payout < "1.01") return;
          if (payout < 1.01) return;

          //Generate Random Hash and Result
          let randomResult = Result.make(status, payout,type);
          let hash = randomResult.hash;
          let result = randomResult.result;

          assert(result);

          result = parseFloat(result);
          result = result.toFixed(2);

          //Default Values
          let isWinner = false;
          let profit = 0.0;
          console.log('Limbo Play Data:', self.data, 'Result:', result, 'Payout:', payout);

          //Calculate Client is Winner or Lost
          if (result > payout) {
            isWinner = true;
            // var rate = Math.pow(Math.E, 6e-5 * (ts - timeStart)).toFixed(2);
            // var winning = amount * (rate - 1);
            profit = amount * payout - amount;
          } else {
            if (result < payout) {
              isWinner = false;
              profit = -amount;
            }
          }
          

          profit = H.CryptoSet(profit, self.data.coin);

          //Send Play Game
          self.emit({ command: "play", target: result, profit: profit });

          //Busted Game
         H.wait(50).then(() => {
  Rule.prepareBusted(
    self.client,
    self.io,
    self.id,
    "limbo",
    self.data,
    profit,
    result,
    hash,
    isWinner,
    async (res, gid) => { // Now receives both res and gid
      console.log('Busted Result:', isWinner, 'selfid:', self.id);
      console.log('Busted Data:', self.data);
      console.log("res", res);
      console.log("gid", gid); // Now you have access to gid
      
      if (res) {
        self.emit({ command: "busted", profit: profit });
        // Now you can use gid here
        let val 
                      if(isWinner){
                         val = 'win'
                      }
                      else{
                          val = 'loss'
                      }
        await roundCompleted(gid, self.id, self.data.coin, val)
      }
    }
  );
});
         

        });
      });
    });
  }
}

module.exports = Limbo;
