"use strict";

//Random Generate Hash/Result for Magic Wheel.

//Required Libs
var SHA256 = require("crypto-js/sha256");

const Result = {};

Result.make = function (canProfit) {
  let hash = makeHash();
  let result = makeResult(hash, canProfit);
  return { hash, result };
};

function makeHash() {
  var seed = "00000000000000" + randomString(50);
  return SHA256(seed).toString();
}

function makeResult(hash, canProfit) {
  // let numbers = [2, 12, 24, 36, 45, 'NEXT'];
  let numbers = [2, 12, 24, 36, "NEXT"];

  // if (!canProfit) {
  //     return [24, 24, 24, 24, 24]
  // }

  let arr = [];
  for (var i = 0; i < 3; i++) {
    arr.push(numbers[getRandomInt(numbers.length)]);
  }

  if (arr[0] === "NEXT") {
    arr[0] = 45;
  }

  return arr;
}

function randomString(length) {
  var chars = "0123456789abcdefghiklmnopqrstuvwxyz".split("");
  var str = "";
  for (var i = 0; i < length; i++) {
    str += chars[Math.floor(Math.random() * chars.length)];
  }
  return str;
}

function getRandomInt(length) {
  return Math.floor(Math.random() * length);
}

// Export the Result module
module.exports = Result;
