'use strict';

//Random Generate Hash/Result for all games.

//Required Libs
var _ = require('lodash')
var SHA256 = require("crypto-js/sha256");
var H = require("../../General/Helper");

const Result = {}

Result.make = function() {
    let hash = makeHash();
    let result = makeResult(hash);
    return { hash, result };
}

function makeHash() {
    var key = "00000000000000" + randomString(50);
    var gameHash = SHA256(key).toString()
    return gameHash;
}

function makeResult(seed) {
    let arr = [];
    let cards = ['heart', 'spade', 'wajit'];
    return _.shuffle(cards)
}

function randomString(length) {
    var chars = '0123456789abcdefghiklmnopqrstuvwxyz'.split('');
    var str = '';
    for (var i = 0; i < length; i++) {
        str += chars[Math.floor(Math.random() * chars.length)];
    }
    return str;
}

// Export the Hash module
module.exports = Result;