'use strict';

//Random Generate Hash/Result

//Required Libs
var SHA256 = require("crypto-js/sha256");
const H = require('../../General/Helper');

const Hash = {}

Hash.make = function(canProfit, segment) {
    let hash    = makeHash();
    let result  = makeResult( hash, parseFloat(segment) - 1 );

    if(!canProfit)
    {
        let arr;

        if(segment === 8){
             arr = [ 4, 2 ];
        }

        if(segment === 11){
             arr = [ 4, 6 ];
        }

        if(segment === 21){
             arr = [ 2, 6, 8 ];
        }

        if(segment === 31){
             arr = [ 8, 2, 6 ];
        }
        
        result = arr[H.getRandomInt(arr.length)];
    }

    return { hash, result };
}

function makeHash() {
    var key = "00000000000000" + randomString(50);
    var gameHash = SHA256(key).toString()
    return gameHash;
}

function makeResult(seed, segment) {
    let hash =  SHA256(seed).toString();
    let h = parseInt(hash.slice(0, 13), 16);
    let e = Math.pow(2, 52);
    let result = Math.floor((98 * e) / (e - h));
    result = (result / 100).toFixed(0);
    var min = Math.min(result, segment)
    return min;
}

function randomString(length) {
    var chars = '0123456789abcdefghiklmnopqrstuvwxyz'.split('');
    var str = '';
    for (var i = 0; i < length; i++) {
        str += chars[Math.floor(Math.random() * chars.length)];
    }
    return str;
}

// Export the Hash module
module.exports = Hash;