const _ = require('lodash');
const Rule = require('../Rule');
const Queue = require('../../General/Queue');
const {encode} = require('../../General/Buffer');
const C = require('../../General/Constant');
const H = require('../../General/Helper');
const Result = require('./Result');

class Wheel {
    constructor(io, client, data, id) {
        this.io = io
        this.client = client
        this.data = data
        this.id = _.toNumber(id);
    }

    /*
     * Send Data To Client
     */
    emit(data) {
        this.client.emit(C.PLAY_WHEEL, encode(data))
    }

    /*
     * Intialize Game
     */
    init() {

        let {
            command
        } = this.data;

        switch (command) {
            case 'play':
                return this.play();
            case 'busted':
                return this.busted();
        }
    }

    /*
     * Play Game
     */
    play() {
        let self = this;

        Rule.CanPlay(self.id, self.data, self.client, 'wheel', (status, err) => {
            if (status !== true) {
                return this.emit({
                    command: 'error',
                    uid: self.id,
                    message: status,
                    code: err
                })
            }

            Rule.preparePlay(self.client, self.id, 'wheel', self.data, (isOk) => {
                if (!isOk) {
                    console.log('Error Wheel Playing: 21')
                    return false;
                }

                let { risk, coin, segment } = self.data;

                if (!risk) return;


                Rule.checkLimited(self.id, coin, (status) => {

                    //Generate Random Hash and Result
                    let randomResult = Result.make(status, segment);
                    let hash = randomResult.hash;
                    let result = randomResult.result;

                    //Update Queue and Save Result and Hash
                    Queue.update(self.id, 'uid', 'hash', hash);
                    Queue.update(self.id, 'uid', 'risk', risk);
                    Queue.update(self.id, 'uid', 'result', result);

                    //Send Play Game
                    this.emit({
                        command: 'play',
                        hash: hash,
                        target: result
                    });
                })

            })
        })
    }

    /*
     * End / Busted Game
     */
    busted() {
        let self = this;

        let {
            win
        } = self.data;

        //Get The Client Game Info
        let info = Queue.getOne('uid', self.id)

        if (!info) {
            console.log('Client Not Playing!', self.id)
            return false;
        }

        let hash = info.hash;
        let result = info.result;
        let risk = info.data.risk;
        let amount = info.data.amount;

        let profit = 0.00000000;
        let isWinner = false;

        if (win) {
            isWinner = true;
            
            // if is green (double)
            if (parseFloat(result) === 100) {
                // profit *= 2;
                profit = amount;
            }
            profit = _.toNumber(amount) / _.toNumber(risk);

        }

        profit = H.CryptoSet(profit);

        Rule.prepareBusted(self.client, self.io, self.id, 'wheel', info.data, profit, result, hash, isWinner, (res) => {
            if (res) {
                self.emit({
                    command: 'busted',
                    profit: profit
                })
            }
        })
    }
}

module.exports = Wheel;