const _ = require('lodash');
const {
    decode
} = require('../General/Buffer');
const C = require('../General/Constant');

//All Games Class
const ClassicDice = require('./ClassicDice');
const SingleKeno = require('./SingleKeno');
const HashDice = require('./HashDice');
const Limbo = require('./Limbo');
const Wheel = require('./Wheel');
const Mine = require('./Mine');
const Hilo = require('./Hilo');
const Crash = require('./Crash');
const KenoGame = require('./Keno');
const Plinko = require('./Plinko');
const VideoPoker = require('./VideoPoker');
const Blackjack = require('./Blackjack');
const Goal = require('./Goal');
const Roulette = require('./Roulette');
const SnakeAndLadders = require('./SnakeAndLadders');
const ThreeCardMonte = require('./ThreeCardMonte');
const MagicWheel = require('./MagicWheel');
const Tower = require('./Tower');
const Diamond = require('./Diamond');
const HighLow = require('./HighLow');

/**
 * Games Handler
 */
function Game(client, io, id) {
    /*
     * Get The Crash Status
     */
    client.on(C.STATUS_CRASH, () => {
        Crash.onStatus(client);
    })

    /*
     * Get The Crash History
     */
    client.on(C.HISTORY_CRASH, () => {
        Crash.onHistory(client);
    })

    /*
     * Get The Current Round Players
     */
    client.on(C.PLAYERS_CRASH, () => {
        Crash.onPlayers(client);
    })

    /*
     * Play Crash
     */
    client.on(C.PLAY_CRASH, (data) => {
        data = decode(data);
        if (!id) return;
        Crash.add(io, _.toNumber(id), data)
    })

    /*
     * CashOut Crash
     */
    client.on(C.FINISH_CRASH, (data) => {
        data = decode(data);
        if (!id) return;
        Crash.out(io, _.toNumber(id), data)
    })

    /*
     * Get The Keno Status
     */
    client.on(C.STATUS_KENO, () => {
        KenoGame.Status(client)
    })

    /*
     * Play Keno
     */
    client.on(C.PLAY_KENO, (data) => {
        data = decode(data);
        if (!id) return;
        KenoGame.Play(client, io, _.toNumber(id), data)
    })

    /*
     * Play Classic Dice
     */
    client.on(C.PLAY_CLASSIC_DICE, (data) => {
        data = decode(data);
        if (!id) return;
        let game = new ClassicDice(io, client, data, id);
        game.init();
    })

    /*
     * Play Hash Dice
     */
    client.on(C.PLAY_HASH_DICE, (data) => {
        data = decode(data);
        if (!id) return;
        let game = new HashDice(io, client, data, id);
        game.init();
    })

    /*
     * Play Limbo
     */
    client.on(C.PLAY_LIMBO, (data) => {
        data = decode(data);
        if (!id) return;
        let game = new Limbo(io, client, data, id);
        game.init();
    })

    /*
     * Play Mine
     */
    client.on(C.PLAY_MINE, (data) => {
        data = decode(data);
        if (!id) return;
        let game = new Mine(io, client, data, id);
        game.init();
    })

    /*
     * Play Single Keno
     */
    client.on(C.PLAY_SINGLE_KENO, (data) => {
        data = decode(data);
        if (!id) return;
        let game = new SingleKeno(io, client, data, id);
        game.init();
    })

    /*
     * Play Hilo
     */
    client.on(C.PLAY_HILO, (data) => {
        data = decode(data);
        if (!id) return;
        let game = new Hilo(io, client, data, id);
        game.init();
    })

    /*
     * Play Wheel
     */
    client.on(C.PLAY_WHEEL, (data) => {
        data = decode(data);
        if (!id) return;
        let game = new Wheel(io, client, data, id);
        game.init();
    })

    /*
     * Play Plinko
     */
    client.on(C.PLAY_PLINKO, (data) => {
        data = decode(data);
        if (!id) return;
        let game = new Plinko(io, client, data, id);
        game.init();
    })

    /*
     * Play Video Poker
     */
    client.on(C.PLAY_VIDEOPOKER, (data) => {
        data = decode(data);
        if (!id) return;
        let game = new VideoPoker(io, client, data, id);
        game.init();
    })

    /*
     * Play Blackjack
     */
    client.on(C.PLAY_BLACKJACK, (data) => {
        data = decode(data);
        if (!id) return;
        let game = new Blackjack(io, client, data, id);
        game.init();
    })

    /*
     * Play Goal
     */
    client.on(C.PLAY_GOAL, (data) => {
        data = decode(data);
        if (!id) return;
        let game = new Goal(io, client, data, id);
        game.init();
    })

    /*
     * Play Roulette
    *
    */
    client.on(C.PLAY_ROULETTE, (data) => {
        data = decode(data);
        if (!id) return;
        let game = new Roulette(io, client, data, id);
        game.init();
    })

    /*
     * Play Snake And Ladders
    *
    */
    client.on(C.PLAY_SNAKEANDLADDERS, (data) => {
        data = decode(data);
        if (!id) return;
        let game = new SnakeAndLadders(io, client, data, id);
        game.init();
    })

    /*
     * Play 3 Card Monte
    *
    */
    client.on(C.PLAY_THREE_CARD_MONTE, (data) => {
        data = decode(data);
        if (!id) return;
        let game = new ThreeCardMonte(io, client, data, id);
        game.init();
    })

    /*
     * Play Magic Wheel
    *
    */
    client.on(C.PLAY_MAGIC_WHEEL, (data) => {
        data = decode(data);
        if (!id) return;
        let game = new MagicWheel(io, client, data, id);
        game.init();
    })

    /*
     * Play Tower
    */
    client.on(C.PLAY_TOWER, (data) => {
        data = decode(data);
        if (!id) return;
        let game = new Tower(io, client, data, id);
        game.init();
    })
    /*
     * Play Diamond
    */
    client.on(C.PLAY_DIAMOND, (data) => {
        data = decode(data);
        if (!id) return;
        let game = new Diamond(io, client, data, id);
        game.init();
    })

    /*
     * Play High or Low
    */
    client.on(C.PLAY_HIGHLOW, (data) => {
        data = decode(data);
        if (!id) return;
        let game = new HighLow(io, client, data, id);
        game.init();
    })
}

module.exports = Game;