const Rule = require('./Rule');
const {encode, decode} = require('../General/Buffer');
const C = require('../General/Constant');

/**
 * Sports Handler
 */
function Sports(client, io, id) {
    /*
     * Get Sport Events
     */
    client.on(C.SPORT_GAME, (data) => {
        let { game } = decode(data);
        Rule.SportEvent(game, (result) => {
            client.emit(C.SPORT_GAME, encode(result));
        })
    });

}

module.exports = Sports;