const _ = require('lodash');
const C = require('../General/Constant');
const H = require('../General/Helper');
const Model = require('../General/Model');

/*
 * Token Object
 */
const Token = {};

/*
 * Get User ID By Token
 */
Token.getID = function (token, callback) {
    if (!token && _.isNull(token) && _.isUndefined(token))
        return callback(false, true);

    Model.query('SELECT uid FROM tokens WHERE key = $1', [token], function (err, results) {
        if (err) {
            console.log('ERROR on Token : 20', err);
            return callback(false, true);
        } else {
            try {
                if (results.rows.length !== 0) {
                    if (!_.isUndefined(results.rows[0])) {
                        callback(results.rows[0].uid, false);
                    } else {
                        callback(false, true)
                    }
                } else {
                    callback(false, true);
                }
            } catch (e) {
                console.log(e.messages)
            }
        }
    });
}

/*
 * Get Token By id
 */
Token.getToken = function (id, callback) {
    if (!id && _.isNull(id) && _.isUndefined(id))
        return callback(false, true);

    Model.query('SELECT key FROM tokens WHERE uid = $1', [id], function (err, results) {
        if (err) {
            console.log('ERROR on Token : 20', err);
            return callback(false, true);
        } else {
            try {
                if (results.rows.length !== 0) {
                    if (!_.isUndefined(results.rows[0])) {
                        callback(results.rows[0].key, false);
                    } else {
                        callback(false, true)
                    }
                } else {
                    callback(false, true);
                }
            } catch (e) {
                console.log(e.messages)
            }
        }
    });
}

/*
 * Create Token
 */
Token.create = function (token, uid, callback) {
    if (!token && !uid) return;

    uid = _.toNumber(uid);
    Model.query('INSERT INTO tokens(uid, key) VALUES($1, $2)', [uid, token], function (err, result) {
        if (err) {
            console.log('ERROR on UserRule : 268', err);
            return callback(null, true);
        } else {
            callback(true, false);
        }
    });
}

/*
 * Refresh Token
 */
Token.refresh = function (id, callback) {
    if (!id) return;

    let uid = _.toNumber(id);
    let token = H.randomString(25);

    Model.query('UPDATE tokens SET key = $1 WHERE uid = $2', [token, uid], function (err, res) {
        if (err) {
            console.log('Error on Refreshing Token: 84', err);
            return callback(null);
        }
        callback(token)
    });
}

module.exports = Token;