const _ = require("lodash");
const Token = require("./Token");
const Rule = require("./Rule");
const Notify = require("./Notify");
const config = require("../config");
const H = require("../General/Helper");
const C = require("../General/Constant");
const { encode, decode } = require("../General/Buffer");

let luckeyUsers = [],
  now = [],
  after = [];

/*
 * User Socket Handler
 */
function User(client, io, id, siofu) {
  /**
   * Luckey Wheel
   */
  client.on("wheeler", (data) => {
    if (!id) return;
    id = parseFloat(id);
    if (!_.includes(luckeyUsers, id)) {
      client.emit(
        "wheeler",
        encode({
          status: true,
        })
      );
      luckeyUsers.push(id);
    } else {
      client.emit(
        "wheeler",
        encode({
          status: false,
        })
      );
    }
  });

  /**
   * Authentication User
   */
  client.on(C.ONLINE, () => {
    Rule.authentication(client, id, (result) => {
      client.emit(C.ONLINE, encode(result));
    });
  });

  /**
   * Authentication User after login
   */
  client.on(C.ONLINE_LOGGED, (data) => {
    let { token } = decode(data);
    if (!token) return;
    Token.getID(token, (idd) => {
      Rule.authentication(client, idd, (result) => {
        client.emit(C.ONLINE_LOGGED, encode(result));
      });
    });
  });

  /**
   * Logout User
   */
  client.on(C.LOGOUT_USER, (data) => {
    Token.refresh(id, () => {});
  });

  /**
   * Get User ID
   */
  client.on(C.GET_UID, (data) => {
    if (!id) return;
    client.emit(C.GET_UID, encode(id));
  });

  client.on(C.RAKEBACK_AMOUNT, () => {
    if (!id) return;

    Rule.checkRakeAmount(id, (result) => {
      client.emit(C.RAKEBACK_AMOUNT, encode(result));
    });
  });

  client.on(C.ADD_RAKEBACK, () => {
    if (!id) return;
    Rule.addRakeback(id, (result) => {
      client.emit(C.ADD_RAKEBACK, encode(result));
    });
  });

  /**
   * Client Login
   */
  client.on(C.LOGIN_USER, (data) => {
    let { username, password, recaptcha } = decode(data);
    Rule.login(username, password, recaptcha, (result) => {
      client.emit(C.LOGIN_USER, encode(result));
    });
  });

  /**
   * Client Login by Google
   */
  client.on(C.LOGIN_USER_GOOGLE, (data) => {
    let { username, email, token } = decode(data); // Add token to destructuring
    // Pass the token to loginByGoogle
    Rule.loginByGoogle(username, email, token, (result) => {
        client.emit(C.LOGIN_USER, encode(result));
    });
});

  /**
   * Client Register
   */
  client.on(C.REGISTER_USER, (data) => {
    let { username, password, email, phone,method, aff,refree,country} = decode(data);
    Rule.register(username, password, email,phone,method, aff, refree,country,(result) => {
      client.emit(C.REGISTER_USER, encode(result));
    });
  });

  /**
   * Client Reset Password
   */
  // client.on(C.RESET_PASSWORD, (data) => {
  //   let { email } = decode(data);
  //   if (!email) return;
  //   Rule.resetClientPassword(email, (result) => {
  //     client.emit(C.RESET_PASSWORD, encode(result));
  //   });
  // });
  client.on(C.RESET_PASSWORD, (data) => {
    let { email } = decode(data);
    if (!email) {
        console.log('No email provided in RESET_PASSWORD request');
        return client.emit(C.RESET_PASSWORD, encode({ status: false, message: 'No email provided' }));
    }
    Rule.resetClientPassword(email, (result) => {
        console.log('Sending reset password result:', result);
        client.emit(C.RESET_PASSWORD, encode(result));
    });
});
  /**
   * Generate 2FA Key
   */
  client.on(C.TWO_FA, (data) => {
    if (!id) return;
    Rule.generateTwoFa(id, (result) => {
      client.emit(C.TWO_FA, encode(result));
    });
  });

  /**
   * Confirm 2FA
   */
  client.on(C.TWO_FA_CONFIRM, (data) => {
    let { code, password } = decode(data);
    if (!id) return;
    Token.getToken(id, (token) => {
      Rule.confirmTwoFa(token, id, code, password, (result) => {
        client.emit(C.TWO_FA_CONFIRM, encode(result));
      });
    });
  });

  /**
   * Disable 2FA Key
   */
  client.on(C.TWO_FA_DISABLE, (data) => {
    let { code, password } = decode(data);
    if (!id) return;
    Rule.disableTwoFa(id, code, password, (result) => {
      client.emit(C.TWO_FA_DISABLE, encode(result));
    });
  });

  /**
   * Get Slot Games List
   */
  client.on(C.GAMES, () => {
    Rule.getGamesList((result) => {
      client.emit(C.GAMES, encode(result));
    });
  });

  /**
   * Client Credit
   */
  client.on(C.CREDIT, (data) => {
    if (!id) return;
    Rule.getClientCredit(id, (result) => {
      client.emit(C.CREDIT, encode({ credit: result }));
    });
  });

  /**
   * Client Bets
   */
  client.on(C.MY_BETS, (data) => {
    let { game } = decode(data);
    if (!id) return;
    Rule.getClientBets(id, game, (result) => {
      client.emit(C.MY_BETS, encode({ history: result }));
    });
  });

  /**
   * Client History
   */
  client.on(C.MY_HISTORY, (data) => {
    if (!id) return;
    Rule.getClientHistory(id, (result) => {
      client.emit(C.MY_HISTORY, encode({ history: result }));
    });
  });

  /**
   * Chats
   */
  client.on(C.CHATS, (data) => {
    let country = "global";
    Rule.getChats(country, (result) => {
      client.emit(C.CHATS, result);
    });
  });

  /**
   * Add a Chat
   */
  client.on(C.ADD_CHAT, (data) => {
    let { country, message } = data;
    if (!id) return;

    //Limit Send Message below 2 seconds each user
    now[id] = new Date().getTime();
    let check = now[id] - after[id];
    if (check < 2000) return;

    Rule.addChat(id, country, message, (result) => {
      after[id] = new Date().getTime();
      io.emit(C.ADD_CHAT, result);
    });
  });

  /**
   * Make a Rain
   */
  client.on(C.RAIN, (data) => {
    let { amount, players, room, coin } = data;
    if (!id) return;
    Token.getToken(id, (token) => {
      if (!token) return console.log("no token");
      Rule.makeRain(
        token,
        id,
        amount,
        coin,
        players,
        room,
        (result, rainStatus, error) => {
          client.emit(C.RAIN, rainStatus);
          H.wait(500).then(() => {
            io.emit(C.ADD_CHAT, result);
          });
        }
      );
    });
  });

  /**
   * Add a Friend
   */
  client.on(C.MY_FRIENDS, (data) => {
    if (!id) return;
    Rule.myFriends(id, (result) => {
      client.emit(C.MY_FRIENDS, encode(result));
    });
  });

  /**
   * Add a Friend
   */
  client.on(C.ADD_FRIEND, (data) => {
    let { name } = decode(data);
    if (!id) return;
    Rule.addFriend(id, name, (result) => {
      client.emit(C.ADD_FRIEND, encode(result));
    });
  });

  /**
   * Send Tip
   */
  client.on(C.SEND_TIP, (data) => {
    let { target, amount, coin } = decode(data);
    if (!id) return;
    Rule.getIdByName(target, (targetID) => {
      Rule.sendTip(id, targetID, amount, coin, (result, error) => {
        io.to(parseFloat(targetID)).emit(C.SEND_TIP, encode(result));
        client.emit(C.SEND_TIP_SELF, encode(result));
      });
    });
  });

  /**
   * Edit Account
   */
  client.on(C.EDIT_ACCOUNT, (data) => {
    let { email, username } = decode(data);
    if (!id) return;
    Rule.editAccount(id, email, username, (result) => {
      client.emit(C.EDIT_ACCOUNT, encode(result));
    });
  });

  /**
   * Edit Passwrod
   */
  client.on(C.EDIT_PASSWORD, (data) => {
    let { password } = decode(data);
    if (!id) return;
    Rule.editPassword(id, password, (result) => {
      client.emit(C.EDIT_PASSWORD, encode(result));
    });
  });

  /**
   * Wallet History
   */
  client.on(C.WALLET_HISTORY, (data) => {
    if (!id) return;
    Rule.walletHistory(id, (result) => {
      client.emit(C.WALLET_HISTORY, encode(result));
    });
  });

  client.on(C.inr_History, (data) => {
    
    Rule.inrHistory(id, (result) => {
      client.emit(C.inr_History, encode(result));
    });
  });

  /**
   * Submit New Withdrawal
   */
  client.on(C.SUBMIT_NEW_WITHDRAWL, (data) => {
    let { wallet, amount, immed, coin, password,chain } = decode(data);
    if (!id) return;
    Rule.newWithdrawal(id, wallet, amount, coin, immed, password,chain, (result) => {
      client.emit(C.SUBMIT_NEW_WITHDRAWL, encode(result));
    });
  });

  client.on(C.SUBMIT_NEW_SWAP, (data) => {
    let { amount, amount1, coin, coin1, immed } = decode(data);
    if (!id) return;
    Rule.swapCoins(id, amount, amount1, coin, coin1, immed, (result) => {
      client.emit(C.SUBMIT_NEW_SWAP, encode(result));
    });
  });

  /**
   * Submit New Withdrawal
   */
  client.on(C.CREDIT_COIN, (data) => {
    let { coin } = decode(data);
    if (!id) return;
    Rule.creditCoin(id, coin, (result) => {
      client.emit(C.CREDIT_COIN, encode(result));
    });
  });

  /**
   * Get Wallet Address
   */
  
  client.on(C.GET_ADDRESS, (data) => {
    let { coin , chain } = decode(data);
    if (!id) return;
    Rule.getWalletAddress(id, coin, chain,(result) => {
      console.log(result);
      client.emit(C.GET_ADDRESS, encode(result));
    });
  });

  /**
   * BankRoll Amount
   */
  client.on(C.BANKROLL, (data) => {
    // let { game, coin } = decode(data);
    // Rule.getBankRoll(game, coin, (result) => {
    //     client.emit(C.BANKROLL, encode(result));
    // })
  });

  /**
   * User Info
   */
  client.on(C.USER_INFO, (data) => {
    let { id, coin, first, rate } = decode(data);

    if (_.isNaN(_.toNumber(id))) {
      Rule.getUserIdByName(id, (uid) => {
        Rule.userInfo(uid, coin, first, rate, (result) => {
          client.emit(C.USER_INFO, encode(result));
        });
      });
    } else {
      Rule.userInfo(id, coin, first, rate, (result) => {
        client.emit(C.USER_INFO, encode(result));
      });
    }
  });

  /**
   * Game Details
   */
  client.on(C.GAME_DETAILS, (data) => {
    let { id } = decode(data);
    Rule.gameDetails(id, (result) => {
      client.emit(C.GAME_DETAILS, encode(result));
    });
  });

  /**
   * User Chart
   */
  client.on(C.USER_CHART, (data) => {
    let { id, game, coin } = decode(data);
    Rule.userChart(id, game, coin, (result) => {
      client.emit(C.USER_CHART, encode(result));
    });
  });

  /**
   * Messages
   */
  client.on(C.MESSAGES, (data) => {
    let { name } = decode(data);
    if (!id) return;
    Token.getToken(id, (token) => {
      if (!token) return;
      Rule.messages(token, id, name, (result) => {
        client.emit(C.MESSAGES, encode(result));
      });
    });
  });

  /**
   * Send a Private Messages
   */
  client.on(C.ADD_MESSAGES, (data) => {
    let { to, message } = decode(data);
    Token.getToken(id, (token) => {
      if (!token) return;
      Rule.addMessages(token, id, to, message, (result) => {
        Rule.getIdByName(to, function (targetID) {
          io.to(parseFloat(targetID))
            .to(parseFloat(id))
            .emit(C.ADD_MESSAGES, encode(result));
        });
      });
    });
  });

  /**
   * Notifications
   */
  client.on(C.NOTIFICATION, () => {
    Rule.notifications((result) => {
      client.emit(C.NOTIFICATION, encode(result));
    });
  });

  /**
   * Get Top Winner
   */
  client.on(C.TOP_WINNERS, () => {
    Rule.topWinners((result) => {
      client.emit(C.TOP_WINNERS, result);
    });
  });

  /**
   * Get The Last Bets (for index)
   */
  client.on(C.LAST_BETS, () => {
    Rule.lastBets((result) => {
      client.emit(C.LAST_BETS, encode(result));
    });
  });

  /**
   * Get The Last Bets (for single game)
   */
  client.on(C.LAST_BETS_BY_GAME, (data) => {
    let { game } = decode(data);
    Rule.lastGameBets(game, (result) => {
      client.emit(C.LAST_BETS_BY_GAME, encode({ history: result }));
    });
  });

  /**
   * Upload User Avatar
   */
  var uploader = new siofu();
  uploader.dir = "./uploads";
  uploader.maxFileSize = 102400 * 100;
  uploader.chunkSize = 102400 * 100;
  uploader.listen(client);
  uploader.on("start", function (event) {
    if (/\.exe$/.test(event.file.name)) {
      uploader.abort(event.file.id, client);
    }
  });
  uploader.on("saved", function (event) {
    Rule.uploadAvatar(client, event, uploader, (result) => {
      client.emit(C.SAVE_AVATAR, encode(result));
    });
  });
}

module.exports = User;
