var _ = require("lodash");
var md5 = require("md5");
var UserRule = require("../Users/Rule");
var Notify = require("../Users/Notify");
var pg = require("../General/Model");
var H = require("../General/Helper");
var C = require("../General/Constant");
const { encode } = require("../General/Buffer");

// Declare Payment object
const Payment = {};

/*
 * CryptoApi Deposit Update
 */
function cryptoApi(io, data) {
  if (!data) {
    return H.log("info", `Update Deposit: Not have Data`);
  }

  H.log("info", `Update Deposit: Start ==> ${data}`);

  var c = _.split(data, "&");
  let arr = {};
  _.forEach(c, function (v) {
    var e = _.split(v, "=");
    var a = _.zip(e);
    arr[a[0]] = a[1];
  });

  let { uid, value_coin, coin, txid_in, confirmations } = arr;

  Notify.send(JSON.stringify(data), true);

  if (!uid) {
    return H.log("info", `Update Deposit: Not have uid`);
  }

  if (!value_coin) {
    return H.log("info", `Update Deposit: Not have value`);
  }

  if (!coin) {
    return H.log("info", `Update Deposit: Not have coin`);
  }

  if (!txid_in) {
    return H.log("info", `Update Deposit: Not have txid_in`);
  }

  if (!_.isUndefined(confirmations)) {
    confirmations = 1;
  }

  H.log("info", `Update Deposit First phase with amount ${value_coin}`);

  let amount = _.toNumber(value_coin);
  uid = _.toNumber(uid);

  coin = _.lowerCase(coin);
  coin = _.replace(coin, "bep 20", "");
  coin = _.replace(coin, "bsc", "");
  coin = _.replace(coin, "trc 20", "");
  coin = _.replace(coin, "trc20", "");
  coin = _.replace(coin, "trc-20", "");
  coin = _.replace(coin, "erc 20", "");
  coin = _.replace(coin, "erc20", "");
  coin = _.replace(coin, "erc-20", "");
  coin = _.replace(coin, "polygon", "");
  coin = _.trim(coin, " ");

  amount = H.CryptoSet(amount);

  if (isNaN(parseFloat(amount))) {
    H.log("info", `Update Deposit isNaN, so changed`);
    amount = _.toNumber(value_coin);
  }

  H.log("info", `Update Deposit Second phase with amount ${amount}`);

  H.log("info", `Update Deposit: Validation Complete, Going to Level 1`);

  pg.query(
  `SELECT
     uid,
     date,
     status,
     txtid,
     amount,
     coin,
     salt
   FROM deposits
   WHERE txtid = $1`,
  [txtid],
    function (err, results) {
      // if not exists
      if (results.rows.length === 0) {
        // Save txid to db
        pg.query(
          "INSERT INTO deposits(uid, amount, salt, txtid, status, coin) VALUES($1, $2, $3, $4, $5, $6)",
          [uid, amount, md5(txid_in), txid_in, confirmations, coin],
          function (err, result) {
            if (err) {
              H.log("info", `Update Deposit: get error on insert query`);
              console.log("Deposit : 60", err);
              return;
            }

            H.log("info", `Update Deposit: Level 1 Complete, Going to Level 2`);
            
            //Add User Credit
            UserRule.addBalance(uid, amount, coin, (result) => {
              //Add Max Profit
              UserRule.addMaxProfit(uid, amount, coin, async (r) => {
                H.log(
                  "info",
                  `Update Deposit: Successfully Added Balance ===> \n Uid: ${uid} \n Amount: ${amount} \n Coin: ${coin} \n `
                );

                Notify.send(
                  "A New User Deposit | Amount => " + amount + " " + coin
                );

                io.to(parseFloat(uid)).emit(
                  C.UPDATE_PAYMENT_STATUS,
                  encode({
                    message:
                      "Successfully Deposited " +
                      amount +
                      " " +
                      _.upperCase(coin),
                    amount: amount,
                    coin: coin,
                  })
                );
                              // Step 1: Fetch the refree and name from the users table based on uid
              const userResult = await pg.query('SELECT name, refree FROM users WHERE id = $1', [uid]);
              const membername = userResult.rows[0].name;
              const refree = userResult.rows[0].refree;

              // Step 2: If refree is not null or empty, process the reward logic
              if (refree) {
                // Fetch the ownername (the one who referred this user) from users table based on referalCode
                const refreeResult = await pg.query('SELECT name FROM users WHERE referalcode = $1', [refree]);
                if (refreeResult.rows.length > 0) {
                  const ownername = refreeResult.rows[0].name;

                  // Step 3: Insert entry into rewards table
                  const rewardAmount = amount * 0.05; // 5% of the deposit amount
                  await pg.query(
                    'INSERT INTO rewards(ownername, membername, referalCode, amount, coin, createdAt, updatedAt) VALUES($1, $2, $3, $4, $5, NOW(), NOW())',
                    [ownername, membername, refree, rewardAmount, coin]
                  );

                  // Step 4: Add 5% of the deposit amount to the owner's credits table
                  const coinField = coin.toLowerCase(); // e.g., btc, eth
                  await pg.query(
                    `UPDATE credits SET ${coinField} = ${coinField} + $1 WHERE uid = (SELECT id FROM users WHERE name = $2)`,
                    [rewardAmount, ownername]
                  );

                  H.log("info", `Reward entry and credit update for refree completed.`);
                }
              }
              });
            });
          }
        );
      } else {
        // H.log('info', `Update Deposit: txid_in is old: ${txid_in}`);
        // console.log('txid_in is old: ', txid_in);
      }
    }
  );
}

// Crypto Api Deposit
Payment.update = function (io, data) {
  return cryptoApi(io, data);
};

// Export the Payment module
module.exports = Payment;
