const express = require('express');
const PaymentService = require('./paymentservices');

// Configuration should be loaded from environment variables
const paymentService = new PaymentService({
    DEPOSIT_API_KEY: 'a9f2b140677334cddd1f9aa1286ffcfb', 
    WEBHOOK_ACCESS_KEY: 'f804a8414e6f76fa30ac24ee0910db00',
    WEBHOOK_PRIVATE_KEY: 'a37663558ba1de31ac2b4b2234868f5b',
    PROJECT_ID: '2877836', 
    BASE_URL: 'https://pay-crm.com'
});

const router = express.Router();

// Create Deposit Endpoint
router.post('/create-deposit', async (req, res) => {
    const client = await db.connect();

    try {
        await client.query('BEGIN');

        const depositResult = await paymentService.createDeposit(req.body, client);

        await client.query('COMMIT');

        res.json(depositResult);
    } catch (error) {
        await client.query('ROLLBACK');
        res.status(400).json({
            success: false,
            message: error.message,
            status: 'Failed',
            code: error.response?.data?.code || 400
        });
    } finally {
        client.release();
    }
});


// Deposit Info Endpoint
router.get('/deposit-info', async (req, res) => {
    try {
        const { order_id } = req.query;
        
        if (!order_id) {
            return res.status(400).json({
                success: false,
                message: 'order_id is required'
            });
        }

        const result = await paymentService.getDepositInfo(order_id);
        res.json(result);
    } catch (error) {
        res.status(400).json({
            success: false,
            message: error.message,
            code: error.response?.data?.code || 400
        });
    }
});

// Webhook Callback Endpoint
router.post('/webhook', async (req, res) => {
    try {
        const result = await paymentService.processWebhook(req.body);
        res.json(result);
    } catch (error) {
        console.error('Webhook processing error:', error);
        res.status(400).json({ 
            status: 'Error',
            message: error.message
        });
    }
});

module.exports = router;