const pg = require('../General/Model');

const checkRole = (...allowedRoles) => {
    return async (req, res, next) => {
        const roleKey = req.headers['role-key'];

        if (!roleKey) {
            return res.status(401).json({ error: 'Role key is required' });
        }

        try {
            // Fetch role from database based on the provided key
            const result = await pg.query('SELECT role FROM roles_keys WHERE role_key = $1', [roleKey]);

            if (result.rows.length === 0) {
                return res.status(403).json({ error: 'Invalid role key' });
            }

            const userRole = result.rows[0].role;

            // Check if the user's role is in the list of allowed roles
            if (!allowedRoles.includes(userRole)) {
                return res.status(403).json({ error: 'Access denied. Insufficient permissions.' });
            }

            // Attach role to request body for further use
            req.body.role = userRole;
            next();
        } catch (err) {
            res.status(500).json({ error: 'Error verifying role key' });
        }
    };
};

module.exports = { checkRole };
