const { Router } = require('express');
const c   = require('./controller');
const { protectStaff } = require('../system/middleware/auth');



const router = Router();


/* ----- staff (admin) ----- */
router.get ('/config', protectStaff, c.getConfig);
router.post('/config', protectStaff, c.upsertConfig);

/* ----- player endpoints (UID is supplied by caller) ----- */
router.get ('/progress/:uid', c.progress);          // e.g. /progress/4747556367
router.get ('/flag/:uid',     c.selectionFlag);     // returns true / false
router.post('/claim',         c.claim);             // body: { uid: 123 }
router.post('/select',        c.selectBonus);       // body: { uid: 123, bonus_type:'sports' }
router.get('/config-public', c.publicConfig);

router.put('/updateConfig', c.updateBonusConfig);
// router.get('/bonus-info')
module.exports = router;
