// jobs/bonusWatcher.js
const cron = require('node-cron');
const pg   = require('./General/Model');

/*
   Every 15 min:
     • Pull fresh wager total for every user from userwager
     • Copy that into user_bonus.wager_progress
     • Mark “completed” when progress ≥ requirement
*/
cron.schedule('*/15 * * * *', async () => {
  try {
    await pg.query(`
      WITH w AS (
        SELECT uid,
               COALESCE(wager::numeric,0) AS wager
        FROM   userwager          -- <-- holds the live wager tally
      )
      UPDATE  user_bonus ub
         SET  wager_progress = w.wager,
              status         = CASE
                                 WHEN w.wager >= ub.wager_required
                                      THEN 'completed'
                                 ELSE 'active'
                               END,
              updated_at     = now()
        FROM  w
       WHERE  ub.uid   = w.uid
         AND  ub.status IN ('active','completed');   -- don’t touch claimed/forfeited
    `);
  } catch (e) {
    console.error('[bonusWatcher]', e.message);
  }
});
