const axios = require('axios');

let conversionRates = {};

const updateConversionRates = async () => {
  try {
    const response = await axios.get('https://api.boss707.com/rate');
    conversionRates = response.data;
  } catch (error) {
    console.error('Failed to fetch conversion rates:', error.message);
  }
};

 const convertToUSDT = async (amount, coin) => {
  if (coin.toUpperCase() === 'USDT') return amount;
  if (!conversionRates[coin.toUpperCase()]) {
    console.error(`Conversion rate not found for ${coin}`);
    return amount;
  }
  const conversionRate = conversionRates[coin.toUpperCase()];
  return amount * conversionRate;
};

// Fetch conversion rates initially and set an interval to update them periodically
updateConversionRates();
setInterval(updateConversionRates, 3600000); // Update every hour

// Export the function
module.exports = {
    convertToUSDT
  };
  