// routes/exchangeRateRoutes.js
const express = require('express');
const router = express.Router();
const exchangeRateController = require('./controller');

// Get all exchange rates
router.get('/rates', exchangeRateController.getAllRates);

// Get specific currency rate
router.get('/rates/:currency', exchangeRateController.getRateByCurrency);

// Add new currency rate
router.post('/rates', exchangeRateController.addRate);

// Update existing currency rate
router.put('/rates/:currency', exchangeRateController.updateRate);

// Delete currency rate
router.delete('/rates/:currency', exchangeRateController.deleteRate);

module.exports = router;