// routes/depositRoutes.js
const express = require('express');
const router = express.Router();
const depositController = require('./controller');
const multer = require('multer');
const path = require('path');

// Configure multer for file uploads
const storage = multer.diskStorage({
    destination: function (req, file, cb) {
        cb(null, 'uploads/deposit_screenshots/');
    },
    filename: function (req, file, cb) {
        cb(null, 'deposit_' + Date.now() + path.extname(file.originalname));
    }
});

const upload = multer({
    storage: storage,
    limits: { fileSize: 5 * 1024 * 1024 }, // 5MB limit
    fileFilter: function (req, file, cb) {
        // Accept only images
        if (!file.originalname.match(/\.(jpg|jpeg|png|gif)$/)) {
            return cb(new Error('Only image files are allowed!'), false);
        }
        cb(null, true);
    }
});

// User routes
router.post('/create', upload.single('screenshot'), depositController.createDeposit);
router.get('/user-deposits', depositController.getUserDeposits);
router.get('/deposit/:depositId', depositController.getDepositById);
router.get('/screenshot/:depositId', depositController.getDepositScreenshot);

// Admin routes
router.get('/admin/all-deposits', depositController.getAllDeposits);
router.get('/admin/pending-deposits', depositController.getPendingDeposits);
router.put('/admin/approve/:depositId', depositController.approveDeposit);
router.put('/admin/reject/:depositId', depositController.rejectDeposit);

module.exports = router;