// Route: POST /api/ai/decide
const express = require('express');
const router = express.Router();

// Import your existing decide function
const { decide } = require('./GameOutcomeEngine');



router.post('/decide', async (req, res) => {
  try {
    const { uid, game, coin } = req.body;
    
    if (!uid || !game || !coin) {
      return res.status(400).json({
        error: 'Missing required fields: uid, game, coin'
      });
    }
    
    const result = await decide(uid, game, coin);
    
    res.json({
      success: true,
      ...result
    });
    
  } catch (error) {
    res.status(500).json({
      success: false,
      type: 'na',
      error: error.message
    });
  }
});

module.exports = router;
