const express = require("express");
const auth    = require('./Users/authMiddleware');
const server = express();
const app = require("http").createServer(server);
const bcrypt = require("bcryptjs");
const io = require("socket.io")(app,{
  cors:{
    // origin: "https://api.boss707.com",
    origin: ["https://admin.boss707.com/","http://localhost:3000","http://localhost:3004","http://localhost:3001","https://boss707.com","https://api.boss707.com","http://localhost:3002","http://localhost:3003"], 
    credentials: true,
    methods: ["GET", "POST"]
  }
})
const { encode } = require("../backend/General/Buffer");
const C = require("../backend/General/Constant");
const cron = require('node-cron');
const { convertToUSDT } = require('./conversiontousdt');
const fs = require('fs');
const path = require('path');
const nodemailer = require('nodemailer');
const randomstring = require('randomstring');
const bodyParser = require("body-parser");
const axios = require('axios');
const compr = require("compression");
const siofu = require("socketio-file-upload");
const cors = require("cors");
var pg = require("./General/Model");
const xss = require("xss-clean");
const helmet = require("helmet");
const _ = require("lodash");
// const jwt = require('jsonwebtoken');
const { expressjwt: jwt } = require("express-jwt");
const cluster = require("cluster");
const totalCPUs = require("os").cpus().length;


const H = require("./General/Helper");
const Market = require("./General/Market");
const Token = require("./Users/Token");
const Notify = require("./Users/Notify");
const Admin = require("./Admin");
// const Sports = require('./Sports');
const Users = require("./Users");
const Games = require("./Games");
const Bots = require("./Games/Bots");
const Crash = require("./Games/Crash");
const Keno = require("./Games/Keno");
const Deposit = require("./Wallet/Deposit");
const WalletNotify = require("./Wallet/WalletNotify");
const inr_deposit = require("./Wallet/inrdeposit");
const BlockNotify = require("./Wallet/BlockNotify");
const Slots = require("./Slots");
const SlotsRule = require("./Slots/Rule");
const md5 = require('md5');
require('dotenv').config();
const requestIp = require('request-ip');
// Require and execute cron jobs
require('./vaultpro/distributejob');
require('./vaultpro/updatedatejob');
const https = require('https');
const crypto = require('crypto');
const bonusRoutes = require('./bonus/routes');
const bannerRoutes = require('./Banners/bannerroutes');
const faroutes = require('./2fa/routes');
const swaproutes= require('./internalswap/routes');
const wpayRoutes = require('./waypay/routes');
const apayRoutes = require('./apay/routes');
const jsGamesRoutes = require('./jsgames/routes');
const jsGamesv2Routes = require('./jsgamesv2/gameRoutes');
const logger = require('./jsgamesv2/logger');
const clubRoutes = require('./clubmembership/routes');
const kycRoutes = require('./kyc/routes');
const emailRoutes = require('./emailservice/routes');
const firebaseRoutes = require('./firabsenotifcation/routes');
const exchangeRateRoutes =  require('./exchangerate/routes');
const apiGameRoutes =  require('./xgamingapi/routes');
const bankDetailsRoutes = require('./BankDetails/bankroutes');
const teamRoutes = require('./affiliate/teamaffiliateroutes');
const affiliateRoutes = require('./affiliate/affiliateroutes');
const clubNotificationRoutes = require('./clubmembership/clubnotification/routes');
const depsoitHistoryRoute = require('./depositHistory/routes');
const fiatWithdrawRoutes = require('./fiatwithdraw/routes');
const betHistoryRoutes = require('./bethistory/routes');
const clubBannerRoutes = require('./clubmembership/clubbanners/routes');
const depositRoutes = require('./fiatdeposit/routes');
const userBonusRoutes = require('./bonus/userBonusRoutes');
const adminBonusRoutes = require('./bonus/adminBonusRoutes');
const reportRoutes = require('./reports/routes');

const girRoutes = require('./gis/routes');
const userRoutes = require('./Users/routes');
const sportsRoutes = require('./sportsapi/sportsapiroutes');
const exchangeRateService = require('././updateExchangeRate');
const authRoutes = require('./system/routes/routes');
const staffRoutes = require('./system/routes/staff');
const gameEngineRoute = require('./gameEngine/routes');
const staffRoutesPublic = require('./system/routes/public');
const staffRoutesDeposit = require('./system/deposit/routes');
const sessionsRoutes = require('./sessions/routes/routes');
const  bonusRoutesWallet = require('./bonusWallet/routes');
const siteConfigAdmin = require('./siteconfig/routes/configRoutes');
const setupSiteConfigSocketSite = require('./siteconfig/sockets/configSocket');
const { initBonusCalculationCron,getUserBonusTimers } = require('./bonus/bonusCron');
require('./bonus/bonusCron');
const sportsBettingRoutes = require('./sportsbet/routes');
const { EventEmitter } = require('events');
// INstantiating the express-jwt middleware
const jwtMW = jwt({
  secret: "keyboardca4ever",
  algorithms: ["RS256"],
});

// General Config
var config = require("./config");
const { sign } = require("crypto");

let users = 0;

if (!config.developer && cluster.isMaster) {
  console.log(`Number of CPUs is ${totalCPUs}`);
  console.log(`Master ${process.pid} is running`);

  // Fork workers.
  for (let i = 0; i < totalCPUs; i++) {
    cluster.fork();
  }

  cluster.on("exit", (worker, code, signal) => {
    console.log(`worker ${worker.process.pid} died`);
    console.log("Let's fork another worker!");
    cluster.fork();
  });
} else {
  // See the react auth blog in which cors is required for access
  server.use((req, res, next) => {
    // res.setHeader('Access-Control-Allow-Origin', 'http://localhost:3004');
    res.setHeader("Access-Control-Allow-Headers", "Content-type,Authorization","Access-Control-Allow-Origin");
    next();
  });
  // parse application/json
  server.use(bodyParser.json());
  // parse application/x-www-form-urlencoded
  server.use(
    bodyParser.urlencoded({
      extended: true,
    })
  );


  server.use(cors(
    {
      origin: '*',
      credentials: true,
    
    }
  ));
  EventEmitter.defaultMaxListeners = 100;
  
  server.set("io",io);
// setup viewEngine
// configViewEngine(server);
// init Web Routes
// routes.initWebRouter(server);
  //Server Security
  server.use(
    helmet({
      crossOriginEmbedderPolicy: false,
    })
  );
  server.use(xss());
  server.use(compr());

  //Upload Image
  server.use(siofu.router);

  console.log(`Worker ${process.pid} started`);
  const appId = "uXuH7SDL75UvHaes";      // Replace with your actual CCPayment App ID
  const appSecret = "9481a3e676cd4028d535e10941e7fad6";
  const uploadsDir = path.join(__dirname, 'uploads/deposit_screenshots');
if (!fs.existsSync(uploadsDir)) {
    fs.mkdirSync(uploadsDir, { recursive: true });
}
server.use(express.text());
//  exchangeRateService.initExchangeRateUpdateJob();
 initBonusCalculationCron(io);
 require('./siteconfig/sockets/configSocket')(io);
 require('./bonusWatcher');
server.use('/jsGames',       jsGamesRoutes);
server.use('/jsGamesv2',     jsGamesv2Routes);
server.use('/api/gis',girRoutes);
function verifySignature(content, signature, app_id, app_secret, timestamp) {
  const signText = `${app_id}${timestamp}${content}`;
  const serverSign = crypto.createHmac('sha256', app_secret).update(signText).digest('hex');
  
  console.log(serverSign);
  console.log(signature);
  return serverSign === signature;
}

function getOrderInfo(orderId, callback) {
  // Check if orderId is provided
  if (!orderId) {
      return callback('orderId is required', null);
  }

  const args = JSON.stringify({ "orderId": orderId });
  const timestamp = Math.floor(Date.now() / 1000);
  const signText = appId + timestamp + args;

  // Generate the sign using HMAC SHA-256
  const sign = crypto
      .createHmac('sha256', appSecret)
      .update(signText)
      .digest('hex');

  // Define request options
  const options = {
      method: 'POST',
      headers: {
          'Content-Type': 'application/json',
          'Appid': appId,
          'Sign': sign,
          'Timestamp': timestamp.toString(),
      },
  };

  // Create the request
  const request = https.request('https://ccpayment.com/ccpayment/v2/getAppOrderInfo', options, (response) => {
      let respData = '';
      
      // Collect data as it comes in
      response.on('data', (chunk) => {
          respData += chunk;
      });

      // When the response is complete
      response.on('end', () => {
          // If successful, pass the response back via the callback
          callback(respData);
      });
  });

  // Handle request error
  request.on('error', (err) => {
      callback(err, null);
  });

  // Write the orderId argument to the request body
  request.write(args);
  request.end();
}

server.post('/api/ccpaymentnotify', async (req, res) => {
  const timestamp = req.header('Timestamp');
  const sign = req.header('Sign');
  const content = Object.keys(req.body).length === 0 ? "" : JSON.stringify(req.body);

  console.log(`Received webhook - Type: ${req.body.type}, OrderId: ${req.body.msg?.orderId}, RecordId: ${req.body.msg?.recordId}`);

  if (!verifySignature(content, sign, appId, appSecret, timestamp)) {
    console.log('Signature verification failed');
    return res.status(401).send('Invalid signature');
  }

  console.log('Signature verified successfully');

  const { type, msg } = req.body;

  if (type === 'ApiDeposit') {
    const { recordId, orderId, coinId, coinSymbol, status } = msg;

    console.log(`Processing ApiDeposit - OrderId: ${orderId}, CoinSymbol: ${coinSymbol}, Status: ${status}`);

    try {
      console.log(`Starting transaction for OrderId: ${orderId}`);
      await pg.query('BEGIN');

      // Acquire an advisory lock based on orderId
      console.log(`Acquiring advisory lock for OrderId: ${orderId}`);
      await pg.query('SELECT pg_advisory_xact_lock(hashtext($1))', [orderId]);
      console.log(`Acquired advisory lock for OrderId: ${orderId}`);

      // Check if the orderId exists and its status
      console.log(`Querying ccdeposit for OrderId: ${orderId}`);
      const depositQuery = 'SELECT userid, status FROM ccdeposit WHERE orderid = $1 LIMIT 1';
      const depositResult = await pg.query(depositQuery, [orderId]);

      if (depositResult.rows.length === 0) {
        console.log(`No matching deposit found for OrderId: ${orderId}`);
        await pg.query('COMMIT');
        console.log(`Transaction committed for OrderId: ${orderId} - No deposit found`);
        return res.status(200).send('success');
      }

      const { userid, status: depositStatus } = depositResult.rows[0];
      console.log(`Found deposit - OrderId: ${orderId}, UserId: ${userid}, Status: ${depositStatus}`);

      // Skip processing if the deposit is in a final state
      if (['Success', 'Failed', 'Rejected'].includes(depositStatus)) {
        console.log(`OrderId: ${orderId} already processed with status: ${depositStatus}`);
        await pg.query('COMMIT');
        console.log(`Transaction committed for OrderId: ${orderId} - Skipped due to final status`);
        return res.status(200).send('success');
      }

      // Fetch order info
      console.log(`Fetching order info for OrderId: ${orderId}`);
      getOrderInfo(orderId, async (orderInfoRaw) => {
        try {
          if (!orderInfoRaw) {
            console.log(`No order info found for OrderId: ${orderId}`);
            await pg.query('COMMIT');
            console.log(`Transaction committed for OrderId: ${orderId} - No order info`);
            return res.status(200).send('success');
          }

          console.log(`Received order info for OrderId: ${orderId}`);
          const orderInfo = JSON.parse(orderInfoRaw);
          console.log(`Parsed order info - OrderId: ${orderId}, PaidList length: ${orderInfo.data.paidList.length}`);

          if (orderInfo.data.paidList.length === 0) {
            console.log(`No payments made for OrderId: ${orderId}`);
            await pg.query('COMMIT');
            console.log(`Transaction committed for OrderId: ${orderId} - No payments`);
            return res.status(200).send('success');
          }

          // Process each payment in the paidList
          for (const payment of orderInfo.data.paidList) {
            console.log(`Processing payment for OrderId: ${orderId} - PaymentStatus: ${payment.status}, Amount: ${payment.amount}`);

            if (payment.status === 'Success') {
              const amount = parseFloat(payment.amount);
              const coinSymbolLower = coinSymbol.toLowerCase();
              console.log(`Updating credits for UserId: ${userid}, Coin: ${coinSymbolLower}, Amount: ${amount}`);

              // Update user's credits
              const updateQuery = `UPDATE credits SET ${coinSymbolLower} = ${coinSymbolLower} + $1 WHERE uid = $2::bigint`;
              await pg.query(updateQuery, [amount, userid]);
              console.log(`Successfully updated ${coinSymbolLower} for UserId: ${userid} by amount: ${amount}`);

              // Update deposit status to 'Success'
              const updateDepositQuery = 'UPDATE ccdeposit SET status = $1 WHERE orderid = $2';
              await pg.query(updateDepositQuery, ['Success', orderId]);
              console.log(`Updated ccdeposit status to Success for OrderId: ${orderId}`);
            } else if (payment.status === 'Processing') {
              console.log(`Payment is Processing for OrderId: ${orderId}`);
              const updateDepositQuery = 'UPDATE ccdeposit SET status = $1 WHERE orderid = $2';
              await pg.query(updateDepositQuery, ['Processing', orderId]);
              console.log(`Updated ccdeposit status to Processing for OrderId: ${orderId}`);
            } else if (payment.status === 'Failed') {
              console.log(`Payment Failed for OrderId: ${orderId}`);
              const updateDepositQuery = 'UPDATE ccdeposit SET status = $1 WHERE orderid = $2';
              await pg.query(updateDepositQuery, ['Failed', orderId]);
              console.log(`Updated ccdeposit status to Failed for OrderId: ${orderId}`);
            } else {
              console.log(`Payment status ${payment.status} treated as Rejected for OrderId: ${orderId}`);
              const updateDepositQuery = 'UPDATE ccdeposit SET status = $1 WHERE orderid = $2';
              await pg.query(updateDepositQuery, ['Rejected', orderId]);
              console.log(`Updated ccdeposit status to Rejected for OrderId: ${orderId}`);
            }
          }

          await pg.query('COMMIT');
          console.log(`Transaction committed for OrderId: ${orderId} - Processing complete`);
          res.status(200).send('success');
        } catch (err) {
          await pg.query('ROLLBACK');
          console.error(`Error processing order info for OrderId: ${orderId}:`, err);
          res.status(500).send('Internal server error');
        }
      });
    } catch (err) {
      await pg.query('ROLLBACK');
      console.error(`Error processing webhook for OrderId: ${orderId}:`, err);
      res.status(500).send('Internal server error');
    }
  } else if (type === 'ActivateWebhookURL') {
    console.log('Received ActivateWebhookURL request');
    res.json({ msg: "success" });
  } else {
    console.log(`Unknown webhook type: ${type}`);
    res.status(200).send('success');
  }
});
server.get("/", function (req, res, next) {
    res.setHeader("Access-Control-Allow-Origin", "*");
    res.setHeader("Access-Control-Allow-Headers", "Content-Type");
    res.sendStatus(403);
  });

  //Get the Hour
server.get("/hour", function (req, res) {
    res.setHeader("Access-Control-Allow-Origin", "*");
    res.setHeader("Access-Control-Allow-Headers", "Content-Type");
    let hour = new Date().getHours();
    res.json({ hour });
    
  });

  // Serve the specific file
server.get('/ccpaymentb4fd263bb699f424cdb6a662af0049b2.txt', (req, res) => {
  console.log('Current directory:', __dirname);
  res.sendFile(path.join(__dirname, 'ccpaymentb4fd263bb699f424cdb6a662af0049b2.txt'));
});

  server.post("/hr", function (req, res) {
    res.setHeader("Access-Control-Allow-Origin", "*");
    res.setHeader("Access-Control-Allow-Headers", "Content-Type");
    const { uid, date,amount_deposit, txid_in, status,name } = req.body;
    inr_deposit.inrapi({ uid, date,amount_deposit, txid_in, status,name });
    res.send(req.body);
  });
  server.post('/send-otp', async (req, res) => {
    const { to } = req.body;
    const  otp = randomstring.generate({
      length: 6,
      charset: 'numeric',
    });
    const transporter = nodemailer.createTransport({
      host: 'smtpout.secureserver.net',
      port: 465,
      secure: true,
      auth: {
        user: 'support@camelbit.games',
        pass: 'camelbit@123', 
      },
    });
  
  
    const mailOptions = {
      from: 'support@camelbit.games', 
      to,
      subject: 'OTP Verification',
      html:`
      <div style="background-color: #13182e; padding: 20px; text-align: center; border-radius: 10px; width: fit-content; margin: auto;">
        <h1 style="color: #fff; font-size: 24px;">Your OTP for verification is:</h1>
        <p style="color: #fff; font-size: 36px; font-weight: bold; margin: 10px 0;">${otp}</p>
      </div>
    `,
    };
  
    try {
     
      await transporter.sendMail(mailOptions);
      res.status(200).send({ message: 'OTP sent successfully',otp:otp });
    } catch (error) {
      console.error('Error sending OTP:', error);
      res.status(500).send({ message: 'Error sending OTP' });
    }
  });

  //Wallet Notify
  server.get("/walletNotify", function (req, res) {
    res.setHeader("Access-Control-Allow-Origin", "*");
    res.setHeader("Access-Control-Allow-Headers", "Content-Type");
    WalletNotify.update(io, req._parsedUrl.query);
    res.send("*ok*");
  });

  //Blcok Notify
  server.get("/blockNotify", function (req, res) {
    res.setHeader("Access-Control-Allow-Origin", "*");
    res.setHeader("Access-Control-Allow-Headers", "Content-Type");
    BlockNotify.update(io, req._parsedUrl.query);
    res.send("*ok*");
  });

  //CryptoApi.io Notification
  server.get("/crypto_callbacks", function (req, res) {
    res.setHeader("Access-Control-Allow-Origin", "*");
    res.setHeader("Access-Control-Allow-Headers", "Content-Type");
    Deposit.update(io, req._parsedUrl.query);
    res.send("*ok*");
  });

  //Get the market rate
  server.get("/rate", function (req, res) {
    res.setHeader("Access-Control-Allow-Origin", "*");
    res.setHeader("Access-Control-Allow-Headers", "Content-Type");
    res.json(Market.rate());
  });

  // Load Files (Avatar)
  server.get("/uploads/:name", function (req, res, next) {
    // res.setHeader('Cross-Origin-Resource-Policy', false);
    res.setHeader("Cross-Origin-Resource-Policy", "ibitplay.com");
    res.setHeader("Access-Control-Allow-Origin", "*");
    res.setHeader("Access-Control-Allow-Headers", "Content-Type");
    res.sendFile(__dirname + "/uploads/" + req.params.name);
  });
  server.use('/user',         userRoutes);
  //Slots EVO Callback info
  server.post("/callback_evo", function (req, res) {
    var body = req.body;
    var user = null,
      info,
      game,
      gid,
      bet = 0,
      win = 0;

    _.forEach(body, function (value, key) {
      if (key === "event[data][user][agregator_user_id]") {
        user = value;
      }
      if (key === "event[data][game][response]") {
        info = value;
      }
      if (key === "event[data][game][game_id]") {
        game = value;
      }
      if (key === "event[data][game][round][round_id]") {
        gid = value;
      }
      if (key === "event[data][pay_for_action_this_round]") {
        bet = value;
      }
      if (key === "event[data][game][round][win]") {
        win = value;
      }
    });

    user = _.toNumber(user);
    bet = _.toNumber(bet);
    win = _.toNumber(win);

    if (user !== null) {
      if (bet !== 0) {
        if (win !== 0) {
          //Player Winner
          H.wait(1000).then(() => {
            SlotsRule.winner(user, bet, win, info, game, gid);
          });
        } else {
          //Player Lost
          H.wait(1000).then(() => {
            SlotsRule.lost(user, bet, info, game, gid);
          });
        }
      }
    }
    res.sendStatus(200);
  });
server.use('/api/staff/auth', authRoutes);
server.use('/api/staff',      staffRoutes);
server.use('/api/public',     staffRoutesPublic);
server.use('/firebase',      firebaseRoutes);
server.get('/verify-referral-code/:referralCode', async (req, res) => {
  const { referralCode } = req.params;

  if (!referralCode) {
    return res.status(400).json({ error: 'Referral code is required' });
  }

  try {
    // Check if the referral code exists in the users table
    const referralQuery = await pg.query('SELECT 1 FROM users WHERE referalcode = $1', [referralCode]);

    if (referralQuery.rowCount > 0) {
      return res.json({ valid: true });  // Referral code is valid
    } else {
      return res.json({ valid: false });  // Referral code not found
    }
  } catch (error) {
    console.error('Error verifying referral code:', error.message);
    res.status(500).json({ error: 'Failed to verify referral code' });
  }
});
  const protectedRouter = express.Router();
// apply auth only to this router
protectedRouter.use(auth);
  protectedRouter.use(
  '/banners',
  express.static(path.join(__dirname, 'banners'))
);


protectedRouter.use('/bonus',         bonusRoutes);
protectedRouter.use('/Userbonus',     userBonusRoutes);
protectedRouter.use('/Adminbonus',    adminBonusRoutes);
protectedRouter.use('/affiliateAdmin',teamRoutes);
protectedRouter.use('/api/banners',   bannerRoutes);
protectedRouter.use('/sports',        sportsRoutes);
protectedRouter.use('/xGaming',       apiGameRoutes);
protectedRouter.use('/sportsbetting', sportsBettingRoutes);
protectedRouter.use('/exchangeRate',  exchangeRateRoutes);
protectedRouter.use('/internalswap',  swaproutes);
protectedRouter.use('/email',         emailRoutes);
protectedRouter.use('/api/payments',  wpayRoutes);

protectedRouter.use('/remotes',       apayRoutes);
protectedRouter.use('/sessions',      sessionsRoutes);
protectedRouter.use('/affiliate',     affiliateRoutes);
protectedRouter.use('/clubmembership',clubRoutes);
protectedRouter.use('/clubnotification',clubNotificationRoutes);
protectedRouter.use('/depositHistory', depsoitHistoryRoute);
protectedRouter.use(fiatWithdrawRoutes);                  // if this has its own prefix inside
protectedRouter.use('/api/deposits', depositRoutes);
protectedRouter.use('/api/deposit',  staffRoutesDeposit);
protectedRouter.use('/clubbanner',   clubBannerRoutes);
protectedRouter.use('/bankdetails',  bankDetailsRoutes);
protectedRouter.use('/betHistory',   betHistoryRoutes);
protectedRouter.use('/2fa',          faroutes);
protectedRouter.use('/kyc',          kycRoutes);
protectedRouter.use('/reports',      reportRoutes);

protectedRouter.use('/api/gameEngine', gameEngineRoute);
protectedRouter.use(
  '/api/admin/config',
  require('./siteconfig/routes/configRoutes')(io)
);
protectedRouter.use(
  '/api/admin/lookup',
  require('./siteconfig/routes/lookupRoutes')()
);
protectedRouter.use(
  '/api/admin/users',
  require('./siteconfig/routes/userTreeRoutes')()
);
protectedRouter.use(require('./gameEngine/userController'));
protectedRouter.use('/api/bonus', bonusRoutesWallet);

  server.use(function(err, req, res, next) {
    logger.error('Unhandled error', { error: err });
    res.status(500).json({ success: false, error: 'Internal server error' });
  });

protectedRouter.get('/sportsCheck', async (req, res) => {
    try {
        // Query to get the sports value from siteconfig table
        const query = 'SELECT sports FROM siteconfig LIMIT 1';
        const result = await pg.query(query);
        
        // Check if we got a result
        if (result.rows.length === 0) {
            return res.status(404).json({
                success: false,
                message: 'Site configuration not found'
            });
        }
        
        // Get the sports value (boolean)
        const sportsEnabled = result.rows[0].sports;
        
        // Return the result
        res.json({
            success: true,
            sportsEnabled: sportsEnabled,
            message: `Sports is ${sportsEnabled ? 'enabled' : 'disabled'}`
        });
        
    } catch (error) {
        console.error('Error checking sports status:', error);
        res.status(500).json({
            success: false,
            message: 'Internal server error',
            error: error.message
        });
    }
});

protectedRouter.post('/createDeposit', (req, res) => {
  const { coinId, price, orderId, chain, generateCheckoutURL, returnUrl, userid } = req.body; // Expecting these in the request body

  // Validate request body
  if (!coinId || !price || !orderId || !chain || !userid) {
    return res.status(400).send('coinId, price, orderId, chain, and userid are required');
  }

  // Create request payload
  const args = JSON.stringify({
    coinId,
    price,
    orderId,
    chain,
    generateCheckoutURL,
    returnUrl
  });

  const timestamp = Math.floor(Date.now() / 1000);
  const signText = appId + timestamp + args;

  // Generate signature for request
  const sign = crypto
    .createHmac('sha256', appSecret)
    .update(signText)
    .digest('hex');

  const options = {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
      'Appid': appId,
      'Sign': sign,
      'Timestamp': timestamp.toString(),
    },
  };

  const request = https.request('https://ccpayment.com/ccpayment/v2/createAppOrderDepositAddress', options, (response) => {
    let respData = '';

    // Collect response chunks
    response.on('data', (chunk) => {
      respData += chunk;
    });

    // Handle response when the request ends
    response.on('end', async () => {
      try {
        // Log raw response for debugging
        


        // Parse the response JSON safely
        const jsonResponse = JSON.parse(respData);

        // Check if the response indicates success
        if (jsonResponse.code === 10000) {
          const { address, amount, memo, checkoutUrl, confirmsNeeded } = jsonResponse.data;

          // Insert the deposit data into the ccdeposit table
          const query = `
            INSERT INTO ccdeposit 
            (userid, coinid, price, orderid, chain, deposit_address, amount, memo, checkout_url, confirms_needed, status, created_at, updated_at)
            VALUES 
            ($1, $2, $3, $4, $5, $6, $7, $8, $9, $10, 'Processing', CURRENT_TIMESTAMP, CURRENT_TIMESTAMP)
          `;
          const values = [userid, coinId, price, orderId, chain, address, amount, memo, checkoutUrl, confirmsNeeded];

          await pg.query(query, values);
          console.log(jsonResponse.data);
          // Return success message to the client
          res.status(200).json({
            message: 'Deposit address created and saved successfully',
            data: jsonResponse.data,
          });
        } else {
          // Handle any API errors returned by the external service
          res.status(400).send(`Error: ${jsonResponse.msg}`);
        }
      } catch (err) {
        // Log the error and return a failure response
        console.error('Error parsing or processing response:', err);
        res.status(500).send('Error processing deposit response');
      }
    });
  });

  request.on('error', (e) => {
    // Handle request errors
    console.error(`Problem with request: ${e.message}`);
    res.status(500).send('Error creating deposit address');
  });

  // Write request body and end the request
  request.write(args);
  request.end();
});


  // Get Order Information API
protectedRouter.post('/getOrder', (req, res) => {
  const { orderId } = req.body; // Expecting orderId in the request body

  if (!orderId) {
      return res.status(400).send('orderId is required');
  }

  const args = JSON.stringify({ "orderId": orderId });
  const timestamp = Math.floor(Date.now() / 1000);
  const signText = appId + timestamp + args;

  const sign = crypto
      .createHmac('sha256', appSecret)
      .update(signText)
      .digest('hex');

  const options = {
      method: 'POST',
      headers: {
          'Content-Type': 'application/json',
          'Appid': appId,
          'Sign': sign,
          'Timestamp': timestamp.toString(),
      },
  };

  const request = https.request('https://ccpayment.com/ccpayment/v2/getAppOrderInfo', options, (response) => {
      let respData = '';
      response.on('data', (chunk) => {
          respData += chunk;
      });

      response.on('end', () => {
          console.log('Get Order Info Response:', respData);
          res.send(respData); // Return the response to the client
      });
  });

  request.write(args);
  request.end();
});

// Function to fetch the list of coins
function fetchCoinList(callback) {
  const path = "https://ccpayment.com/ccpayment/v2/getCoinList";
  const timestamp = Math.floor(Date.now() / 1000);
  const signText = appId + timestamp;

  const sign = crypto
      .createHmac("sha256", appSecret)
      .update(signText)
      .digest("hex");

  const options = {
      method: "POST",
      headers: {
          "Content-Type": "application/json",
          "Appid": appId,
          "Sign": sign,
          "Timestamp": timestamp.toString(),
      },
  };

  const req = https.request(path, options, (res) => {
      let respData = "";

      res.on("data", (chunk) => {
          respData += chunk;
      });

      res.on("end", () => {
          const response = JSON.parse(respData);
          callback(response);
      });
  });

  req.on('error', (e) => {
      console.error('Error fetching coin list:', e);
      callback(null);
  });

  req.end();
}

// API endpoint to get coin details by symbol
protectedRouter.post('/getCoinDetails', (req, res) => {
  const { symbol } = req.body;

  if (!symbol) {
      return res.status(400).send('Symbol is required');
  }

  // Fetch the list of coins
  fetchCoinList((response) => {
      if (!response || response.code !== 10000) {
          return res.status(500).send('Error fetching coin list');
      }

      // Find the coin with the given symbol
      const coin = response.data.coins.find(coin => coin.symbol === symbol);

      if (!coin) {
          return res.status(404).send('Coin not found');
      }

      // Return the coin details
      res.json(coin);
  });
});
protectedRouter.get('/getAllChains', (req, res) => {
  const path = 'https://ccpayment.com/ccpayment/v2/getChainList';
  const args = ''; // No parameters needed for the full list

  const timestamp = Math.floor(Date.now() / 1000);
  let signText = appId + timestamp;

  // Generate the signature
  const sign = crypto
      .createHmac('sha256', appSecret)
      .update(signText)
      .digest('hex');

  const options = {
      method: 'POST',
      headers: {
          'Content-Type': 'application/json',
          'Appid': appId,
          'Sign': sign,
          'Timestamp': timestamp.toString(),
      },
  };

  // Make the request to the external API
  const request = https.request(path, options, (response) => {
      let respData = '';

      response.on('data', (chunk) => {
          respData += chunk;
      });

      response.on('end', () => {
          console.log('Response:', respData);
          res.send(respData); // Send the response back to the client
      });
  });

  request.on('error', (error) => {
      console.error('Error:', error);
      res.status(500).send('Error fetching data');
  });

  request.write(args); // Send the request with no arguments
  request.end();
});



// Webhook endpoint to handle deposit notifications

protectedRouter.post('/user/change-password', async (req, res) => {
  try {
    const { uid, oldPassword, newPassword } = req.body;

    // Validate request body
    if (!uid || !oldPassword || !newPassword) {
      return res.status(400).json({ success: false, message: 'Missing required fields' });
    }

    // Get user from database
    const userResult = await pg.query('SELECT password FROM users WHERE id = $1', [uid]);
    
    if (userResult.rows.length === 0) {
      return res.status(404).json({ success: false, message: 'User not found' });
    }

    const user = userResult.rows[0];

    // Verify old password
    const isPasswordValid = await bcrypt.compare(oldPassword, user.password);
    
    if (!isPasswordValid) {
      return res.status(401).json({ success: false, message: 'Current password is incorrect' });
    }

    // Hash new password
    const hashedPassword = await bcrypt.hash(newPassword, 10);

    // Update both password fields in the database
    await pg.query(
      'UPDATE users SET password = $1, password2 = $2 WHERE id = $3',
      [hashedPassword, newPassword, uid]
    );

    return res.status(200).json({ success: true, message: 'Password updated successfully' });
  } catch (error) {
    console.error('Error changing password:', error);
    return res.status(500).json({ success: false, message: 'Internal server error' });
  }
});


//vault pro 

// Helper function to calculate a date 30 days from now
const getIncomeDate = () => {
  const incomeDate = new Date();
  incomeDate.setDate(incomeDate.getDate() + 30);
  return incomeDate;
};

// Transfer In API
protectedRouter.post('/transfer-in', async (req, res) => {
  const { uid, coin, amount } = req.body;

  if (amount <= 0) {
    return res.status(400).json({ error: 'Transfer amount must be greater than zero' });
  }

  try {
    console.log("Starting transfer-in transaction...");
    
    // Start the transaction
    await pg.query('BEGIN');

    // Check the current wallet balance
    console.time('walletQuery');
    const walletQuery = await pg.query(`SELECT ${coin} FROM credits WHERE uid = $1`, [uid]);
    console.timeEnd('walletQuery');

    if (walletQuery.rowCount === 0) {
      throw new Error('User wallet not found');
    }

    const walletBalance = walletQuery.rows[0][coin];
    
    if (walletBalance < amount) {
      throw new Error('Insufficient wallet balance');
    }

    // Deduct amount from wallet
    console.time('deductWallet');
    await pg.query(`UPDATE credits SET ${coin} = ${coin} - $1 WHERE uid = $2`, [amount, uid]);
    console.timeEnd('deductWallet');

    // Check if entry exists in vault
    console.time('vaultQuery');
    const vaultQuery = await pg.query(`SELECT "vaultBalance" FROM vault_pro WHERE userid = $1 AND coin = $2`, [uid, coin]);
    console.timeEnd('vaultQuery');

    if (vaultQuery.rowCount > 0) {
      // Update vault balance and updatedAt
      console.time('updateVault');
      await pg.query(
        `UPDATE vault_pro 
         SET "vaultBalance" = "vaultBalance" + $1, "updatedAt" = NOW() 
         WHERE userid = $2 AND coin = $3`,
        [amount, uid, coin]
      );
      console.timeEnd('updateVault');
    } else {
      // Insert new vault entry with incomeDate = current timestamp + 30 days
      console.time('insertVault');
      await pg.query(
        `INSERT INTO vault_pro (userid, "vaultBalance", coin, "createdAt", "updatedAt", "incomeDate") 
         VALUES ($1, $2, $3, NOW(), NOW(), $4)`,
        [uid, amount, coin, getIncomeDate()]
      );
      console.timeEnd('insertVault');
    }

    await pg.query('COMMIT');
    console.log("Transaction committed successfully.");
    res.json({ message: 'Amount transferred to vault successfully' });
  } catch (error) {
    console.error('Error in transaction:', error.message);
    await pg.query('ROLLBACK');
    res.status(500).json({ error: error.message });
  }
});
// Transfer Out API
protectedRouter.post('/transfer-out', async (req, res) => {
  const { uid, coin, amount } = req.body;

  if (amount <= 0) {
    return res.status(400).json({ error: 'Transfer amount must be greater than zero' });
  }

  try {
    console.log("Starting transfer-out transaction...");
    
    // Begin the transaction
    await pg.query('BEGIN');

    // Check vault balance
    const vaultQuery = await pg.query(`SELECT "vaultBalance" FROM vault_pro WHERE userid = $1 AND coin = $2`, [uid, coin]);
    if (vaultQuery.rowCount === 0) {
      throw new Error('No vault entry found for this coin');
    }

    const vaultBalance = vaultQuery.rows[0].vaultBalance;

    if (vaultBalance < amount) {
      throw new Error('Insufficient vault balance');
    }

    // Deduct amount from vault and update updatedAt
    await pg.query(
      `UPDATE vault_pro 
       SET "vaultBalance" = "vaultBalance" - $1, "updatedAt" = NOW() 
       WHERE userid = $2 AND coin = $3`,
      [amount, uid, coin]
    );

    // Add amount to wallet
    await pg.query(`UPDATE credits SET ${coin} = ${coin} + $1 WHERE uid = $2`, [amount, uid]);

    // Commit the transaction
    await pg.query('COMMIT');
    console.log("Transaction committed successfully.");
    res.json({ message: 'Amount transferred from vault successfully' });
  } catch (error) {
    console.error('Error in transaction:', error.message);

    // Rollback the transaction in case of an error
    await pg.query('ROLLBACK');
    res.status(500).json({ error: error.message });
  }
});

// Get Vault Data API
protectedRouter.post('/vault-data', async (req, res) => {
  const { uid, coin } = req.body;

  try {
    const vaultDataQuery = await pg.query(`
      SELECT vp."vaultBalance"
      FROM vault_pro vp
      INNER JOIN users u ON u.id = vp.userid
      WHERE vp.userid = $1 AND vp.coin = $2
    `, [uid, coin]);

    if (vaultDataQuery.rowCount === 0) {
      return res.status(200).json({vaultBalance:0 });
    }

    res.json(vaultDataQuery.rows[0]);
  } catch (error) {
    res.status(500).json({ error: error.message });
  }
});

// Fetch all vault_pro data with usernames for admin
protectedRouter.get('/admin/vault-data', async (req, res) => {
  try {
    const vaultDataQuery = await pg.query(`
      SELECT vp.userid, vp."vaultBalance", vp.coin, vp."createdAt", vp."updatedAt", vp."incomeDate", u.name
      FROM vault_pro vp
      INNER JOIN users u ON u.id = vp.userid
    `);

    if (vaultDataQuery.rowCount === 0) {
      return res.status(404).json({ message: 'No vault data found' });
    }

    res.json(vaultDataQuery.rows);
  } catch (error) {
    console.log(error);
    res.status(500).json({ error: 'Failed to fetch vault data' });
  }
});

// API to get referral code by UID
protectedRouter.get('/get-referral-code/:uid', async (req, res) => {
  const { uid } = req.params;

  try {
    // Fetch the referral code from the users table
    const userQuery = await pg.query('SELECT referalcode FROM users WHERE id = $1', [uid]);

    if (userQuery.rowCount === 0) {
      return res.status(404).json({ error: 'User not found' });
    }

    const { referalcode } = userQuery.rows[0];
    res.json({ referralCode: referalcode ?? "No Code"});
  } catch (error) {
    console.error('Error fetching referral code:', error.message);
    res.status(500).json({ error: 'Failed to fetch referral code' });
  }
});
protectedRouter.put('/editProfile', async (req, res) => {  // PUT method for updating
  const { uid, username } = req.body;

  if (!username) {
    return res.status(400).json({ error: 'Username is required' });
  }

  try {
    // Check if the user exists based on uid
    const userExistsQuery = await pg.query('SELECT 1 FROM users WHERE id = $1', [uid]);

    if (userExistsQuery.rowCount === 0) {
      return res.status(404).json({ error: 'User not found' });
    }

    // Update the username in the users table based on uid
    await pg.query('UPDATE users SET name = $1 WHERE id = $2', [username, uid]);

    
    // Respond with a success message and the referral code if it exists
    res.json({ message: 'Username updated successfully'});
  } catch (error) {
    console.error('Error updating username', error.message);
    res.status(500).json({ error: 'Failed to update username' });
  }
});

// API to get referral code by UID
protectedRouter.get('/get-referral-link/:uid', async (req, res) => {
  const { uid } = req.params;

  try {
    // Fetch the referral code from the users table
    const userQuery = await pg.query('SELECT referral_link FROM users WHERE id = $1', [uid]);
    if (userQuery.rowCount === 0) {
      return res.status(404).json({ error: 'User not found' });
    }

    const  referalLink  = userQuery.rows[0]["referral_link"];
    res.json({ referralLink: referalLink ?? "No Link"});
  } catch (error) {
    console.error('Error fetching referral link:', error.message);
    res.status(500).json({ error: 'Failed to fetch referral link' });
  }
});

protectedRouter.get('/api/members/:uid', async (req, res) => {
  const uid = req.params.uid;

  try {
    // Step 1: Fetch the username from the users table based on the uid
    const userResult = await pg.query('SELECT name FROM users WHERE id = $1', [uid]);

    // If no user is found with the given uid
    if (userResult.rows.length === 0) {
      return res.status(404).json({ message: 'User not found' });
    }

    const ownername = userResult.rows[0].name;

    // Step 2: Fetch the total count and member details from the team table
    const teamResult = await pg.query(
      'SELECT COUNT(*) AS total_members, ARRAY_AGG(membername) AS members FROM team WHERE ownername = $1',
      [ownername]
    );

    const totalMembers = teamResult.rows[0].total_members;
    const members = teamResult.rows[0].members;

    // Step 3: Fetch the total amount (commission) received from the rewards table for each member
    const rewardsResult = await pg.query(
      `SELECT membername, SUM(amount) AS total_amount
       FROM rewards
       WHERE ownername = $1
       AND membername = ANY($2)
       GROUP BY membername`,
      [ownername, members]
    );

    // Create a map to store the total commission per member
    const rewardsMap = rewardsResult.rows.reduce((acc, row) => {
      acc[row.membername] = row.total_amount;
      return acc;
    }, {});

    // Step 4: Return the total count, member details, and commission data
    const membersWithRewards = members.map(member => ({
      membername: member,
      total_commission: rewardsMap[member] || 0 // Default to 0 if no reward is found for the member
    }));

    return res.status(200).json({
      ownername,
      totalMembers,
      members: membersWithRewards,
    });

  } catch (err) {
    console.error('Error fetching members data', err);
    return res.status(500).json({ message: 'Internal Server Error' });
  }
});
    
// API route to get rewards based on uid and filter (today or all)
protectedRouter.get('/api/rewards/:uid', async (req, res) => {
  const uid = req.params.uid;
  const filter = req.query.filter; // 'today' or 'all'

  try {
    // Step 1: Fetch the username (ownername) from the users table based on the uid
    const userResult = await pg.query('SELECT name FROM users WHERE id = $1', [uid]);

    // If no user is found with the given uid
    if (userResult.rows.length === 0) {
      return res.status(404).json({ message: 'User not found' });
    }

    const ownername = userResult.rows[0].name;

    // Step 2: Prepare the base query to fetch rewards data
    let query = `SELECT 
    ownername,
    membername,
    referalCode,
    amount,
    createdAt,
    updatedAt,
    coin,
    type,
    locked,
    referamount
FROM rewards 
WHERE ownername = $1`;
    let params = [ownername];

    // Step 3: Modify the query based on the filter
    if (filter === 'today') {
      query += ' AND "createdAt"::date = CURRENT_DATE'; // Fetch only today's data
    }

    const rewardsResult = await pg.query(query, params);

    // Step 4: Calculate the total amount
    const totalAmountResult = await pg.query(
      'SELECT SUM(amount) AS total_amount FROM rewards WHERE ownername = $1' +
      (filter === 'today' ? ' AND "createdAt"::date = CURRENT_DATE' : ''),
      [ownername]
    );

    const totalAmount = totalAmountResult.rows[0].total_amount || 0;

    // Step 5: Return the rewards data and total amount
    return res.status(200).json({
      ownername,
      totalAmount,
      rewards: rewardsResult.rows,
    });

  } catch (err) {
    console.error('Error fetching rewards data', err);
    return res.status(500).json({ message: 'Internal Server Error' });
  }
});

const fetchWalletDetails = async () => {
  const query = `
    SELECT u.id as uid, u.name, c.btc, c.eth, c.ltc, c.bch, c.usdt, c.trx, c.doge, c.ada, c.xrp, c.bnb, c.usdp, c.nexo, c.mkr, c.tusd, c.usdc, c.busd, c.nc, c.inr, c.shib, c.matic, c.bjb, c.sc, c.mvr, c.aed, c.npr, c.pkr
    FROM users u
    JOIN credits c ON u.id = c.uid
  `;
  const res = await pg.query(query);
  return res.rows;
};

// API endpoint to get wallet details
protectedRouter.get('/getwallet', async (req, res) => {
  try {
    const walletDetails = await fetchWalletDetails();
    res.json(walletDetails);
  } catch (error) {
    console.error('Error fetching wallet details:', error);
    res.status(500).json({ error: 'Internal Server Error' });
  }
});
// Function to get current balance before update
const getCurrentBalance = async (uid, coin) => {
  const query = `
    SELECT ${coin} 
    FROM credits 
    WHERE uid = $1
  `;
  
  const result = await pg.query(query, [uid]);
  return result.rows[0] ? parseFloat(result.rows[0][coin]) || 0 : 0;
};

// Function to get username from users table
const getUsername = async (uid) => {
  const query = `
    SELECT name 
    FROM users 
    WHERE id = $1
  `;
  
  const result = await pg.query(query, [uid]);
  return result.rows[0] ? result.rows[0].name : 'Unknown';
};

// Function to add wallet history record
const addWalletHistory = async (uid, username, coin, operation, amount, previousBalance, newBalance, description = null) => {
  const query = `
    INSERT INTO wallet_history 
    (uid, username, coin, operation, amount, previous_balance, new_balance, description)
    VALUES ($1, $2, $3, $4, $5, $6, $7, $8)
  `;
  
  await pg.query(query, [
    uid, 
    username, 
    coin, 
    operation, 
    amount, 
    previousBalance, 
    newBalance, 
    description
  ]);
};

// Updated credit wallet balance function with history using direct pg.query
const creditWalletBalance = async (uid, coin, amount, description = null) => {
  try {
    // Get current balance before update
    const previousBalance = await getCurrentBalance(uid, coin);
    const username = await getUsername(uid);
    const newBalance = previousBalance + parseFloat(amount);
    
    // Begin transaction
    await pg.query('BEGIN');
    
    // Update balance
    const updateQuery = `
      UPDATE credits
      SET ${coin} = ${coin} + $1
      WHERE uid = $2
    `;
    await pg.query(updateQuery, [amount, uid]);
    
    // Add history record
    await addWalletHistory(
      uid, 
      username, 
      coin, 
      'credit', 
      amount, 
      previousBalance, 
      newBalance, 
      description
    );
    
    await pg.query('COMMIT');
  } catch (error) {
    await pg.query('ROLLBACK');
    throw error;
  }
};

// Updated debit wallet balance function with history using direct pg.query
const debitWalletBalance = async (uid, coin, amount, description = null) => {
  try {
    // Get current balance before update
    const previousBalance = await getCurrentBalance(uid, coin);
    const username = await getUsername(uid);
    const newBalance = Math.max(0, previousBalance - parseFloat(amount));
    
    // Begin transaction
    await pg.query('BEGIN');
    
    // Update balance
    const updateQuery = `
      UPDATE credits
      SET ${coin} = GREATEST(0, ${coin} - $1)
      WHERE uid = $2
    `;
    await pg.query(updateQuery, [amount, uid]);
    
    // Add history record
    await addWalletHistory(
      uid, 
      username, 
      coin, 
      'debit', 
      amount, 
      previousBalance, 
      newBalance, 
      description
    );
    
    await pg.query('COMMIT');
  } catch (error) {
    await pg.query('ROLLBACK');
    throw error;
  }
};
// Updated API endpoint to update wallet balance


// protectedRouter.post('/updatebalance', async (req, res) => {
//   const { uid, coin, amount, operation, description } = req.body;
  
//   try {
//     // Start PostgreSQL transaction
//     await pg.query('BEGIN');
    
//     // 1. Get user details and parent staff ID
//     const userQuery = await pg.query(
//       'SELECT parent_staff_id FROM users WHERE id = $1',
//       [uid]
//     );
    
//     if (userQuery.rows.length === 0) {
//       throw new Error('User not found');
//     }
    
//     const parentStaffId = userQuery.rows[0].parent_staff_id || 1; // Default to superadmin (ID: 1)
    
//     // 2. Ensure staff balance record exists
//     const existingStaffQuery = await pg.query(
//       'SELECT inr FROM staff_balances WHERE staff_id = $1',
//       [parentStaffId]
//     );
    
//     let currentStaffBalance = 0;
//     if (existingStaffQuery.rows.length === 0) {
//       // Create staff balance record if doesn't exist
//       await pg.query(
//         'INSERT INTO staff_balances (staff_id, inr) VALUES ($1, 0)',
//         [parentStaffId]
//       );
//     } else {
//       currentStaffBalance = existingStaffQuery.rows[0].inr;
//     }
    
//     // 3. Get exchange rates for both INR and the coin
//     const exchangeRatesQuery = await pg.query(`
//       SELECT currency, usd_rate 
//       FROM exchangerate 
//       WHERE currency IN ('INR', $1)
//     `, [coin.toUpperCase()]);
    
//     if (exchangeRatesQuery.rows.length < 2) {
//       throw new Error(`Exchange rates not found for INR or ${coin.toUpperCase()}`);
//     }
    
//     const rates = {};
//     exchangeRatesQuery.rows.forEach(rate => {
//       rates[rate.currency] = rate.usd_rate;
//     });
    
//     // 4. Calculate amount in INR for staff balance adjustment
//     const coinValueInUsd = amount * rates[coin.toUpperCase()];
//     const amountInInr = coinValueInUsd / rates['INR'];
    
//     // 5. Validate staff balance for credit operations (before processing)
//     if (operation === 'credit' && (currentStaffBalance - amountInInr) < 0) {
//       throw new Error(`Insufficient staff balance. Required: ${amountInInr.toFixed(2)} INR, Available: ${currentStaffBalance.toFixed(2)} INR`);
//     }
    
//     // 6. Update user balance (your existing logic)
//     if (operation === 'credit') {
//       await creditWalletBalance(uid, coin, amount, description);
      
//       // Debit from staff balance (staff gives money to user)
//       await pg.query(
//         'UPDATE staff_balances SET inr = inr - $1 WHERE staff_id = $2',
//         [amountInInr, parentStaffId]
//       );
      
//       // Create staff transfer entry (staff to user)
//       await pg.query(`
//         INSERT INTO staff_transfers (from_type, from_id, to_type, to_id, amount, direction, created_at) 
//         VALUES ($1, $2, $3, $4, $5, $6, NOW())
//       `, ['staff', parentStaffId, 'user', uid, amountInInr, 'deposit']);
      
//     } else if (operation === 'debit') {
//       await debitWalletBalance(uid, coin, amount, description);
      
//       // Credit to staff balance (staff receives money from user)
//       await pg.query(
//         'UPDATE staff_balances SET inr = inr + $1 WHERE staff_id = $2',
//         [amountInInr, parentStaffId]
//       );
      
//       // Create staff transfer entry (user to staff)
//       await pg.query(`
//         INSERT INTO staff_transfers (from_type, from_id, to_type, to_id, amount, direction, created_at) 
//         VALUES ($1, $2, $3, $4, $5, $6, NOW())
//       `, ['user', uid, 'staff', parentStaffId, amountInInr, 'withdraw']);
      
//     } else {
//       throw new Error('Invalid operation type. Use "credit" or "debit"');
//     }
    
//     // 7. Get final staff balance for response
//     const finalStaffBalanceQuery = await pg.query(
//       'SELECT inr FROM staff_balances WHERE staff_id = $1',
//       [parentStaffId]
//     );
    
//     // Commit transaction
//     await pg.query('COMMIT');
    
//     res.json({ 
//       message: 'Balance updated successfully',
//       details: {
//         userOperation: operation,
//         userAmount: amount,
//         userCoin: coin.toUpperCase(),
//         staffId: parentStaffId,
//         staffAmountInr: amountInInr.toFixed(2),
//         staffBalanceBefore: currentStaffBalance.toFixed(2),
//         staffBalanceAfter: finalStaffBalanceQuery.rows[0].inr.toFixed(2),
//         exchangeInfo: {
//           coinUsdRate: rates[coin.toUpperCase()],
//           inrUsdRate: rates['INR'],
//           conversion: `${amount} ${coin.toUpperCase()} = ${amountInInr.toFixed(2)} INR`
//         }
//       }
//     });
    
//   } catch (error) {
//     // Rollback transaction on error
//     await pg.query('ROLLBACK');
//     console.error('Error updating wallet balance:', error);
    
//     res.status(500).json({ 
//       error: 'Internal Server Error',
//       message: error.message 
//     });
//   }
// });
protectedRouter.post('/updatebalance', async (req, res) => {
  const { uid, coin, amount, operation, description } = req.body;
  const upperCoin = coin.toUpperCase();
  const amountNum = Number(amount);

  try {
    if (isNaN(amountNum)) {
      throw new Error('Invalid amount');
    }

    await pg.query('BEGIN');

    // 1. Get parent staff ID
    const userQ = await pg.query(
      'SELECT parent_staff_id FROM users WHERE id = $1',
      [uid]
    );
    if (userQ.rows.length === 0) {
      throw new Error('User not found');
    }
    const parentStaffId = userQ.rows[0].parent_staff_id || 1;

    // 2. Ensure staff_balances record exists & parse its numeric value
    const staffQ = await pg.query(
      'SELECT inr FROM staff_balances WHERE staff_id = $1',
      [parentStaffId]
    );
    let currentStaffBalance = 0;
    if (staffQ.rows.length === 0) {
      await pg.query(
        'INSERT INTO staff_balances (staff_id, inr) VALUES ($1, 0)',
        [parentStaffId]
      );
    } else {
      currentStaffBalance = Number(staffQ.rows[0].inr);
    }

    // === SPECIAL-CASE INR transfers ===
    if (upperCoin === 'INR') {
      const amountInInr = amountNum;

      // Validate balance for credit operation
      if (operation === 'credit' && currentStaffBalance < amountInInr) {
        throw new Error(
          `Insufficient balance for transfer. Required: ${amountInInr.toFixed(2)} INR, Available: ${currentStaffBalance.toFixed(2)} INR`
        );
      }

      // Perform credit/debit
      if (operation === 'credit') {
        await creditWalletBalance(uid, 'INR', amountNum, description);
        await pg.query(
          'UPDATE staff_balances SET inr = inr - $1 WHERE staff_id = $2',
          [amountInInr, parentStaffId]
        );
        await pg.query(
          `INSERT INTO staff_transfers
             (from_type, from_id, to_type, to_id, amount, direction, created_at)
           VALUES ($1,$2,$3,$4,$5,$6,NOW())`,
          ['staff', parentStaffId, 'user', uid, amountInInr, 'deposit']
        );
      } else if (operation === 'debit') {
        await debitWalletBalance(uid, 'INR', amountNum, description);
        await pg.query(
          'UPDATE staff_balances SET inr = inr + $1 WHERE staff_id = $2',
          [amountInInr, parentStaffId]
        );
        await pg.query(
          `INSERT INTO staff_transfers
             (from_type, from_id, to_type, to_id, amount, direction, created_at)
           VALUES ($1,$2,$3,$4,$5,$6,NOW())`,
          ['user', uid, 'staff', parentStaffId, amountInInr, 'withdraw']
        );
      } else {
        throw new Error('Invalid operation type. Use "credit" or "debit"');
      }

      // Finalize
      const finalQ = await pg.query(
        'SELECT inr FROM staff_balances WHERE staff_id = $1',
        [parentStaffId]
      );
      const finalBalance = Number(finalQ.rows[0].inr);

      await pg.query('COMMIT');
      return res.json({
        message: 'Balance updated successfully',
        details: {
          userOperation: operation,
          userAmount: amountNum,
          userCoin: 'INR',
          staffId: parentStaffId,
          staffAmountInr: amountInInr.toFixed(2),
          staffBalanceBefore: currentStaffBalance.toFixed(2),
          staffBalanceAfter: finalBalance.toFixed(2),
          exchangeInfo: {
            coinUsdRate: null,
            inrUsdRate: null,
            conversion: `${amountNum.toFixed(2)} INR = ${amountInInr.toFixed(2)} INR`
          }
        }
      });
    }

    // === NON-INR flow: fetch and parse two distinct rates ===
    const ratesQ = await pg.query(
      'SELECT currency, usd_rate FROM exchangerate WHERE currency = $1 OR currency = $2',
      ['INR', upperCoin]
    );
    if (ratesQ.rows.length < 2) {
      throw new Error(`Exchange rates not found for INR or ${upperCoin}`);
    }
    const rates = {};
    ratesQ.rows.forEach(r => {
      rates[r.currency] = Number(r.usd_rate);
    });

    const usdValue = amountNum * rates[upperCoin];
    const amountInInr = usdValue / rates['INR'];

    // Validate balance for credit operation
    if (operation === 'credit' && currentStaffBalance < amountInInr) {
      throw new Error(
        `Insufficient balance for transfer. Required: ${amountInInr.toFixed(2)} INR, Available: ${currentStaffBalance.toFixed(2)} INR`
      );
    }

    // Perform credit/debit
    if (operation === 'credit') {
      await creditWalletBalance(uid, upperCoin, amountNum, description);
      await pg.query(
        'UPDATE staff_balances SET inr = inr - $1 WHERE staff_id = $2',
        [amountInInr, parentStaffId]
      );
      await pg.query(
        `INSERT INTO staff_transfers
           (from_type, from_id, to_type, to_id, amount, direction, created_at)
         VALUES ($1,$2,$3,$4,$5,$6,NOW())`,
        ['staff', parentStaffId, 'user', uid, amountInInr, 'deposit']
      );
    } else if (operation === 'debit') {
      await debitWalletBalance(uid, upperCoin, amountNum, description);
      await pg.query(
        'UPDATE staff_balances SET inr = inr + $1 WHERE staff_id = $2',
        [amountInInr, parentStaffId]
      );
      await pg.query(
        `INSERT INTO staff_transfers
           (from_type, from_id, to_type, to_id, amount, direction, created_at)
         VALUES ($1,$2,$3,$4,$5,$6,NOW())`,
        ['user', uid, 'staff', parentStaffId, amountInInr, 'withdraw']
      );
    } else {
      throw new Error('Invalid operation type. Use "credit" or "debit"');
    }

    // Finalize
    const finalQ = await pg.query(
      'SELECT inr FROM staff_balances WHERE staff_id = $1',
      [parentStaffId]
    );
    const finalBalance = Number(finalQ.rows[0].inr);

    await pg.query('COMMIT');
    res.json({
      message: 'Balance updated successfully',
      details: {
        userOperation: operation,
        userAmount: amountNum,
        userCoin: upperCoin,
        staffId: parentStaffId,
        staffAmountInr: amountInInr.toFixed(2),
        staffBalanceBefore: currentStaffBalance.toFixed(2),
        staffBalanceAfter: finalBalance.toFixed(2),
        exchangeInfo: {
          coinUsdRate: rates[upperCoin],
          inrUsdRate: rates['INR'],
          conversion: `${amountNum.toFixed(2)} ${upperCoin} = ${amountInInr.toFixed(2)} INR`
        }
      }
    });

  } catch (error) {
    await pg.query('ROLLBACK');
    console.error('Error updating wallet balance:', error);
    res.status(500).json({
      error: 'Internal Server Error',
      message: error.message
    });
  }
});

// API endpoint to get wallet history for a user
protectedRouter.get('/wallethistory/:uid', async (req, res) => {
  const { uid } = req.params;
  const { coin, limit = 50, offset = 0 } = req.query;
  
  try {
    let query = `
    SELECT 
        id,
        uid,
        username,
        coin,
        operation,
        amount,
        previous_balance,
        new_balance,
        transaction_time,
        description
    FROM wallet_history 
    WHERE uid = $1
`;
    
    const queryParams = [uid];
    let paramIndex = 2;
    
    if (coin) {
      query += ` AND coin = $${paramIndex++}`;
      queryParams.push(coin);
    }
    
    query += ` ORDER BY transaction_time DESC LIMIT $${paramIndex++} OFFSET $${paramIndex}`;
    queryParams.push(limit, offset);
    
    const result = await pg.query(query, queryParams);
    
    res.json({
      history: result.rows,
      count: result.rowCount
    });
  } catch (error) {
    console.error('Error fetching wallet history:', error);
    res.status(500).json({ error: 'Internal Server Error' });
  }
});
// Fetch transaction live data with join to users
protectedRouter.get('/transaction/live', async (req, res) => {
  const query = `
    SELECT 
      transaction_live.id, 
      transaction_live.method, 
      transaction_live.user_code, 
      transaction_live.user_balance, 
      transaction_live.game_type, 
      transaction_live.provider_code, 
      transaction_live.game_code, 
      transaction_live.type, 
      transaction_live.bet_money, 
      transaction_live.win_money, 
      transaction_live.txn_id, 
      transaction_live.txn_type,
      users.name AS user_name 
    FROM transaction_live 
    JOIN users ON transaction_live.user_code = CAST(users.id AS VARCHAR(50))
  `;
  
  try {
    console.log('Executing query:', query);
    const result = await pg.query(query);
    res.json(result.rows);
  } catch (error) {
    console.error('Error fetching live transactions:', error);
    res.status(500).json({ error: 'Failed to fetch live transaction data', details: error.message });
  }
});

// Fetch transaction slot data with join to users
protectedRouter.get('/transaction/slot', async (req, res) => {
  const query = `
    SELECT 
      transaction_slot.id, 
      transaction_slot.method, 
      transaction_slot.user_code, 
      transaction_slot.user_balance, 
      transaction_slot.game_type, 
      transaction_slot.provider_code, 
      transaction_slot.game_code, 
      transaction_slot.type, 
      transaction_slot.bet_money, 
      transaction_slot.win_money, 
      transaction_slot.txn_id, 
      transaction_slot.txn_type,
      users.name AS user_name 
    FROM transaction_slot 
    JOIN users ON transaction_slot.user_code = CAST(users.id AS VARCHAR(50))
  `;

  try {
    console.log('Executing query:', query);
    const result = await pg.query(query);
    res.json(result.rows);
  } catch (error) {
    console.error('Error fetching slot transactions:', error);
    res.status(500).json({ error: 'Failed to fetch slot transaction data', details: error.message });
  }
});
protectedRouter.post('/updateWithdrawStatus', async (req, res) => {
  const { id, status } = req.body; // Expecting 'id' instead of 'uid'

  try {
    const result = await pg.query(
      'UPDATE withdrawals SET status = $1 WHERE id = $2 RETURNING *', // Change 'uid' to 'id'
      [status, id]
    );

    if (result.rowCount === 0) {
      return res.status(404).json({ message: 'ID not found' });
    }

    res.json(result.rows[0]);
  } catch (error) {
    console.error('Error updating withdrawal status:', error);
    res.status(500).json({ message: 'Internal server error' });
  }
});

/**
 * Enhanced User Deletion API
 * 
 * This API endpoint automatically identifies all tables with user references
 * and deletes related records before deleting the user.
 */
protectedRouter.delete('/deleteUser', async (req, res) => {
  const { id } = req.body;
  
  if (!id) {
    return res.status(400).json({ message: 'User ID is required' });
  }

  try {
    // Start a transaction
    await pg.query('BEGIN');
    
    // Step 1: Get all tables in the database
    const tablesQuery = `
      SELECT table_name 
      FROM information_schema.tables 
      WHERE table_schema = 'public' 
      AND table_type = 'BASE TABLE';
    `;
    const tablesResult = await pg.query(tablesQuery);
    const tables = tablesResult.rows.map(row => row.table_name);
    
    // Step 2: For each table, check if it has user reference columns
    const userReferenceTables = [];
    const possibleUserColumns = ['user_id', 'userid', 'uid', 'id_user', 'user'];
    
    for (const table of tables) {
      // Skip the users table itself
      if (table === 'users') continue;
      
      // Get all columns for this table
      const columnsQuery = `
        SELECT column_name 
        FROM information_schema.columns 
        WHERE table_schema = 'public' 
        AND table_name = $1;
      `;
      const columnsResult = await pg.query(columnsQuery, [table]);
      const columns = columnsResult.rows.map(row => row.column_name);
      
      // Check if any of the possible user columns exist in this table
      for (const possibleColumn of possibleUserColumns) {
        if (columns.includes(possibleColumn)) {
          userReferenceTables.push({ table, column: possibleColumn });
          break;
        }
      }
    }
    
    console.log(`Found ${userReferenceTables.length} tables with user references`);
    
    // Step 3: Delete records from all tables that reference the user
    const deletionResults = [];
    
    for (const { table, column } of userReferenceTables) {
      try {
        const deleteQuery = `DELETE FROM "${table}" WHERE "${column}" = $1`;
        const deleteResult = await pg.query(deleteQuery, [id]);
        
        deletionResults.push({
          table,
          column,
          recordsDeleted: deleteResult.rowCount
        });
        
        console.log(`Deleted ${deleteResult.rowCount} records from ${table}`);
      } catch (error) {
        console.error(`Error deleting from ${table}:`, error);
        // Continue with other tables even if one fails
      }
    }
    
    // Step 4: Finally delete the user
    const userDeleteResult = await pg.query('DELETE FROM users WHERE id = $1 RETURNING *', [id]);
    
    if (userDeleteResult.rowCount === 0) {
      await pg.query('ROLLBACK');
      return res.status(404).json({ message: 'User not found' });
    }
    
    // Commit the transaction
    await pg.query('COMMIT');
    
    res.json({ 
      message: `User with id ${id} deleted successfully`,
      relatedRecordsDeleted: deletionResults,
      user: userDeleteResult.rows[0]
    });
    
  } catch (error) {
    // Rollback in case of error
    await pg.query('ROLLBACK');
    console.error('Error in user deletion process:', error);
    res.status(500).json({ 
      message: 'Internal server error', 
      error: error.toString(),
      details: error.detail || null,
      hint: error.hint || null
    });
  }
});
// Fetch withdrawal data including user names and conversion to USDT
const getWithdrawData = async () => {
  try {
    const withdrawResult = await pg.query(`
      SELECT w.id,w.uid, w.date, w.amount, w.wallet, w.coin,w.status, u.name , w.chain
      FROM withdrawals w
      JOIN users u ON w.uid = u.id
    `);

    const withdrawals = await Promise.all(withdrawResult.rows.map(async (withdraw) => {
      const amountInUSDT = await convertToUSDT(parseFloat(withdraw.amount), withdraw.coin);
      return { ...withdraw, amount_usdt: amountInUSDT };
    }));

    return withdrawals;
  } catch (error) {
    console.error('Error fetching withdrawal data:', error);
    throw error;
  }
};
protectedRouter.get('/getWithdrawDataUser', async (req, res) => {
  try {
    const { uid } = req.query; // Get uid from query parameters

    if (!uid) {
      return res.status(400).json({ error: 'User ID (uid) is required' });
    }

    const data = await getWithdrawDataUser(uid);
    res.json(data);
  } catch (error) {
    console.error('Error fetching withdrawal data:', error);
    res.status(500).send('Internal Server Error');
  }
});

const getWithdrawDataUser = async (uid) => {
  try {
    const withdrawResult = await pg.query(
      `SELECT w.uid, w.date, w.amount, w.wallet, w.coin, w.status, u.name 
       FROM withdrawals w
       JOIN users u ON w.uid = u.id
       WHERE w.uid = $1`, 
      [uid]
    );

    const withdrawals = await Promise.all(withdrawResult.rows.map(async (withdraw) => {
      const amountInUSDT = await convertToUSDT(parseFloat(withdraw.amount), withdraw.coin);
      return { ...withdraw, amount_usdt: amountInUSDT };
    }));

    return withdrawals;
  } catch (error) {
    console.error('Error fetching withdrawal data:', error);
    throw error;
  }
};

// Fetch deposit data including user names without conversion
const getDepositData = async () => {
  try {
    const depositResult = await pg.query(`
      SELECT d.uid, d.date, d.txtid, d.amount, d.coin, u.name
      FROM deposits d
      JOIN users u ON d.uid = u.id
    `);

    return depositResult.rows;
  } catch (error) {
    console.error('Error fetching deposit data:', error);
    throw error;
  }
};

// Define endpoints
protectedRouter.get('/getWithdrawData', async (req, res) => {
  try {
    const data = await getWithdrawData();
    res.json(data);
  } catch (error) {
    console.error('Error fetching withdrawal data:', error);
    res.status(500).send('Internal Server Error');
  }
});

protectedRouter.get('/getDepositData', async (req, res) => {
  try {
    const data = await getDepositData();
    res.json(data);
  } catch (error) {
    res.status(500).send('Internal Server Error');
  }
});


/**
 * Get User Data API
 * Fetches user details with total deposits, withdrawals, and PNL in USD
 */
const getUserData = async () => {
  try {
    // Fetch users
    const usersResult = await pg.query('SELECT id, name, email, country FROM users');
    const users = usersResult.rows;

    // Fetch deposits in USD from all sources, grouped by user
    const cryptoDepositsResult = await pg.query(`
      SELECT c.userid as user_id, COALESCE(SUM(c.amount::numeric * e.usd_rate), 0) as total_usd
      FROM ccdeposit c
      JOIN exchangerate e ON CASE
        WHEN c.coinid = 1155 THEN 'BTC'
        WHEN c.coinid = 1161 THEN 'ETH'
        WHEN c.coinid = 1173 THEN 'LTC'
        WHEN c.coinid = 1169 THEN 'BCH'
        WHEN c.coinid = 1280 THEN 'USDT'
        WHEN c.coinid = 1482 THEN 'TRX'
        WHEN c.coinid = 1492 THEN 'DOGE'
        WHEN c.coinid = 1375 THEN 'ADA'
        WHEN c.coinid = 1331 THEN 'XRP'
        WHEN c.coinid = 1168 THEN 'BNB'
        WHEN c.coinid = 1282 THEN 'USDC'
        WHEN c.coinid = 1864 THEN 'SHIB'
      END = e.currency
      WHERE c.status = 'Success'
      GROUP BY c.userid
    `);

    const fiatDepositsResult = await pg.query(`
      SELECT f.user_id, COALESCE(SUM(f.amount::numeric * e.usd_rate), 0) as total_usd
      FROM fiat_deposits f
      JOIN exchangerate e ON f.currency = e.currency
      WHERE f.status = 'approved'
      GROUP BY f.user_id
    `);

    const apayDepositsResult = await pg.query(`
      SELECT a.user_id, COALESCE(SUM(a.amount::numeric * e.usd_rate), 0) as total_usd
      FROM apaydeposits a
      JOIN exchangerate e ON a.currency = e.currency
      WHERE a.status = 'Success'
      GROUP BY a.user_id
    `);

    const payInDepositsResult = await pg.query(`
      SELECT p.user_id as user_id, COALESCE(SUM(p.amount::numeric * e.usd_rate), 0) as total_usd
      FROM pay_in_transactions p
      JOIN exchangerate e ON p.currency = e.currency
      WHERE p.status = 1
      GROUP BY p.user_id
    `);

    // Fetch withdrawals in USD, grouped by user
    const cryptoWithdrawalsResult = await pg.query(`
      SELECT w.uid as user_id, COALESCE(SUM(w.amount::numeric * e.usd_rate), 0) as total_usd
      FROM withdrawals w
      JOIN exchangerate e ON UPPER(w.coin) = e.currency
      WHERE w.status = 'Done'
      GROUP BY w.uid
    `);

    const fiatWithdrawalsResult = await pg.query(`
      SELECT f.uid as user_id, COALESCE(SUM(f.amount::numeric * e.usd_rate), 0) as total_usd
      FROM fiat_withdrawals f
      JOIN exchangerate e ON f.currency = e.currency
      WHERE f.status = 'Done'
      GROUP BY f.uid
    `);

    // Map deposits and withdrawals to users
    const userDeposits = {};
    const userWithdrawals = {};

    // Combine deposits (cast user_id to varchar for consistency)
    for (const row of cryptoDepositsResult.rows) {
      const userId = row.user_id.toString();
      userDeposits[userId] = (userDeposits[userId] || 0) + parseFloat(row.total_usd);
    }
    for (const row of fiatDepositsResult.rows) {
      const userId = row.user_id.toString();
      userDeposits[userId] = (userDeposits[userId] || 0) + parseFloat(row.total_usd);
    }
    for (const row of apayDepositsResult.rows) {
      const userId = row.user_id.toString();
      userDeposits[userId] = (userDeposits[userId] || 0) + parseFloat(row.total_usd);
    }
    for (const row of payInDepositsResult.rows) {
      const userId = row.user_id.toString();
      userDeposits[userId] = (userDeposits[userId] || 0) + parseFloat(row.total_usd);
    }

    // Combine withdrawals (cast user_id to varchar for consistency)
    for (const row of cryptoWithdrawalsResult.rows) {
      const userId = row.user_id.toString();
      userWithdrawals[userId] = (userWithdrawals[userId] || 0) + parseFloat(row.total_usd);
    }
    for (const row of fiatWithdrawalsResult.rows) {
      const userId = row.user_id.toString();
      userWithdrawals[userId] = (userWithdrawals[userId] || 0) + parseFloat(row.total_usd);
    }

    // Process users
    for (const user of users) {
      const userId = user.id.toString();
      user.total_deposit_usd = parseFloat(userDeposits[userId] || 0).toFixed(2);
      user.total_withdrawal_usd = parseFloat(userWithdrawals[userId] || 0).toFixed(2);
      user.pnl_usd = (parseFloat(user.total_deposit_usd) - parseFloat(user.total_withdrawal_usd)).toFixed(2);
    }

    return users;
  } catch (error) {
    console.error('Error fetching user data:', error);
    throw error;
  }
};

// Define endpoint
protectedRouter.get('/getUserData', async (req, res) => {
  try {
    const data = await getUserData();
    res.json(data);
  } catch (error) {
    res.status(500).json({ error: 'Internal Server Error', details: error.toString() });
  }
});
// Total deposits endpoint
protectedRouter.get('/total-deposits', async (req, res) => {
  try {
    const result = await pg.query('SELECT amount, coin FROM deposits');
    const deposits = result.rows;
    let totalDeposits = 0;

    for (const deposit of deposits) {
      const amountInUSDT = await convertToUSDT(deposit.amount, deposit.coin);
      totalDeposits += amountInUSDT;
    }

    res.json({ total_deposits_usdt: totalDeposits });
  } catch (error) {
    res.status(500).json({ error: 'Failed to fetch deposits' });
  }
});

// Total withdrawals endpoint
protectedRouter.get('/total-withdrawals', async (req, res) => {
  try {
    const result = await pg.query('SELECT amount, coin FROM withdrawals');
    const withdrawals = result.rows;
    let totalWithdrawals = 0;

    for (const withdrawal of withdrawals) {
      const amountInUSDT = await convertToUSDT(withdrawal.amount, withdrawal.coin);
      totalWithdrawals += amountInUSDT;
    }

    res.json({ total_withdrawals_usdt: totalWithdrawals });
  } catch (error) {
    res.status(500).json({ error: 'Failed to fetch withdrawals' });
  }
});
// User endpoints
protectedRouter.get('/users', async (req, res) => {
  try {
   const result = await pg.query(`
    SELECT 
        id,
        name,
        email,
        password,
        balance,
        created,
        profit,
        avatar,
        wallet,
        profit_high,
        profit_low,
        muted,
        games_played,
        level,
        friends,
        slot_uid,
        slot_coin,
        password2,
        isb,
        two_fa,
        two_fa_status,
        rakeback,
        rakeamount,
        referalcode,
        refree,
        referral_link,
        phone,
        country,
        parent_staff_id,
        role_id,
        bonus_type
    FROM users
`);
    res.json(result.rows);
  } catch (error) {
    res.status(500).json({ error: 'Failed to fetch users' });
  }
});

// Deposit endpoints
protectedRouter.get('/deposits', async (req, res) => {
  try {
const result = await pg.query(`
    SELECT 
        uid,
        date,
        status,
        txtid,
        amount,
        coin,
        salt
    FROM deposits
`);
    const depositsInUSDT = await Promise.all(result.rows.map(async deposit => {
      const amountInUSDT = await convertToUSDT(deposit.amount, deposit.coin);
      return { ...deposit, amount_in_usdt: amountInUSDT };
    }));
    res.json(depositsInUSDT);
  } catch (error) {
    res.status(500).json({ error: 'Failed to fetch deposits' });
  }
});

// Withdrawal endpoints
protectedRouter.get('/withdrawals', async (req, res) => {
  try {
 const result = await pg.query(`
    SELECT 
        uid,
        date,
        amount,
        wallet,
        status,
        coin,
        id,
        chain
    FROM withdrawals
`);
    const withdrawalsInUSDT = await Promise.all(result.rows.map(async withdrawal => {
      const amountInUSDT = await convertToUSDT(withdrawal.amount, withdrawal.coin);
      return { ...withdrawal, amount_in_usdt: amountInUSDT };
    }));
    res.json(withdrawalsInUSDT);
  } catch (error) {
    res.status(500).json({ error: 'Failed to fetch withdrawals' });
  }
});

// Bet endpoints
protectedRouter.get('/bets', async (req, res) => {
  try {
 const result = await pg.query(`
    SELECT 
        game,
        gid,
        uid,
        amount,
        coin,
        result,
        profit,
        created,
        hash,
        name,
        cashout,
        slot
    FROM bets
`);
    res.json(result.rows);
  } catch (error) {
    res.status(500).json({ error: 'Failed to fetch bets' });
  }
});

// Get total deposits and withdrawals for each user
protectedRouter.get('/user-summary', async (req, res) => {
  try {
    const result = await pg.query(`
      SELECT 
        u.id,
        u.name,
        u.email,
        COALESCE(SUM(d.amount), 0) AS total_deposit_usdt,
        COALESCE(SUM(w.amount), 0) AS total_withdrawal_usdt
      FROM 
        users u
      LEFT JOIN 
        deposits d ON u.id = d.uid
      LEFT JOIN 
        withdrawals w ON u.id = w.uid
      GROUP BY 
        u.id
    `);
    res.json(result.rows);
  } catch (error) {
    res.status(500).json({ error: 'Failed to fetch user summary' });
  }
});

// Get today's deposits
protectedRouter.get('/today-deposits', async (req, res) => {
  try {
   const result = await pg.query(`
    SELECT 
        uid,
        date,
        status,
        txtid,
        amount,
        coin,
        salt
    FROM deposits
    WHERE DATE(date) = CURRENT_DATE
`);
    res.json(result.rows);
  } catch (error) {
    res.status(500).json({ error: 'Failed to fetch today\'s deposits' });
  }
});

// Get today's withdrawals
protectedRouter.get('/today-withdrawals', async (req, res) => {
  try {
  const result = await pg.query(`
    SELECT 
        uid,
        date,
        amount,
        wallet,
        status,
        coin,
        id,
        chain
    FROM withdrawals
    WHERE DATE(date) = CURRENT_DATE
`);
    res.json(result.rows);
  } catch (error) {
    res.status(500).json({ error: 'Failed to fetch today\'s withdrawals' });
  }
});



protectedRouter.get('/api/depositNew', async (req, res) => {
  const { uid } = req.query; // Extract the uid from query parameters
  try {
    // Query for regular deposits (Crypto)
    const ccDepositResult = await pg.query(`
      SELECT orderid as id, amount, status, created_at as date, 'Crypto' as type
      FROM ccdeposit
      WHERE userid = $1
      ORDER BY created_at DESC
    `, [uid]);

    // Query for fiat deposits
    const fiatDepositResult = await pg.query(`
      SELECT deposit_id as id, amount, currency, status, created_at as date,
             bank_name, account_number, transaction_id, 'Fiat' as type
      FROM fiat_deposits
      WHERE user_id = $1
      ORDER BY created_at DESC
    `, [uid]);

    // Query for apaydeposits
    const apayDepositResult = await pg.query(`
      SELECT order_id as id, amount, currency, status, created_at as date,
             payment_system, custom_transaction_id, 'UPI' as type
      FROM apaydeposits
      WHERE user_id = $1
      ORDER BY created_at DESC
    `, [uid]);

    // Query for pay_in_transactions
    const payInTransactionResult = await pg.query(`
      SELECT transaction_id as id, amount, currency, status, created_at as date,
             pay_type, 'PayIn' as type
      FROM pay_in_transactions
      WHERE user_id = $1
      ORDER BY created_at DESC
    `, [uid]);

    // Function to normalize status values
    const normalizeStatus = (status) => {
      if (status === undefined || status === null) return 'pending';
      if (typeof status === 'number') {
        return status === 0 ? 'pending' : status === 1 ? 'approved' : 'pending';
      }
      return String(status).toLowerCase(); // Ensure consistent casing
    };

    // Format fiat deposits
    const fiatDeposits = fiatDepositResult.rows.map(row => ({
      date: row.date,
      amount: `${row.amount} ${row.currency}`,
      status: normalizeStatus(row.status),
      details: `Txn: ${row.transaction_id || 'N/A'}`
    }));

    // Format apaydeposits
    const apayDeposits = apayDepositResult.rows.map(row => ({
      date: row.date,
      amount: `${row.amount} ${row.currency}`,
      status: normalizeStatus(row.status),
      details: `Txn: ${row.custom_transaction_id || 'N/A'}`
    }));

    // Format pay_in_transactions
    const payInTransactions = payInTransactionResult.rows.map(row => ({
      date: row.date,
      amount: `${row.amount} ${row.currency}`,
      status: normalizeStatus(row.status),
      details: `Type: ${row.pay_type || 'N/A'}`
    }));

    // Format crypto deposits
    const cryptoDeposits = ccDepositResult.rows.map(row => ({
      date: row.date,
      amount: row.amount,
      status: normalizeStatus(row.status),
      details: `Order: ${row.id}`
    }));

    // Combine fiat-like deposits (fiat, apay, pay_in) into fiatDeposits array
    const combinedFiatDeposits = [
      ...fiatDeposits,
      ...apayDeposits,
      ...payInTransactions
    ].sort((a, b) => new Date(b.date) - new Date(a.date)); // Sort by date DESC

    // Combine all deposits
    res.json({
      deposits: cryptoDeposits,
      fiatDeposits: combinedFiatDeposits
    });
  } catch (error) {
    console.error('Error fetching deposits:', error);
    res.status(500).json({ error: 'Failed to fetch deposits' });
  }
});

protectedRouter.get('/api/withdrawNew', async (req, res) => {
  const { uid } = req.query;  // Extract uid from query parameters
  try {
    const withdrawalsQuery = `
      SELECT wallet, amount, status, date , chain
      FROM withdrawals
      WHERE uid = $1 
      ORDER BY date DESC
    `;
    
    const fiatWithdrawalsQuery = `
      SELECT amount, status, date, currency, bank_name, account_number,
              account_holder_name, ifsc_code, upi_id, name 
      FROM fiat_withdrawals
      WHERE uid = $1 
      ORDER BY date DESC
    `;
    
    // Execute both queries in parallel
    const [withdrawalsResult, fiatWithdrawalsResult] = await Promise.all([
      pg.query(withdrawalsQuery, [uid]),
      pg.query(fiatWithdrawalsQuery, [uid])
    ]);
    
    // Combine results and send response
    res.json({
      withdrawals: withdrawalsResult.rows,
      fiatWithdrawals: fiatWithdrawalsResult.rows
    });
  } catch (error) {
    console.error(error);
    res.status(500).json({ error: "Failed to fetch today's withdrawals" });
  }
});

// Get today's transactions (deposits and withdrawals)
protectedRouter.get('/today-transactions', async (req, res) => {
  try {
   const deposits = await pg.query(`
    SELECT 
        uid,
        date,
        status,
        txtid,
        amount,
        coin,
        salt
    FROM deposits
    WHERE DATE(date) = CURRENT_DATE
`);

const withdrawals = await pool.query(`
    SELECT 
        uid,
        date,
        amount,
        wallet,
        status,
        coin,
        id,
        chain
    FROM withdrawals
    WHERE DATE(date) = CURRENT_DATE
`);
    res.json([...deposits.rows, ...withdrawals.rows]);
  } catch (error) {
    res.status(500).json({ error: 'Failed to fetch today\'s transactions' });
  }
});

protectedRouter.get('/api/admin/dashboard', async (req, res) => {
  try {
    const today = new Date();
    today.setHours(0, 0, 0, 0);
    const todayISO = today.toISOString();
    const yesterday = new Date(today);
    yesterday.setDate(today.getDate() - 1);
    const yesterdayISO = yesterday.toISOString();

    // Coin ID to currency mapping for ccdeposit
    const coinIdToCurrency = {
      1155: 'BTC',
      1161: 'ETH',
      1173: 'LTC',
      1169: 'BCH',
      1280: 'USDT',
      1482: 'TRX',
      1492: 'DOGE',
      1375: 'ADA',
      1331: 'XRP',
      1168: 'BNB',
      1282: 'USDC',
      1864: 'SHIB'
    };

    // Run all queries in parallel for better performance
    const [
      // User statistics
      totalUsersResult,
      todayUsersResult,

      // Total deposits from different sources (in USD)
      totalCryptoDepositsResult,
      totalFiatDepositsResult,
      totalApayDepositsResult,
      totalPayInTransactionsResult,

      // Previous total deposits (up to yesterday, in USD)
      prevTotalCryptoDepositsResult,
      prevTotalFiatDepositsResult,
      prevTotalApayDepositsResult,
      prevTotalPayInTransactionsResult,

      // Today's deposits (in USD)
      todayCryptoDepositsResult,
      todayFiatDepositsResult,
      todayApayDepositsResult,
      todayPayInTransactionsResult,

      // Total withdrawals (in USD)
      totalCryptoWithdrawalsResult,
      totalFiatWithdrawalsResult,

      // Previous total withdrawals (up to yesterday, in USD)
      prevTotalCryptoWithdrawalsResult,
      prevTotalFiatWithdrawalsResult,

      // Today's withdrawals (in USD)
      todayCryptoWithdrawalsResult,
      todayFiatWithdrawalsResult,
    ] = await Promise.all([
      // User statistics
      pg.query('SELECT COUNT(*) as count FROM users'),
      pg.query('SELECT COUNT(*) as count FROM users WHERE created >= $1', [todayISO]),

      // Total deposits from all sources (converted to USD)
      pg.query(`
        SELECT COALESCE(SUM(c.amount::numeric * e.usd_rate), 0) as total
        FROM ccdeposit c
        JOIN exchangerate e ON CASE
          WHEN c.coinid = 1155 THEN 'BTC'
          WHEN c.coinid = 1161 THEN 'ETH'
          WHEN c.coinid = 1173 THEN 'LTC'
          WHEN c.coinid = 1169 THEN 'BCH'
          WHEN c.coinid = 1280 THEN 'USDT'
          WHEN c.coinid = 1482 THEN 'TRX'
          WHEN c.coinid = 1492 THEN 'DOGE'
          WHEN c.coinid = 1375 THEN 'ADA'
          WHEN c.coinid = 1331 THEN 'XRP'
          WHEN c.coinid = 1168 THEN 'BNB'
          WHEN c.coinid = 1282 THEN 'USDC'
          WHEN c.coinid = 1864 THEN 'SHIB'
        END = e.currency
        WHERE c.status = 'Success'
      `),
      pg.query(`
        SELECT COALESCE(SUM(f.amount::numeric * e.usd_rate), 0) as total
        FROM fiat_deposits f
        JOIN exchangerate e ON f.currency = e.currency
        WHERE f.status = 'approved'
      `),
      pg.query(`
        SELECT COALESCE(SUM(a.amount::numeric * e.usd_rate), 0) as total
        FROM apaydeposits a
        JOIN exchangerate e ON a.currency = e.currency
        WHERE a.status = 'Success'
      `),
      pg.query(`
        SELECT COALESCE(SUM(p.amount::numeric * e.usd_rate), 0) as total
        FROM pay_in_transactions p
        JOIN exchangerate e ON p.currency = e.currency
        WHERE p.status = 1
      `),

      // Previous total deposits (up to yesterday, in USD)
      pg.query(`
        SELECT COALESCE(SUM(c.amount::numeric * e.usd_rate), 0) as total
        FROM ccdeposit c
        JOIN exchangerate e ON CASE
          WHEN c.coinid = 1155 THEN 'BTC'
          WHEN c.coinid = 1161 THEN 'ETH'
          WHEN c.coinid = 1173 THEN 'LTC'
          WHEN c.coinid = 1169 THEN 'BCH'
          WHEN c.coinid = 1280 THEN 'USDT'
          WHEN c.coinid = 1482 THEN 'TRX'
          WHEN c.coinid = 1492 THEN 'DOGE'
          WHEN c.coinid = 1375 THEN 'ADA'
          WHEN c.coinid = 1331 THEN 'XRP'
          WHEN c.coinid = 1168 THEN 'BNB'
          WHEN c.coinid = 1282 THEN 'USDC'
          WHEN c.coinid = 1864 THEN 'SHIB'
        END = e.currency
        WHERE c.status = 'Success' AND c.created_at < $1
      `, [todayISO]),
      pg.query(`
        SELECT COALESCE(SUM(f.amount::numeric * e.usd_rate), 0) as total
        FROM fiat_deposits f
        JOIN exchangerate e ON f.currency = e.currency
        WHERE f.status = 'approved' AND f.created_at < $1
      `, [todayISO]),
      pg.query(`
        SELECT COALESCE(SUM(a.amount::numeric * e.usd_rate), 0) as total
        FROM apaydeposits a
        JOIN exchangerate e ON a.currency = e.currency
        WHERE a.status = 'Success' AND a.created_at < $1
      `, [todayISO]),
      pg.query(`
        SELECT COALESCE(SUM(p.amount::numeric * e.usd_rate), 0) as total
        FROM pay_in_transactions p
        JOIN exchangerate e ON p.currency = e.currency
        WHERE p.status = 1 AND p.created_at < $1
      `, [todayISO]),

      // Today's deposits (in USD)
      pg.query(`
        SELECT COALESCE(SUM(c.amount::numeric * e.usd_rate), 0) as total, COUNT(*) as count
        FROM ccdeposit c
        JOIN exchangerate e ON CASE
          WHEN c.coinid = 1155 THEN 'BTC'
          WHEN c.coinid = 1161 THEN 'ETH'
          WHEN c.coinid = 1173 THEN 'LTC'
          WHEN c.coinid = 1169 THEN 'BCH'
          WHEN c.coinid = 1280 THEN 'USDT'
          WHEN c.coinid = 1482 THEN 'TRX'
          WHEN c.coinid = 1492 THEN 'DOGE'
          WHEN c.coinid = 1375 THEN 'ADA'
          WHEN c.coinid = 1331 THEN 'XRP'
          WHEN c.coinid = 1168 THEN 'BNB'
          WHEN c.coinid = 1282 THEN 'USDC'
          WHEN c.coinid = 1864 THEN 'SHIB'
        END = e.currency
        WHERE c.status = 'Success' AND c.created_at >= $1
      `, [todayISO]),
      pg.query(`
        SELECT COALESCE(SUM(f.amount::numeric * e.usd_rate), 0) as total, COUNT(*) as count
        FROM fiat_deposits f
        JOIN exchangerate e ON f.currency = e.currency
        WHERE f.status = 'approved' AND f.created_at >= $1
      `, [todayISO]),
      pg.query(`
        SELECT COALESCE(SUM(a.amount::numeric * e.usd_rate), 0) as total, COUNT(*) as count
        FROM apaydeposits a
        JOIN exchangerate e ON a.currency = e.currency
        WHERE a.status = 'Success' AND a.created_at >= $1
      `, [todayISO]),
      pg.query(`
        SELECT COALESCE(SUM(p.amount::numeric * e.usd_rate), 0) as total, COUNT(*) as count
        FROM pay_in_transactions p
        JOIN exchangerate e ON p.currency = e.currency
        WHERE p.status = 1 AND p.created_at >= $1
      `, [todayISO]),

      // Total withdrawals (in USD)
      pg.query(`
        SELECT COALESCE(SUM(w.amount::numeric * e.usd_rate), 0) as total
        FROM withdrawals w
        JOIN exchangerate e ON UPPER(w.coin) = e.currency
        WHERE w.status = 'Done'
      `),
      pg.query(`
        SELECT COALESCE(SUM(f.amount::numeric * e.usd_rate), 0) as total
        FROM fiat_withdrawals f
        JOIN exchangerate e ON f.currency = e.currency
        WHERE f.status = 'Done'
      `),

      // Previous total withdrawals (up to yesterday, in USD)
      pg.query(`
        SELECT COALESCE(SUM(w.amount::numeric * e.usd_rate), 0) as total
        FROM withdrawals w
        JOIN exchangerate e ON UPPER(w.coin) = e.currency
        WHERE w.status = 'Done' AND w.date < $1
      `, [todayISO]),
      pg.query(`
        SELECT COALESCE(SUM(f.amount::numeric * e.usd_rate), 0) as total
        FROM fiat_withdrawals f
        JOIN exchangerate e ON f.currency = e.currency
        WHERE f.status = 'Done' AND f.date < $1
      `, [todayISO]),

      // Today's withdrawals (in USD)
      pg.query(`
        SELECT COALESCE(SUM(w.amount::numeric * e.usd_rate), 0) as total, COUNT(*) as count
        FROM withdrawals w
        JOIN exchangerate e ON UPPER(w.coin) = e.currency
        WHERE w.status = 'Done' AND w.date >= $1
      `, [todayISO]),
      pg.query(`
        SELECT COALESCE(SUM(f.amount::numeric * e.usd_rate), 0) as total, COUNT(*) as count
        FROM fiat_withdrawals f
        JOIN exchangerate e ON f.currency = e.currency
        WHERE f.status = 'Done' AND f.date >= $1
      `, [todayISO]),
    ]);

    // Calculate totals (all in USD)
    const totalDeposits = parseFloat(totalCryptoDepositsResult.rows[0].total) +
                          parseFloat(totalFiatDepositsResult.rows[0].total) +
                          parseFloat(totalApayDepositsResult.rows[0].total) +
                          parseFloat(totalPayInTransactionsResult.rows[0].total);

    const prevTotalDeposits = parseFloat(prevTotalCryptoDepositsResult.rows[0].total) +
                              parseFloat(prevTotalFiatDepositsResult.rows[0].total) +
                              parseFloat(prevTotalApayDepositsResult.rows[0].total) +
                              parseFloat(prevTotalPayInTransactionsResult.rows[0].total);

    const totalWithdrawals = parseFloat(totalCryptoWithdrawalsResult.rows[0].total) +
                             parseFloat(totalFiatWithdrawalsResult.rows[0].total);

    const prevTotalWithdrawals = parseFloat(prevTotalCryptoWithdrawalsResult.rows[0].total) +
                                 parseFloat(prevTotalFiatWithdrawalsResult.rows[0].total);

    const todayDepositsAmount = parseFloat(todayCryptoDepositsResult.rows[0].total) +
                                parseFloat(todayFiatDepositsResult.rows[0].total) +
                                parseFloat(todayApayDepositsResult.rows[0].total) +
                                parseFloat(todayPayInTransactionsResult.rows[0].total);

    const todayDepositsCount = parseInt(todayCryptoDepositsResult.rows[0].count) +
                              parseInt(todayFiatDepositsResult.rows[0].count) +
                              parseInt(todayApayDepositsResult.rows[0].count) +
                              parseInt(todayPayInTransactionsResult.rows[0].count);

    const todayWithdrawalsAmount = parseFloat(todayCryptoWithdrawalsResult.rows[0].total) +
                                   parseFloat(todayFiatWithdrawalsResult.rows[0].total);

    const todayWithdrawalsCount = parseInt(todayCryptoWithdrawalsResult.rows[0].count) +
                                  parseInt(todayFiatWithdrawalsResult.rows[0].count);

    // Calculate fiat breakdown for today (combining fiat_deposits, apaydeposits, and pay_in_transactions)
    const todayFiatDepositsAmount = parseFloat(todayFiatDepositsResult.rows[0].total) +
                                    parseFloat(todayApayDepositsResult.rows[0].total) +
                                    parseFloat(todayPayInTransactionsResult.rows[0].total);

    const todayFiatDepositsCount = parseInt(todayFiatDepositsResult.rows[0].count) +
                                   parseInt(todayApayDepositsResult.rows[0].count) +
                                   parseInt(todayPayInTransactionsResult.rows[0].count);

    // Calculate fiat breakdown for total (combining fiat_deposits, apaydeposits, and pay_in_transactions)
    const totalFiatDepositsAmount = parseFloat(totalFiatDepositsResult.rows[0].total) +
                                    parseFloat(totalApayDepositsResult.rows[0].total) +
                                    parseFloat(totalPayInTransactionsResult.rows[0].total);

    // Format and send response (all monetary values in USD)
    res.json({
      totalUsers: parseInt(totalUsersResult.rows[0].count),
      previousTotalUsers: parseInt(totalUsersResult.rows[0].count) - parseInt(todayUsersResult.rows[0].count),
      newUsersToday: parseInt(todayUsersResult.rows[0].count),

      deposits: {
        total: totalDeposits.toFixed(2),
        previousTotal: prevTotalDeposits.toFixed(2),
        breakdown: {
          crypto: parseFloat(totalCryptoDepositsResult.rows[0].total).toFixed(2),
          fiat: totalFiatDepositsAmount.toFixed(2)
        },
        today: {
          amount: todayDepositsAmount.toFixed(2),
          count: todayDepositsCount,
          breakdown: {
            crypto: {
              amount: parseFloat(todayCryptoDepositsResult.rows[0].total).toFixed(2),
              count: parseInt(todayCryptoDepositsResult.rows[0].count)
            },
            fiat: {
              amount: todayFiatDepositsAmount.toFixed(2),
              count: todayFiatDepositsCount
            }
          }
        }
      },

      withdrawals: {
        total: totalWithdrawals.toFixed(2),
        previousTotal: prevTotalWithdrawals.toFixed(2),
        breakdown: {
          crypto: parseFloat(totalCryptoWithdrawalsResult.rows[0].total).toFixed(2),
          fiat: parseFloat(totalFiatWithdrawalsResult.rows[0].total).toFixed(2)
        },
        today: {
          amount: todayWithdrawalsAmount.toFixed(2),
          count: todayWithdrawalsCount,
          breakdown: {
            crypto: {
              amount: parseFloat(todayCryptoWithdrawalsResult.rows[0].total).toFixed(2),
              count: parseInt(todayCryptoWithdrawalsResult.rows[0].count)
            },
            fiat: {
              amount: parseFloat(todayFiatWithdrawalsResult.rows[0].total).toFixed(2),
              count: parseInt(todayFiatWithdrawalsResult.rows[0].count)
            }
          }
        }
      },

      financials: {
        netBalance: (totalDeposits - totalWithdrawals).toFixed(2),
        previousNetBalance: (prevTotalDeposits - prevTotalWithdrawals).toFixed(2),
        todayNetBalance: (todayDepositsAmount - todayWithdrawalsAmount).toFixed(2)
      },

      timestamp: new Date().toISOString(),
      date: new Date().toLocaleDateString()
    });
  } catch (error) {
    console.error('Error fetching admin dashboard data:', error);
    res.status(500).json({ 
      error: 'Failed to fetch dashboard data',
      details: error.toString()
    });
  }
});
/**
 * Admin Detailed User Statistics API
 * Provides detailed information about user growth and activity
 */
protectedRouter.get('/api/admin/user-stats', async (req, res) => {
  try {
    const today = new Date();
    today.setHours(0, 0, 0, 0);
    const todayISO = today.toISOString();

    // Get counts for different user segments
    const [
      totalUsersResult,
      todayUsersResult,
      activeUsersResult,
      prevActiveUsersResult,
      verifiedUsersResult,
      prevVerifiedUsersResult,
      usersByCountryResult,
      registrationTrendResult
    ] = await Promise.all([
      pg.query('SELECT COUNT(*) as count FROM users'),
      pg.query('SELECT COUNT(*) as count FROM users WHERE created >= $1', [todayISO]),
      pg.query("SELECT COUNT(*) as active FROM users WHERE created >= (CURRENT_DATE - INTERVAL '30 days')"),
      pg.query("SELECT COUNT(*) as active FROM users WHERE created >= (CURRENT_DATE - INTERVAL '60 days') AND created < (CURRENT_DATE - INTERVAL '30 days')"),
      pg.query(`
        SELECT COUNT(*) as count
        FROM users u
        LEFT JOIN user_kyc k ON u.id = k.user_id::bigint
        WHERE k.status = 'Verified'
      `),
      pg.query(`
        SELECT COUNT(*) as count
        FROM users u
        LEFT JOIN user_kyc k ON u.id = k.user_id::bigint
        WHERE k.status = 'Verified' AND u.created < $1
      `, [todayISO]),
      pg.query("SELECT country, COUNT(*) as count FROM users WHERE country IS NOT NULL GROUP BY country ORDER BY count DESC LIMIT 10"),
      pg.query(`
        SELECT 
          DATE(created) as date,
          COUNT(*) as count
        FROM users
        WHERE created >= CURRENT_DATE - INTERVAL '30 days'
        GROUP BY DATE(created)
        ORDER BY date ASC
      `)
    ]);

    res.json({
      totalUsers: parseInt(totalUsersResult.rows[0].count),
      previousTotalUsers: parseInt(totalUsersResult.rows[0].count) - parseInt(todayUsersResult.rows[0].count),
      newUsersToday: parseInt(todayUsersResult.rows[0].count),
      activeUsers30d: parseInt(activeUsersResult.rows[0].active),
      previousActiveUsers30d: parseInt(prevActiveUsersResult.rows[0].active),
      verifiedUsers: parseInt(verifiedUsersResult.rows[0].count),
      previousVerifiedUsers: parseInt(prevVerifiedUsersResult.rows[0].count),
      topCountries: usersByCountryResult.rows,
      registrationTrend: registrationTrendResult.rows,
      timestamp: new Date().toISOString()
    });
  } catch (error) {
    console.error('Error fetching user statistics:', error);
    res.status(500).json({ 
      error: 'Failed to fetch user statistics',
      details: error.toString()
    });
  }
});



// Get live bets
protectedRouter.get('/live-bets', async (req, res) => {
  try {
  const result = await pg.query(`
    SELECT 
        game,
        gid,
        uid,
        amount,
        coin,
        result,
        profit,
        created,
        hash,
        name,
        cashout,
        slot
    FROM bets
    ORDER BY created DESC
    LIMIT 50
`);
    res.json(result.rows);
  } catch (error) {
    res.status(500).json({ error: 'Failed to fetch live bets' });
  }
});


protectedRouter.post("/inrhistory", async function (req, res) {
  res.setHeader("Access-Control-Allow-Origin", "*");
  res.setHeader("Access-Control-Allow-Headers", "Content-Type");
  const { name } = req.body;

  pg.query("SELECT date,amount,status,trxid FROM inr_deposit WHERE name = $1", [name], function (err, result) {
      if (err) {
          console.log("Error on select query:", err);
          res.status(500).json({ error: 'An error occurred while fetching data.' });
          return;
      }

      // Directly send the result as a response
      res.json(result.rows);
  });
});

server.use('/', protectedRouter);

const setEventHandlers = () => {
  console.log("API Server is running on port:", config.port);

  if (config.developer) {
    Crash.idle(io);
    Keno.IdleGame(io);
    Bots.Idle(io);
    Market.update(); // need at first
    setInterval(() => {
      Market.update();
    }, 3600000);
  } else {
    Market.dummyUpdate();
  }

  io.sockets.on("connection", onPublicConnection);

  const admin = io.of("/pedramx");
  admin.use((socket, next) => {
    next();
  });
  admin.on("connection", onPrivateConnection);
};

const onPublicConnection = (client) => {
  users++;

  const token = client.handshake.query.auth_token;
 
  if (!token) return;

  let ip = client.request.connection.remoteAddress;
  if (!ip) ip = client.handshake.headers["x-forwarded-for"];
  let origin = client.handshake.headers.origin;
  let domain = ["http://localhost:3000","http://localhost:3004","https://boss707.com","https://api.boss707.com","http://localhost:3001","http://localhost:3002","http://localhost:3003"];

  if (config.developer) {
    if (!domain.includes(origin)) {
      Notify.send("ORIGIN => " + origin + " - Details : " + ip);
      return console.log("origin");
    }
  }

  setTimeout(() => {
    client.emit("U2t5cGU6IEBQZWRyb3hhbQ", "U2t5cGU6IEBQZWRyb3hhbQ==");
  }, 2000);

  Notify.send("New Online User, Total: " + users + " / Details: " + ip);

  Token.getID(token, (id) => {
    if (id) {
      uid = id.toString();
      client.userid = id;
      client.join(parseFloat(id));
    }
    client.on("disconnecting", () => {
      users--;
      if (id) client.leave(id);
    });

    Users(client, io, id,siofu);
    Games(client, io, id);
    Slots(client, io, id);
    // setupSiteConfigSocket(io);
    client.on('getBonusTimers', async () => {
    if (id) {
      try {
        const timerData = await getUserBonusTimers(id);
        client.emit('bonusTimerUpdate', timerData);
      } catch (error) {
        console.error('Error getting bonus timers:', error);
      }
    }
  });
  });
};
function onPrivateConnection(client) {
    Admin(client, io);
  }
  
  if (config.developer) {
    try {
      setEventHandlers();
    } catch (e) {
      console.log("catch", e);
    }
  } else {
    setEventHandlers();
  }
  
  if (config.developer) {
    process.stdin.resume();
    function exitHandler(err, exitCode) {
      Notify.send("ERROR EXIT: " + JSON.stringify(err), true);
    }
    process.on(
      "uncaughtException",
      exitHandler.bind(null, {
        exit: true,
      })
    );
  }
  
  app.listen(config.port);
}
