// routes/sessionRoutes.js
const express = require('express');
const router = express.Router();
const sessions = require('../controller/controller');

// Admin: fetch all sessions for a given user
// GET /api/admin/users/:userId/sessions
router.get(
  '/admin/users/:userId/sessions',
  sessions.getUserSessions
);

// Client: record a session on login
// POST /api/sessions
router.post(
  '/sessions',
  sessions.createSession
);

module.exports = router;
