const pg = require('../../General/Model');

/** return array of descendant staff IDs + self; super (level 0) also gets null */
async function permittedStaffIds(staffId, level) {
  const { rows } = await pg.query(
    `SELECT descendant_id FROM staff_hierarchy WHERE ancestor_id=$1`,
    [staffId]
  );
  const ids = rows.map(r => r.descendant_id);
  ids.push(staffId);
  if (level === 0) ids.push(null);         // orphans for SuperAdmin
  return ids;
}

async function canAccessUser(staffId, level, userId) {
  const ids = await permittedStaffIds(staffId, level);
  const { rows } = await pg.query(
    `SELECT 1 FROM users
      WHERE id=$1
        AND (parent_staff_id = ANY($2) OR ($3=0 AND parent_staff_id IS NULL))`,
    [userId, ids, level]
  );
  return !!rows.length;
}

module.exports = { permittedStaffIds, canAccessUser };
