const axios = require('axios');

const getEventResult = async (req, res) => {
  try {
    // Get eventid from query parameters
    const { eventid } = req.query;
    
    if (!eventid) {
      return res.status(400).json({ error: 'eventid parameter is required' });
    }

    // Make request to external API for event result
    const response = await axios.get(`http://89.116.20.218:8085/api/result/event-result?eventid=${eventid}`, {
      headers: {
        'x-rapidapi-key': process.env.RAPIDAPI_KEY ?? '2ca9cb98b4mshd1781885e76d4d1p19b3e0jsna3a9558803ed',
        'x-rapidapi-host': process.env.RAPIDAPI_HOST ?? 'betfair-betting-api1.p.rapidapi.com',
        'X-ScoreSwift-Key': process.env.SCORESWIFT_KEY ?? 'eNp57Jb7yHgI26S8Yw4u_v31'
      }
    });

    // Send back the response received from API
    return res.status(200).json(response.data);
    
  } catch (error) {
    console.error('Error fetching event result:', error.message);
    return res.status(500).json({ 
      error: 'Failed to fetch event result',
      details: error.response?.data || error.message 
    });
  }
};

const getEventListResult = async (req, res) => {
  try {
    // Get sid (sport id) from query parameters
    const { sid } = req.query;
    
    if (!sid) {
      return res.status(400).json({ error: 'sid (sport id) parameter is required' });
    }

    // Make request to external API for event list
    const response = await axios.get(`http://89.116.20.218:8085/api/result/event-list?sid=${sid}`, {
      headers: {
        'x-rapidapi-key': process.env.RAPIDAPI_KEY ?? '2ca9cb98b4mshd1781885e76d4d1p19b3e0jsna3a9558803ed',
        'x-rapidapi-host': process.env.RAPIDAPI_HOST ?? 'betfair-betting-api1.p.rapidapi.com',
        'X-ScoreSwift-Key': process.env.SCORESWIFT_KEY ?? 'eNp57Jb7yHgI26S8Yw4u_v31'
      }
    });

    // Send back the response received from API
    return res.status(200).json(response.data);
    
  } catch (error) {
    console.error('Error fetching event list:', error.message);
    return res.status(500).json({ 
      error: 'Failed to fetch event list',
      details: error.response?.data || error.message 
    });
  }
};

module.exports = {
  getEventResult,
  getEventListResult
};