const axios = require('axios');
const { filterSeriesData } = require('./seriesfilter'); // Adjust the path as needed

const getCompetitions = async (req, res) => {
  try {
    const gameId = req.query.id;

    // Validate game ID
    if (!gameId) {
      return res.status(400).json({ error: 'Game ID is required' });
    }

    // Fetch competitions from external API
    const response = await axios.get('http://89.116.20.218:8085/api/getCompetitions', {
      params: { id: gameId },
      headers: {
        'x-rapidapi-key': process.env.RAPIDAPI_KEY ?? 'eNp57Jb7yHgI26S8Yw4u_v31',
        'x-rapidapi-host': process.env.RAPIDAPI_HOST ?? 'betfair14.p.rapidapi.com',
        'X-ScoreSwift-Key': process.env.SCORESWIFT_KEY ?? 'eNp57Jb7yHgI26S8Yw4u_v31'
      }
    });

    // Use the filterSeriesData function to filter the competitions
    const filteredSeries = await filterSeriesData(response.data, gameId);

    // Return the filtered competitions
    res.json(filteredSeries);

  } catch (error) {
    console.error('Competitions fetch error:', error);
    res.status(500).json({
      error: 'Error fetching competitions',
      details: error.message
    });
  }
};

module.exports = { getCompetitions };