// controllers/sportsController.js
const SportsConfig = require('./sportsconfig');

class SportsController {
  static async getAllSports(req, res) {
    try {
      const sports = await SportsConfig.getAllSports();
      res.json({
        success: true,
        data: sports
      });
    } catch (error) {
      res.status(500).json({
        success: false,
        error: error.message
      });
    }
  }

  static async getSportById(req, res) {
    try {
      const { id } = req.params;
      const sport = await SportsConfig.getSportById(id);
      
      if (!sport) {
        return res.status(404).json({
          success: false,
          error: 'Sport not found'
        });
      }

      res.json({
        success: true,
        data: sport
      });
    } catch (error) {
      res.status(500).json({
        success: false,
        error: error.message
      });
    }
  }

  static async updateSport(req, res) {
    try {
      const { id } = req.params;
      const { enabled } = req.body;

      if (typeof enabled !== 'boolean') {
        return res.status(400).json({
          success: false,
          error: 'Enabled status must be a boolean'
        });
      }

      const updatedSport = await SportsConfig.updateSport(id, enabled);

      if (!updatedSport) {
        return res.status(404).json({
          success: false,
          error: 'Sport not found'
        });
      }

      res.json({
        success: true,
        data: updatedSport
      });
    } catch (error) {
      res.status(500).json({
        success: false,
        error: error.message
      });
    }
  }
}

module.exports = SportsController;