const bcrypt = require('bcrypt');
const pg = require('../../General/Model');

async function updateStaffPassword(email, newPassword) {
    try {
        // Generate new hash
        const newHash = await bcrypt.hash(newPassword, 10);
        
        // Update the password in database
        const result = await pg.query(
            'UPDATE staff SET password = $1 WHERE email = $2 RETURNING id, email',
            [newHash, email]
        );
        
        if (result.rows.length === 0) {
            console.log('No staff found with email:', email);
            return false;
        }
        
        console.log('Password updated successfully for:', email);
        console.log('Updated staff ID:', result.rows[0].id);
        return true;
        
    } catch (error) {
        console.error('Error updating password:', error);
        return false;
    }
}

// Usage - replace with the actual email from your staff table
const staffEmail = 'superadmin@smartbet36.com'; // Replace with actual email
const newPassword = 'Superadmin@234';

updateStaffPassword(staffEmail, newPassword);