const express  = require('express');
const multer   = require('multer');
const ctrl     = require('./controller');
const { requireStaffForUsername } =
        require('./middleware');

const router  = express.Router();
const upload  = multer({ limits:{fileSize:5*1024*1024} });

/* USER – create manual INR deposit
   body must contain:
   { username, handled_by, amount, transaction_id, ... }           */
router.post('/create', upload.single('screenshot'), ctrl.createDeposit);

/* STAFF – list own pending */
router.get('/admin/pending', ctrl.getPendingDeposits);

/* STAFF – approve / reject (only inside hierarchy) */
router.put('/admin/approve/:id', ctrl.approveDeposit);
router.put('/admin/reject/:id',  ctrl.rejectDeposit);
router.get('/admin/:staffId', ctrl.listByHierarchy); 
/* optional: list history for one username */
router.get('/user/history/:username',
           requireStaffForUsername(), ctrl.getUserDeposits);
// routes/deposit.js
router.get('/:staff_id(\\d+)?/:id/screenshot', ctrl.getDepositScreenshot);
router.post('/user-pl', ctrl.getUserPL);
router.post('/staff-pl', ctrl.getStaffPL);
module.exports = router;
