/* -------------------------------------------------------------
   ONE canonical helper for INR moves
------------------------------------------------------------- */
exports.transferInr = async (
  client,
  fromType, fromId,
  toType,   toId,
  amount,
  skipDebit = false,
  direction                       //  <── 'deposit' | 'withdraw'
) => {

  amount = Number(amount);
  console.log(amount, typeof amount);
  if (!Number.isFinite(amount) || amount <= 0)
    throw new Error("Amount must be positive");

  const tbl = t => (t==="staff" ? "staff_balances" : "credits");
  const idc = t => (t==="staff" ? "staff_id"       : "uid");

  /* debit */
  if (!skipDebit) {
    await client.query(
      `UPDATE ${tbl(fromType)}
          SET inr = inr - $1
        WHERE ${idc(fromType)} = $2`,
      [amount, fromId]
    );
  }

  /* credit (upsert) */
  await client.query(
    `INSERT INTO ${tbl(toType)} (${idc(toType)}, inr)
         VALUES ($1,$2)
     ON CONFLICT (${idc(toType)})
     DO UPDATE SET inr = ${tbl(toType)}.inr + EXCLUDED.inr`,
    [toId, amount]
  );

  /* history row –  simple, no CASE */
  await client.query(
    `INSERT INTO staff_transfers
           (from_type, from_id, to_type, to_id, amount, direction)
     VALUES ($1,$2,$3,$4,$5,$6)`,
    [fromType, fromId, toType, toId, amount, direction]
  );
};
