import React from 'react';
import styled from 'styled-components';
import Social from '../../Pages/Parts/Sidebar/Social';
import { useSidebar } from '../../../context/SidebarContext';

const Container = styled.div`
  background-color: #1B1D21;
  padding: 20px;
`;

const FooterWrapper = styled.div`
  color: #ffffff;
  padding: 20px 0px;
  display: flex;
  justify-content: space-between;
  font-family: Arial, sans-serif;

  @media (max-width: 768px) {
    flex-direction: column;
    padding: 15px 0px;
    gap: 20px;
  }
`;

const Divider = styled.div`
  width: 100%;
  height: 0.5px;
  background-color: #fff;
  margin: 10px 0;

  @media (max-width: 768px) {
    margin: 15px 0;
  }
`;

const Section = styled.div`
  width: 50%;
  padding-left: 40px;
  justify-content: center;
  color: #fff;
  font-family: Arial, sans-serif !important;
  font-size: 14px;

  @media (max-width: 768px) {
    width: 100%;
    padding-left: 0;
    margin-bottom: 20px;
    text-align: center;
  }
`;

const Logo = styled.img`
  width: 150px;
  height: auto;

  @media (max-width: 768px) {
    width: 120px;
    margin: 0 auto;
    display: block;
  }
`;

const Description = styled.div`
  font-size: 14px;
  margin-top: 10px;
  color: #fff;

  @media (max-width: 768px) {
    font-size: 12px;
    line-height: 1.5;
    margin-top: 15px;
  }
`;

const LinkHeader = styled.h3`
  color: #fff;
  font-family: Arial, sans-serif !important;
  font-size: 12px;

  @media (max-width: 768px) {
    font-size: 11px;
    margin-bottom: 8px;
  }
`;

const Link = styled.a`
  color: #fff;
  text-decoration: none;
  font-size: 12px;
  margin-bottom: 5px;
  display: block;
  &:hover {
    text-decoration: underline;
  }

  @media (max-width: 768px) {
    font-size: 11px;
    margin-bottom: 8px;
    text-align: center;
  }
`;

const CurrencyIcon = styled.img`
  width: 20px;
  height: 20px;
  margin-right: 5px;

  @media (max-width: 768px) {
    width: 18px;
    height: 18px;
    margin-right: 3px;
  }
`;

const Flex = styled.div`
  flex: 1;

  @media (max-width: 768px) {
    width: 100%;
  }
`;

const FlexWrap = styled.div`
  display: flex;

  @media (max-width: 768px) {
    flex-direction: column;
    gap: 20px;
  }
`;

const BottomFlexWrap = styled.div`
  display: flex;
  width: 100%;
  justify-content: space-between;
  margin: 20px 0px;

  @media (max-width: 768px) {
    flex-direction: column;
    align-items: center;
    text-align: center;
    margin: 15px 0px;
  }
`;

const FooterContainerTop = styled.div`
  padding: 40px 34px;
  margin-left: ${props => props.$isCollapsed ? '160px' : '250px'};

  @media (max-width: 768px) {
    margin-left: 0;
    padding: 20px 15px;
    visibility: visible;
    height: auto;
    overflow: visible;
    margin-bottom: 100px;
  }
`;

const AwardContainer = styled.div`
  display: flex;
  justify-content: center;
  align-items: center;
  gap: 12px;
  padding: 20px 0px;
  background: #295E5C;
  overflow-x: auto;

  @media (max-width: 768px) {
    gap: 8px;
    padding: 15px 0px;
    justify-content: flex-start;
    padding-left: 15px;
    padding-right: 15px;
  }
`;

const AwardCard = styled.div`
  display: flex;
  flex-direction: column;
  align-items: center;
  background-color: #2A2F30;
  border-radius: 8px;
  padding: 4px 8px;
  min-width: 140px;
  transition: transform 0.2s;

  &:hover {
    transform: translateY(-5px);
  }

  @media (max-width: 768px) {
    min-width: 100px;
    padding: 3px 6px;
  }
`;

const AwardImage = styled.div`
  width: 137px;
  height: 87px;

  img {
    width: 100%;
    height: 100%;
    object-fit: contain;
  }

  @media (max-width: 768px) {
    width: 90px;
    height: 60px;
  }
`;

const AwardTitle = styled.h3`
  color: #c4a042;
  font-size: 14px;
  font-weight: 600;
  text-align: center;
  margin: 0;
  text-transform: uppercase;

  @media (max-width: 768px) {
    font-size: 10px;
  }
`;

const AwardSubtitle = styled.p`
  color: #888;
  font-size: 12px;
  text-align: center;
  margin: 4px 0;
  text-transform: uppercase;

  @media (max-width: 768px) {
    font-size: 9px;
    margin: 2px 0;
  }
`;

const AwardYear = styled.span`
  color: #666;
  font-size: 12px;

  @media (max-width: 768px) {
    font-size: 9px;
  }
`;

const LogoContainer = styled.div`
  width: 100%;
  overflow-x: auto;
  -webkit-overflow-scrolling: touch;

  /* Hide scrollbar for Chrome, Safari and Opera */
  &::-webkit-scrollbar {
    display: none;
  }
  
  /* Hide scrollbar for IE, Edge and Firefox */
  -ms-overflow-style: none;
  scrollbar-width: none;

  @media (max-width: 768px) {
    margin: 15px 0;
  }
`;

const LogoWrapper = styled.div`
  display: flex;
  align-items: center;
  gap: 40px;
  justify-content: center;

  @media (max-width: 768px) {
    gap: 20px;
    justify-content: center;
    padding-left: 15px;
    padding-right: 15px;
    flex-wrap: wrap;
  }
`;

const Logo1 = styled.div`
  width: ${props => props.width}px;
  height: ${props => props.height}px;
  display: flex;
  align-items: center;
  
  img {
    width: 100%;
    height: 100%;
    object-fit: contain;
    filter: brightness(0.8);
    transition: filter 0.3s ease;
    
    &:hover {
      filter: brightness(1);
    }
  }

  @media (max-width: 768px) {
    width: ${props => Math.min(props.width * 0.7, 80)}px;
    height: ${props => Math.min(props.height * 0.7, 50)}px;
  }
`;

const MobileSection = styled.div`
  @media (max-width: 768px) {
    display: flex;
    flex-direction: column;
    gap: 15px;
  }
`;

const MobileLinkSection = styled.div`
  @media (max-width: 768px) {
    display: flex;
    flex-direction: column;
    gap: 15px;
    align-items: center;
  }
`;

const MobileCurrencySection = styled.div`
  @media (max-width: 768px) {
    display: flex;
    flex-direction: column;
    gap: 10px;
    align-items: center;
  }
`;

const awards = [
  {
    title: 'Best on Mobile',
    organization: 'Sigma Africa',
    year: '2024',
    image:'/assets/images/bcgames/awards/a1.webp'
  },
  {
    title: 'Best Casino Operator',
    organization: 'Sigma Europe',
    year: '2023',
    image:'/assets/images/bcgames/awards/a2.webp'
  },
  {
    title: 'Crypto Game Platform',
    organization: 'Sigma Asia',
    year: '2023',
    image:'/assets/images/bcgames/awards/a1.webp'
  },
  {
    title: 'Crypto Casino',
    organization: 'Sigma Europe',
    year: '2022',
    image:'/assets/images/bcgames/awards/a3.webp'
  },
  {
    title: 'Crypto Casino',
    organization: 'Sigma Africa',
    year: '2022',
    image:'/assets/images/bcgames/awards/a4.webp'
  },
  {
    title: 'Blockchain Gaming',
    organization: 'Platform America',
    year: '2022',
    image:'/assets/images/bcgames/awards/a5.webp'
  },
  {
    title: 'Crypto Casino',
    organization: 'Affpapa',
    year: '2022',
    image:'/assets/images/bcgames/awards/a6.webp'
  },
  {
    title: 'Crypto Casino',
    organization: 'Sigma Europe',
    year: '2022',
    image:'/assets/images/bcgames/awards/a7.webp'
  }
];

const logos = [
  { id: 1, src: '/assets/images/bcgames/promote/p1.webp', alt: 'Sigma', width: 100, height: 40 },
  { id: 2, src: '/assets/images/bcgames/promote/p2.webp', alt: 'Responsible Gambling', width: 100, height: 60 },
  { id: 3, src: '/assets/images/bcgames/promote/p3.webp', alt: 'GamCare', width: 100, height: 90 },
  { id: 4, src: '/assets/images/bcgames/promote/p4.webp', alt: 'Betblocker', width: 150, height: 50 },
  { id: 5, src: '/assets/images/bcgames/promote/p5.webp', alt: '18+', width: 50, height: 50 },
  { id: 6, src: '/assets/images/bcgames/promote/p6.webp', alt: 'Cloud9', width: 130, height: 45 },
  { id: 7, src: '/assets/images/bcgames/promote/p7.png', alt: 'Circular Logo', width: 50, height: 50 },
];

const paymentLogos = [
  { src: "/assets/images/shuffle/footerCoins/interacLogo.webp", alt: "Interac" },
  { src: "/assets/images/shuffle/footerCoins/btc.svg", alt: "Bitcoin" },
  { src: "/assets/images/shuffle/footerCoins/eth.svg", alt: "Ethereum" },
  { src: "/assets/images/shuffle/footerCoins/trx.svg", alt: "Tron" },
  { src: "/assets/images/shuffle/footerCoins/ltc.svg", alt: "Litecoin" },
  { src: "/assets/images/shuffle/footerCoins/sol.svg", alt: "Solana" },
  { src: "/assets/images/shuffle/footerCoins/ton.svg", alt: "Tether" },
  { src: "/assets/images/USDT.png", alt: "BNB" },
  { src: "/assets/images/shuffle/footerCoins/xrp.svg", alt: "XRP" },
  { src: "/assets/images/shuffle/footerCoins/link.svg", alt: "Cardano" },
  { src: "/assets/images/shuffle/footerCoins/ada.svg", alt: "BNB" },
];

const HelloFooter = () => {
  const { isCollapsed, setIsCollapsed } = useSidebar();
  
  return (
    <FooterContainerTop $isCollapsed={isCollapsed}>
      <LogoContainer>
        <LogoWrapper>
          {logos.map(logo => (
            <Logo1 key={logo.id} width={logo.width} height={logo.height}>
              <img src={logo.src} alt={logo.alt} />
            </Logo1>
          ))}
        </LogoWrapper>
      </LogoContainer>
      
      <Divider />
   
      <div style={{ width: "100%", display: "flex", justifyContent: "center" }}>
        <FooterWrapper>
          <Section>
            <Logo src="./assets/boss707.png" alt="FP.IO" />
            <Description>
              boss707 is built by gamblers for gamblers. With our unique community and a huge selection of games like Crash, HashDice, Plinko, Slots, and many more. Your greatest casino adventure is waiting for you!
            </Description>
          </Section>
          
          <Flex>
            <FlexWrap>
              <Section>
                <MobileLinkSection>
                  <Link href="/provably-fair">HELP CENTER</Link>
                  <Link href="/provably-fair">USER AGREEMENT</Link>
                  <Link href="/provably-fair">PRIVACY POLICY</Link>
                </MobileLinkSection>
              </Section>
              
              <Section>
                <MobileSection>
                  <div>
                    <LinkHeader>CONTACT US</LinkHeader>
                    <Link href="mailto:support@boss707.com">
                      Email: <span style={{ color: '#fff' }}>support@boss707.com</span>
                    </Link>
                  </div>
                  
                  <div>
                    <LinkHeader>ACCEPTED CURRENCIES</LinkHeader>
                    <MobileCurrencySection>
                      <div style={{ display: 'flex', gap: '8px', flexWrap: 'wrap', justifyContent: 'center' }}>
                        <CurrencyIcon src="/assets/images/BTC.png" alt="Bitcoin" />
                        <CurrencyIcon src="/assets/images/eth.png" alt="Ethereum" />
                        <CurrencyIcon src="/assets/images/doge.png" alt="Dogecoin" />
                        <CurrencyIcon src="/assets/images/TETHER.png" alt="Tether" />
                        <CurrencyIcon src="/assets/images/ltc.png" alt="Litecoin" />
                      </div>
                    </MobileCurrencySection>
                  </div>
                </MobileSection>
              </Section>
            </FlexWrap>
          </Flex>
        </FooterWrapper>
      </div>
    </FooterContainerTop>
  );
};

export default HelloFooter;