import React, { Component } from 'react'
import { Row, Col, Card } from "react-bootstrap";
import { __, forceSatoshiFormat } from "../../../../Helper";
import storage from "../../../../Storage";
import styled from 'styled-components';

const PaytableContainer = styled.div`
  background-color: rgb(18, 20, 24);
  color: white;
  padding: 20px;
  border-radius: 12px;
  margin: 20px 0;
  border: 1px solid #2a2a2a;
`;

const PaytableTitle = styled.h3`
  color: #34d399;
  text-align: center;
  margin-bottom: 20px;
  font-size: 1.5rem;
  font-weight: bold;
`;

const PaytableGrid = styled.div`
  display: grid;
  grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
  gap: 16px;
`;

const PaytableRow = styled.div`
  display: flex;
  justify-content: space-between;
  align-items: center;
  padding: 12px 16px;
  background-color: ${props => props.active ? 'rgba(52, 211, 153, 0.1)' : '#292D2E'};
  border-radius: 8px;
  border: ${props => props.active ? '1px solid #34d399' : '1px solid transparent'};
  transition: all 0.2s ease;
  
  &:hover {
    background-color: ${props => props.active ? 'rgba(52, 211, 153, 0.15)' : '#3A4142'};
  }
`;

const HandName = styled.div`
  color: ${props => props.active ? '#34d399' : 'white'};
  font-weight: ${props => props.active ? 'bold' : 'normal'};
  font-size: 14px;
`;

const Payout = styled.div`
  color: #34d399;
  font-weight: bold;
  font-size: 14px;
`;

class Table extends Component {
	constructor(props) {
		super(props);
		this.state = {
			amount: forceSatoshiFormat(storage.getKey('lam') ? storage.getKey('lam') : .00000010),
			scoreName: null
		}
	}

	componentDidMount() {
		this.props.engine.on('update_table', (score,) => {
			this.setState({ scoreName: __.upperCase(score) })
		})

		this.props.engine.on('update_table_amount', (amount) => {
			this.setState({ amount: parseFloat(amount) })
		})
	}

	render() {
		const { scoreName, amount } = this.state;
		
		const paytable = [
			{ name: 'ROYAL FLUSH', multiplier: 8, payout: amount * 8 },
			{ name: 'STRAIGHT FLUSH', multiplier: 4, payout: amount * 4 },
			{ name: 'FOUR OF A KIND', multiplier: 2, payout: amount * 2 },
			{ name: 'FULL HOUSE', multiplier: 1.9, payout: amount * 1.9 },
			{ name: 'FLUSH', multiplier: 1.6, payout: amount * 1.6 },
			{ name: 'STRAIGHT', multiplier: 1.4, payout: amount * 1.4 },
			{ name: 'THREE OF A KIND', multiplier: 1.3, payout: amount * 1.3 },
			{ name: 'TWO PAIR', multiplier: 1.2, payout: amount * 1.2 },
			{ name: 'JACKS OR BETTER', multiplier: 1.1, payout: amount * 1.1 },
			{ name: 'NOTHING', multiplier: 0, payout: 0 }
		];

		return (
			<PaytableContainer>
				<PaytableTitle>Video Poker Paytable</PaytableTitle>
				<PaytableGrid>
					{paytable.map((hand, index) => (
						<PaytableRow 
							key={index} 
							active={scoreName === hand.name}
						>
							<HandName active={scoreName === hand.name}>
								{hand.name}
							</HandName>
							<Payout>
								{hand.multiplier}x - {forceSatoshiFormat(hand.payout)}
							</Payout>
						</PaytableRow>
					))}
				</PaytableGrid>
			</PaytableContainer>
		);
	}
}

export default Table
