import React, { Component } from 'react';
import { withRouter } from "react-router-dom";
import Cookies from "js-cookie";
import Swal from 'sweetalert2';
import storage from "../../../Storage";
import {encode} from "../../../Helper";
import socket from "../../../Socket";
import C from "../../../Constant";
import styled from 'styled-components';
import { cleanupNotifications } from '../../../services/firebase';


const StyledImg = styled.img`
  height: 18px;
  width: 18px;
  filter: invert(48%) sepia(6%) saturate(426%) hue-rotate(167deg) brightness(94%) contrast(87%);
`;

class Logout extends Component {
    constructor(props) {
        super(props);
        this.state = {};
    }

    ask(){
        Swal.fire({
            title: 'Are you sure to logout?',
            text: "",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes!'
        }).then((result) => {
            if (result.value)
            {
                socket.emit(C.LOGOUT_USER);
                localStorage.clear();
                Cookies.remove("session");
                Cookies.remove("auth");
                Cookies.remove("uid");
                cleanupNotifications();
                window.location.replace('./');
            }
        });
    }

    render(){
        return(<div style={{marginRight:'6px'}}>
                <a onClick={this.ask} className={"dropdown-item"}>
                    {/* <i className="dripicons-exit text-muted ml-1 mr-2 text-drop"/> */}

                    <StyledImg className='ml-1 mr-2'  src='/assets/images/nanoicons/logout.png'/>
                    <span style={{ fontSize:'16px', color: '#676F78'}}>Logout</span>
                   
                </a>
        </div>);
    }
}

export default withRouter(Logout);
