import React, { useEffect, useState } from 'react';
import styled from 'styled-components';
import { useHistory } from 'react-router-dom';
import { Modal } from 'react-bootstrap';
import { Info, X } from 'lucide-react';
import storage from "../../../../Storage";
import socket from "../../../../Socket";
import C from "../../../../Constant";
import { getUID, decode, wait, sendNotfication } from '../../../../Helper';
import BonusDetails from '../BonusDetailsTable'; // Assuming this exists
import SkylaDepositModal from '../../Wallet/Deposit/ModalContent'; // Assuming this exists
import LockIcon from '../../../../Icons/LockIcon'; // Assuming this exists

// Styled Components Definitions (unchanged from your original code)
const Container = styled.div`
  height: 100vh;
  width: 100%;
  color: white;
  background: #111418;
  position: fixed;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  display: flex;
  flex-direction: column;
  overflow: hidden; /* Prevent container from scrolling */
`;

const BackButton = styled.div`
  position: absolute;
  top: 10px;
  right: 4px;
  background: transparent;
  height: 24px;
  width: 24px;
  z-index: 20;
  cursor: pointer;
`;

const InnerContainer = styled.div`
  flex-shrink: 0;
  background: #111418;
  z-index: 10;
  position: relative;
  top: 67px;
`;

const BonusCard = styled.div`
  background: linear-gradient(
    274deg,
    rgba(246, 105, 44, 0) 14.01%,
    rgba(246, 105, 44, 0.6) 146.96%
  );
  padding: 24px;
  height: 200px;
  width: 100%;
  position: relative;
  overflow: hidden;
  box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25);
`;

const BonusContent = styled.div`
  position: relative;
  z-index: 1;
  width: 60%;
`;

const TotalAmount = styled.div`
  font-size: 21px;
  color: white;
  font-weight: bold;
  margin-bottom: 0px;
  margin-top: -20px;
`;

const BonusType1 = styled.div`
  margin-top: -30px;
  .label {
    color: rgba(255, 255, 255, 0.6);
    font-size: 14px;
  }
  .amount {
    color: white;
    font-size: 16px;
    font-weight: bold;
  }
`;
const ModalContent = styled.div`
  background: rgb(18, 20, 24);
  border-radius: 12px;
  width: 100%;
  max-width: 480px;
  height: 45%;
  position: relative;
  animation: modalFadeIn 0.3s ease-out;
  display: flex;
  flex-direction: column;
  @keyframes modalFadeIn {
    from {
      opacity: 0;
      transform: translateY(-20px);
    }
    to {
      opacity: 1;
      transform: translateY(0);
    }
  }
`;

const DetailsButton = styled.button`
  background: transparent;
  border: none;
  color: rgba(255, 255, 255, 0.6);
  cursor: pointer;
  font-size: 12px;
  padding: 0;
  display: flex;
  align-items: center;
  gap: 4px;
  &:hover {
    color: white;
  }
`;

const ReedeemButton = styled.button`
  background: #917663;
  border: none;
  color: rgba(255, 255, 255, 0.6);
  cursor: pointer;
  font-size: 12px;
  padding: 4px 18px;
  display: flex;
  align-items: center;
  border-radius: 4px;
  gap: 4px;
  margin-top: 24px;
  &:hover {
    color: white;
  }
`;

const BonusCardImage = styled.img`
  position: absolute;
  top: 90px;
  right: -16px;
  transform: translateY(-50%);
  width: 80%;
  z-index: 0;
  opacity: 0.8;
  object-fit: cover;
`;

const ScrollableContent = styled.div`
  flex: 1;
  overflow-y: scroll; /* Changed to scroll for better mobile support */
  overflow-x: hidden;
  margin-top: 56px;
  -webkit-overflow-scrolling: touch; /* Momentum scrolling for iOS */
  padding: 0 12px 120px 12px; /* Increased bottom padding */
  min-height: 0; /* Prevents flex shrinkage issues */
  max-height: calc(100vh - 267px); /* Explicit max-height */
  -ms-overflow-style: none; /* Hide scrollbar for IE/Edge */
  scrollbar-width: none; /* Hide scrollbar for Firefox */
  touch-action: pan-y; /* Enable vertical touch scrolling */
  
  &::-webkit-scrollbar {
    display: none; /* Hide scrollbar for Chrome/Safari */
  }
  
  /* iOS-specific adjustments */
  @media (max-width: 768px) {
    padding-bottom: 150px; /* Extra padding for iOS */
    max-height: calc(100vh - 267px - env(safe-area-inset-bottom)); /* Respect safe areas */
  }
`;

const TabContainer = styled.div`
  margin-left: 0.5rem;
  display: flex;
  width: 100%;
  gap: 16px;
  justify-content: center;
  padding: 16px 0;
`;

const TabButton = styled.div`
  padding: 0.1rem 0.5rem;
  font-size: 0.9rem;
  font-weight: 500;
  transition: all 0.2s;
  border-bottom: ${props => props.active ? '2px solid #f09c06' : 'none'};
  color: ${props => props.active ? 'white' : '#9ca3af'};
  background-color: transparent;
  cursor: pointer;
  &:hover {
    color: white;
  }
`;

const GridContainer1 = styled.div`
  display: grid;
  grid-template-columns: repeat(1, 1fr);
  gap: 20px;
  padding: 12px;
`;

const CardBG = styled.div`
  background-color: rgb(50, 55, 56);
  border-radius: 12px;
  position: relative;
`;

const Card = styled.div`
  background: ${props => props.background || '#2b2b3d'};
  border-radius: 12px;
  padding: 16px;
  display: flex;
  align-items: center;
  position: relative;
  gap: 16px;
  min-height: 150px;
  backdrop-filter: blur(40px);
  -webkit-backdrop-filter: blur(40px);
`;

const ContentWrapper = styled.div`
  flex: 1;
  width: 100%;
  position: relative;
  margin-bottom: 20px;
`;

const ImagePlaceholder = styled.img`
  width: 100px;
  height: 100px;
  object-fit: contain;
`;

const CardTitle = styled.h3`
  color: white;
  font-size: 16px;
  margin: 4px 0;
  font-weight: 600;
`;

const StatRow = styled.div`
  color: #9ca3af;
  font-size: 12px;
`;

const ButtonWrapper = styled.div`
  display: flex;
  justify-content: flex-end;
  width: 100%;
  margin-top: 24px;
`;





const InfoModalContent = styled(ModalContent)`
 background:rgb(18, 20, 24);
  max-width: 480px;
  border-radius: 12px;
  border: 1px solid rgba(255, 255, 255, 0.1);
`;

const InfoList = styled.ul`
  list-style: none;
  padding: 0;
  margin: 0;

  li {
    padding: 12px 0;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
    color: rgba(255, 255, 255, 0.8);
    font-size: 14px;
    display: flex;
    align-items: center;
    gap: 10px;

    &:last-child {
      border-bottom: none;
    }

    &:before {
      content: "•";
      color: #D8AB59;
      font-size: 20px;
    }
  }
`;


const ModalOverlay = styled.div`
  position: fixed;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: rgba(0, 0, 0, 0.5);
  display: ${props => props.show ? 'flex' : 'none'};
  justify-content: center;
  align-items: center;
  z-index: 99999;
  padding: 12px;
`;



const ModalTitle = styled.h4`
  color: white;
  margin-top: 60px;
  font-size: 18px;
  font-weight: 600;
`;

const ModalHeader = styled.div`
  display: flex;
  justify-content: space-between;
  align-items: center;
  background: rgb(30, 35, 40);
  padding: 16px 24px;
  border-bottom: 1px solid #2A2D35;
`;

const CloseButton = styled.button`
  background: none;
  border: none;
  color: #6F767E;
  cursor: pointer;
  padding: 4px;
  display: flex;
  align-items: center;
  justify-content: center;
  &:hover {
    color: white;
  }
`;

const ModalBody = styled.div`
  padding: 24px;
  color: white;
  overflow-y: auto;
  flex-grow: 1;
  &::-webkit-scrollbar {
    width: 6px;
  }
  &::-webkit-scrollbar-track {
    background: rgb(18, 20, 24);
    border-radius: 3px;
  }
  &::-webkit-scrollbar-thumb {
    background: #454951;
    border-radius: 3px;
  }
  &::-webkit-scrollbar-thumb:hover {
    background: #555;
  }
  @media (max-width: 768px) {
    padding: 12px 14px;
    height: 100vh;
  }
`;

const ModalOverlay1 = styled.div`
  position: fixed;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: rgba(0, 0, 0, 0.5);
  display: ${props => props.show ? 'flex' : 'none'};
  justify-content: center;
  align-items: center;
  z-index: 1050;
  padding: 20px;
  @media (max-width: 768px) {
    padding: 0px;
  }
`;

const ModalContent1 = styled.div`
  background: rgb(18, 20, 24);
  border-radius: 12px;
  width: 100%;
  max-width: 570px;
  position: relative;
  animation: modalFadeIn 0.3s ease-out;
  min-height: 400px;
  max-height: 76vh;
  display: flex;
  flex-direction: column;
  @keyframes modalFadeIn {
    from {
      opacity: 0;
      transform: translateY(-20px);
    }
    to {
      opacity: 1;
      transform: translateY(0);
    }
  }
  @media (max-width: 768px) {
    height: 100vh;
    max-height: 76vh;
  }
`;

const ModalHeader1 = styled.div`
  display: grid;
  grid-template-columns: 24px 1fr 24px;
  align-items: center;
  padding: 16px 24px;
  border-bottom: 1px solid #2A2D35;
  flex-shrink: 0;
 
  background: rgb(30, 35, 40);
  border-top-left-radius: 12px;
  border-top-right-radius: 12px;
`;

const ModalTitle1 = styled.h4`
  color: white;
  margin: 0;
  font-size: 18px;
  font-weight: 600;
  text-align: center;
  grid-column: 2;
`;

const CloseButton1 = styled.button`
  background: none;
  border: none;
  color: #6F767E;
  cursor: pointer;
  padding: 4px;
  display: flex;
  align-items: center;
  justify-content: center;
  grid-column: 3;
  margin-left: auto;
  &:hover {
    color: white;
  }
`;

const ModalBody1 = styled.div`
  padding: 24px;
  color: white;
  overflow-y: auto;
  flex-grow: 1;
  &::-webkit-scrollbar {
    width: 6px;
  }
  &::-webkit-scrollbar-track {
    background: #2A2D35;
    border-radius: 3px;
  }
  &::-webkit-scrollbar-thumb {
    background: #454951;
    border-radius: 3px;
  }
  &::-webkit-scrollbar-thumb:hover {
    background: #555;
  }
  @media (max-width: 768px) {
    padding: 12px 14px;
    height: 100vh;
  }
`;

const StyledModal = styled(Modal)`
  .modal-content {
    background: rgb(18, 20, 24);
    color: white;
  }
  .modal-header {
    border-bottom: none;
  }
  .modal-title {
    color: white;
  }
  .modal-body {
    padding: 20px;
    background: rgb(18, 20, 24);
  }
`;

const InputField = styled.input`
  width: 100%;
  padding: 10px;
  border-radius: 8px;
  border: 1px solid #ccc;
  background: rgba(0, 0, 0, 0.2);
  color: white;
  margin-top: 10px;
  &::placeholder {
    color: rgba(255, 255, 255, 0.5);
  }
`;

const InfoIconWrapper = styled.div`
  position: absolute;
  top: 16px;
  right: 16px;
  z-index: 1;
  cursor: pointer;
  transition: transform 0.2s ease;
  &:hover {
    transform: scale(1.1);
  }
`;

const BONUS_INFO = {
  dailyBonus: { title: "Daily Bonus", points: ["Login daily to claim your bonus rewards", "Available for VIP level 25 and above", "Bonus amount increases with VIP level", "Must be claimed within 24 hours", "Wagering requirements may apply"] },
  rakeback: { title: "Rakeback Bonus", points: ["Earn back a percentage of your house edge", "No minimum bet requirements", "Available for all casino games", "Instant crediting to your account", "Higher percentages for VIP members"] },
  weeklyCashback: { title: "Weekly Cashback", points: ["Available for VIP 22 and above", "Based on weekly gaming activity", "Credited every Monday", "No wagering requirements", "Higher rates for higher VIP levels"] },
  monthlyCashback: { title: "Monthly Cashback", points: ["VIP 22 exclusive benefit", "Based on monthly activity", "Credited first of each month", "Includes all game categories", "Progressive cashback rates"] },
  sportsBonus: { title: "Sports Weekly Bonus", points: ["VIP 22 sports betting bonus", "Weekly qualification period", "Based on betting volume", "Minimum bet requirements", "Exclusive to sports betting"] }
};
// Styled components from desktop
const ClaimButton = styled.button`
  width: 100%;
  padding: 12px;
  border-radius: 8px;
  background: ${({ amount }) => (amount > 0 ? '#f09c06' : 'rgba(255, 255, 255, 0.1)')};
  color: ${({ amount }) => (amount > 0 ? 'white' : 'white')};
  border: none;
  cursor: ${({ amount }) => (amount > 0 ? 'pointer' : 'not-allowed')};
  margin-top: 25px;

  &:hover {
    background: ${({ amount }) => (amount > 0 ? '#f09c06' : 'rgba(255, 255, 255, 0.1)')};
  }
`;

const ClaimButton2 = styled.button`
  width: 100%;
  padding: 12px;
  border-radius: 8px;
  background: ${({ eligible, claimable }) => {
    if (!eligible) return 'rgba(255, 255, 255, 0.1)'; // Not eligible
    if (eligible && !claimable) return 'rgba(255, 255, 255, 0.1)'; // Eligible but not claimable
    return '#f09c06'; // Eligible and claimable
  }};
  color: white;
  border: none;
  cursor: ${({ eligible, claimable }) => (eligible && claimable ? 'pointer' : 'not-allowed')};
  margin-top: 25px;

  &:hover {
    background: ${({ eligible, claimable }) => {
    if (!eligible) return 'rgba(255, 255, 255, 0.1)'; // Not eligible
    if (eligible && !claimable) return 'rgba(255, 255, 255, 0.1)'; // Eligible but not claimable
    return '#f09c06'; // Eligible and claimable
  }};
  }

  &:disabled {
    opacity: 0.5;
    cursor: not-allowed;
  }
`;



const BonusMobile = () => {

  const [activeTab, setActiveTab] = useState('1');
  const [openDepositModal, setOpenDepositModal] = useState(false);

  const [selectedInfo, setSelectedInfo] = useState(null);

  const [showRedeemModal, setShowRedeemModal] = useState(false);
  const [redeemCode, setRedeemCode] = useState('');

  const [token] = useState(storage.getKey("token") || null);
  const [logged, setLogged] = useState(false);
  const [amount, setAmount] = useState(0);

  const [claimLoading, setClaimLoading] = useState({
    daily: false,
    weekly: false,
    monthly: false,
    sports: false
  });

  const tabs = [
    { id: '1', label: 'General bonus' },
    { id: '2', label: 'VIP Bonus' },
  ];

  // useEffect(() => {
  //   // Scroll to top
  //   document.body.scrollTop = 0;
  //   document.documentElement.scrollTop = 0;

  //   // Check if user is logged in
  //   if (token !== null) {
  //     setLogged(true);
  //   }


  //   // Initialize socket connections
  //   const initializeSocket = async () => {
  //     await wait(200);
  //     socket.emit(C.RAKEBACK_AMOUNT);
  //   };

  //   initializeSocket();

  //   // Socket listeners
  //   const handleRakebackAmount = (data) => {
  //     const decodedData = decode(data);
  //     if (decodedData) {
  //       console.log("rbaack",decodedData);
  //       setAmount(decodedData.amount);
  //     }
  //   };

  //   const handleAddRakeback = async (data) => {
  //     const decodedData = decode(data);
  //     await wait(1000);
  //     socket.emit(C.CREDIT);
  //     let message = decodedData.status.toString();
  //     sendNotfication(message, "info", "top-center");
  //     window.location.reload();
  //   };


  //   socket.on(C.RAKEBACK_AMOUNT, handleRakebackAmount);
  //   socket.on(C.ADD_RAKEBACK, handleAddRakeback);

  //   // Cleanup socket listeners
  //   return () => {
  //     socket.off(C.RAKEBACK_AMOUNT, handleRakebackAmount);
  //     socket.off(C.ADD_RAKEBACK, handleAddRakeback);
  //   };
  // }, [token]);
  // const addReward = () => {
  //   socket.emit(C.ADD_RAKEBACK);
  //   // Play sound when addReward is triggered
  //   const audio = new Audio('/sounds/magic-spell.mp3');
  //   audio.play().catch(error => console.error("Error playing audio:", error));
  // };
  // Define this outside your component/effect as a module-level variable
  let rakebackProcessId = null;

  // Inside your component/effect
  useEffect(() => {
    const componentId = Math.random().toString(36).substring(7); // Generate unique ID for this component instance
    console.log(`[${componentId}] Component mounted/effect running`);
    //   // Scroll to top
    document.body.scrollTop = 0;
    document.documentElement.scrollTop = 0;

    //   // Check if user is logged in
    if (token !== null) {
      setLogged(true);
    }

    // Initialize socket connections
    const initializeSocket = async () => {
      await wait(200);
      socket.emit(C.RAKEBACK_AMOUNT);
      console.log(`[${componentId}] Emitted RAKEBACK_AMOUNT`);
    };

    initializeSocket();

    // Socket listeners
    const handleRakebackAmount = (data) => {
      console.log(`[${componentId}] Received RAKEBACK_AMOUNT event`);
      const decodedData = decode(data);
      if (decodedData) {
        console.log(`[${componentId}] Rakeback amount:`, decodedData.amount);
        setAmount(decodedData.amount);
      }
    };

    const handleAddRakeback = async (data) => {
      const eventId = Math.random().toString(36).substring(7);
      console.log(`[${componentId}] Received ADD_RAKEBACK event [${eventId}]`);

      // Generate a unique process ID for this rakeback claim
      const newProcessId = Date.now().toString();

      // If there's already a process ID and it's different from this one, another process is handling the claim
      if (rakebackProcessId) {
        console.log(`[${componentId}] Already processing rakeback [${rakebackProcessId}], ignoring event [${eventId}]`);
        return;
      }

      // Set our process ID to claim this rakeback process
      rakebackProcessId = newProcessId;
      console.log(`[${componentId}] Starting to process rakeback [${rakebackProcessId}]`);

      try {
        const decodedData = decode(data);
        console.log(`[${componentId}] Decoded data [${rakebackProcessId}]:`, decodedData);

        await wait(1000);
        console.log(`[${componentId}] Waited 1s, now emitting CREDIT [${rakebackProcessId}]`);
        socket.emit(C.CREDIT);

        let message = decodedData.status.toString();
        console.log(`[${componentId}] Showing notification [${rakebackProcessId}]: ${message}`);
        sendNotfication(message, "info", "top-center");

        // Force a page reload after a short delay
        console.log(`[${componentId}] Will reload page in 1s [${rakebackProcessId}]`);
        setTimeout(() => {
          console.log(`[${componentId}] Reloading page now [${rakebackProcessId}]`);
          window.location.reload();
        }, 1000);
      } catch (err) {
        console.error(`[${componentId}] Error processing rakeback [${rakebackProcessId}]:`, err);
      }
    };

    // IMPORTANT: Remove any existing listeners globally
    console.log(`[${componentId}] Removing any existing listeners`);
    socket.removeAllListeners(C.RAKEBACK_AMOUNT);
    socket.removeAllListeners(C.ADD_RAKEBACK);

    // Now add our listeners
    console.log(`[${componentId}] Adding new listeners`);
    socket.on(C.RAKEBACK_AMOUNT, handleRakebackAmount);
    socket.on(C.ADD_RAKEBACK, handleAddRakeback);

    // Cleanup socket listeners
    return () => {
      console.log(`[${componentId}] Component unmounting/effect cleaning up`);
      socket.off(C.RAKEBACK_AMOUNT, handleRakebackAmount);
      socket.off(C.ADD_RAKEBACK, handleAddRakeback);
    };
  }, [token]);

  const addReward = () => {
    console.log("addReward function called, emitting ADD_RAKEBACK");
    socket.emit(C.ADD_RAKEBACK);

    // Play sound when addReward is triggered
    const audio = new Audio('/sounds/magic-spell.mp3');
    audio.play().catch(error => console.error("Error playing audio:", error));
  };

  const [openModal, setOpneModal] = useState(false);

  const [loading, setLoading] = useState(false);
  const [error, setError] = useState(null);
  const [success, setSuccess] = useState(false);
  const [bonus, setBonus] = useState(null);


  const [bonususer, setBonususer] = useState(null);
  const [bonusredeemuser, setBonusredeemuser] = useState(null)

  const handleBonusRequest = async () => {
    setLoading(true);
    setError(null);
    setSuccess(false);

    try {
      const userId = getUID();
      const response = await fetch('https://api.boss707.com/bonus/userbonus', {
        method: 'POST',

        headers: {
          'Content-Type': 'application/json',
          'Authorization': `Bearer ${token}`,
          'role-key': '8a37f45e02c57b489f9b5a9949154cf3b8c48540744185c463df5f79f25d9053'
        },
        body: JSON.stringify({
          userid: userId,
          role: 'user'
        })
      });

      if (!response.ok) {
        throw new Error('Request failed');
      }

      const data = await response.json();
      setSuccess(true);
      if (Array.isArray(data) && data.length > 0) {
        setBonususer(data[0]); // Extract the first object from the array
        setSuccess(true);
        console.log('User Bonus Success:', data[0]);
      } else {
        throw new Error('No data found');
      }
    } catch (err) {
      setError(err.message);
      console.error('Error:', err);
    } finally {
      setLoading(false);
    }
  };


  const handleBonusRedeemRequest = async () => {
    setLoading(true);
    setError(null);
    setSuccess(false);

    try {
      const userId = getUID();
      const token = localStorage.getItem('token');
      const response = await fetch('https://api.boss707.com/bonus/user', {
        method: 'POST',
        headers: {
          'Authorization': `Bearer ${token}`,
          'Content-Type': 'application/json',
          'role-key': '8a37f45e02c57b489f9b5a9949154cf3b8c48540744185c463df5f79f25d9053'
        },
        body: JSON.stringify({
          userid: userId
        })
      });

      if (!response.ok) {
        throw new Error('Request failed');
      }

      const data = await response.json();
      setSuccess(true);
      setBonusredeemuser(data);
      console.log('User Bonus Redeem:', data);
    } catch (err) {
      setError(err.message);
      console.error('Error:', err);
    } finally {
      setLoading(false);
    }
  };
  // Add this function to fetch bonus history
  const fetchBonusHistory = async () => {
    setLoading(true);
    setError(null);

    try {
      const response = await fetch(`https://api.boss707.com/Userbonus/api/bonus-history?userid=${getUID()}`, {
        method: 'GET',
        headers: {
          'Content-Type': 'application/json',
          'Authorization': `Bearer ${token}`,
          'role-key': '8a37f45e02c57b489f9b5a9949154cf3b8c48540744185c463df5f79f25d9053'
        }
      });

      if (!response.ok) {
        throw new Error('Failed to fetch bonus history');
      }

      const data = await response.json();
      const claimedBonuses = data.history.filter(item => item.is_claimed === true);
      setBonusHistory(claimedBonuses);
      console.log('Claimed Bonus History:', claimedBonuses);
      return claimedBonuses;
    } catch (err) {
      setError(err.message);
      console.error('Error fetching bonus history:', err);
      return [];
    } finally {
      setLoading(false);
    }
  };

  // Add state for bonus history
  const [bonusHistory, setBonusHistory] = useState([]);
  // const fetchGameDeatils = async () => {
  //   setLoading(true);
  //   setError(null);
  //   setSuccess(false);

  //   try {
  //     const userId = getUID();
  //     const response = await fetch('https://api.boss707.com/bonus/bonusgame', {
  //       method: 'POST',
  //       headers: {
  //         'Content-Type': 'application/json',
  //         'role-key': '8a37f45e02c57b489f9b5a9949154cf3b8c48540744185c463df5f79f25d9053'
  //       },
  //       body: JSON.stringify({
  //         userid: userId,
  //         role: 'user'
  //       })
  //     });

  //     if (!response.ok) {
  //       throw new Error('Request failed');
  //     }

  //     const data = await response.json();
  //     setSuccess(true);
  //     if (Array.isArray(data) && data.length > 0) {
  //       setBonus(data[0]); // Extract the first object from the array
  //       setSuccess(true);
  //       console.log('Game Bonus Success:', data[0]);
  //     } else {
  //       throw new Error('No data found');
  //     }
  //   } catch (err) {
  //     setError(err.message);
  //     console.error('Error:', err);
  //   } finally {
  //     setLoading(false);
  //   }
  // };
  const fetchBonuses = async () => {
    setLoading(true);
    setError(null);
    setSuccess(false);

    try {

      const response = await fetch(`https://api.boss707.com/Userbonus/api/bonuses?userid=${getUID()}`, {
        method: 'GET',
        headers: {
          'Content-Type': 'application/json',
          'role-key': '8a37f45e02c57b489f9b5a9949154cf3b8c48540744185c463df5f79f25d9053'
        }
      });

      if (!response.ok) {
        throw new Error('Failed to fetch bonuses');
      }

      const data = await response.json();
      setBonus(data); // Store the entire bonus response
      setSuccess(true);
      console.log('Bonuses:', data);
    } catch (err) {
      setError(err.message);
      console.error('Error fetching bonuses:', err);
    } finally {
      setLoading(false);
    }
  };


  const handleClaimBonus = async (bonusType) => {
    setClaimLoading(prev => ({ ...prev, [bonusType]: true }));
    setError(null);

    try {
      const token = localStorage.getItem('token');
      const response = await fetch(`https://api.boss707.com/Userbonus/api/bonuses/claim/${bonusType}?userid=${getUID()}`, {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
          'Authorization': `Bearer ${token}`,
          'role-key': '8a37f45e02c57b489f9b5a9949154cf3b8c48540744185c463df5f79f25d9053'
        }
      });

      const data = await response.json();

      if (!response.ok) {
        throw new Error(data.error || 'Failed to claim bonus');
      }
      // Play sound when addReward is triggered
      const audio = new Audio('/sounds/magic-spell.mp3');
      audio.play().catch(error => console.error("Error playing audio:", error));
      sendNotfication('Bonus claimed successfully', 'success', 'top-center');
      window.location.reload(); // Refresh the page
    } catch (err) {
      setError(err.message);
      sendNotfication(err.message, 'error', 'top-center');
    } finally {
      setClaimLoading(prev => ({ ...prev, [bonusType]: false }));
    }
  };
  useEffect(() => {
    const fetchData = async () => {
      try {
        // Run all async functions concurrently using Promise.all
        const [bonusRequestResult, bonusesResult, redeemRequestResult, historyResult] = await Promise.all([
          handleBonusRequest(),
          fetchBonuses(),
          handleBonusRedeemRequest(),
          fetchBonusHistory(),
        ]);

        // Handle the results as needed
        console.log('Bonus Request:', bonusRequestResult);
        console.log('Bonuses:', bonusesResult);
        console.log('Redeem Request:', redeemRequestResult);
        console.log('Bonus History:', historyResult);
      } catch (error) {
        // Handle errors from any of the Promises
        console.error('Error fetching data:', error);
        // Optionally update state to show error to the user
      }
    };

    fetchData();
  }, []);

  const formatAmount = (amount) => `$${amount.toFixed(2)}`;
  const history = useHistory();

  const [reedemcode, setReedemCode] = useState(null)

  const handleRedeemCode = async () => {

    if (!reedemcode) return sendNotfication('Please Enter Reedeam Code !')

    const url = 'https://api.boss707.com/bonus/redeem-bonus/redeem';
    const headers = {
      'Content-Type': 'application/json',
      'role-key': '8a37f45e02c57b489f9b5a9949154cf3b8c48540744185c463df5f79f25d9053',
    };
    const payload = {
      userid: getUID(),
      code: reedemcode, // Assuming you have a code to redeem
    };

    try {
      const response = await fetch(url, {
        method: 'POST',
        headers: {
          'Authorization': `Bearer ${token}`,
          ...headers,
        },
        body: JSON.stringify(payload),
      });

      const data = await response.json();

      if (response.status === 200) {
        sendNotfication(data.message); // Show success notification
        // setAmount(data.amount); // Update amount if needed
        window.location.reload();
      } else if (response.status === 400) {
        sendNotfication(data.error); // Show error notification for bad request
      } else if (response.status === 404) {
        sendNotfication(data.error); // Show error notification for not found
      } else if (response.status === 500) {
        sendNotfication(data.error); // Show error notification for server error
      }
    } catch (error) {
      sendNotfication('Failed to redeem bonus'); // Handle network errors
    }
    finally {
      setReedemCode("");
    }
  };
  // Update the calculateTotalBonus function to include claimed bonus amounts
  const calculateTotalBonus = (user, bonus, bonusredeemuser, bonusHistory) => {
    if (!user && !bonus && !bonusredeemuser && !bonusHistory) return 0;

    const userBonuses =
      (user?.vipbonus || 0) +
      (user?.specialbonus || 0) +
      (user?.generalbonus || 0) +
      (user?.joiningbonus || 0);

    const additionalBonuses =
      (bonus?.bonuses?.daily?.amount || 0) +
      (bonus?.bonuses?.weekly?.amount || 0) +
      (bonus?.bonuses?.monthly?.amount || 0);

    // Add null check for bonusredeemuser
    const redeemBonusTotal = bonusredeemuser?.reduce((sum, item) => sum + (item.amount || 0), 0) || 0;

    // Calculate total from claimed bonus history
    const claimedBonusTotal = bonusHistory?.reduce((sum, item) => sum + (parseFloat(item.bonus_amount) || 0), 0) || 0;

    return userBonuses + additionalBonuses + redeemBonusTotal + claimedBonusTotal;
  };

  // Example of how to use the updated function
  const totalBonus = calculateTotalBonus(bonususer, bonus, bonusredeemuser, bonusHistory);


  return (
    <>
      <ModalOverlay show={selectedInfo !== null}>
        <InfoModalContent>
          <ModalHeader>
            <ModalTitle>{selectedInfo?.title} </ModalTitle>
            <CloseButton onClick={() => setSelectedInfo(null)}>
              <X size={20} />
            </CloseButton>
          </ModalHeader>
          <ModalBody>
            <InfoList>
              {selectedInfo?.points.map((point, index) => (
                <li key={index}>{point}</li>
              ))}
            </InfoList>
          </ModalBody>
        </InfoModalContent>
      </ModalOverlay>
      <Container>
        <BackButton onClick={() => history.goBack()}>
          <X size={24} color="white" />
        </BackButton>

        <InnerContainer>
          <BonusCard>
            <BonusContent>
              <div style={{ marginTop: "24px", width: "100%", display: "flex", justifyContent: 'space-between', alignItems: 'center' }}>
                <BonusType1>
                  <div style={{ marginTop: '-26px' }} className="label">Total Bonus Claimed(USD)</div>
                </BonusType1>
              </div>
              <TotalAmount>
                ${(bonususer?.specialbonus + bonususer?.joiningbonus + bonususer?.actualdailybonus + bonususer?.actualweeklybonus + bonususer?.actualmonthlybonus + bonususer?.rakebonus || 0)}
              </TotalAmount>
              <ReedeemButton onClick={() => setShowRedeemModal(true)}>Redeem Code</ReedeemButton>
            </BonusContent>
            <BonusCardImage src="/assets/images/bcgames/bonus/mb1.png" alt="Banner" />
          </BonusCard>
        </InnerContainer>

        <ScrollableContent>
          <TabContainer>
            {tabs.map(tab => (
              <TabButton
                key={tab.id}
                active={activeTab === tab.id}
                onClick={() => setActiveTab(tab.id)}
              >
                {tab.label}
              </TabButton>
            ))}
          </TabContainer>

          <div style={{ paddingBottom: "50px" }}>
            {activeTab === "1" && (
              <GridContainer1>
                <CardBG>
                  <InfoIconWrapper onClick={() => setSelectedInfo(BONUS_INFO.dailyBonus)}>
                    <Info size={20} color="rgba(255, 255, 255, 0.7)" />
                  </InfoIconWrapper>
                  <Card background="linear-gradient(to right, rgba(103, 55, 255, .6) 0%, rgba(103, 55, 255, 0) 40%)">
                    <ImagePlaceholder src="/assets/images/bonus/daily.png" alt="Daily Bonus" />
                    <ContentWrapper>
                      <CardTitle>Daily Bonus</CardTitle>
                      <StatRow>
                        <span>{bonus?.bonuses.daily.eligible ? 'Bonus Unlocked' : 'Available at VIP 20'}</span>
                        {bonus?.bonuses.daily.eligible && bonus?.bonuses.daily.claimable && (
                          <span style={{ marginLeft: '4px' }}>${bonus.bonuses.daily.amount.toFixed(2)}</span>
                        )}
                      </StatRow>
                      <ButtonWrapper>
                        <ClaimButton2
                          disabled={!bonus?.bonuses.daily.eligible || !bonus?.bonuses.daily.claimable || claimLoading.daily}
                          eligible={bonus?.bonuses.daily.eligible}
                          // claimable={bonus?.bonuses.daily.claimable}
                          claimable={true}
                          onClick={() => handleClaimBonus('daily')}
                        >
                          {claimLoading.daily ? 'Loading...' : 'Claim'}
                        </ClaimButton2>
                      </ButtonWrapper>
                    </ContentWrapper>
                  </Card>
                </CardBG>
                <CardBG>
                  <InfoIconWrapper onClick={() => setSelectedInfo(BONUS_INFO.rakeback)}>
                    <Info size={20} color="rgba(255, 255, 255, 0.7)" />
                  </InfoIconWrapper>
                  <Card background="linear-gradient(to right, rgba(214, 129, 0, .6) 0%, rgba(214, 129, 0, 0) 40%)">
                    <ImagePlaceholder src="/assets/images/bonus/rakeback.png" alt="Rakeback" />
                    <ContentWrapper>
                      <CardTitle>Rakeback</CardTitle>
                      <StatRow>
                        <div>Ready to claim:</div>
                        <span>{amount}</span>
                      </StatRow>
                      <ButtonWrapper>
                        <ClaimButton disabled={amount <= 0} amount={amount} onClick={addReward}>Claim</ClaimButton>
                      </ButtonWrapper>
                    </ContentWrapper>
                  </Card>
                </CardBG>
              </GridContainer1>
            )}
            {activeTab === "2" && (
              <GridContainer1>
                <CardBG>
                  <InfoIconWrapper onClick={() => setSelectedInfo(BONUS_INFO.weeklyCashback)}>
                    <Info size={20} color="rgba(255, 255, 255, 0.7)" />
                  </InfoIconWrapper>
                  <Card background="linear-gradient(to right, rgba(6, 115, 217, .6) 0%, rgba(6, 115, 217, 0) 40%)">
                    <ImagePlaceholder src="/assets/images/bonus/weekly.png" alt="Weekly Cashback" />
                    <ContentWrapper>
                      <CardTitle>Weekly Cashback</CardTitle>
                      <StatRow>
                        <span>{bonus?.bonuses.weekly.eligible ? 'Bonus Unlocked' : 'Available at VIP 25'}</span>
                        {bonus?.bonuses.weekly.eligible && bonus?.bonuses.weekly.claimable && (
                          <span style={{ marginLeft: '4px' }}>${bonus.bonuses.weekly.amount.toFixed(2)}</span>
                        )}
                      </StatRow>
                      <ButtonWrapper>
                        <ClaimButton2
                          disabled={!bonus?.bonuses.weekly.eligible || !bonus?.bonuses.weekly.claimable || claimLoading.weekly}
                          eligible={bonus?.bonuses.weekly.eligible}
                          // claimable={bonus?.bonuses.weekly.claimable}
                          claimable={true}
                          onClick={() => handleClaimBonus('weekly')}
                        >
                          {claimLoading.weekly ? 'Loading...' : 'Claim'}
                        </ClaimButton2>
                      </ButtonWrapper>
                    </ContentWrapper>
                  </Card>
                </CardBG>
                <CardBG>
                  <InfoIconWrapper onClick={() => setSelectedInfo(BONUS_INFO.monthlyCashback)}>
                    <Info size={20} color="rgba(255, 255, 255, 0.7)" />
                  </InfoIconWrapper>
                  <Card background="linear-gradient(to right, rgba(179, 9, 61, .6) 0%, rgba(179, 9, 61, 0) 40%)">
                    <ImagePlaceholder src="/assets/images/bonus/monthly.png" alt="Monthly Cashback" />
                    <ContentWrapper>
                      <CardTitle>Monthly Cashback</CardTitle>
                      <StatRow>
                        <span>{bonus?.bonuses.monthly.eligible ? 'Bonus Unlocked' : 'Available at VIP 30'}</span>
                        {bonus?.bonuses.monthly.eligible && bonus?.bonuses.monthly.claimable && (
                          <span style={{ marginLeft: '4px' }}>${bonus.bonuses.monthly.amount.toFixed(2)}</span>
                        )}
                      </StatRow>
                      <ButtonWrapper>
                        <ClaimButton2
                          disabled={!bonus?.bonuses.monthly.eligible || !bonus?.bonuses.monthly.claimable || claimLoading.monthly}
                          eligible={bonus?.bonuses.monthly.eligible}
                          // claimable={bonus?.bonuses.monthly.claimable}
                          claimable={true}
                          onClick={() => handleClaimBonus('monthly')}
                        >
                          {claimLoading.monthly ? 'Loading...' : 'Claim'}
                        </ClaimButton2>
                      </ButtonWrapper>
                    </ContentWrapper>
                  </Card>
                </CardBG>
                <CardBG>
                  {/* <InfoIconWrapper onClick={() => setSelectedInfo(BONUS_INFO.sportsBonus)}>
                    <Info size={20} color="rgba(255, 255, 255, 0.7)" />
                  </InfoIconWrapper> */}
                  {/* <Card background="linear-gradient(to right, rgba(65, 84, 254, .6) 0%, rgba(65, 84, 254, 0) 40%)">
                    <ImagePlaceholder src="/assets/images/bonus/sports.png" alt="Sports Weekly Bonus" />
                    <ContentWrapper>
                      <CardTitle>Sports Weekly Bonus</CardTitle>
                      <StatRow>
                        <span>{bonus?.bonuses.weekly.eligible ? 'Bonus Unlocked' : 'Available at VIP 22'}</span>
                        {bonus?.bonuses.weekly.eligible && bonus?.bonuses.weekly.claimable && (
                          <span style={{ marginLeft: '4px' }}>${bonus.bonuses.weekly.amount.toFixed(2)}</span>
                        )}
                      </StatRow>
                      <ButtonWrapper>
                        <ClaimButton2
                          disabled={!bonus?.bonuses.weekly.eligible || !bonus?.bonuses.weekly.claimable || claimLoading.sports}
                          eligible={bonus?.bonuses.weekly.eligible}
                          claimable={bonus?.bonuses.weekly.claimable}
                          onClick={() => handleClaimBonus('weekly')}
                        >
                          {claimLoading.sports ? 'Loading...' : 'Claim'}
                        </ClaimButton2>
                      </ButtonWrapper>
                    </ContentWrapper>
                  </Card> */}
                </CardBG>
              </GridContainer1>
            )}
          </div>
        </ScrollableContent>

        <ModalOverlay show={openModal}>
          <ModalContent>
            <ModalHeader>
              <div style={{ textAlign: "center", fontSize: "18px" }}>Bonus Details</div>
              <CloseButton onClick={() => setOpneModal(!openModal)}>
                <X size={24} />
              </CloseButton>
            </ModalHeader>
            <ModalBody>
              <BonusDetails data={bonus} />
            </ModalBody>
          </ModalContent>
        </ModalOverlay>

        <ModalOverlay1 show={openDepositModal}>
          <ModalContent1>
            <ModalHeader1>
              <ModalTitle1>Deposit</ModalTitle1>
              <CloseButton1 onClick={() => setOpenDepositModal(!openDepositModal)}>
                <X size={24} />
              </CloseButton1>
            </ModalHeader1>
            <ModalBody1>
              <SkylaDepositModal />
            </ModalBody1>
          </ModalContent1>
        </ModalOverlay1>

        <StyledModal show={showRedeemModal}>
          <ModalHeader1>
            <ModalTitle1 style={{ color: "white", marginTop: "40px" }}>Redeem Code</ModalTitle1>
            <CloseButton1 onClick={() => setShowRedeemModal(false)}>
              <X size={24} />
            </CloseButton1>
          </ModalHeader1>
          <Modal.Body>
            <label htmlFor="redeemCode">Enter your code</label>
            <InputField
              type="text"
              id="redeemCode"
              placeholder="Enter code"
              value={redeemCode}
              onChange={(e) => setRedeemCode(e.target.value)}
            />
            <div style={{ width: '100%', display: 'flex', justifyContent: 'center' }}>
              <ReedeemButton onClick={handleRedeemCode}>Redeem</ReedeemButton>
            </div>
          </Modal.Body>
        </StyledModal>
      </Container>
    </>
  );
};

export default BonusMobile;
