import React, { Component, createRef } from 'react';
import { CarouselContainer, ScrollContainer, GameCard, GameImage, GameOverlay, PlayIconContainer, IconBg, HeaderContainer, TopTitle, HeaderContent, GridWrapper } from './YourStyledComponents'; // Adjust the import based on your file structure
import { ChevronLeft, ChevronRight } from 'lucide-react'; // Adjust the import based on your file structure
import axios from 'axios'; // Make sure to install axios if you haven't already

class LotterySection extends Component {
    constructor(props) {
        super(props);
        this.state = {
            showAll: false,
            displayGamesLotteryXgaming: [], // Initialize with an empty array
        };

        this.scrollContainerLotteryRef = createRef(); // For Lottery section
        const xLottery = this.getFilteredGamesXGaming(xGamingLottery);
    }

    getFilteredGamesXGaming = (games) => {
        const { searchQuery } = this.state;
        const { companies } = this.props;
        const { canScrollLeft, canScrollRight } = this.state;
    
        if (!searchQuery) return games;
        return games.filter(game => game.title && game.title.toLowerCase().includes(searchQuery.toLowerCase()));
      };


    handleLeftLotteryClick = () => {
        if (this.scrollContainerLotteryRef.current) {
            this.scrollContainerLotteryRef.current.scrollBy({
                left: -300, // Adjust the scroll amount as needed
                behavior: 'smooth'
            });
        }
    };

    handleRightLotteryClick = () => {
        if (this.scrollContainerLotteryRef.current) {
            this.scrollContainerLotteryRef.current.scrollBy({
                left: 300, // Adjust the scroll amount as needed
                behavior: 'smooth'
            });
        }
    };

   displayGamesLotteryXgaming = isMobileView
    ? xLottery
    : (this.state.showAll ? xLottery : xLottery.slice(0, 20));

    render() {
        return (
            <div style={{ marginTop: "6px" }}>
                <HeaderContainer>
                    <TopTitle>
                        Lottery
                    </TopTitle>
                    <HeaderContent>
                        <div onClick={() => this.setState({ showAll: !this.state.showAll })}>
                            <IconBg>
                                <span style={{ fontWeight: "bold" }}>{this.state.showAll ? "Show Less" : "Show More"}</span>
                                <span>
                                    {/* <ChevronRight size={14} /> */}
                                </span>
                            </IconBg>
                        </div>

                        <div style={{ display: "flex", gap: '4px' }}>
                            <IconBg onClick={this.handleLeftLotteryClick}>
                                <ChevronLeft size={16} />
                            </IconBg>
                            <IconBg onClick={this.handleRightLotteryClick}>
                                <ChevronRight size={16} />
                            </IconBg>
                        </div>
                    </HeaderContent>
                </HeaderContainer>

                {
                    !this.state.showAll ? (
                        <CarouselContainer>
                            <ScrollContainer ref={this.scrollContainerLotteryRef}>
                                {this.state.displayGamesLotteryXgaming.map((game, index) => (
                                    <GameCard
                                        key={game.id} onClick={() => this.handleGameLaunchXGaming(game)}
                                    >
                                        <GameImage src={game.details_thumbnails_300x300} alt={`Game ${index}`} />
                                        <GameOverlay>
                                            <PlayIconContainer>
                                                <PlayIcon />
                                            </PlayIconContainer>
                                        </GameOverlay>
                                    </GameCard>
                                ))}
                            </ScrollContainer>
                        </CarouselContainer>
                    ) : (
                        <GridWrapper>
                            {this.state.displayGamesLotteryXgaming.map((game, index) => (
                                <GameCard
                                    key={game.id} onClick={() => this.handleGameLaunchXGaming(game)}
                                >
                                    <GameImage src={game.details_thumbnails_300x300} alt={`Game ${index}`} />
                                    <GameOverlay>
                                        <PlayIconContainer>
                                            <PlayIcon />
                                        </PlayIconContainer>
                                    </GameOverlay>
                                </GameCard>
                            ))}
                        </GridWrapper>
                    )
                }
            </div>
        );
    }
}

export default LotterySection;