import React, { Component, useEffect, useState } from "react";
import { Link } from "react-router-dom";
import { Card, Alert, FormControl, Container, Row, Col, Spinner } from "react-bootstrap";
import Carousel from "../../Parts/Home/crousel";
import { Helmet } from 'react-helmet';
import Popular from "./Popular";
import Games from "./Games";
import Slots from "../../../Slots/Slots";
import { BRAND, decode, encode, getUID, isMobile, sendNotfication } from "../../../../Helper";
import { withCookies } from 'react-cookie';
import styled from 'styled-components';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { faArrowLeft, faSpinner } from '@fortawesome/free-solid-svg-icons';
import CustomSlider from "../../../Components/CustomSlider";
import BannerGames from "../../../Components/BannerGames";
import GameList from "../../HomeOrignals";
import { PickOption } from "../../../Games/Lottery";
import CasinoLeaderboard from "../../../Components/HelloGamesTable";
import { ChevronLeft, ChevronRight, Play } from "lucide-react";
import Banner from "../../../Components/Banner";
import LatestWins from "../../../Components/LatestWins";
import GamingCards from "../../../Components/GamingCards";
import SkylaGameCards from "../../../Components/SkylaGamingCard";
import LiveSportsCards from "../../../Components/Lobby";
import LiveSports from "../../../Components/Lobby";
import PaymentBar from "../../../Components/PaymentBar";
import SkylaSlider from "../../../Components/SkylaBannerSlider";
import MobilePaymentBR from "../../../Components/MobilePaymetBar";
import GameCarousel from "../../../Components/CarouselGame";
import C from '../../../../../src/Constant';
import socket from '../../../../Socket';
import storage from "../../../../Storage";
import { useSiteConfig } from "../../../../hooks/useSiteConfig";
import GameIframe from "../../../../context/gameIframe";
import GameProviders from "./Provider";
import Esports from "../../../Components/Esports";
import LobbySection from "../../../Components/Lobby";
import { useSelector } from "react-redux";
import { gamesService } from "../../../../utils/Services";
import SportsBanner from "../../../Components/Sportbanner/sportbanner";
import Sports from "../../../Components/Sportbanner";


const FullScreenContainer = styled.div`
  position: fixed;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  z-index: 999;
  background-color: #1b2336;
`;

const FullScreenIframe = styled.iframe`
  width: 100%;
  height: 100%;
  border: none;
  display: ${(props) => (props.loading ? 'none' : 'block')};
`;
const ResponsiveImage = styled.img`
  object-fit: cover;
  width: 140px;
  height: 140px;
  border-radius:20px;

  @media (min-width: 467px) {
    width: 188px;
    height: 188px;
  }
`;


const BackButton = styled.button`
  position: absolute;
  top: 10px;
  left: 10px;
  z-index: 1000;
  background: none;
  border: none;
  color: #000;
  font-size: 24px;
  cursor: pointer;
`;

const Loader = styled.div`
  position: absolute;
  top: 50%;
  left: 50%;
  transform: translate(-50%, -50%);
  font-size: 24px;
  color: #000;
`;





const SliderContainer = styled.div`
  width: 100%;
  max-width: 800px;
  position: relative;
  overflow: hidden;
`;

const SliderTrack = styled.div`
  display: flex;
  transition: transform 0.5s ease-in-out;
  transform: translateX(${(props) => props.translate}%);
`;

const SliderItem = styled.div`
  flex: 0 0 100%;
  padding: 20px;
  box-sizing: border-box;
  text-align: center;
  background-color: #f2f2f2;
`;

const SliderNavigation = styled.div`
  position: absolute;
  top: 50%;
  transform: translateY(-50%);
  width: 100%;
  display: flex;
  justify-content: space-between;
  padding: 0 20px;
  box-sizing: border-box;
`;

const NavigationButton = styled.button`
  background-color: rgba(255, 255, 255, 0.5);
  border: none;
  outline: none;
  font-size: 24px;
  padding: 10px;
  cursor: pointer;
`;
const LottoCard = styled.button`
  background-color: #0E1423;
 border-radius:12px;
 width:100%
   margin-bottom:12px;
`;

const ContainerPlay = styled.div`
  display: flex;
  overflow-x: auto;
  scroll-snap-type: x mandatory;
  -webkit-overflow-scrolling: touch;
  scrollbar-width: none;
  -ms-overflow-style: none;
  
  &::-webkit-scrollbar {
    display: none;
  }

  @media (min-width: 768px) {
    display: grid;
    grid-template-columns: repeat(4, 1fr);
    gap: 10px;
    // padding: 10px;
    justify-content: center;
  }

  @media (max-width: 767px) {
    gap: 8px;
    // padding: 5px;

    
  }
`;
const SkeletonLoader = styled.div`
  width: 100%;
  height: 100%;
  background: linear-gradient(
    90deg,
    rgba(190, 190, 190, 0.2) 25%,
    rgba(129, 129, 129, 0.24) 37%,
    rgba(190, 190, 190, 0.2) 63%
  );
  background-size: 400% 100%;
  animation: skeleton-loading 1.4s ease infinite;
  border-radius: 8px;

  @keyframes skeleton-loading {
    0% {
      background-position: 100% 50%;
    }
    100% {
      background-position: 0% 50%;
    }
  }
`;
const GridWrapper = styled.div`
  display: grid;
  grid-template-columns: repeat(8, 1fr); // 8 items per row
  gap: 12px; // Adjust gap between items as needed
   @media (max-width: 767px) {
    // gap: 8px;
   grid-template-columns: repeat(3, 1fr); // 8 items per row

    
  }
 
`;

const PickOptionWrapper = styled.div`
  flex: 0 0 auto;
  width: calc(50% - 6px);
  scroll-snap-align: start;

  @media (min-width: 768px) {
    width: 100%;
  }
`;


const HiddenOnSmallScreens = styled.div`
display:flex;
  @media (max-width: 768px) {
    display: none;
  }
`;

const GamesWrapper = styled.div`
  background-color: #1C1E22;
  padding: 2px;
  border-radius: 0 20px 20px 20px; /* top-left | top-right | bottom-right | bottom-left */
  position: relative;
  margin-top: 40px !important;
 
  @media (max-width: 768px) {
    margin-top: 100px !important;
  }
`;


const GamesTopWrapper = styled.div`
  background-color: #1C1E22;
  padding: 2px;
  border-radius: 0 20px 20px 20px; /* top-left | top-right | bottom-right | bottom-left */
  position: relative;
  margin-top: 40px !important;
   margin-top: 100px !important;
  @media (max-width: 768px) {
    margin-top: 100px !important;
  }
`;
const GridContainer = styled.div`
  display: grid;
  gap: 10px;
  padding: 0rem;
  margin:12px 12px;
  width: 100%;
  // Mobile view (2 columns)
  grid-template-columns: repeat(2, 1fr);
  // Tablet view (3 columns)
  @media (min-width: 768px) {
    grid-template-columns: repeat(3, 1fr);
  }
  // Desktop view (4 columns)
  @media (min-width: 1024px) {
    grid-template-columns: repeat(6, 1fr);
  }
`;
const GridItem = styled.div`
  background-color: transparent;
  border-radius: 10px;
  overflow: hidden;
  box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
  transition: transform 0.3s ease;
  &:hover {
    transform: translateY(-5px);
  }
`;


const GridContainerNew = styled.div`
  display: grid;
  gap: 10px;
  padding: 0rem;
  margin:12px 12px;
  width: 100%;
  padding-right:17px;
  // Mobile view (2 columns)
  grid-template-columns: repeat(2, 1fr) !important;
  // Tablet view (3 columns)
  @media (min-width: 768px) {
    grid-template-columns: repeat(3, 1fr) !important;
  }
  // Desktop view (4 columns)
  @media (min-width: 1024px) {
    grid-template-columns: repeat(6, 1fr) !important;
  }
`;
const GridItemNew = styled.div`
  background-color: transparent;
  border-radius: 10px;
  overflow: hidden;
  box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
  transition: transform 0.3s ease;
  &:hover {
    transform: translateY(-5px);
  }
`;









const AllButtonTopTitleContainer = styled.div`
  background-color: #1C1E22;
  border-radius: 15px;
  display:flex;
  justify-caontent:center;
  align-items:center;
  color:#7F898C;
  font-weight:bold;
  z-index: 1;
  padding: 5px 23px;
  margin: 0;
  cursor:pointer;
`;



const NavItem = styled.button`
  display: flex;
  align-items: center;
  background-color: ${props => props.active ? '#23262B' : 'transparent'};
  color: ${props => props.active ? '#ffffff' : '#888888'};
  border: none;
  padding: 12px 16px;
  border-radius: 24px;
  cursor: pointer;
  transition: all 0.3s ease;
  font-size: 12px;
  white-space: nowrap;
  flex-shrink: 0;
 

  &:hover {
    background-color: #2a2a2a;
  }
`;





const NavBar = styled.nav`
  display: inline-flex; // Changed to inline-flex
  justify-content: flex-end;
  background-color: #191A1E;
  padding: 4px;
  border-radius: 26px;
  overflow: hidden; // Changed from overflow-x
`;

const NavBarEnd = styled.div`
  display: flex;
  width: 100%;
`;

const TabSwitcher = styled.div`
  display: flex;
  overflow-x: auto;
  scrollbar-width: none;
  -ms-overflow-style: none;
  &::-webkit-scrollbar {
    display: none;
  }
`;
const GameOverlay = styled.div`
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
 background-color: rgba(0, 0, 0, 0.4);
  backdrop-filter: blur(5px);
  border-radius: 8px;
  display: flex;
  justify-content: center;
  align-items: center;
  opacity: 0;
  transition: opacity 0.2s ease;
 
  

`;

const Tab = styled.button`
  background-color: ${props => props.active ? '#2c3137' : 'transparent'};
  color: white;
  border: none;
  padding: 10px 20px;
  border-radius: 26px;
  cursor: pointer;
  font-size: 16px;
  margin-right: 10px;
  white-space: nowrap;
  transition: background-color 0.3s ease;
  &:hover {
    background-color: ${props => props.active ? '#2c3137' : '#1c1e22'};
  }
`;

const FlexArrange = styled.div`
  display: flex;
  align-items: center;
`;

const TabImage = styled.img`
  height: 28px;
  width: 28px;
  object-fit: contain;
  margin-right: 8px;
  filter: ${props => props.active ? 'none' : 'grayscale(100%)'};
  transition: filter 0.3s ease;
`;

const TabText = styled.div`
  @media (max-width: 480px) {
    display: none;
  }
`;




const HeaderContainer = styled.div`
  width: 100%;
  display: flex;
  justify-content: space-between;
  align-items: center;
`;

const HeaderContent = styled.div`
  display: flex;
  gap: 10px;
  align-items: center;
  margin:12px 0px;
`;

const IconBg = styled.div`
  padding: 6px 8px;
  background-color:#03030F;
  border-radius: 10px;
  cursor: pointer;
  display: flex;
  align-items: center;
  &:hover {
    background-color: #4a5354;
  }
`;

const CarouselContainer = styled.div`
  position: relative;
  width: 100%;
  // margin-top: 20px;
`;

const ScrollContainer = styled.div`
  display: flex;
  overflow-x: auto;
  overflow-y: hidden;
  gap: 11px;
  scrollbar-width: none;
  -ms-overflow-style: none;
  &::-webkit-scrollbar {
    display: none;
  }
`;
const GameCard = styled.div`
  min-width: 142px;
  height: 195px;
  border-radius: 8px;
  position: relative;
  cursor: pointer;
  display: flex;
  flex-direction: column;
  justify-content: center;
  align-items: center;
  transition: transform 0.2s ease;

  &:hover {
  

    ${GameOverlay} {
      opacity: 1;
    }
  
    transform: translateY(-5px);

  }

   @media (max-width: 768px) {
   min-width: 115px;
    height: 160px;
  }
`;

const LotteryGameCard = styled.div`
  min-width: 142px;
  height: 106px; // Original height
  border-radius: 8px;
  position: relative;
  cursor: pointer;
  display: flex;
  flex-direction: column;
  justify-content: center;
  align-items: center;
  transition: transform 0.2s ease;

  &:hover {
    ${GameOverlay} {
      opacity: 1;
    }
    transform: translateY(-5px);
  }

  @media (max-width: 768px) {
    min-width: 115px;
    height: 80px; // Decreased height for mobile screens
  }
`;

const GameImage = styled.img`
  width: 100%;
  height: 100%;
  object-fit: cover;
  border-radius: 8px;
`;

const LotteryGameImage = styled.img`
  width: 100%;
  height: 100%;
  object-fit: cover;
  border-radius: 8px;
`;


const PlayIconContainer = styled.div`
  width: 50px;
  height: 50px;
  border-radius: 50%;
  background-color: rgba(255, 255, 255, 0.3);
  display: flex;
  justify-content: center;
  align-items: center;
`;

const PlayIcon = styled(Play)`
  color: #fff;
  font-size: 24px;
`;


const TopTitle = styled.div`
  color: white;
  font-size: 16px;
  font-weight: bold;
  margin-left:4px;
`;


const ProviderLogo = styled.img`
object-fit:contain;
height:1.6rem;
width:80%;
`;
const ProviderWrapper = styled.div`
margin-top:50px !important;
margin-bottom:50px !important;
`;
const ProviderHeadingWrapper = styled.div`
margin-top:10px !important;
margin-bottom:10px !important;
display:flex;
justify-content:space-between;
`;




const ProviderGridContainer = styled.div.attrs({ className: 'provide-grid-container' })`
  display: grid;
  gap: 1px;
  background:#03030F;
  
  padding: 1px;
  border-radius: 10px;
  overflow-x: auto;
  overflow-y: hidden;
  scrollbar-width: none; /* Firefox */
  -ms-overflow-style: none; /* IE and Edge */
  &::-webkit-scrollbar {
    display: none; /* Chrome, Safari, Opera */
  }
  
  // Mobile layout (3 columns, scrollable)
  @media (max-width: 767px) {
    grid-auto-flow: column;
    grid-template-rows: repeat(2, 1fr);
    grid-auto-columns: minmax(100px, 1fr);
    scroll-snap-type: x mandatory;
    scroll-behavior: smooth;
  }
  
  // Tablet layout (3 columns)
  @media (min-width: 768px) and (max-width: 1023px) {
    grid-auto-flow: column;
    grid-template-rows: repeat(2, 1fr);
    grid-auto-columns: minmax(150px, 1fr);
    scroll-snap-type: x mandatory;
    scroll-behavior: smooth;
  }
  
  // Desktop layout (9 columns, 2 rows)
  @media (min-width: 1024px) {
    grid-template-columns: repeat(9, 1fr);
    grid-template-rows: repeat(2, 1fr);
    overflow: hidden;
  }
`;

const ProviderGridItem = styled(Link)`
  background:#03030F;
  display: flex;
  align-items: center;
  justify-content: center;
  padding: 5px 8px;
  scroll-snap-align: start;
  
  @media (max-width: 1023px) {
    aspect-ratio: 16 / 9;
  }
`;

const LotteryImage = styled.img`
  width: 100%;
  height: 100%;
  object-fit: cover;
`;
const PaginationContainer = styled.div`
  display: flex;
  justify-content: center;
  align-items: center;
  margin-top: 20px;
  gap: 10px;
`;




const LotteryInfo = styled.div`
  position: absolute;
  bottom: 0;
  left: 0;
  right: 0;
  padding: 16px;
  background: linear-gradient(to top, rgba(0,0,0,0.8), transparent);
  color: white;
`;

const LotteryTitle = styled.h4`
  margin: 0;
  font-size: 18px;
  font-weight: bold;
`;

const LotteryPrize = styled.div`
  font-size: 14px;
  color: #ffd700;
  margin-top: 4px;
`;




const withSiteConfig = (WrappedComponent) => {
  return function WithSiteConfigWrapper(props) {
    const { siteConfig } = useSiteConfig();
    return <WrappedComponent {...props} siteConfig={siteConfig} />;
  };
};

// Add this new styled component at the top with other styled components
const LoadMoreButton = styled.button`
  background-color:#03030F;
  color: white;
  border: none;
  padding: 12px 24px;
  border-radius: 8px;
  cursor: pointer;
  font-weight: bold;
  margin: 20px auto;
  display: block;
  transition: background-color 0.3s ease;

  &:hover {
    background-color: #4a5354;
  }

  &:disabled {
    background-color: #ccc;
    cursor: not-allowed;
  }
`;

// Add these new styled components at the top with other styled components
const LoaderContainer = styled.div`
  display: flex;
  justify-content: center;
  align-items: center;
  padding: 20px;
`;



const PaginationButton = styled.button`
  display: flex;
  align-items: center;
  gap: 5px;
  padding: 8px 12px;
  background-color: ${props => props.disabled ? '#3a3a3a' : '#4a4a4a'};
  color: ${props => props.disabled ? '#777' : 'white'};
  border: none;
  border-radius: 4px;
  cursor: ${props => props.disabled ? 'not-allowed' : 'pointer'};
  
  &:hover {
    background-color: ${props => props.disabled ? '#3a3a3a' : '#5a5a5a'};
  }
`;

const PaginationInfo = styled.div`
  color: white;
  font-size: 14px;
`;

const StyledSpinner = styled.div`
  width: ${props => props.size === "sm" ? "16px" : "24px"};
  height: ${props => props.size === "sm" ? "16px" : "24px"};
  border: 2px solid rgba(255, 255, 255, 0.3);
  border-top: 2px solid white;
  border-radius: 50%;
  animation: spin 1s linear infinite;
  
  @keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
  }
`;

class Home extends Component {
  constructor(props) {
    super(props);
    this._isMounted = false;
    const loggedStatus = !!localStorage.getItem('token');;
    this.state = {
      reloaded: false,
      padding: 'py-2',
      selectedSection: 'home',
      sectionIndex: 0,
      slideSelected: null,
      isAgent: true,
      vendorPagination: {
        evolution: { currentPage: 1, totalPages: 1, loading: false },
        pragmatic: { currentPage: 1, totalPages: 1, loading: false },
        pragmaticlive: { currentPage: 1, totalPages: 1, loading: false },
        spribe: { currentPage: 1, totalPages: 1, loading: false },
        ezugi: { currentPage: 1, totalPages: 1, loading: false },
        ideal: { currentPage: 1, totalPages: 1, loading: false },
        microgaming: { currentPage: 1, totalPages: 1, loading: false },
        pgsoft: { currentPage: 1, totalPages: 1, loading: false },
        hacksaw: { currentPage: 1, totalPages: 1, loading: false },
        jili: { currentPage: 1, totalPages: 1, loading: false },
        netent: { currentPage: 1, totalPages: 1, loading: false }
      },
      enabledFeatures: {
        evolution: true,
        pragmaticslots: true,
        pragmaticslive: true,
        ideal: true,
        bonus: true,
        microgaming: true,
        Pgsoft: true,
        esport: true,
        lobby: true,
        Hacksaw: true,
        bgaming: true,
        jili: true,
        spribe: true,
        netent: true,
        bjboriginal: true,
      },
      gamesEvolution: [],
      gamesPragmatic: [],
      gamesPragmaticlive: [],
      gamesEvoplay: [],
      gamesGenisis: [],
      gamesPgsoft: [],
      gamesLiveCasinoProvider: [],
      gamesSpribe: [],
      gamesSports: [],
      gamesMostExpensive: [],
      xGamingNetent: [],
      xGamingPragamticPlay: [],
      xGamingAviator: [],
      xGamingEvolution: [],
      xGamingPgSoft: [],
      xGamingLottery: [],
      xGamingIndian: [],
      xGamingCrash: [],
      xGamingBetGames: [],
      xGaminglive88: [],
      xGamingVivoGame: [],
      xGamingkAGame: [],
      xGamingJili: [],
      xCrashGames: [],
      //newlyreplace by vendors
      jsEvolution: [],
      jsPragmeticSlots: [],
      jsPragamaticLive: [],
      jsSpribe: [],
      jsEzugi: [],
      jsIdeal: [],
      jsMicrogaming: [],
      jsDpesports: [],
      jsPgsoft: [],
      jsTwoj: [],
      jsHacksaw: [],
      jsJili: [],
      jsNetent: [],
      jsBgaming: [],
      showMoreEzugi: false,
      showMoreIdeal: false,
      showMoreMicrogaming: false,
      showMoreDpesports: false,
      showMorePgsoft: false,
      showMoreTwoj: false,
      showMoreHackSaw: false,
      showMoreJsJili: false,
      showMoreJsNetent: false,
      showMoreJsBgaming: false,
      error: null,
      loading: false,
      message: null,
      showMore: false,
      showMoreP: false,
      showMoreO: false,
      showMoreLCP: false,
      showMoreSP: false,
      showMoreSB: false,
      showMoreEvo: false,
      showMoreLivecasino: false,
      showMoreAllSots: false,
      showMoreVivo: false,
      showMoreBetGame: false,
      showMoreka: false,
      showMoreLive88: false,
      showMoreJili: false,
      isMobileView: window.innerWidth <= 768,
      searchQuery: '',
      showIframe: false,
      iframeUrl: '',
      iframeLoading: true,
      showAll: false,
      showAllIndian: false,
      showPragamatic: false,
      showAllData: false,
      isLogged: loggedStatus,
      activeItem: 'Lobby',
      canScrollLeft: false,
      canScrollRight: true,
      crashPage: 1,
      live88Page: 1,
      isLoadingMore: false,
      lotteryPage: 1,
      isLoadingMoreLottery: false,
      displayGamesLotteryXgaming: [], // Changed from lotteryGames to displayGamesLotteryXgaming
      vivoPage: 1,
      isLoadingMoreVivo: false,
      displayGamesVivoXgaming: [], // For storing Vivo games
      betGamePage: 1,
      isLoadingMoreBetGame: false,
      displayGamesBetGameXgaming: [], // For storing BetGame games
      kaPage: 1,
      isLoadingMoreKa: false,
      displayGamesKaXgaming: [], // For storing KA games
      evolutionPage: 1,
      indianPage: 1,
      isLoadingMoreEvolution: false,
      isLoadingMoreIndian: false,
      displayGamesEvolutionXgaming: [],
      displayGamesIndianXgaming: [],
      pragmaticPage: 1,
      isLoadingMorePragmatic: false,
      allPragmaticPlay: [], // For storing Pragmatic Play games
      netentPage: 1,
      pgPage: 1,
      isLoadingMoreNetent: false,
      isLoadingMorePg: false,
      isLoadingMoreSlots: false,
      allNetentGames: [],
      allPgGames: [],
      loadedLiveCasinoImages: new Set(),
      loadedPragmeticImage: new Set(),
      isLoadGames: true,
    };
    this.gridRef = React.createRef();
    this.sections = ["/assets/images/evolutionicon.png", "/assets/images/ezubi.png", "/assets/images/pragmatic.png", "/assets/images/netent.png", "/assets/images/novomatic.png"];
    this.livecasino = ["/assets/images/live1.png", "/assets/images/live2.png", "/assets/images/live3.jpg", "/assets/images/live4.jpg", "/assets/images/live5.jpg", "/assets/images/live6.png"];
    this.itemsToShow = 5;
    this.containerPlayRef = React.createRef();
    this.handleMouseDown = this.handleMouseDown.bind(this);
    this.handleMouseLeave = this.handleMouseLeave.bind(this);
    this.handleMouseUp = this.handleMouseUp.bind(this);
    this.handleMouseMove = this.handleMouseMove.bind(this);
    this.scrollContainerRef = React.createRef();
    this.scrollContainerLiveRef = React.createRef();
    this.scrollContainerLiveAllRef = React.createRef();
    this.scrollContainerSpribeRef = React.createRef();
    this.scrollContainerLiveCasinoRef = React.createRef();
    this.scrollContainerSlotsRef = React.createRef();
    this.scrollContainerAllSlotsRef = React.createRef();
    this.scrollContainerEvolutionGaminingRef = React.createRef();
    this.scrollContainerCrashRef = React.createRef();
    this.scrollContainerVivo = React.createRef();
    this.scrollContainerLive88 = React.createRef();
    this.scrollContainerKa = React.createRef();
    this.scrollContainerJili = React.createRef();
    this.scrollContainerBetGame = React.createRef();
    this.notificationCounter = 0;
    this.scrollContainerLotteryRef = React.createRef();
    this.scrollContainerPraRef = React.createRef();
    this.scrollContainerEzugiRef = React.createRef();
    this.scrollContainerIdealRef = React.createRef();
    this.scrollContainerMicrogamingRef = React.createRef();
    this.scrollContainerDpesportsRef = React.createRef();
    this.scrollContainerPgsoftRef = React.createRef();
    this.scrollContainerTwojRef = React.createRef();
    this.scrollContainerHackSawRef = React.createRef();
    this.scrollContainerJsJiliRef = React.createRef();
    this.scrollContainerJsBgamingRef = React.createRef();
    this.scrollContainerJsNetentRef = React.createRef();
  }



  async componentDidMount() {
    // Set _isMounted to true first to ensure content renders
    this._isMounted = true;

    // Get the logged state from localStorage when component mounts
    const loggedStatus = localStorage.getItem('logged') === 'true';
    this.setState({ isLogged: loggedStatus });

    // One-time reload logic using "logged" as flag
  // if (localStorage.getItem('logged') !== 'reloaded') {
  //   setTimeout(() => {
  //     localStorage.setItem('logged', 'reloaded');
  //     window.location.reload();
  //   }, 3000);
  // }
    
  
    // Scroll to top
    document.body.scrollTop = 0;
    document.documentElement.scrollTop = 0;

    // Update enabled features
    this.updateEnabledFeatures(this.props.finalState);

    // Mobile padding adjustment
    if (isMobile()) {
      this.setState({ padding: 'p-1' });
    }

    // Add event listeners
    window.addEventListener('resize', this.handleResize);
    this.handleResize();

    // Add scroll and resize event listeners for grid
    this.checkScrollPosition();
    if (this.gridRef.current) {
      this.gridRef.current.addEventListener('scroll', this.checkScrollPosition);
      window.addEventListener('resize', this.checkScrollPosition);
    }

    // Add mouse event listeners for container
    const containerPlay = this.containerPlayRef.current;
    if (containerPlay) {
      containerPlay.addEventListener('mousedown', this.handleMouseDown);
      containerPlay.addEventListener('mouseleave', this.handleMouseLeave);
      containerPlay.addEventListener('mouseup', this.handleMouseUp);
      containerPlay.addEventListener('mousemove', this.handleMouseMove);
    }

    // Socket event listeners
    socket.on(C.USER_INFO, this.handleUserInfo);
    this.requestUserInfo();

    // List of vendors to fetch
    const vendors = ['evolution', 'pragmatic', 'spribe', 'ezugi', 'ideal',
      'microgaming', 'pgsoft', 'hacksaw', 'jili', 'netent', 'pragmaticlive', 'bgaming'];

    // Create an object to store all fetched data
    const vendorData = {};
    const vendorPagination = {};

    // Fetch initial data for all vendors
    for (const vendor of vendors) {
      try {
        const result = await this.fetchJSGamesByVendor(vendor, 1, 24);

        // Store games in appropriate state variable name
        const stateKey = vendor === 'pragmatic' ? 'jsPragmeticSlots' :
          vendor === 'pragmaticlive' ? 'jsPragamaticLive' :
            vendor === 'evolution' ? 'jsEvolution' :
              vendor === 'spribe' ? 'jsSpribe' :
                vendor === 'bgaming' ? 'jsBgaming'
                  :
                  `js${vendor.charAt(0).toUpperCase() + vendor.slice(1)}`;

        vendorData[stateKey] = result.games;

        // Store pagination info correctly using the API's format
        vendorPagination[vendor] = {
          currentPage: result.pagination.current_page || 1,
          totalPages: result.pagination.total_pages || 1,
          loading: false
        };

        // console.log(`${vendor} pagination:`, result.pagination); // Debug log
      } catch (error) {
        console.error(`Error fetching ${vendor} games:`, error);
        vendorPagination[vendor] = { currentPage: 1, totalPages: 1, loading: false };
      }
    }

    setTimeout(() => {
      this.setState({
        ...vendorData,
        vendorPagination,
        isLoadGames: false
      });
    }, 300);
  }

  componentWillUnmount() {
    // Set _isMounted to false
    this._isMounted = false;

    // Clean up resize event listeners
    window.removeEventListener('resize', this.handleResize);

    // Clean up grid scroll event listeners
    if (this.gridRef.current) {
      this.gridRef.current.removeEventListener('scroll', this.checkScrollPosition);
      window.removeEventListener('resize', this.checkScrollPosition);
    }

    // Clean up container mouse event listeners
    const containerPlay = this.containerPlayRef.current;
    if (containerPlay) {
      containerPlay.removeEventListener('mousedown', this.handleMouseDown);
      containerPlay.removeEventListener('mouseleave', this.handleMouseLeave);
      containerPlay.removeEventListener('mouseup', this.handleMouseUp);
      containerPlay.removeEventListener('mousemove', this.handleMouseMove);
    }

    // Clean up socket event listeners
    socket.off(C.USER_INFO, this.handleUserInfo);
  }

  handleImageLiveCasinoLoad = (gameId) => {
    this.setState(prevState => ({
      loadedLiveCasinoImages: new Set(prevState.loadedLiveCasinoImages).add(gameId)
    }));
  };

  requestUserInfo = () => {
    socket.emit(C.USER_INFO, encode({
      id: getUID(),
      coin: storage.getKey('coin') || '',
      rate: null,
      game: 'all',
      first: true
    }));
  };
  handleUserInfo = (data) => {
    const decodedData = decode(data);
    console.log("hello");
    console.log("decodedData", decodedData);
    this.getUserInfo(decodedData);

    if (decodedData.status) {
      this.setState({ userData: decodedData });
    }
  };

  getUserInfo = (data) => {
    //  console.log("helojuhchabsx", data.parent_id);

    if (typeof data.parent_id === 'number' && Number.isInteger(data.parent_id)) {
      this.setState({ isAgent: true });
    } else {
      this.setState({ isAgent: false });
    }
    console.log("isAgent", this.state.isAgent);

  };


  handleScrollLeftAllSlots = () => {
    if (this.scrollContainerAllSlotsRef.current) {
      this.scrollContainerAllSlotsRef.current.scrollBy({
        left: -400, // Adjust the scroll amount as needed
        behavior: 'smooth'
      });
    }
  }

  handleScrollRightAllSlots = () => {
    if (this.scrollContainerAllSlotsRef.current) {
      this.scrollContainerAllSlotsRef.current.scrollBy({
        left: 400, // Adjust the scroll amount as needed
        behavior: 'smooth'
      });
    }
  }





  handleScrollLeftVivo = () => {
    if (this.scrollContainerVivo.current) {
      this.scrollContainerVivo.current.scrollBy({
        left: -400, // Adjust the scroll amount as needed
        behavior: 'smooth'
      });
    }
  }

  handleScrollRightVivo = () => {
    if (this.scrollContainerVivo.current) {
      this.scrollContainerVivo.current.scrollBy({
        left: 400, // Adjust the scroll amount as needed
        behavior: 'smooth'
      });
    }
  }
  handleScrollLeftJSBgaming = () => {
    if (this.scrollContainerJsBgamingRef.current) {
      this.scrollContainerJsBgamingRef.current.scrollBy({
        left: -400, // Adjust the scroll amount as needed
        behavior: 'smooth'
      });
    }
  }

  handleScrollRightJSBgaming = () => {
    if (this.scrollContainerJsBgamingRef.current) {
      this.scrollContainerJsBgamingRef.current.scrollBy({
        left: 400, // Adjust the scroll amount as needed
        behavior: 'smooth'
      });
    }
  }


  handleScrollLeftJili = () => {
    if (this.scrollContainerJili.current) {
      this.scrollContainerJili.current.scrollBy({
        left: -400, // Adjust the scroll amount as needed
        behavior: 'smooth'
      });
    }
  }

  handleScrollRightJili = () => {
    if (this.scrollContainerJili.current) {
      this.scrollContainerJili.current.scrollBy({
        left: 400, // Adjust the scroll amount as needed
        behavior: 'smooth'
      });
    }
  }







  handleScrollLeftBetGame = () => {
    if (this.scrollContainerBetGame.current) {
      this.scrollContainerBetGame.current.scrollBy({
        left: -400, // Adjust the scroll amount as needed
        behavior: 'smooth'
      });
    }
  }
  handleScrollRightBetGame = () => {
    if (this.scrollContainerBetGame.current) {
      this.scrollContainerBetGame.current.scrollBy({
        left: 400, // Adjust the scroll amount as needed
        behavior: 'smooth'
      });
    }
  }





  handleScrollLeftLive88 = () => {
    if (this.scrollContainerLive88.current) {
      this.scrollContainerLive88.current.scrollBy({
        left: -400, // Adjust the scroll amount as needed
        behavior: 'smooth'
      });
    }
  }

  handleScrollRightLive88 = () => {
    if (this.scrollContainerLive88.current) {
      this.scrollContainerLive88.current.scrollBy({
        left: 400, // Adjust the scroll amount as needed
        behavior: 'smooth'
      });
    }
  }



  handleScrollLeftKa = () => {
    if (this.scrollContainerKa.current) {
      this.scrollContainerKa.current.scrollBy({
        left: -400, // Adjust the scroll amount as needed
        behavior: 'smooth'
      });
    }
  }

  handleScrollRightKa = () => {
    if (this.scrollContainerKa.current) {
      this.scrollContainerKa.current.scrollBy({
        left: 400, // Adjust the scroll amount as needed
        behavior: 'smooth'
      });
    }
  }






  handleScrollLeftLiveCasino = () => {
    if (this.scrollContainerLiveCasinoRef.current) {
      this.scrollContainerLiveCasinoRef.current.scrollBy({
        left: -400, // Adjust the scroll amount as needed
        behavior: 'smooth'
      });
    }
  }

  handleScrollRightLiveCasino = () => {
    if (this.scrollContainerLiveCasinoRef.current) {
      this.scrollContainerLiveCasinoRef.current.scrollBy({
        left: 400, // Adjust the scroll amount as needed
        behavior: 'smooth'
      });
    }
  }
  handleLeftCrashClick = () => {
    if (this.scrollContainerCrashRef.current) {
      this.scrollContainerCrashRef.current.scrollBy({
        left: -300, // Adjust the scroll amount as needed
        behavior: 'smooth'
      });
    }
  };

  handleRightCrashClick = () => {
    if (this.scrollContainerCrashRef.current) {
      this.scrollContainerCrashRef.current.scrollBy({
        left: 300, // Adjust the scroll amount as needed
        behavior: 'smooth'
      });
    }
  };

  handleScrollLeftSlots = () => {
    if (this.scrollContainerSlotsRef.current) {
      this.scrollContainerSlotsRef.current.scrollBy({
        left: -400, // Adjust the scroll amount as needed
        behavior: 'smooth'
      });
    }
  }

  handleScrollRightSlots = () => {
    if (this.scrollContainerSlotsRef.current) {
      this.scrollContainerSlotsRef.current.scrollBy({
        left: 400, // Adjust the scroll amount as needed
        behavior: 'smooth'
      });
    }
  }

  checkScrollPosition = () => {
    if (this.gridRef.current) {
      const { scrollLeft, scrollWidth, clientWidth } = this.gridRef.current;

      this.setState({
        canScrollLeft: scrollLeft > 0,
        canScrollRight: Math.ceil(scrollLeft) < (scrollWidth - clientWidth)
      });
    }
  };

  handleLeftLotteryClick = () => {
    if (this.scrollContainerLotteryRef.current) {
      this.scrollContainerLotteryRef.current.scrollBy({
        left: -300,
        behavior: 'smooth'
      });
    }
  };

  handleRightLotteryClick = () => {
    if (this.scrollContainerLotteryRef.current) {
      this.scrollContainerLotteryRef.current.scrollBy({
        left: 300,
        behavior: 'smooth'
      });
    }
  };
  handleLeftPraClick = () => {
    if (this.scrollContainerPraRef.current) {
      this.scrollContainerPraRef.current.scrollBy({
        left: -400,
        behavior: 'smooth'
      });
    }
  };

  handleRightPraClick = () => {
    if (this.scrollContainerPraRef.current) {
      this.scrollContainerPraRef.current.scrollBy({
        left: 400,
        behavior: 'smooth'
      });
    }
  };

  // Ezugi
  handleScrollLeftEzugi = () => {
    if (this.scrollContainerEzugiRef.current) {
      this.scrollContainerEzugiRef.current.scrollBy({ left: -400, behavior: 'smooth' });
    }
  }
  handleScrollRightEzugi = () => {
    if (this.scrollContainerEzugiRef.current) {
      this.scrollContainerEzugiRef.current.scrollBy({ left: 400, behavior: 'smooth' });
    }
  }

  // Ideal
  handleScrollLeftIdeal = () => {
    if (this.scrollContainerIdealRef.current) {
      this.scrollContainerIdealRef.current.scrollBy({ left: -400, behavior: 'smooth' });
    }
  }
  handleScrollRightIdeal = () => {
    if (this.scrollContainerIdealRef.current) {
      this.scrollContainerIdealRef.current.scrollBy({ left: 400, behavior: 'smooth' });
    }
  }

  // Microgaming
  handleScrollLeftMicrogaming = () => {
    if (this.scrollContainerMicrogamingRef.current) {
      this.scrollContainerMicrogamingRef.current.scrollBy({ left: -400, behavior: 'smooth' });
    }
  }
  handleScrollRightMicrogaming = () => {
    if (this.scrollContainerMicrogamingRef.current) {
      this.scrollContainerMicrogamingRef.current.scrollBy({ left: 400, behavior: 'smooth' });
    }
  }

  // Dpesports
  handleScrollLeftDpesports = () => {
    if (this.scrollContainerDpesportsRef.current) {
      this.scrollContainerDpesportsRef.current.scrollBy({ left: -400, behavior: 'smooth' });
    }
  }
  handleScrollRightDpesports = () => {
    if (this.scrollContainerDpesportsRef.current) {
      this.scrollContainerDpesportsRef.current.scrollBy({ left: 400, behavior: 'smooth' });
    }
  }

  // Pgsoft
  handleScrollLeftPgsoft = () => {
    if (this.scrollContainerPgsoftRef.current) {
      this.scrollContainerPgsoftRef.current.scrollBy({ left: -400, behavior: 'smooth' });
    }
  }
  handleScrollRightPgsoft = () => {
    if (this.scrollContainerPgsoftRef.current) {
      this.scrollContainerPgsoftRef.current.scrollBy({ left: 400, behavior: 'smooth' });
    }
  }

  // 2j
  handleScrollLeftTwoj = () => {
    if (this.scrollContainerTwojRef.current) {
      this.scrollContainerTwojRef.current.scrollBy({ left: -400, behavior: 'smooth' });
    }
  }
  handleScrollRightTwoj = () => {
    if (this.scrollContainerTwojRef.current) {
      this.scrollContainerTwojRef.current.scrollBy({ left: 400, behavior: 'smooth' });
    }
  }


  handleScrollLeftHackSaw = () => {
    if (this.scrollContainerHackSawRef.current) {
      this.scrollContainerHackSawRef.current.scrollBy({ left: -400, behavior: 'smooth' });
    }
  }
  handleScrollRightHackSaw = () => {
    if (this.scrollContainerHackSawRef.current) {
      this.scrollContainerHackSawRef.current.scrollBy({ left: 400, behavior: 'smooth' });
    }
  }

  handleScrollLeftJsJili = () => {
    if (this.scrollContainerJsJiliRef.current) {
      this.scrollContainerJsJiliRef.current.scrollBy({ left: -400, behavior: 'smooth' });
    }
  }

  handleScrollRightJsJili = () => {
    if (this.scrollContainerJsJiliRef.current) {
      this.scrollContainerJsJiliRef.current.scrollBy({ left: 400, behavior: 'smooth' });
    }
  }

  handleScrollLeftJsNetent = () => {
    if (this.scrollContainerJsNetentRef.current) {
      this.scrollContainerJsNetentRef.current.scrollBy({ left: -400, behavior: 'smooth' });
    }
  }

  handleScrollRightJsNetent = () => {
    if (this.scrollContainerJsNetentRef.current) {
      this.scrollContainerJsNetentRef.current.scrollBy({ left: 400, behavior: 'smooth' });
    }
  }


  handleScroll = (direction) => {
    if (this.gridRef.current) {
      const scrollAmount = this.gridRef.current.clientWidth / 2;
      this.gridRef.current.scrollBy({
        left: direction === 'left' ? -scrollAmount : scrollAmount,
        behavior: 'smooth'
      });
    }
  };

  handleShowAllData = () => {
    this.setState(prevState => ({ showAllData: !prevState.showAllData }));
  }

  handleMouseDown(e) {
    this.isDown = true;
    this.startX = e.pageX - this.containerPlayRef.current.offsetLeft;
    this.scrollLeft = this.containerPlayRef.current.scrollLeft;
  }

  handleShowAllIndainClick = (e) => {
    e.preventDefault(); // Prevent default link behavior
    this.setState({ showAll: !this.state.showAll });
  }
  handleShowAllClick = (e) => {
    e.preventDefault(); // Prevent default link behavior
    this.setState({ showAllIndian: !this.state.showAllIndian });
  }
  handleShowAllPragamaticClick = (e) => {
    e.preventDefault(); // Prevent default link behavior
    this.setState({ showPragamatic: !this.state.showPragamatic });
  }
  handleShowAllClickEvo = (e) => {
    e.preventDefault(); // Prevent default link behavior
    this.setState({ showMoreEvo: !this.state.showMoreEvo });
  }




  handleShowAllClickVivo = (e) => {
    e.preventDefault(); // Prevent default link behavior
    this.setState({ showMoreVivo: !this.state.showMoreVivo });
  }
  handleShowAllClickKa = (e) => {
    e.preventDefault(); // Prevent default link behavior
    this.setState({ showMoreka: !this.state.showMoreka });
  }
  handleShowAllClickLive88 = (e) => {
    e.preventDefault(); // Prevent default link behavior
    this.setState({ showMoreLive88: !this.state.showMoreLive88 });
  }
  handleShowAllClickBetGame = (e) => {
    e.preventDefault(); // Prevent default link behavior
    this.setState({ showMoreBetGame: !this.state.showMoreBetGame });
  }

  handleShowAllClickJili = (e) => {
    e.preventDefault(); // Prevent default link behavior
    this.setState({ showMoreJili: !this.state.showMoreJili });
  }

  handleShowAllClickBGaming = (e) => {
    e.preventDefault(); // Prevent default link behavior
    this.setState({ showMoreJsBgaming: !this.state.showMoreJsBgaming });
  }


  handleMouseLeave() {
    this.isDown = false;
  }

  handleMouseUp() {
    this.isDown = false;
  }

  handleMouseMove(e) {
    if (!this.isDown) return;
    e.preventDefault();
    const x = e.pageX - this.containerPlayRef.current.offsetLeft;
    const walk = (x - this.startX) * 2;
    this.containerPlayRef.current.scrollLeft = this.scrollLeft - walk;
  }
  handleItemClick = (item) => {
    this.setState({ activeItem: item });
  };

  componentDidUpdate(prevProps, prevState) {
    if (prevState.activeItem !== this.state.activeItem) {
      // console.log(`Active item changed to: ${this.state.activeItem}`);
      // Add any additional side effects or logic you want to run on activeItem change
    }
  }









  handleBackButton = () => {
    this.setState({ showIframe: false, iframeUrl: '', iframeLoading: true });
    window.location.reload(true);
  };

  handleIframeLoad = () => {
    this.setState({ iframeLoading: false });
  };


  handleGameLaunchJSGames = async (game) => {
    const isLogged = localStorage.getItem('logged') === 'true';

    if (!isLogged) {
      sendNotfication('Please login to play', 'error');
      return;
    }

    this.setState({ loading: true, message: null });

    try {
      // Get credits and coin type from localStorage
      const credits = localStorage.getItem('credit') || '0';
      const coins = localStorage.getItem('coin') || 'USDT';
      if (coins !== 'USDT' && coins !== 'INR') {
        sendNotfication("Please Swap Into USDT To Play", "error");
        this.setState({ loading: false });
        return;
      }
      // Prepare the launch request payload
      const requestPayload = {
        game_uid: game.game_uid,
        user_id: getUID(),
        credit_amount: credits,
        currency_code: coins,
        language: "en",
      };

      // Make the API call to launch the game
      const result = await gamesService.launchGame(requestPayload);

      // Check if the response is successful
      if (!result.success) {
        // throw new Error("Network response was not ok");
        sendNotfication("Game under maintenance", "error")
      }

      // Check if game launch was successful
      if (result.success && result.data.game_launch_url) {
        this.setState({
          iframeUrl: result.data.game_launch_url,
          showIframe: true,
          iframeLoading: true,
        });
      } else {
        // Throw an error if game launch failed
        // throw new Error("Failed to launch game: " + (result.message || "Unknown error"));
      }
    } catch (error) {
      // Handle any errors during the game launch process
      this.setState({
        message: {
          type: 'error',
          text: error.message
        }
      });
      // sendNotfication(error.message,"error")
    } finally {
      // Reset loading state
      this.setState({ loading: false });

      // Clear message after 5 seconds
      setTimeout(() => {
        this.setState({ message: null });
      }, 5000);
    }
  };

  fetchJSGamesByVendor = async (vendorName, page = 1, perPage = 24) => {
    const token = localStorage.getItem('token');
    const headers = {
      'Authorization': `Bearer ${token}`
    };
    try {
      const result = await gamesService.getGamesByVendor(vendorName, page, perPage, headers);

      if (result.success && result.payload && result.payload.games) {
        // Return the games array and pagination information directly from the API
        return {
          games: result.payload.games,
          pagination: result.payload.pagination || {
            current_page: page,
            per_page: perPage,
            total: result.payload.games.length,
            total_pages: Math.ceil(result.payload.games.length / perPage)
          }
        };
      } else {
        throw new Error("No games found or invalid response");
      }
    } catch (error) {
      console.error(`Error fetching ${vendorName} games:`, error.message);
      return { games: [], pagination: { current_page: 1, per_page: perPage, total: 0, total_pages: 0 } };
    }
  };

  loadMoreGames = async (vendor) => {
    // Determine the state and pagination mapping
    const stateKeyMapping = {
      'evolution': 'jsEvolution',
      'pragmatic': 'jsPragmeticSlots',
      'pragmaticlive': 'jsPragamaticLive',
      'spribe': 'jsSpribe',
      'ezugi': 'jsEzugi',
      'ideal': 'jsIdeal',
      'microgaming': 'jsMicrogaming',
      'pgsoft': 'jsPgsoft',
      'hacksaw': 'jsHacksaw',
      'jili': 'jsJili',
      'netent': 'jsNetent',
      'bgaming': 'jsBgaming'
    };

    const stateKey = stateKeyMapping[vendor];

    if (!stateKey) return;

    // Get current pagination state
    const vendorPagination = { ...this.state.vendorPagination };
    const pagination = vendorPagination[vendor];

    // If already at last page or currently loading, do nothing
    if (pagination.currentPage >= pagination.totalPages || pagination.loading) {
      return;
    }

    // Set loading state
    vendorPagination[vendor].loading = true;
    this.setState({ vendorPagination });

    try {
      // Fetch next page
      const nextPage = pagination.currentPage + 1;
      const result = await this.fetchJSGamesByVendor(vendor, nextPage, 24);

      // Append new games to existing ones
      const updatedGames = [...this.state[stateKey], ...result.games];

      // Update pagination info
      vendorPagination[vendor] = {
        currentPage: result.pagination.current_page,
        totalPages: result.pagination.total_pages,
        loading: false
      };

      // Update state
      this.setState({
        [stateKey]: updatedGames,
        vendorPagination
      });
    } catch (error) {
      console.error(`Error loading more ${vendor} games:`, error);
      vendorPagination[vendor].loading = false;
      this.setState({ vendorPagination });
    }
  };
  handlePagination = async (vendor, direction) => {
    // Determine the state and pagination mapping
    const stateKeyMapping = {
      'evolution': 'jsEvolution',
      'pragmatic': 'jsPragmeticSlots',
      'pragmaticlive': 'jsPragamaticLive',
      'spribe': 'jsSpribe',
      'ezugi': 'jsEzugi',
      'ideal': 'jsIdeal',
      'microgaming': 'jsMicrogaming',
      'pgsoft': 'jsPgsoft',
      'hacksaw': 'jsHacksaw',
      'jili': 'jsJili',
      'netent': 'jsNetent',
      'bgaming': 'jsBgaming'
    };

    const stateKey = stateKeyMapping[vendor];

    if (!stateKey) return;

    // Get current pagination state
    const vendorPagination = { ...this.state.vendorPagination };
    const pagination = vendorPagination[vendor];

    // Calculate target page
    let targetPage = direction === 'next' ?
      pagination.currentPage + 1 :
      pagination.currentPage - 1;

    // Validate target page
    if (targetPage < 1 || targetPage > pagination.totalPages || pagination.loading) {
      return;
    }

    // Set loading state
    vendorPagination[vendor].loading = true;
    this.setState({ vendorPagination });

    try {
      // Fetch target page
      const result = await this.fetchJSGamesByVendor(vendor, targetPage, 24);

      // console.log(`Pagination result for ${vendor}:`, result.pagination); // Debug log

      // Update pagination info using the API's format
      vendorPagination[vendor] = {
        currentPage: result.pagination.current_page,
        totalPages: result.pagination.total_pages,
        loading: false
      };

      // Update state with new games
      this.setState({
        [stateKey]: result.games,
        vendorPagination
      });
    } catch (error) {
      console.error(`Error navigating ${vendor} games:`, error);
      vendorPagination[vendor].loading = false;
      this.setState({ vendorPagination });
    }
  };

  componentDidUpdate(prevProps) {
    // Step 4: Call updateEnabledFeatures when finalState changes
    if (prevProps.finalState !== this.props.finalState) {
      this.updateEnabledFeatures(this.props.finalState);
    }
  }

  updateEnabledFeatures(finalState) {
    // Steps 2, 3, 5: Safely update enabledFeatures with new object
    this.setState({
      enabledFeatures: {
        evolution: finalState?.evolution ?? true,
        pragmaticslots: finalState?.pragmaticslots ?? true,
        pragmaticslive: finalState?.pragmaticlive ?? true,
        spribe: finalState?.spribe ?? true,
        ezugi: finalState?.ezugi ?? true,
        ideal: finalState?.ideal ?? true,
        esport: finalState?.esport ?? true,
        microgaming: finalState?.microgaming ?? true,
        Pgsoft: finalState?.pgsoft ?? true,
        Hacksaw: finalState?.hacksawgaming ?? true,
        jili: finalState?.jili ?? true,
        netent: finalState?.netent ?? true,
        bjboriginal: finalState?.originals ?? true,
        bgaming: finalState?.microgaming ?? true,
      },
    });
  }



  handleResize = () => {
    const width = window.innerWidth || document.documentElement.clientWidth || document.body.clientWidth;
    this.setState({ isMobileView: width <= 768 });
  };

  handleClick = (e) => {
    this.setState({ selectedSection: e });
  };

  handleArrowClick = (direction) => {
    const { sectionIndex } = this.state;
    const { sections, itemsToShow } = this;
    const totalSections = sections.length;

    let newIndex;

    if (direction === 'left') {
      newIndex = (sectionIndex - itemsToShow + totalSections) % totalSections;
    } else {
      newIndex = (sectionIndex + itemsToShow) % totalSections;
    }

    this.setState({ selectedSection: sections[newIndex], sectionIndex: newIndex });
  };

  handleShowMore = () => {
    this.setState({ showMore: !this.state.showMore });
  };

  handleShowMoreP = () => {
    this.setState({ showMoreP: !this.state.showMoreP });
  };

  handleShowMoreO = () => {
    this.setState({ showMoreO: !this.state.showMoreO });
  };

  handleShowMoreLCP = () => {
    this.setState({ showMoreLCP: !this.state.showMoreLCP });
  };

  handleShowMoreSP = () => {
    this.setState({ showMoreSP: !this.state.showMoreSP });
  };

  handleShowMoreSB = () => {
    this.setState({ showMoreSB: !this.state.showMoreSB });
  };

  handleSearch = (query) => {
    this.setState({ searchQuery: query });
  };


  getFilteredGamesXGaming = (games) => {
    const { searchQuery } = this.state;
    const { companies } = this.props;
    const { canScrollLeft, canScrollRight } = this.state;

    if (!searchQuery) return games;
    return games.filter(game => game.title && game.title.toLowerCase().includes(searchQuery.toLowerCase()));
  };
  handleScrollLeft = () => {
    if (this.scrollContainerRef.current) {
      this.scrollContainerRef.current.scrollBy({
        left: -400,
        behavior: 'smooth'
      });
    }
  }

  handleScrollRight = () => {
    if (this.scrollContainerRef.current) {
      this.scrollContainerRef.current.scrollBy({
        left: 400,
        behavior: 'smooth'
      });
    }
  }

  handleScrollLeftLive = () => {
    if (this.scrollContainerLiveRef.current) {
      this.scrollContainerLiveRef.current.scrollBy({
        left: -400,
        behavior: 'smooth'
      });
    }
  }

  handleScrollRightLive = () => {
    if (this.scrollContainerLiveRef.current) {
      this.scrollContainerLiveRef.current.scrollBy({
        left: 400,
        behavior: 'smooth'
      });
    }
  }
  handleScrollLeftLiveAll = () => {
    if (this.scrollContainerLiveAllRef.current) {
      this.scrollContainerLiveAllRef.current.scrollBy({
        left: -400,
        behavior: 'smooth'
      });
    }
  }

  handleLotteryGameClick = (gameId) => {
    // Handle lottery game click
    // console.log(`Lottery game ${gameId} clicked`);
    // Add your lottery game launch logic here
  };

  handleScrollLeftLive = () => {
    if (this.scrollContainerRef.current) {
      this.scrollContainerRef.current.scrollBy({
        left: -400, // Adjust the scroll amount as needed
        behavior: 'smooth'
      });
    }
  }

  handleScrollRightLive = () => {
    if (this.scrollContainerRef.current) {
      this.scrollContainerRef.current.scrollBy({
        left: 400, // Adjust the scroll amount as needed
        behavior: 'smooth'
      });
    }
  }


  handleScrollRightLiveAll = () => {
    if (this.scrollContainerLiveAllRef.current) {
      this.scrollContainerLiveAllRef.current.scrollBy({
        left: 400,
        behavior: 'smooth'
      });
    }
  }

  handleScrollLeftSpribe = () => {
    if (this.scrollContainerSpribeRef.current) {
      this.scrollContainerSpribeRef.current.scrollBy({
        left: -400, // Adjust the scroll amount as needed
        behavior: 'smooth'
      });
    }
  }

  handleScrollRightSpribe = () => {
    if (this.scrollContainerSpribeRef.current) {
      this.scrollContainerSpribeRef.current.scrollBy({
        left: 400, // Adjust the scroll amount as needed
        behavior: 'smooth'
      });
    }
  }
  handleScrollLeftEvolution = () => {
    if (this.scrollContainerEvolutionGaminingRef.current) {
      this.scrollContainerEvolutionGaminingRef.current.scrollBy({
        left: -400, // Adjust the scroll amount as needed
        behavior: 'smooth'
      });
    }
  }
  handleScrollRightEvolution = () => {
    if (this.scrollContainerEvolutionGaminingRef.current) {
      this.scrollContainerEvolutionGaminingRef.current.scrollBy({
        left: 400, // Adjust the scroll amount as needed
        behavior: 'smooth'
      });
    }
  }




  render() {
    let { content, t, siteConfig } = this.props;


    // const finalState = useSelector((state) => state.finalState.finalState);
    // console.log('finalState:', finalState);

    const { canScrollLeft, canScrollRight, isLogged } = this.state;
    const { loading, message, isMobileView, showIframe, enabledFeatures, iframeUrl, iframeLoading, jsPragmeticSlots, jsSpribe,
      jsEvolution, jsPragamaticLive, jsHacksaw, jsJili, jsNetent, jsBgaming } = this.state;
    const { loadedLiveCasinoImages } = this.state;




    const companies = [
      { image: '/assets/images/Providers/evolutiongaming.webp', path: '/providers/evolution-gaming' },
      { image: '/assets/images/Providers/netent.webp', path: '/providers/netent' },
      { image: '/assets/images/Providers/bet.webp', path: '/providers/betsoft' },
      { image: '/assets/images/Providers/quickspin.webp', path: '/providers/quickspin' },
      { image: '/assets/images/Providers/bgaming.webp', path: '/providers/bgaming' },
      { image: '/assets/images/Providers/ka.webp', path: '/providers/Ka' },
      { image: '/assets/images/Providers/wazdan.webp', path: '/providers/wazdan' },
      { image: '/assets/images/Providers/platipus.webp', path: '/providers/platipus' },
      { image: '/assets/images/Providers/evolutiongaming.webp', path: '/providers/evolution-gaming' },
      { image: '/assets/images/Providers/netent.webp', path: '/providers/netent' },
      { image: '/assets/images/Providers/bet.webp', path: '/providers/betsoft' },
      { image: '/assets/images/Providers/quickspin.webp', path: '/providers/quickspin' },
      { image: '/assets/images/Providers/bgaming.webp', path: '/providers/bgaming' },
      { image: '/assets/images/Providers/ka.webp', path: '/providers/Ka' },
      { image: '/assets/images/Providers/wazdan.webp', path: '/providers/wazdan' },
      { image: '/assets/images/Providers/platipus.webp', path: '/providers/platipus' },
      { image: '/assets/images/Providers/netent.webp', path: '/providers/netent' },
      { image: '/assets/images/Providers/bet.webp', path: '/providers/betsoft' },
    ];






    const displayGamesEvolutionJSgaming = isMobileView
      ? jsEvolution : (this.state.showMoreEvo ? jsEvolution : jsEvolution.slice(0, 40));


    const displayGamesPragamticLiveJSgaming = isMobileView
      ? jsPragamaticLive : (this.state.showMoreBetGame ? jsPragamaticLive : jsPragamaticLive.slice(0, 40));

    const displayGamesPragamticSlotsJSgaming = isMobileView
      ? jsPragmeticSlots : (this.state.showPragamatic ? jsPragmeticSlots : jsPragmeticSlots.slice(0, 40));

    const displayGamesPragamticSpribesJSgaming = isMobileView
      ? jsSpribe : (this.state.showMoreSP ? jsSpribe : jsSpribe.slice(0, 40));

    // Add these display logic variables before the render section
    const displayGamesEzugiJSgaming = isMobileView
      ? this.state.jsEzugi : (this.state.showMoreEzugi ? this.state.jsEzugi : this.state.jsEzugi.slice(0, 40));

    const displayGamesIdealJSgaming = isMobileView
      ? this.state.jsIdeal : (this.state.showMoreIdeal ? this.state.jsIdeal : this.state.jsIdeal.slice(0, 40));

    const displayGamesMicrogamingJSgaming = isMobileView
      ? this.state.jsMicrogaming : (this.state.showMoreMicrogaming ? this.state.jsMicrogaming : this.state.jsMicrogaming.slice(0, 40));


    const displayGamesHackSawJSgaming = isMobileView
      ? this.state.jsHacksaw : (this.state.showMoreHackSaw ? this.state.jsHacksaw : this.state.jsHacksaw.slice(0, 40));

    const displayGamesJiliJSgaming = isMobileView
      ? this.state.jsJili : (this.state.showMoreJsJili ? this.state.jsJili : this.state.jsJili.slice(0, 40));

    const displayGamesNetentJSgaming = isMobileView
      ? this.state.jsNetent : (this.state.showMoreJsNetent ? this.state.jsNetent : this.state.jsNetent.slice(0, 40));


    const displayGamesPgsoftJSgaming = isMobileView
      ? this.state.jsPgsoft : (this.state.showMorePgsoft ? this.state.jsPgsoft : this.state.jsPgsoft.slice(0, 40));


    const displayGamesBgamingJSgaming = isMobileView
      ? this.state.jsBgaming : (this.state.showMoreJsBgaming ? this.state.jsBgaming : this.state.jsBgaming.slice(0, 40));



    const skylaSlots = [];

    const imageStyle = {
      position: 'absolute',
      top: '50%',
      left: '50%',
      transform: 'translate(-50%, -50%)',
      width: '250px',
      animation: 'fadeinout 2s infinite',
    };
    const animationStyle = `
      @keyframes fadeinout {
        0%, 100% { opacity: 0; }
        50% { opacity: 1; }
      }
    `;
    if (showIframe) {
      return (
        <FullScreenContainer>
          <style>{animationStyle}</style>
          {this.state.iframeLoading && (
            <img src="assets/images/./assets/boss707.png" alt="Loading" style={imageStyle} />
          )}
          <FullScreenIframe
            src={iframeUrl}
            title="Game Iframe"
            onLoad={this.handleIframeLoad}
            loading={this.state.iframeLoading}
          />
          <BackButton onClick={this.handleBackButton}>
            <FontAwesomeIcon icon={faArrowLeft} />
          </BackButton>
        </FullScreenContainer>
      );
    }


    return (
      <>
      
        {this._isMounted &&
          <>
            <Helmet>
              <title>{BRAND} - Crypto Casino Games and Crypto Gambling</title>
              <meta name="keywords" content="WEB 3.0 Crypto Casino Games, Online Casino Games, Bitcoin Crash Game, Dice Games, Live Casino Games, Crypto Casino Games, Blockchain Games, Bitcoin Casino Games, Best Crypto Online Game, Crypto Gambling Games, PlayCrash.com Crypto Games" />
              <meta name="description"
                content="PlayCrash.com is built by gamblers for gamblers. With our unique community and a huge selection of games like Crash, HashDice, Plinko, Slots, and many more." />
              <meta name="og:title" content="PlayCrash.com is built by gamblers for gamblers. With our unique community and a huge selection of games like Crash, HashDice, Plinko, Slots, and many more." />
              <meta name="og:description" content="PlayCrash.com is built by gamblers for gamblers. With our unique community and a huge selection of games like Crash, HashDice, Plinko, Slots, and many more." />
            </Helmet>

            {/* Page Content */}
            {content}


            <div style={{ marginTop: '-10px' }}>

              {/* <div>fffff</div> */}
              {/* <CustomSlider /> */}
              {/* <BannerGames /> */}
              {/* {
                isLogged ? (<SkylaSlider />
                ) : (<Banner />)
              } */}
              {/* <SkylaSlider/> */}
              {/* <Banner/> */}

               {/* <LatestWins
                all={[ ...this.state.jsPragmeticSlots, ]}
                slots={this.state.jsPragmeticSlots}
                liveCasino={this.state.jsPragmeticSlots}
              />  */}

              {this.state.isLogged ? (
             
                <SkylaSlider />  
              ) : ( 
                  <Banner />
                
              )
              }


              <GamingCards />
              

              {/* {
              siteConfig?.originals&&( */}

              {/* )             } */}

              {enabledFeatures.spribe && (
                <div style={{ marginTop: "6px" }}>
                  <HeaderContainer>
                    <TopTitle>
                      Spribe
                    </TopTitle>
                    <HeaderContent>
                      <div onClick={() => this.setState({ showMoreSP: !this.state.showMoreSP })}>

                        <IconBg>
                          <div style={{ fontWeight: "bold" }}>{this.state.showMoreSP ? "Show Less" : "Show More"}</div>
                          <span>
                            {/* <ChevronRight size={14} /> */}
                          </span>
                        </IconBg>
                      </div>
                      {
                        !this.state.showMoreSP && (

                          <div style={{ display: "flex", gap: '4px' }}>
                            <IconBg onClick={this.handleScrollLeftSpribe}>
                              <ChevronLeft size={16} />
                            </IconBg>
                            <IconBg>
                              <ChevronRight onClick={this.handleScrollRightSpribe} size={16} />
                            </IconBg>
                          </div>
                        )
                      }

                    </HeaderContent>
                  </HeaderContainer>
                  {
                    !this.state.showMoreSP ? (
                      <CarouselContainer>
                        <ScrollContainer ref={this.scrollContainerSpribeRef}>
                          {displayGamesPragamticSpribesJSgaming?.map((game, index) => (
                            <GameCard
                              key={game.id}
                              onClick={() => this.handleGameLaunchJSGames(game)}
                            >
                              <GameImage src={game.game_icon} alt={`Game ${index}`} />
                              <GameOverlay>
                                <PlayIconContainer>
                                  <PlayIcon />
                                </PlayIconContainer>
                              </GameOverlay>
                            </GameCard>
                          ))}
                        </ScrollContainer>
                      </CarouselContainer>
                    ) : (
                      <>
                        <GridWrapper>
                          {displayGamesPragamticSpribesJSgaming?.map((game, index) => (
                            <GameCard
                              key={game.id}
                              onClick={() => this.handleGameLaunchJSGames(game)}
                            >
                              <GameImage src={game.game_icon} alt={`Game ${index}`} />
                              <GameOverlay>
                                <PlayIconContainer>
                                  <PlayIcon />
                                </PlayIconContainer>
                              </GameOverlay>
                            </GameCard>
                          ))}
                        </GridWrapper>
                        <PaginationContainer>
                          <PaginationButton
                            onClick={() => this.handlePagination('spribe', 'prev')}
                            disabled={this.state.vendorPagination.spribe.currentPage <= 1 || this.state.vendorPagination.spribe.loading}
                          >
                            <ChevronLeft size={16} /> Previous
                          </PaginationButton>

                          <PaginationInfo>
                            Page {this.state.vendorPagination.spribe.currentPage} of {this.state.vendorPagination.spribe.totalPages}
                          </PaginationInfo>

                          <PaginationButton
                            onClick={() => this.handlePagination('spribe', 'next')}
                            disabled={this.state.vendorPagination.spribe.currentPage >= this.state.vendorPagination.spribe.totalPages || this.state.vendorPagination.spribe.loading}
                          >
                            Next <ChevronRight size={16} />
                          </PaginationButton>

                          {this.state.vendorPagination.spribe.loading && (
                            <StyledSpinner size="sm" />
                          )}
                        </PaginationContainer>
                      </>
                    )
                  }
                </div>
              )}

              {enabledFeatures.evolution && (
                <div style={{ marginTop: "6px" }}>
                  <HeaderContainer>
                    <TopTitle>Evolution</TopTitle>
                    <HeaderContent>
                      <div onClick={() => this.setState({ showMoreEvo: !this.state.showMoreEvo })}>
                        <IconBg>
                          <div style={{ fontWeight: "bold" }}>{this.state.showMoreEvo ? "Show Less" : "Show More"}</div>
                        </IconBg>
                      </div>
                      {!this.state.showMoreEvo && (
                        <div style={{ display: "flex", gap: '4px' }}>
                          <IconBg onClick={this.handleScrollLeftEvolution}>
                            <ChevronLeft size={16} />
                          </IconBg>
                          <IconBg onClick={this.handleScrollRightEvolution}>
                            <ChevronRight size={16} />
                          </IconBg>
                        </div>
                      )}
                    </HeaderContent>
                  </HeaderContainer>

                  {!this.state.showMoreEvo ? (
                    <CarouselContainer>
                      <ScrollContainer ref={this.scrollContainerEvolutionGaminingRef}>
                        {displayGamesEvolutionJSgaming?.map((game, index) => (
                          <GameCard
                            key={game.id}
                            onClick={() => this.handleGameLaunchJSGames(game)}
                          >
                            {!loadedLiveCasinoImages.has(game.id) && <SkeletonLoader />}
                            <GameImage onLoad={() => this.handleImageLiveCasinoLoad(game.id)}
                              style={{
                                display: loadedLiveCasinoImages.has(game.id) ? 'block' : 'none'
                              }} src={game.game_icon} alt={`Game ${index}`} />
                            <GameOverlay>
                              <PlayIconContainer>
                                <PlayIcon />
                              </PlayIconContainer>
                            </GameOverlay>
                          </GameCard>
                        ))}
                      </ScrollContainer>
                    </CarouselContainer>
                  ) : (
                    <>
                      <GridWrapper>
                        {displayGamesEvolutionJSgaming?.map((game, index) => (
                          <>
                            {
                              this.state.isLoadGames ? <SkeletonLoader /> : <GameCard
                                key={game.id}
                                onClick={() => this.handleGameLaunchJSGames(game)}
                              >
                                {!loadedLiveCasinoImages.has(game.id) && <SkeletonLoader />}
                                <GameImage
                                  onLoad={() => this.handleImageLiveCasinoLoad(game.id)}
                                  style={{
                                    display: loadedLiveCasinoImages.has(game.id) ? 'block' : 'none'
                                  }} src={game.game_icon} alt={`Game ${index}`} />
                                <GameOverlay>
                                  <PlayIconContainer>
                                    <PlayIcon />
                                  </PlayIconContainer>
                                </GameOverlay>
                              </GameCard>
                            }

                          </>
                        ))}
                      </GridWrapper>
                      <PaginationContainer>
                        <PaginationButton
                          onClick={() => this.handlePagination('evolution', 'prev')}
                          disabled={this.state.vendorPagination.evolution.currentPage <= 1 || this.state.vendorPagination.evolution.loading}
                        >
                          <ChevronLeft size={16} /> Previous
                        </PaginationButton>

                        <PaginationInfo>
                          Page {this.state.vendorPagination.evolution.currentPage} of {this.state.vendorPagination.evolution.totalPages}
                        </PaginationInfo>

                        <PaginationButton
                          onClick={() => this.handlePagination('evolution', 'next')}
                          disabled={this.state.vendorPagination.evolution.currentPage >= this.state.vendorPagination.evolution.totalPages || this.state.vendorPagination.evolution.loading}
                        >
                          Next <ChevronRight size={16} />
                        </PaginationButton>

                        {this.state.vendorPagination.evolution.loading && (
                          <StyledSpinner size="sm" />
                        )}
                      </PaginationContainer>
                    </>
                  )}
                </div>
              )}
              {enabledFeatures.esport && (
                <Esports />
              )}


              {/* {
  siteConfig?.sports &&( */}





              <div style={{ marginTop: "24px" }}>

                {
                  !isMobile() ? <PaymentBar /> : <MobilePaymentBR />
                }
              </div>



              {enabledFeatures.pragmaticslots && (
                <div style={{ marginTop: "6px" }}>
                  <HeaderContainer>
                    <TopTitle>
                      Pragamatic Slots
                    </TopTitle>
                    <HeaderContent>
                      <div onClick={() => this.setState({ showPragamatic: !this.state.showPragamatic })}>

                        <IconBg>
                          <div style={{ fontWeight: "bold" }}>{this.state.showPragamatic ? "Show Less" : "Show More"}</div>
                          <span>

                          </span>
                        </IconBg>
                      </div>
                      {
                        !this.state.showPragamatic && (

                          <div style={{ display: "flex", gap: '4px' }}>
                            <IconBg onClick={this.handleLeftPraClick}>
                              <ChevronLeft size={16} />
                            </IconBg>
                            <IconBg>
                              <ChevronRight onClick={this.handleRightPraClick} size={16} />
                            </IconBg>
                          </div>
                        )
                      }

                    </HeaderContent>
                  </HeaderContainer>
                  {
                    !this.state.showPragamatic ? (
                      <CarouselContainer>
                        <ScrollContainer ref={this.scrollContainerPraRef}>
                          {displayGamesPragamticSlotsJSgaming?.map((game, index) => (
                            <GameCard
                              key={game.id}
                              onClick={() => this.handleGameLaunchJSGames(game)}
                            >
                              <GameImage src={game.game_icon} alt={`Game ${index}`} />
                              <GameOverlay>
                                <PlayIconContainer>
                                  <PlayIcon />
                                </PlayIconContainer>
                              </GameOverlay>
                            </GameCard>
                          ))}
                        </ScrollContainer>
                      </CarouselContainer>
                    ) : (
                      <>
                        <GridWrapper>
                          {displayGamesPragamticSlotsJSgaming.map((game, index) => (
                            <GameCard
                              key={game.id}
                              onClick={() => this.handleGameLaunchJSGames(game)}
                            >
                              <GameImage src={game.game_icon} alt={`Game ${index}`} />
                              <GameOverlay>
                                <PlayIconContainer>
                                  <PlayIcon />
                                </PlayIconContainer>
                              </GameOverlay>
                            </GameCard>
                          ))}
                        </GridWrapper>

                        <PaginationContainer>
                          <PaginationButton
                            onClick={() => this.handlePagination('pragmatic', 'prev')}
                            disabled={this.state.vendorPagination.pragmatic.currentPage <= 1 || this.state.vendorPagination.pragmatic.loading}
                          >
                            <ChevronLeft size={16} /> Previous
                          </PaginationButton>

                          <PaginationInfo>
                            Page {this.state.vendorPagination.pragmatic.currentPage} of {this.state.vendorPagination.pragmatic.totalPages}
                          </PaginationInfo>

                          <PaginationButton
                            onClick={() => this.handlePagination('pragmatic', 'next')}
                            disabled={this.state.vendorPagination.pragmatic.currentPage >= this.state.vendorPagination.pragmatic.totalPages || this.state.vendorPagination.pragmatic.loading}
                          >
                            Next <ChevronRight size={16} />
                          </PaginationButton>

                          {this.state.vendorPagination.pragmatic.loading && (
                            <StyledSpinner size="sm" />
                          )}
                        </PaginationContainer>


                      </>
                    )
                  }
                </div>
              )}
              {enabledFeatures.lobby && (
                <LobbySection />
              )}


              <GameProviders />






              {enabledFeatures.pragmaticslive && (
                <div style={{ marginTop: "6px" }}>
                  <HeaderContainer>
                    <TopTitle>
                      Pragamatic Live
                    </TopTitle>
                    <HeaderContent>
                      <div onClick={() => this.setState({ showMoreBetGame: !this.state.showMoreBetGame })}>

                        <IconBg>
                          <div style={{ fontWeight: "bold" }}>{this.state.showMoreBetGame ? "Show Less" : "Show More"}</div>
                          <span>
                            {/* <ChevronRight size={14} /> */}
                          </span>
                        </IconBg>
                      </div>
                      {
                        !this.state.showMoreBetGame && (

                          <div style={{ display: "flex", gap: '4px' }}>
                            <IconBg onClick={this.handleScrollLeftBetGame}>
                              <ChevronLeft size={16} />
                            </IconBg>
                            <IconBg>
                              <ChevronRight onClick={this.handleScrollRightBetGame} size={16} />
                            </IconBg>
                          </div>
                        )
                      }

                    </HeaderContent>
                  </HeaderContainer>
                  {
                    !this.state.showMoreBetGame ? (
                      <CarouselContainer>
                        <ScrollContainer ref={this.scrollContainerBetGame}>
                          {displayGamesPragamticLiveJSgaming?.map((game, index) => (
                            <GameCard
                              key={game.id}
                              onClick={() => this.handleGameLaunchJSGames(game)}
                            >
                              <GameImage src={game.game_icon} alt={`Game ${index}`} />
                              <GameOverlay>
                                <PlayIconContainer>
                                  <PlayIcon />
                                </PlayIconContainer>
                              </GameOverlay>
                            </GameCard>
                          ))}
                        </ScrollContainer>
                      </CarouselContainer>
                    ) : (
                      <>
                        <GridWrapper>
                          {displayGamesPragamticLiveJSgaming?.map((game, index) => (
                            <GameCard
                              key={game.id}
                              onClick={() => this.handleGameLaunchJSGames(game)}
                            >
                              <GameImage src={game.game_icon} alt={`Game ${index}`} />
                              <GameOverlay>
                                <PlayIconContainer>
                                  <PlayIcon />
                                </PlayIconContainer>
                              </GameOverlay>
                            </GameCard>
                          ))}
                        </GridWrapper>
                        <PaginationContainer>
                          <PaginationButton
                            onClick={() => this.handlePagination('pragmaticlive', 'prev')}
                            disabled={this.state.vendorPagination.pragmaticlive.currentPage <= 1 || this.state.vendorPagination.pragmaticlive.loading}
                          >
                            <ChevronLeft size={16} /> Previous
                          </PaginationButton>

                          <PaginationInfo>
                            Page {this.state.vendorPagination.pragmaticlive.currentPage} of {this.state.vendorPagination.pragmaticlive.totalPages}
                          </PaginationInfo>

                          <PaginationButton
                            onClick={() => this.handlePagination('pragmaticlive', 'next')}
                            disabled={this.state.vendorPagination.pragmaticlive.currentPage >= this.state.vendorPagination.pragmaticlive.totalPages || this.state.vendorPagination.pragmaticlive.loading}
                          >
                            Next <ChevronRight size={16} />
                          </PaginationButton>

                          {this.state.vendorPagination.pragmaticlive.loading && (
                            <StyledSpinner size="sm" />
                          )}
                        </PaginationContainer>
                      </>
                    )
                  }
                </div>
              )}



              {/* Ezugi Games Section */}
              {/* <div style={{ marginTop: "6px" }}>
                <HeaderContainer>
                  <TopTitle>Ezugi</TopTitle>
                  <HeaderContent>
                    <div onClick={() => this.setState({ showMoreEzugi: !this.state.showMoreEzugi })}>
                      <IconBg>
                        <div style={{ fontWeight: "bold" }}>{this.state.showMoreEzugi ? "Show Less" : "Show More"}</div>
                      </IconBg>
                    </div>
                    {!this.state.showMoreEzugi && (
                      <div style={{ display: "flex", gap: '4px' }}>
                        <IconBg onClick={this.handleScrollLeftEzugi}>
                          <ChevronLeft size={16} />
                        </IconBg>
                        <IconBg onClick={this.handleScrollRightEzugi}>
                          <ChevronRight size={16} />
                        </IconBg>
                      </div>
                    )}
                  </HeaderContent>
                </HeaderContainer>

                {!this.state.showMoreEzugi ? (
                  <CarouselContainer>
                    <ScrollContainer ref={this.scrollContainerEzugiRef}>
                      {displayGamesEzugiJSgaming?.map((game, index) => (
                        <GameCard key={game.id} onClick={() => this.handleGameLaunchJSGames(game)}>
                          <GameImage src={game.game_icon} alt={`Game ${index}`} />
                          <GameOverlay>
                            <PlayIconContainer>
                              <PlayIcon />
                            </PlayIconContainer>
                          </GameOverlay>
                        </GameCard>
                      ))}
                    </ScrollContainer>
                  </CarouselContainer>
                ) : (
                  <>
                    <GridWrapper>
                      {displayGamesEzugiJSgaming?.map((game, index) => (
                        <GameCard key={game.id} onClick={() => this.handleGameLaunchJSGames(game)}>
                          <GameImage src={game.game_icon} alt={`Game ${index}`} />
                          <GameOverlay>
                            <PlayIconContainer>
                              <PlayIcon />
                            </PlayIconContainer>
                          </GameOverlay>
                        </GameCard>
                      ))}
                    </GridWrapper>
                    <PaginationContainer>
                      <PaginationButton
                        onClick={() => this.handlePagination('ezugi', 'prev')}
                        disabled={this.state.vendorPagination.ezugi.currentPage <= 1 || this.state.vendorPagination.ezugi.loading}
                      >
                        <ChevronLeft size={16} /> Previous
                      </PaginationButton>

                      <PaginationInfo>
                        Page {this.state.vendorPagination.ezugi.currentPage} of {this.state.vendorPagination.ezugi.totalPages}
                      </PaginationInfo>

                      <PaginationButton
                        onClick={() => this.handlePagination('ezugi', 'next')}
                        disabled={this.state.vendorPagination.ezugi.currentPage >= this.state.vendorPagination.ezugi.totalPages || this.state.vendorPagination.ezugi.loading}
                      >
                        Next <ChevronRight size={16} />
                      </PaginationButton>

                      {this.state.vendorPagination.ezugi.loading && (
                        <StyledSpinner size="sm" />
                      )}
                    </PaginationContainer>
                  </>
                )}
              </div> */}

              {/* Ideal Games Section */}
              {enabledFeatures.ideal && (
                <div style={{ marginTop: "6px" }}>
                  <HeaderContainer>
                    <TopTitle>Ideal</TopTitle>
                    <HeaderContent>
                      <div onClick={() => this.setState({ showMoreIdeal: !this.state.showMoreIdeal })}>
                        <IconBg>
                          <div style={{ fontWeight: "bold" }}>{this.state.showMoreIdeal ? "Show Less" : "Show More"}</div>
                        </IconBg>
                      </div>
                      {!this.state.showMoreIdeal && (
                        <div style={{ display: "flex", gap: '4px' }}>
                          <IconBg onClick={this.handleScrollLeftIdeal}>
                            <ChevronLeft size={16} />
                          </IconBg>
                          <IconBg onClick={this.handleScrollRightIdeal}>
                            <ChevronRight size={16} />
                          </IconBg>
                        </div>
                      )}
                    </HeaderContent>
                  </HeaderContainer>

                  {!this.state.showMoreIdeal ? (
                    <CarouselContainer>
                      <ScrollContainer ref={this.scrollContainerIdealRef}>
                        {displayGamesIdealJSgaming?.map((game, index) => (
                          <GameCard key={game.id} onClick={() => this.handleGameLaunchJSGames(game)}>
                            <GameImage src={game.game_icon} alt={`Game ${index}`} />
                            <GameOverlay>
                              <PlayIconContainer>
                                <PlayIcon />
                              </PlayIconContainer>
                            </GameOverlay>
                          </GameCard>
                        ))}
                      </ScrollContainer>
                    </CarouselContainer>
                  ) : (
                    <>
                      <GridWrapper>
                        {displayGamesIdealJSgaming?.map((game, index) => (
                          <GameCard key={game.id} onClick={() => this.handleGameLaunchJSGames(game)}>
                            <GameImage src={game.game_icon} alt={`Game ${index}`} />
                            <GameOverlay>
                              <PlayIconContainer>
                                <PlayIcon />
                              </PlayIconContainer>
                            </GameOverlay>
                          </GameCard>
                        ))}
                      </GridWrapper>
                      <PaginationContainer>
                        <PaginationButton
                          onClick={() => this.handlePagination('ideal', 'prev')}
                          disabled={this.state.vendorPagination.ideal.currentPage <= 1 || this.state.vendorPagination.ideal.loading}
                        >
                          <ChevronLeft size={16} /> Previous
                        </PaginationButton>

                        <PaginationInfo>
                          Page {this.state.vendorPagination.ideal.currentPage} of {this.state.vendorPagination.ideal.totalPages}
                        </PaginationInfo>

                        <PaginationButton
                          onClick={() => this.handlePagination('ideal', 'next')}
                          disabled={this.state.vendorPagination.ideal.currentPage >= this.state.vendorPagination.ideal.totalPages || this.state.vendorPagination.ideal.loading}
                        >
                          Next <ChevronRight size={16} />
                        </PaginationButton>

                        {this.state.vendorPagination.ideal.loading && (
                          <StyledSpinner size="sm" />
                        )}
                      </PaginationContainer>
                    </>
                  )}
                </div>
              )}

              {/* Microgaming Games Section */}
              {enabledFeatures.microgaming && (
                <div style={{ marginTop: "6px" }}>
                  <HeaderContainer>
                    <TopTitle>Microgaming</TopTitle>
                    <HeaderContent>
                      <div onClick={() => this.setState({ showMoreMicrogaming: !this.state.showMoreMicrogaming })}>
                        <IconBg>
                          <div style={{ fontWeight: "bold" }}>{this.state.showMoreMicrogaming ? "Show Less" : "Show More"}</div>
                        </IconBg>
                      </div>
                      {!this.state.showMoreMicrogaming && (
                        <div style={{ display: "flex", gap: '4px' }}>
                          <IconBg onClick={this.handleScrollLeftMicrogaming}>
                            <ChevronLeft size={16} />
                          </IconBg>
                          <IconBg onClick={this.handleScrollRightMicrogaming}>
                            <ChevronRight size={16} />
                          </IconBg>
                        </div>
                      )}
                    </HeaderContent>
                  </HeaderContainer>

                  {!this.state.showMoreMicrogaming ? (
                    <CarouselContainer>
                      <ScrollContainer ref={this.scrollContainerMicrogamingRef}>
                        {displayGamesMicrogamingJSgaming?.map((game, index) => (
                          <GameCard key={game.id} onClick={() => this.handleGameLaunchJSGames(game)}>
                            <GameImage src={game.game_icon} alt={`Game ${index}`} />
                            <GameOverlay>
                              <PlayIconContainer>
                                <PlayIcon />
                              </PlayIconContainer>
                            </GameOverlay>
                          </GameCard>
                        ))}
                      </ScrollContainer>
                    </CarouselContainer>
                  ) : (
                    <>
                      <GridWrapper>
                        {displayGamesMicrogamingJSgaming?.map((game, index) => (
                          <GameCard key={game.id} onClick={() => this.handleGameLaunchJSGames(game)}>
                            <GameImage src={game.game_icon} alt={`Game ${index}`} />
                            <GameOverlay>
                              <PlayIconContainer>
                                <PlayIcon />
                              </PlayIconContainer>
                            </GameOverlay>
                          </GameCard>
                        ))}
                      </GridWrapper>
                      <PaginationContainer>
                        <PaginationButton
                          onClick={() => this.handlePagination('microgaming', 'prev')}
                          disabled={this.state.vendorPagination.microgaming.currentPage <= 1 || this.state.vendorPagination.microgaming.loading}
                        >
                          <ChevronLeft size={16} /> Previous
                        </PaginationButton>

                        <PaginationInfo>
                          Page {this.state.vendorPagination.microgaming.currentPage} of {this.state.vendorPagination.microgaming.totalPages}
                        </PaginationInfo>

                        <PaginationButton
                          onClick={() => this.handlePagination('microgaming', 'next')}
                          disabled={this.state.vendorPagination.microgaming.currentPage >= this.state.vendorPagination.microgaming.totalPages || this.state.vendorPagination.microgaming.loading}
                        >
                          Next <ChevronRight size={16} />
                        </PaginationButton>

                        {this.state.vendorPagination.microgaming.loading && (
                          <StyledSpinner size="sm" />
                        )}
                      </PaginationContainer>
                    </>
                  )}
                </div>
              )}


              {/* PGSoft Games Section */}
              {enabledFeatures.Pgsoft && (
                <div style={{ marginTop: "6px" }}>
                  <HeaderContainer>
                    <TopTitle>PGSoft</TopTitle>
                    <HeaderContent>
                      <div onClick={() => this.setState({ showMorePgsoft: !this.state.showMorePgsoft })}>
                        <IconBg>
                          <div style={{ fontWeight: "bold" }}>{this.state.showMorePgsoft ? "Show Less" : "Show More"}</div>
                        </IconBg>
                      </div>
                      {!this.state.showMorePgsoft && (
                        <div style={{ display: "flex", gap: '4px' }}>
                          <IconBg onClick={this.handleScrollLeftPgsoft}>
                            <ChevronLeft size={16} />
                          </IconBg>
                          <IconBg onClick={this.handleScrollRightPgsoft}>
                            <ChevronRight size={16} />
                          </IconBg>
                        </div>
                      )}
                    </HeaderContent>
                  </HeaderContainer>

                  {!this.state.showMorePgsoft ? (
                    <CarouselContainer>
                      <ScrollContainer ref={this.scrollContainerPgsoftRef}>
                        {displayGamesPgsoftJSgaming?.map((game, index) => (
                          <GameCard key={game.id} onClick={() => this.handleGameLaunchJSGames(game)}>
                            <GameImage src={game.game_icon} alt={`Game ${index}`} />
                            <GameOverlay>
                              <PlayIconContainer>
                                <PlayIcon />
                              </PlayIconContainer>
                            </GameOverlay>
                          </GameCard>
                        ))}
                      </ScrollContainer>
                    </CarouselContainer>
                  ) : (
                    <>
                      <GridWrapper>
                        {displayGamesPgsoftJSgaming?.map((game, index) => (
                          <GameCard key={game.id} onClick={() => this.handleGameLaunchJSGames(game)}>
                            <GameImage src={game.game_icon} alt={`Game ${index}`} />
                            <GameOverlay>
                              <PlayIconContainer>
                                <PlayIcon />
                              </PlayIconContainer>
                            </GameOverlay>
                          </GameCard>
                        ))}
                      </GridWrapper>
                      <PaginationContainer>
                        <PaginationButton
                          onClick={() => this.handlePagination('pgsoft', 'prev')}
                          disabled={this.state.vendorPagination.pgsoft.currentPage <= 1 || this.state.vendorPagination.pgsoft.loading}
                        >
                          <ChevronLeft size={16} /> Previous
                        </PaginationButton>

                        <PaginationInfo>
                          Page {this.state.vendorPagination.pgsoft.currentPage} of {this.state.vendorPagination.pgsoft.totalPages}
                        </PaginationInfo>

                        <PaginationButton
                          onClick={() => this.handlePagination('pgsoft', 'next')}
                          disabled={this.state.vendorPagination.pgsoft.currentPage >= this.state.vendorPagination.pgsoft.totalPages || this.state.vendorPagination.pgsoft.loading}
                        >
                          Next <ChevronRight size={16} />
                        </PaginationButton>

                        {this.state.vendorPagination.pgsoft.loading && (
                          <StyledSpinner size="sm" />
                        )}
                      </PaginationContainer>
                    </>
                  )}
                </div>
              )}
              {enabledFeatures.Hacksaw && (
                <div style={{ marginTop: "6px" }}>
                  <HeaderContainer>
                    <TopTitle>HackSaw</TopTitle>
                    <HeaderContent>
                      <div onClick={() => this.setState({ showMoreHackSaw: !this.state.showMoreHackSaw })}>
                        <IconBg>
                          <div style={{ fontWeight: "bold" }}>{this.state.showMoreHackSaw ? "Show Less" : "Show More"}</div>
                        </IconBg>
                      </div>
                      {!this.state.showMoreHackSaw && (
                        <div style={{ display: "flex", gap: '4px' }}>
                          <IconBg onClick={this.handleScrollLeftHackSaw}>
                            <ChevronLeft size={16} />
                          </IconBg>
                          <IconBg onClick={this.handleScrollRightHackSaw}>
                            <ChevronRight size={16} />
                          </IconBg>
                        </div>
                      )}
                    </HeaderContent>
                  </HeaderContainer>

                  {!this.state.showMoreHackSaw ? (
                    <CarouselContainer>
                      <ScrollContainer ref={this.scrollContainerHackSawRef}>
                        {displayGamesHackSawJSgaming?.map((game, index) => (
                          <GameCard key={game.id} onClick={() => this.handleGameLaunchJSGames(game)}>
                            <GameImage src={game.game_icon} alt={`Game ${index}`} />
                            <GameOverlay>
                              <PlayIconContainer>
                                <PlayIcon />
                              </PlayIconContainer>
                            </GameOverlay>
                          </GameCard>
                        ))}
                      </ScrollContainer>
                    </CarouselContainer>
                  ) : (
                    <>
                      <GridWrapper>
                        {displayGamesHackSawJSgaming?.map((game, index) => (
                          <GameCard key={game.id} onClick={() => this.handleGameLaunchJSGames(game)}>
                            <GameImage src={game.game_icon} alt={`Game ${index}`} />
                            <GameOverlay>
                              <PlayIconContainer>
                                <PlayIcon />
                              </PlayIconContainer>
                            </GameOverlay>
                          </GameCard>
                        ))}
                      </GridWrapper>
                      <PaginationContainer>
                        <PaginationButton
                          onClick={() => this.handlePagination('hacksaw', 'prev')}
                          disabled={this.state.vendorPagination.hacksaw.currentPage <= 1 || this.state.vendorPagination.hacksaw.loading}
                        >
                          <ChevronLeft size={16} /> Previous
                        </PaginationButton>

                        <PaginationInfo>
                          Page {this.state.vendorPagination.hacksaw.currentPage} of {this.state.vendorPagination.hacksaw.totalPages}
                        </PaginationInfo>

                        <PaginationButton
                          onClick={() => this.handlePagination('hacksaw', 'next')}
                          disabled={this.state.vendorPagination.hacksaw.currentPage >= this.state.vendorPagination.hacksaw.totalPages || this.state.vendorPagination.hacksaw.loading}
                        >
                          Next <ChevronRight size={16} />
                        </PaginationButton>

                        {this.state.vendorPagination.hacksaw.loading && (
                          <StyledSpinner size="sm" />
                        )}
                      </PaginationContainer>
                    </>
                  )}
                </div>
              )}
              {enabledFeatures.bgaming && (
                <div style={{ marginTop: "6px" }}>
                  <HeaderContainer>
                    <TopTitle>B Gaming</TopTitle>
                    <HeaderContent>
                      <div onClick={() => this.setState({ showMoreJsBgaming: !this.state.showMoreJsBgaming })}>
                        <IconBg>
                          <div style={{ fontWeight: "bold" }}>{this.state.showMoreJsBgaming ? "Show Less" : "Show More"}</div>
                        </IconBg>
                      </div>
                      {!this.state.showMoreJsBgaming && (
                        <div style={{ display: "flex", gap: '4px' }}>
                          <IconBg onClick={this.handleScrollLeftJSBgaming}>
                            <ChevronLeft size={16} />
                          </IconBg>
                          <IconBg onClick={this.handleScrollRightJSBgaming}>
                            <ChevronRight size={16} />
                          </IconBg>
                        </div>
                      )}
                    </HeaderContent>
                  </HeaderContainer>

                  {!this.state.showMoreJsBgaming ? (
                    <CarouselContainer>
                      <ScrollContainer ref={this.scrollContainerJsBgamingRef}>
                        {displayGamesBgamingJSgaming?.map((game, index) => (
                          <GameCard key={game.id} onClick={() => this.handleGameLaunchJSGames(game)}>
                            <GameImage src={game.game_icon} alt={`Game ${index}`} />
                            <GameOverlay>
                              <PlayIconContainer>
                                <PlayIcon />
                              </PlayIconContainer>
                            </GameOverlay>
                          </GameCard>
                        ))}
                      </ScrollContainer>
                    </CarouselContainer>
                  ) : (
                    <>
                      <GridWrapper>
                        {displayGamesBgamingJSgaming?.map((game, index) => (
                          <GameCard key={game.id} onClick={() => this.handleGameLaunchJSGames(game)}>
                            <GameImage src={game.game_icon} alt={`Game ${index}`} />
                            <GameOverlay>
                              <PlayIconContainer>
                                <PlayIcon />
                              </PlayIconContainer>
                            </GameOverlay>
                          </GameCard>
                        ))}
                      </GridWrapper>
                      <PaginationContainer>
                        <PaginationButton
                          onClick={() => this.handlePagination('bgaming', 'prev')}
                          disabled={this.state.vendorPagination.bgaming.currentPage <= 1 || this.state.vendorPagination.bgaming.loading}
                        >
                          <ChevronLeft size={16} /> Previous
                        </PaginationButton>

                        <PaginationInfo>
                          Page {this.state.vendorPagination.bgaming.currentPage} of {this.state.vendorPagination.bgaming.totalPages}
                        </PaginationInfo>

                        <PaginationButton
                          onClick={() => this.handlePagination('bgaming', 'next')}
                          disabled={this.state.vendorPagination.bgaming.currentPage >= this.state.vendorPagination.bgaming.totalPages || this.state.vendorPagination.bgaming.loading}
                        >
                          Next <ChevronRight size={16} />
                        </PaginationButton>

                        {this.state.vendorPagination.bgaming.loading && (
                          <Spinner size="sm" />
                        )}
                      </PaginationContainer>
                    </>
                  )}
                </div>
              )}
              {enabledFeatures.jili && (
                <div style={{ marginTop: "6px" }}>
                  <HeaderContainer>
                    <TopTitle>Jili</TopTitle>
                    <HeaderContent>
                      <div onClick={() => this.setState({ showMoreJsJili: !this.state.showMoreJsJili })}>
                        <IconBg>
                          <div style={{ fontWeight: "bold" }}>{this.state.showMoreJsJili ? "Show Less" : "Show More"}</div>
                        </IconBg>
                      </div>
                      {!this.state.showMoreJsJili && (
                        <div style={{ display: "flex", gap: '4px' }}>
                          <IconBg onClick={this.handleScrollLeftJsJili}>
                            <ChevronLeft size={16} />
                          </IconBg>
                          <IconBg onClick={this.handleScrollRightJsJili}>
                            <ChevronRight size={16} />
                          </IconBg>
                        </div>
                      )}
                    </HeaderContent>
                  </HeaderContainer>

                  {!this.state.showMoreJsJili ? (
                    <CarouselContainer>
                      <ScrollContainer ref={this.scrollContainerJsJiliRef}>
                        {displayGamesJiliJSgaming?.map((game, index) => (
                          <GameCard key={game.id} onClick={() => this.handleGameLaunchJSGames(game)}>
                            <GameImage src={game.game_icon} alt={`Game ${index}`} />
                            <GameOverlay>
                              <PlayIconContainer>
                                <PlayIcon />
                              </PlayIconContainer>
                            </GameOverlay>
                          </GameCard>
                        ))}
                      </ScrollContainer>
                    </CarouselContainer>
                  ) : (
                    <>
                      <GridWrapper>
                        {displayGamesJiliJSgaming?.map((game, index) => (
                          <GameCard key={game.id} onClick={() => this.handleGameLaunchJSGames(game)}>
                            <GameImage src={game.game_icon} alt={`Game ${index}`} />
                            <GameOverlay>
                              <PlayIconContainer>
                                <PlayIcon />
                              </PlayIconContainer>
                            </GameOverlay>
                          </GameCard>
                        ))}
                      </GridWrapper>
                      <PaginationContainer>
                        <PaginationButton
                          onClick={() => this.handlePagination('jili', 'prev')}
                          disabled={this.state.vendorPagination.jili.currentPage <= 1 || this.state.vendorPagination.jili.loading}
                        >
                          <ChevronLeft size={16} /> Previous
                        </PaginationButton>

                        <PaginationInfo>
                          Page {this.state.vendorPagination.jili.currentPage} of {this.state.vendorPagination.jili.totalPages}
                        </PaginationInfo>

                        <PaginationButton
                          onClick={() => this.handlePagination('jili', 'next')}
                          disabled={this.state.vendorPagination.jili.currentPage >= this.state.vendorPagination.jili.totalPages || this.state.vendorPagination.jili.loading}
                        >
                          Next <ChevronRight size={16} />
                        </PaginationButton>

                        {this.state.vendorPagination.jili.loading && (
                          <StyledSpinner size="sm" />
                        )}
                      </PaginationContainer>
                    </>
                  )}
                </div>
              )}

              {/* Netent Section */}
              {enabledFeatures.netent && (
                <div style={{ marginTop: "6px" }}>
                  <HeaderContainer>
                    <TopTitle>Netent</TopTitle>
                    <HeaderContent>
                      <div onClick={() => this.setState({ showMoreJsNetent: !this.state.showMoreJsNetent })}>
                        <IconBg>
                          <div style={{ fontWeight: "bold" }}>{this.state.showMoreJsNetent ? "Show Less" : "Show More"}</div>
                        </IconBg>
                      </div>
                      {!this.state.showMoreJsNetent && (
                        <div style={{ display: "flex", gap: '4px' }}>
                          <IconBg onClick={this.handleScrollLeftJsNetent}>
                            <ChevronLeft size={16} />
                          </IconBg>
                          <IconBg onClick={this.handleScrollRightJsNetent}>
                            <ChevronRight size={16} />
                          </IconBg>
                        </div>
                      )}
                    </HeaderContent>
                  </HeaderContainer>

                  {!this.state.showMoreJsNetent ? (
                    <CarouselContainer>
                      <ScrollContainer ref={this.scrollContainerJsNetentRef}>
                        {displayGamesNetentJSgaming?.map((game, index) => (
                          <GameCard key={game.id} onClick={() => this.handleGameLaunchJSGames(game)}>
                            <GameImage src={game.game_icon} alt={`Game ${index}`} />
                            <GameOverlay>
                              <PlayIconContainer>
                                <PlayIcon />
                              </PlayIconContainer>
                            </GameOverlay>
                          </GameCard>
                        ))}
                      </ScrollContainer>
                    </CarouselContainer>
                  ) : (
                    <>
                      <GridWrapper>
                        {displayGamesNetentJSgaming?.map((game, index) => (
                          <GameCard key={game.id} onClick={() => this.handleGameLaunchJSGames(game)}>
                            <GameImage src={game.game_icon} alt={`Game ${index}`} />
                            <GameOverlay>
                              <PlayIconContainer>
                                <PlayIcon />
                              </PlayIconContainer>
                            </GameOverlay>
                          </GameCard>
                        ))}
                      </GridWrapper>
                      <PaginationContainer>
                        <PaginationButton
                          onClick={() => this.handlePagination('netent', 'prev')}
                          disabled={this.state.vendorPagination.netent.currentPage <= 1 || this.state.vendorPagination.netent.loading}
                        >
                          <ChevronLeft size={16} /> Previous
                        </PaginationButton>

                        <PaginationInfo>
                          Page {this.state.vendorPagination.netent.currentPage} of {this.state.vendorPagination.netent.totalPages}
                        </PaginationInfo>

                        <PaginationButton
                          onClick={() => this.handlePagination('netent', 'next')}
                          disabled={this.state.vendorPagination.netent.currentPage >= this.state.vendorPagination.netent.totalPages || this.state.vendorPagination.netent.loading}
                        >
                          Next <ChevronRight size={16} />
                        </PaginationButton>

                        {this.state.vendorPagination.netent.loading && (
                          <StyledSpinner size="sm" />
                        )}
                      </PaginationContainer>
                    </>
                  )}
                </div>
              )}

              {enabledFeatures.bjboriginal && (
                <Games currentPage="home" t={t} />
              )}
              {/* <div style={{ marginTop: "6px" }}>
                <HeaderContainer>
                  <TopTitle>BGaming</TopTitle>
                  <HeaderContent>
                    <div onClick={() => this.setState({ showMoreJsBgaming: !this.state.showMoreJsBgaming })}>
                      <IconBg>
                        <div style={{ fontWeight: "bold" }}>{this.state.showMoreJsBgaming ? "Show Less" : "Show More"}</div>
                      </IconBg>
                    </div>
                    {!this.state.showMoreJsBgaming && (
                      <div style={{ display: "flex", gap: '4px' }}>
                        <IconBg onClick={this.handleScrollLeftJSBgaming}>
                          <ChevronLeft size={16} />
                        </IconBg>
                        <IconBg onClick={this.handleScrollRightJSBgaming}>
                          <ChevronRight size={16} />
                        </IconBg>
                      </div>
                    )}
                  </HeaderContent>
                </HeaderContainer>

                {!this.state.showMoreJsBgaming ? (
                  <CarouselContainer>
                    <ScrollContainer ref={this.scrollContainerJsBgamingRef}>
                      {displayGamesBgamingJSgaming?.map((game, index) => (
                        <GameCard key={game.id} onClick={() => this.handleGameLaunchJSGames(game)}>
                          <GameImage src={game.game_icon} alt={`Game ${index}`} />
                          <GameOverlay>
                            <PlayIconContainer>
                              <PlayIcon />
                            </PlayIconContainer>
                          </GameOverlay>
                        </GameCard>
                      ))}
                    </ScrollContainer>
                  </CarouselContainer>
                ) : (
                  <>
                    <GridWrapper>
                      {displayGamesBgamingJSgaming?.map((game, index) => (
                        <GameCard key={game.id} onClick={() => this.handleGameLaunchJSGames(game)}>
                          <GameImage src={game.game_icon} alt={`Game ${index}`} />
                          <GameOverlay>
                            <PlayIconContainer>
                              <PlayIcon />
                            </PlayIconContainer>
                          </GameOverlay>
                        </GameCard>
                      ))}
                    </GridWrapper>
                    <PaginationContainer>
                      <PaginationButton
                        onClick={() => this.handlePagination('netent', 'prev')}
                        disabled={this.state.vendorPagination.bgaming.currentPage <= 1 || this.state.vendorPagination.bgaming.loading}
                      >
                        <ChevronLeft size={16} /> Previous
                      </PaginationButton>

                      <PaginationInfo>
                        Page {this.state.vendorPagination.bgaming.currentPage} of {this.state.vendorPagination.bgaming.totalPages}
                      </PaginationInfo>

                      <PaginationButton
                        onClick={() => this.handlePagination('netent', 'next')}
                        disabled={this.state.vendorPagination.bgaming.currentPage >= this.state.vendorPagination.bgaming.totalPages || this.state.vendorPagination.bgaming.loading}
                      >
                        Next <ChevronRight size={16} />
                      </PaginationButton>

                      {this.state.vendorPagination.bgaming.loading && (
                        <StyledSpinner size="sm" />
                      )}
                    </PaginationContainer>
                  </>
                )}
              </div> */}

            </div>
          </>
        }


        <CasinoLeaderboard />

        {/* Loader */}
        {loading && (
          <div className="d-flex justify-content-center align-items-center" style={{ position: 'fixed', top: '50%', left: '50%', transform: 'translate(-50%, -50%)', zIndex: 9999 }}>
            <Spinner animation="border" role="status">
              <span className="sr-only">Loading...</span>
            </Spinner>
          </div>
        )}

        {/* Snackbar */}
        {message && (
          <Alert variant={message.type === 'error' ? 'danger' : 'success'} style={{ position: 'fixed', bottom: 20, left: '50%', transform: 'translateX(-50%)', zIndex: 9999 }}>
            {message.text}
          </Alert>
        )}

      </>
    );
  }
}

function HomeWithContext(props) {


  const finalState = useSelector((state) => state.finalState.finalState);

  // Log finalState to the console
  // console.log('finalState in HomeWithContext:', finalState);

  // Pass finalState as a prop to the Home component if needed
  return <Home {...props} finalState={finalState} />;
}

export default withCookies(HomeWithContext);

