

import React, { useState, useEffect, useRef } from 'react';
import styled from 'styled-components';

import { 
    Play, 
    RefreshCw, 
    Flag, 
    Info,
    ChevronRight,
    Star
} from 'lucide-react';
import { useHistory } from 'react-router-dom';
import { useBetting } from '../../../../../../../context/BettingContext';
import { bannerImage } from '../../../../../../../utils/constants';
import BookmakerMarket from './BookMaker';
import InPlayBet from './InPlayBet';
import FancyBet from './FancyBet';
import videojs from "video.js";
import "video.js/dist/video-js.css";

// Styled Components
const Container = styled.div`
  width: 100%;
  background: #f5f5f5;
`;

const Header = styled.div`
  background: #2c3e50;
  position: relative;
  width: 100%;
  height: 200px;
  overflow: hidden;
 
  box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
`;

const BannerImage = styled.img`
  width: 100%;
  height: 100%;
  object-fit: cover;
  object-position: center;
  transition: transform 0.5s ease;
  
  &:hover {
    transform: scale(1.05);
  }

`;



const BannerOverlay = styled.div`
  position: absolute;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background: linear-gradient(
    rgba(0, 0, 0, 0.3),
    rgba(0, 0, 0, 0.1)
  );
  pointer-events: none;
`;


const Container1 = styled.div`
  width: 100%;

 min-height:100vh;
 overflow-y:auto;
`;

const Header1 = styled.div`
  background: yellow;
  color: white;
  padding: 10px;
  font-size: 18px;
  height: 200px;
  display: flex;
  justify-content: space-between;
  align-items: center;
`;

const Content = styled.div`
  background: white;
`;

const Match = styled.div`
  display: flex;
  justify-content: space-between;
  align-items: center;
  padding: 10px;
  border-bottom: 1px solid #eee;
`;

const MatchInfo = styled.div`
  flex: 1;
`;

const MatchTitle = styled.div`
  color: #3498db;
  font-weight: bold;
  margin-bottom: 5px;
  cursor: pointer;
  display: inline-block;
  
  &:hover {
    text-decoration: underline;
    color: #2980b9;
  }
`;

const Status = styled.span`
  color: #27ae60;
  font-size: 14px;
`;

const OddsContainer = styled.div`
  display: flex;
  gap: 10px;
`;

const OddsSection = styled.div`
  display: flex;
  gap: 2px;
`;

const OddsBox = styled.div`
  background: ${props => props.blue ? '#72BBEF' : '#FFB6C1'};
  padding: 10px;
  min-width: 60px;
  text-align: center;
  border-radius: 4px;
  cursor: ${props => props.suspended ? 'not-allowed' : 'pointer'};
  color: ${props => props.suspended ? '#e74c3c' : 'black'} !important;
  opacity: ${props => props.suspended ? 0.7 : 1};
  transition: all 0.2s ease;

  &:hover {
    opacity: ${props => props.suspended ? 0.7 : 0.8};
  }
`;


const FrameContainer = styled.div`
  width: 100%;
  display: block;
  // position: relative;
  min-height: 169px;
`;

const ScoreContainer = styled.div`
  width: 100%;
  overflow: hidden;
  background: #000;
  // border-radius: 8px 8px 0 0;
  min-height: 169px;
`;

const ScoreHeader = styled.div`
  width: 100%;
  background: #000;
  // border-radius: 6px 6px 0 0;
  // padding: 12px;
`;

const ScoreFrame = styled.iframe`
  width: 100%;
  height: 100%;
  min-height: 169px;
  border: none;
  display: block;
`;

const StreamContainer = styled.div`
  width: 100%;
  margin-bottom: 24px;
`;

const StreamWrapper = styled.div`
  width: 100%;
  height: 169px;
  background: #f1f1f1;
  // border-radius: 8px;
  overflow: hidden;
  box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
`;

const StreamFrame = styled.iframe`
  width: 100%;
  height: 100%;
  border: none;
  display: block;
`;

const LiveScoreFrame = ({ eventId }) => (
  <ScoreContainer>
    <ScoreHeader />
    <ScoreFrame 
      src={`https://score.akamaized.uk/?id=${eventId}`}
      title="Live Score"
    />
  </ScoreContainer>
);

const LiveStreamFrame = ({ eventId }) => (
  <StreamContainer>
    <StreamWrapper>
      <StreamFrame
        src={`https://livestream-v3-iframe.akamaized.uk/?eventid=${eventId}`}
        title="Live Stream"
        allowFullScreen
      />
    </StreamWrapper>
  </StreamContainer>
);
const MiddleDetailBettingUi = ({ matchData }) => {
  const { addBet } = useBetting();
  const history = useHistory();
  const [bookmakerData, setBookmakerData] = useState([]);
  const [fancyData, setFancyData] = useState([]);
  const isMounted = useRef(true);
  const intervalRef = useRef(null);

  const fetchBookmakerFancy = async () => {
    if (!matchData?.eventId || !isMounted.current) return;
    
    try {
   const token = localStorage.getItem('token');
const response = await fetch(`https://api.boss707.com/sports/bookmakerFancy?eventid=${matchData.eventId}`, {
  headers: {
    'Authorization': `Bearer ${token}`,
    'Content-Type': 'application/json'
  }
});
      const data = await response.json();
      
      if (isMounted.current) {
        setBookmakerData(data.bookMaker || []);
        setFancyData(data.fancy || []);
      }
    } catch (error) {
      console.error('Error fetching bookmaker/fancy data:', error);
      if (isMounted.current) {
        setBookmakerData([]);
        setFancyData([]);
      }
    }
  };

  useEffect(() => {
    isMounted.current = true;

    if (matchData?.eventId) {
      fetchBookmakerFancy();
      intervalRef.current = setInterval(fetchBookmakerFancy, 5000);
    }

    return () => {
      isMounted.current = false;
      if (intervalRef.current) {
        clearInterval(intervalRef.current);
        intervalRef.current = null;
      }
    };
  }, [matchData?.eventId]);

  if (!matchData) {
    return null;
  }

  return (
  <>
    {/* {matchData?.eventId && <LiveStreamFrame eventId={matchData.eventId} />} */}
    {/* {matchData?.eventId &&   <FrameContainer> <LiveStreamFrame eventId={matchData.eventId} />  </FrameContainer>} */}
    {matchData?.eventId &&   <FrameContainer> <LiveScoreFrame eventId={matchData.eventId} />  </FrameContainer>}
    <InPlayBet matchData={matchData} />
    {bookmakerData.length > 0 && <BookmakerMarket  matchData={matchData} 
    bookmakerData={bookmakerData}  />}
    {fancyData.length > 0 && <FancyBet matchData={matchData} 
    fancyData={fancyData} />}
    </>

  );
};

export default MiddleDetailBettingUi;