


///newwer
import React, { useEffect, useState, useRef } from 'react';
import styled from 'styled-components';
import { useBetting } from '../../../../../context/BettingContext';
import {
  Play,
  RefreshCw,
  Flag,
  Info,
  ChevronRight,
  Star
} from 'lucide-react';
import { useHistory } from 'react-router-dom';
import LoadingSpinner from '../Loader';
import { SPORT_ID_MAP } from './CricketBetUi/SideMenu';
import { height, width } from '@mui/system';

// Styled Components
const Container = styled.div`
  width: 100%;
  background: #000000;
  font-family: 'Montserrat Alternates', sans-serif;
  height: 100%;
  display: flex;
  flex-direction: column;
  position: relative;
  overflow: hidden; /* Prevent double scrollbars */
`;

const Content = styled.div`
  background: #000000;
  flex: 1;
  overflow-y: auto;
  margin-bottom:100px;
  height: calc(100vh - 20px); /* Adjust based on your header height */
  -webkit-overflow-scrolling: touch; /* Smooth scrolling on iOS */

  /* Scrollbar styling */
  &::-webkit-scrollbar {
    width: 8px;
  }

  &::-webkit-scrollbar-track {
    background: rgb(50, 55, 56);
  }

  &::-webkit-scrollbar-thumb {
    background: rgb(240, 156, 6);
    border-radius: 4px;
  }

  &::-webkit-scrollbar-thumb:hover {
    background: rgb(220, 136, 6);
  }
`;
const Match = styled.div`
  display: flex;
  justify-content: space-between;
  align-items: center;
  padding: 4px 10px;
  border-bottom: 1px solid rgb(50, 55, 56);
  background: #000000;
`;



const MatchInfo = styled.div`
  flex: 1;
`;

const MatchTitle = styled.div`
  color: #ffffff;
  font-weight: bold;
  // margin-bottom: 5px;
  font-size: 10px;
  font-family: 'Montserrat Alternates', sans-serif;
`;

const MatchTitle1 = styled.div`
  color: #ffffff;
  font-weight: bold;
  margin-bottom: -5px;
  font-size: 11px;
  font-family: 'Montserrat Alternates', sans-serif;
`;


const Status = styled.span`
  color: rgb(240, 156, 6);
  font-size: 12px;
  margin-left: 14px;
  font-weight:bold;
  // margin-bottom: -5px;
   
  font-family: 'Montserrat Alternates', sans-serif;
`;

const NoStatus = styled.span`
  color: #cccccc;
  font-size: 10px;
  margin-left: 14px;
  // margin-bottom: -5px;
 
  font-family: 'Montserrat Alternates', sans-serif;
`;

const OddsContainer = styled.div`
  display: flex;
  align-items: stretch;
  gap: 10px;
  min-width: 420px;
`;

const OddsSection = styled.div`
  display: flex;
  gap: 2px;
  min-width: 90px;
`;

const OddsBox = styled.div`
  background: ${props => props.blue ? '#72BBEF' : '#FFB6C1'};
  padding: 6px 8px;
  min-width: 60px;
  text-align: center;
  border-radius: 6px;
  font-weight: bold;
  line-height: 1;
  cursor: ${props => props.suspended ? 'not-allowed' : 'pointer'};
  color: ${props => props.suspended ? '#e74c3c' : 'black'} !important;
  opacity: ${props => props.suspended ? 0.7 : 1};
  transition: all 0.2s ease;

  &:hover {
    opacity: ${props => props.suspended ? 0.7 : 0.85};
  }
`;

const IconGroup = styled.div`
  display: flex;
  gap: 2px;
  margin-bottom: -5px;
`;

const Icon = styled.span`
  background: #2ecc71;
  color: white;
  padding: 2px 6px;
  border-radius: 4px;
  font-size: 12px;
`;

const PTE = styled.div`
  color: #ffffff;
  margin-right: 10px;
  font-size: 14px;
  font-family: 'Montserrat Alternates', sans-serif;
  min-width: 120px;
  text-align: right;
`;

const LiveDot = styled.span`
  display: inline-block;
  width: 8px;
  height: 8px;
    margin-bottom:-5px;
  background-color: #2ecc71;
  border-radius: 50%;
  margin-right: 8px;
  animation: blink 1s ease-in-out infinite;

  @keyframes blink {
    0% {
      opacity: 0;
    }
    50% {
      opacity: 1;
    }
    100% {
      opacity: 0;
    }
  }
`;
const NOLiveDot = styled.span`
  display: inline-block;
  width: 8px;
  height: 8px;
  background-color: #cccccc;
  border-radius: 50%;
  margin-right: 8px;
   margin-bottom:-5px;
`;

const TitleContainer = styled.div`
  display: flex;
  align-items: center;
`;


const CricketBettingUI = (props) => {
  console.log("props", props.tab)
  const { addBet } = useBetting();
  const [isLoading, setIsLoading] = useState(true);
  const [matches, setMatches] = useState([]);
  const fetchSeqRef = useRef(0);
  useEffect(() => {
    const fetchAllMatches = async () => {
      const seq = ++fetchSeqRef.current;
      setIsLoading(true);
      setMatches([]); // clear immediately to avoid stale UI
      try {
        const token = localStorage.getItem('token');

        const collectMarkets = (arr) => Array.isArray(arr)
          ? arr.flatMap(s => s?.markets || [])
          : [];

        const fetchInplayById = async (sportId) => {
          const res = await fetch(`https://api.boss707.com/sports/inplayGameId/${sportId}`, {
            headers: { 'Authorization': `Bearer ${token}`, 'Content-Type': 'application/json' }
          });
          const json = await res.json();
          const games = json?.games || json || [];
          const markets = Array.isArray(games) ? games.flatMap(g => g?.markets || []) : [];
          return markets.map(m => ({ ...m, inplay: true }));
        };

        let rawMarkets = [];
        if (props.upperTab === 'in-play') {
          if (props.tab === 'all-sports') {
            const [inPlayRes, allMatchesRes] = await Promise.all([
              fetch('https://api.boss707.com/sports/allinplay', {
                headers: { 'Authorization': `Bearer ${token}`, 'Content-Type': 'application/json' }
              }),
              fetch('https://api.boss707.com/sports/all-matches', {
                headers: { 'Authorization': `Bearer ${token}`, 'Content-Type': 'application/json' }
              })
            ]);
            const inPlayData = await inPlayRes.json();
            const allMatchesData = await allMatchesRes.json();
            const inPlayMarkets = collectMarkets(inPlayData).map(m => ({ ...m, inplay: true }));
            const allMarkets = collectMarkets(allMatchesData);
            const map = new Map();
            inPlayMarkets.forEach(m => m?.marketId && map.set(m.marketId, m));
            allMarkets.forEach(m => {
              if (m?.marketId && !map.has(m.marketId)) map.set(m.marketId, m);
            });
            rawMarkets = Array.from(map.values());
          } else {
            const sportId = SPORT_ID_MAP[props.tab];
            rawMarkets = sportId ? await fetchInplayById(sportId) : [];
          }
        } else if (props.upperTab === 'today' || props.upperTab === 'tomorrow') {
          const dateEndpoint = props.upperTab === 'today'
            ? 'matches-by-date/today'
            : 'matches-by-date/tomorrow';
          if (props.tab === 'all-sports') {
            const res = await fetch(`https://api.boss707.com/sports/${dateEndpoint}`, {
              headers: { 'Authorization': `Bearer ${token}`, 'Content-Type': 'application/json' }
            });
            const data = await res.json();
            rawMarkets = collectMarkets(data);
          } else {
            const sportId = SPORT_ID_MAP[props.tab];
            if (sportId) {
              const path = props.upperTab === 'today'
                ? `matches/today/${sportId}`
                : `matches/tomorrow/${sportId}`;
              const res = await fetch(`https://api.boss707.com/sports/${path}`, {
                headers: { 'Authorization': `Bearer ${token}`, 'Content-Type': 'application/json' }
              });
              const data = await res.json();
              // handle either array of markets or array of sports with markets
              if (Array.isArray(data)) {
                if (data.length > 0 && data[0]?.markets) {
                  rawMarkets = collectMarkets(data);
                } else {
                  rawMarkets = data;
                }
              } else {
                rawMarkets = collectMarkets(data);
              }
            }
          }
        }

        // guard: if a newer fetch started, ignore
        if (seq !== fetchSeqRef.current) return;

        // Create a Map to store unique matches
        const matchesMap = new Map();

        // Base match object
        const createMatchObject = (match) => ({
          id: match.marketId,
          team1: match.runners?.[0]?.runnerName || '',
          team2: match.runners?.[1]?.runnerName || '',
          status: (() => {
            if (props.upperTab === 'in-play') return 'In-Play';
            const utcDate = new Date(match.marketStartTime);
            return new Intl.DateTimeFormat('en-IN', { hour: '2-digit', minute: '2-digit', hour12: true }).format(utcDate);
          })(),
          isSuspended: match.stopBet,
          inplay: props.upperTab === 'in-play' ? true : Boolean(match.inplay),
          eventId: match.version,
          pte: (() => {
            if (props.upperTab === 'in-play') return 0;
            try {
              return (match.runners || []).reduce((sum, r) => sum + (r.totalMatched || 0), 0);
            } catch {
              return 0;
            }
          })(),
          marketStartTime: match.marketStartTime,
          odds: { one: { back: '--', lay: '--' }, x: { back: '--', lay: '--' }, two: { back: '--', lay: '--' } }
        });

        rawMarkets.forEach(m => m?.marketId && !matchesMap.has(m.marketId) && matchesMap.set(m.marketId, createMatchObject(m)));

        // Updated odds fetching function that also returns totalMatched
        const fetchMatchOdds = async (matchId) => {
          try {
            const token = localStorage.getItem('token');
            const response = await fetch(`https://api.boss707.com/sports/market-odds?market_id=${matchId}`, {
              headers: {
                'Authorization': `Bearer ${token}`,
                'Content-Type': 'application/json'
              }
            });
            const data = await response.json();

            const marketOdds = data[0];
            if (!marketOdds || !marketOdds.runners) return null;

            const runners = marketOdds.runners;
            let formattedOdds = {
              one: { back: '--', lay: '--' },
              x: { back: '--', lay: '--' },
              two: { back: '--', lay: '--' }
            };

            if (runners.length === 2) {
              formattedOdds.one = {
                back: runners[0].ex.availableToBack[0]?.price || '--',
                lay: runners[0].ex.availableToLay[0]?.price || '--'
              };
              formattedOdds.two = {
                back: runners[1].ex.availableToBack[0]?.price || '--',
                lay: runners[1].ex.availableToLay[0]?.price || '--'
              };
            } else if (runners.length === 3) {
              formattedOdds.one = {
                back: runners[0].ex.availableToBack[0]?.price || '--',
                lay: runners[0].ex.availableToLay[0]?.price || '--'
              };
              formattedOdds.x = {
                back: runners[1].ex.availableToBack[0]?.price || '--',
                lay: runners[1].ex.availableToLay[0]?.price || '--'
              };
              formattedOdds.two = {
                back: runners[2].ex.availableToBack[0]?.price || '--',
                lay: runners[2].ex.availableToLay[0]?.price || '--'
              };
            }

            return {
              odds: formattedOdds,
              totalMatched: marketOdds.totalMatched || 0
            };
          } catch (error) {
            console.error('Error fetching odds:', error);
            return null;
          }
        };

        // Fetch odds for all matches and update them in the map for in-play only
        const matchesWithOdds = await Promise.all(
          Array.from(matchesMap.entries()).map(async ([marketId, match]) => {
            if (props.upperTab === 'in-play') {
              const oddsData = await fetchMatchOdds(marketId);
              if (oddsData) {
                match.odds = oddsData.odds;
                match.pte = oddsData.totalMatched; // Update PTE with totalMatched from odds API
              }
            }
            return match;
          })
        );

        // guard: if a newer fetch started, ignore
        if (seq !== fetchSeqRef.current) return;

        // Sort and set the matches
        const sortedMatches = matchesWithOdds.sort((a, b) => {
          if (a.inplay && !b.inplay) return -1;
          if (!a.inplay && b.inplay) return 1;
          return new Date(a.marketStartTime) - new Date(b.marketStartTime);
        });

        setMatches(sortedMatches);
      } catch (error) {
        console.error('Error fetching matches:', error);
      } finally {
        setIsLoading(false);
      }
    };

    fetchAllMatches();
    const interval = setInterval(fetchAllMatches, 30000);
    return () => {
      fetchSeqRef.current += 1; // invalidate any in-flight fetch
      clearInterval(interval);
    };
  }, [props.tab, props.upperTab]);




  const handleOddsClick = (match, category, type, odds) => {
    console.log("consoles", match, category, type, odds)
    if (match.isSuspended || odds === '--' || odds === 'Suspend') return;

    // Determine the selection name based on category
    let selectionName = '';
    if (category === 'matched') {
      selectionName = match.team1;  // First team for matched category
    } else if (category === 'x') {
      selectionName = 'The Draw';   // Draw for x category
    } else if (category === 'two') {
      selectionName = match.team2;  // Second team for two category
    }

    const betDetails = {
      matchId: match.id,
      matchTitle: `${match.team1} v ${match.team2}`,
      team1: match.team1,
      team2: match.team2,
      selectionName: selectionName, // Add selection name
      category,
      type,
      odds,
      isBlue: type === 'back',
      stake: '',
      liability: '0.00'
    };

    console.log('Selected Bet:', betDetails);
    addBet(betDetails);
  };


  const history = useHistory();



  // Option 1: Using window.location.reload()
  const handleMatchClick = (match) => {
    // setMatchClicked(true);
    history.push({
      pathname: `/sports/markets/${match.id}`,
      state: {
        matchData: match
      }
    });
  };





  console.log("matches, ", matches)

  return (
    <Container>


      <Content>
     
        <Match style={{
          backgroundColor: '#2C3E50',
          position: 'sticky',
          top: '0px',
          zIndex: 5,
          marginLeft: "8px",
          marginRight: '8px',
          borderRadius: '5px'
        }}>


          <MatchInfo style={{ flex: 1, }} ></MatchInfo>
          <OddsContainer>
            <OddsSection>
              <div style={{ textAlign: 'left', minWidth: 140, color: 'white', fontWeight: 'bold' }}>Games</div>
            </OddsSection>

            <OddsSection style={{ minWidth: 180 }}>
              <div style={{ textAlign: 'left', width: '100%', color: 'white', fontWeight: 'bold' }}>Matched PTE</div>
            </OddsSection>
            <OddsSection>
              <div style={{ textAlign: 'left', width: '100%', color: 'white', fontWeight: 'bold', marginRight: '130px' }}>1</div>
            </OddsSection>
            <OddsSection>
              <div style={{ textAlign: 'left', width: '100%', color: 'white', fontWeight: 'bold', marginRight: '110px' }}>X</div>
            </OddsSection>
            <OddsSection>
              <div style={{ textAlign: 'center', width: '100%', color: 'white', fontWeight: 'bold' , marginRight: '80px'}}>2</div>
            </OddsSection>
          </OddsContainer>
        </Match>
        {isLoading ? (
          <div style={{ padding: '24px', textAlign: 'center', color: '#fff' }}>Loading...</div>
        ) : matches.length === 0 ? (
          <div style={{ padding: '24px', textAlign: 'center', color: '#fff' }}>No matches found</div>
        ) : null}
        {matches.map((match, index) => (
          <Match key={index}>
            <MatchInfo onClick={() => handleMatchClick(match)}>
              <TitleContainer>
                {match.inplay ? <LiveDot /> : <NOLiveDot />}
                <MatchTitle1>{`${match.team1} v ${match.team2}`}</MatchTitle1>
              </TitleContainer>
              <div style={{ display: 'flex', alignItems: 'center', gap: '4px' }}>
                {match.inplay ? <Status>In-Play</Status> : <NoStatus>{match.status}</NoStatus>}
                <IconGroup>
                  {/* <Icon><Play size={12} /></Icon>
                  <Icon><RefreshCw size={12} /></Icon>
                  <Icon><Flag size={12} /></Icon>
                  <Icon><Info size={12} /></Icon> */}
                  <img src='/assets/images/sports/cricket.png' style={{ width: "45px", height: "15px", objectFit: 'contain' }} />
                  <img src='/assets/images/sports/livestream.png' style={{ width: "15px", height: "15px", objectFit: 'contain' }} />
                  <img src='/assets/images/sports/watch.png' style={{ width: "15px", height: "15px", objectFit: 'contain' }} />
                  <img src='/assets/images/sports/fancy.png' style={{ width: "15px", height: "15px", objectFit: 'contain' }} />
                  <img src='/assets/images/sports/book.png' style={{ width: "15px", height: "15px", objectFit: 'contain' }} />

                </IconGroup>
              </div>
            </MatchInfo>
            <PTE>{match.pte}</PTE>
            <OddsContainer>
              <OddsSection>
                <OddsBox
                  blue
                  suspended={match.isSuspended}
                  onClick={() => handleOddsClick(match, 'matched', 'back', match.odds.one.back)}
                >
                  {match.odds.one.back}
                </OddsBox>
                <OddsBox
                  suspended={match.isSuspended}
                  onClick={() => handleOddsClick(match, 'matched', 'lay', match.odds.one.lay)}
                >
                  {match.odds.one.lay}
                </OddsBox>
              </OddsSection>
              <OddsSection>
                <OddsBox
                  blue
                  suspended={match.isSuspended}
                  onClick={() => handleOddsClick(match, 'x', 'back', match.odds.x.back)}
                >
                  {match.odds.x.back}
                </OddsBox>
                <OddsBox
                  suspended={match.isSuspended}
                  onClick={() => handleOddsClick(match, 'x', 'lay', match.odds.x.lay)}
                >
                  {match.odds.x.lay}
                </OddsBox>
              </OddsSection>
              <OddsSection>
                <OddsBox
                  blue
                  suspended={match.isSuspended}
                  onClick={() => handleOddsClick(match, 'two', 'back', match.odds.two.back)}
                >
                  {match.odds.two.back}
                </OddsBox>
                <OddsBox
                  suspended={match.isSuspended}
                  onClick={() => handleOddsClick(match, 'two', 'lay', match.odds.two.lay)}
                >
                  {match.odds.two.lay}
                </OddsBox>
              </OddsSection>
            </OddsContainer>
          </Match>
        ))}
      </Content>


    </Container>
  );
};

export default CricketBettingUI;