import { Target } from 'lucide-react';
import React, { useState } from 'react';
import styled from 'styled-components';
import { useBetting } from '../../../../../../../context/BettingContext';
import { sendNotfication } from '../../../../../../../Helper';

const Container = styled.div`
  width: 100%;
   font-family: 'Montserrat Alternates', sans-serif;
  background: #000000;
`;

const Header = styled.div`
  display: flex;
  justify-content: space-between;
  align-items: center;
  padding: 8px 12px;
  background: rgb(50, 55, 56);
  color: white;
   font-family: 'Montserrat Alternates', sans-serif;
`;

const HeaderTitle = styled.div`
  display: flex;
  align-items: center;
  gap: 8px;
  color: white;
  font-weight: bold;
  font-size: 10px;
   font-family: 'Montserrat Alternates', sans-serif;
`;

const MatchedInfo = styled.div`
  display: flex;
  align-items: center;
  gap: 8px;
  font-size: 10px;
   font-family: 'Montserrat Alternates', sans-serif;
`;

const InfoIcon = styled.span`
  width: 20px;
  height: 20px;
  border-radius: 50%;
  background: #6E6E6E;
  display: flex;
  align-items: center;
  justify-content: center;
  font-size: 12px;
`;

const ChartIcon = styled.span`
  color: #6E6E6E;
`;

const Table = styled.div`
  width: 100%;
`;

const TableHeader = styled.div`
  display: grid;
  grid-template-columns: 1fr auto auto;
  border-bottom: 1px solid rgb(50, 55, 56);
  // background: rgb(50, 55, 56);
   font-family: 'Montserrat Alternates', sans-serif;
`;

const HeaderCell = styled.div`
  width: 90px;
  padding: 8px;
  display: flex;
  justify-content: center;
  align-items: center;
  font-size: 10px;
  font-weight: bold;
  color: white;
  border-left: 1px solid rgb(50, 55, 56);
   font-family: 'Montserrat Alternates', sans-serif;
  
  &:first-child {
    width: auto;
    border-left: none;
  }
`;

const TableRow = styled.div`
  display: grid;
  grid-template-columns: 1fr auto auto;
  border-bottom: 1px solid rgb(50, 55, 56);
  background: ${props => props.highlight ? '#1a1a1a' : '#000000'};
   font-family: 'Montserrat Alternates', sans-serif;
`;

const TeamCell = styled.div`
  padding: 12px;
  font-size: 11px;
  color: white;
  display: flex;
  align-items: center;
   font-family: 'Montserrat Alternates', sans-serif;
`;

const OddsCell = styled.div`
  width: 90px;
  padding: 8px;
  display: flex;
  flex-direction: column;
  align-items: center;
  background: ${props => {
    if (props.selected) {
      return props.type === 'back' ? '#72BBEF' : '#FFB6C1';
    }
    return props.type === 'back' ? '#72BBEF' : '#FFB6C1';
  }};
  border-left: 1px solid rgb(50, 55, 56);
  cursor: pointer;
   font-family: 'Montserrat Alternates', sans-serif;

  .odds {
    font-weight: bold;
    font-size: 10px;
    color: black;
  }
  
  .volume {
    font-size: 8px;
    color: black;
  }
`;

// New styled components for bet container
const BetContainer = styled.div`
  padding: 2px 10px;
  background: ${props => props.betType === 'back' ? '#1a1a1a' : '#1a1a1a'};
  border-top: 1px solid rgb(50, 55, 56);
  color: white;
   font-family: 'Montserrat Alternates', sans-serif;
`;

const BetInputContainer = styled.div`
  display: flex;
  align-items: stretch;
  height: 40px;
  border: 1px solid rgb(50, 55, 56);
  border-radius: 4px;
  overflow: hidden;
  background: #1a1a1a;
   font-family: 'Montserrat Alternates', sans-serif;
`;

const AdjustButton = styled.div`
  width: 40px;
  border: none;
  background: rgb(50, 55, 56);
  color: white;
  font-size: 18px;
  cursor: pointer;
  display: flex;
  align-items: center;
  justify-content: center;
   font-family: 'Montserrat Alternates', sans-serif;
  
  &:hover {
    background: rgb(60, 65, 66);
  }

  &:active {
    background: rgb(40, 45, 46);
  }
`;

const BetInput = styled.div`
  flex: 1;
  padding: 8px;
  font-size: 16px;
  text-align: center;
  background: #1a1a1a;
  color: white;
  display: flex;
  min-width:100px;
  align-items: center;
  justify-content: center;
  border: 1px solid rgb(50, 55, 56);
   font-family: 'Montserrat Alternates', sans-serif;
`;

const QuickAmounts = styled.div`
  display: grid;
  grid-template-columns: repeat(6, 1fr);
  gap: 2px;
  margin-bottom: 8px;
`;

const QuickAmount = styled.div`
  padding: 4px;
  text-align: center;
  background: #1a1a1a;
  border: 1px solid rgb(50, 55, 56);
  cursor: pointer;
  color: white;
  font-size: 10px;
   font-family: 'Montserrat Alternates', sans-serif;
  
  &:hover {
    background: rgb(50, 55, 56);
  }
`;

const NumberPad = styled.div`
  display: grid;
  grid-template-columns: repeat(7, 1fr);
  grid-template-rows: repeat(2, 1fr);
  gap: 2px;
  width: 100%;
`;

const NumberButton = styled.div`
  padding: 12px;
  text-align: center;
  background: #1a1a1a;
  border: 1px solid rgb(50, 55, 56);
  cursor: pointer;
  color: white;
  font-size: 12px;
  display: flex;
  align-items: center;
  justify-content: center;
   font-family: 'Montserrat Alternates', sans-serif;
  
  &:hover {
    background: rgb(50, 55, 56);
  }
`;

const CrossButton = styled(NumberButton)`
  font-weight: bold;
  font-size: 16px;
`;

const ActionButtons = styled.div`
  display: grid;
  grid-template-columns: 1fr 1fr;
  gap: 5px;
  margin-top: 8px;
`;

const CancelButton = styled.div`
  padding: 10px;
  text-align: center;
  background: #1a1a1a;
  border: 1px solid rgb(50, 55, 56);
  cursor: pointer;
  color: white;
  font-size: 12px;
   font-family: 'Montserrat Alternates', sans-serif;
`;

const PlaceButton = styled.div`
  padding: 10px;
  text-align: center;
  background: rgb(240, 156, 6);
  border: 1px solid rgb(240, 156, 6);
  cursor: pointer;
  color: black;
  font-size: 12px;
  font-weight: bold;
   font-family: 'Montserrat Alternates', sans-serif;
`;

const AcceptOddsContainer = styled.div`
  display: flex;
  align-items: center;
  margin-top: 8px;
  gap: 5px;
  color: white;
  font-size: 10px;
   font-family: 'Montserrat Alternates', sans-serif;
`;

const AcceptOddsCheckbox = styled.input`
  margin: 0;
  cursor: pointer;
`;

const quickAmounts = [100, 1000, 2000, 5000, 50000, 100000];

const InPlayBetMobile = ({data}) => {
  console.log("InPlayBetMobile Data:", data);
  // Update state to handle multiple bets
  const [selectedBets, setSelectedBets] = useState({});
  const [betAmounts, setBetAmounts] = useState({});
  const [acceptAnyOdds, setAcceptAnyOdds] = useState({});
  const { placeBets } = useBetting();

  const handleOddsClick = (team, type, odds, volume) => {
    const betKey = `${team}-${type}`;
    const oppositeType = type === 'back' ? 'lay' : 'back';
    const oppositeKey = `${team}-${oppositeType}`;
    
    setSelectedBets(prev => {
      const newBets = { ...prev };
      
      // If same bet is clicked again, remove it
      if (newBets[betKey]) {
        delete newBets[betKey];
      } else {
        // Remove opposite type bet for same team if exists
        delete newBets[oppositeKey];
        // Add new bet
        newBets[betKey] = { team, type, odds, volume };
      }
      
      return newBets;
    });

    // Initialize bet amount if not exists
    if (!betAmounts[betKey]) {
      setBetAmounts(prev => ({
        ...prev,
        [betKey]: '100'
      }));
    }
  };

  const handleAmountChange = (betKey, amount) => {
    setBetAmounts(prev => ({
      ...prev,
      [betKey]: amount.toString()
    }));
  };

  const handleNumberClick = (betKey, num) => {
    setBetAmounts(prev => {
      const currentAmount = prev[betKey] || '0';
      if (currentAmount === '100' && num !== '00') {
        return { ...prev, [betKey]: num.toString() };
      } else {
        return { ...prev, [betKey]: currentAmount + num.toString() };
      }
    });
  };

  const handleClear = (betKey) => {
    setBetAmounts(prev => ({
      ...prev,
      [betKey]: '0'
    }));
  };

  const adjustBetAmount = (betKey, adjustment) => {
    setBetAmounts(prev => {
      const currentAmount = Number(prev[betKey] || 0);
      const newAmount = Math.max(0, currentAmount + adjustment);
      return {
        ...prev,
        [betKey]: newAmount.toString()
      };
    });
  };

  const handleCancelBet = (betKey) => {
    setSelectedBets(prev => {
      const newBets = { ...prev };
      delete newBets[betKey];
      return newBets;
    });
  };

  const renderBetContainer = (betKey, bet) => (
    <BetContainer key={betKey} betType={bet.type}>
      {/* BetContainer content */}
      <div style={{fontSize: '12px', color: 'white', textAlign: 'right', margin:"1px 6px 1px 0px", fontFamily: 'normal'}}>Min Bet</div>
      <div style={{display: 'flex', gap: '10px', margin: '4px 0px 4px 0px', alignItems: 'center'}}>
      <div style={{marginTop: '-2px', flex: 1}}>
          <BetInput>{bet.odds}</BetInput>

        </div>
        <BetInputContainer>
          <AdjustButton onClick={() => adjustBetAmount(betKey, -10)}>−</AdjustButton>
          <BetInput>{betAmounts[betKey]}</BetInput>
          <AdjustButton onClick={() => adjustBetAmount(betKey, 10)}>+</AdjustButton>
        </BetInputContainer>
      </div>

      <QuickAmounts>
        {quickAmounts.map(amount => (
          <QuickAmount 
            key={amount}
            onClick={() => handleAmountChange(betKey, amount)}
          >
            {amount}
          </QuickAmount>
        ))}
      </QuickAmounts>

      <NumberPad>
        {[1, 2, 3, 4, 5, 6].map((num) => (
          <NumberButton key={num} onClick={() => handleNumberClick(betKey, num)}>
            {num}
          </NumberButton>
        ))}
        <CrossButton onClick={() => handleClear(betKey)}>×</CrossButton>
        {[7, 8, 9, 0, '00'].map((num) => (
          <NumberButton key={num} onClick={() => handleNumberClick(betKey, num)}>
            {num}
          </NumberButton>
        ))}
      </NumberPad>

      <ActionButtons>
        <CancelButton onClick={() => handleCancelBet(betKey)}>
          Cancel
        </CancelButton>
        <PlaceButton
          onClick={async () => {
            const stake = parseFloat(betAmounts[betKey] || '0');
            const oddsNum = parseFloat(bet.odds || '0');
            if (!stake || stake < 4 || !oddsNum || oddsNum <= 1) {
              alert('Enter valid stake (>=4) and odds (>1).');
              sendNotfication('Enter valid stake (>=4) and odds (>1).', 'error', 'bottom-left');
              return;
            }

            const selectionName = bet.team === 'team1'
              ? data.team1
              : bet.team === 'team2'
              ? data.team2
              : 'The Draw';

            const betRow = {
              market: 'MO',
              matchId: data.id,
              matchTitle: `${data.team1} v ${data.team2}`,
              selectionName,
              category: 'x',
              type: bet.type,
              odds: oddsNum,
              stake: stake,
              liability: bet.type === 'lay' ? stake * (oddsNum - 1) : stake,
            };

            const result = await placeBets([betRow]);
            if (result?.confirmed?.length > 0) {
    
              sendNotfication('Bets placed successfully!', 'success', 'bottom-left');
              handleCancelBet(betKey);
            } else {
              sendNotfication(result?.errors?.[0]?.message || 'Bet placement failed', 'error', 'bottom-left');
            }
          }}
        >
          Place Bet
        </PlaceButton>
      </ActionButtons>

      <AcceptOddsContainer>
        <AcceptOddsCheckbox 
          type="checkbox" 
          checked={acceptAnyOdds[betKey] || false}
          onChange={() => setAcceptAnyOdds(prev => ({
            ...prev,
            [betKey]: !prev[betKey]
          }))}
        />
        <span>Accept any odds</span>
      </AcceptOddsContainer>
    </BetContainer>
  );

  return (
    <Container>
      <Header>
      <HeaderTitle>
          <Target size={16} />
          Match Odds
        </HeaderTitle>
        <MatchedInfo>
          Matched
          <span>IR 22,433,508</span>
        </MatchedInfo>
      </Header>
      
      <Table>
        <TableHeader>
          <HeaderCell></HeaderCell>
          <HeaderCell>Back</HeaderCell>
          <HeaderCell>Lay</HeaderCell>
        </TableHeader>

        {/* Team 1 */}
        <TableRow>
          <TeamCell>{data.team1}</TeamCell>
          <OddsCell 
            type="back" 
      onClick={() => handleOddsClick('team1', 'back', '2.1', '216')}

            selected={selectedBets['team1-back']}
          >
            <span className="odds">{data.odds.one.back}</span>
            <span className="volume">216</span>
          </OddsCell>
          <OddsCell 
            type="lay"
            onClick={() => handleOddsClick("team2", 'lay', "1.6", '209')}
            selected={selectedBets['team1-lay']}
          >
            <span className="odds">{data.odds.one.lay}</span>
            <span className="volume">209</span>
          </OddsCell>
        </TableRow>
        {Object.entries(selectedBets)
          .filter(([key]) => key.startsWith('team1'))
          .map(([betKey, bet]) => renderBetContainer(betKey, bet))}

        {/* Team 2 */}
        <TableRow>
          <TeamCell>{data.team2}</TeamCell>
          <OddsCell 
            type="back"
              onClick={() => handleOddsClick('team2', 'back', '1.8', '216')}
            selected={selectedBets['team2-back']}
          >
            <span className="odds">{data.odds.two.back}</span>
            <span className="volume">234</span>
          </OddsCell>
          <OddsCell 
            type="lay"
            onClick={() => handleOddsClick('team2', 'lay', '2.1', '216')}
            selected={selectedBets['team2-lay']}
          >
            <span className="odds">{data.odds.two.lay}</span>
            <span className="volume">543</span>
          </OddsCell>
        </TableRow>
        {Object.entries(selectedBets)
          .filter(([key]) => key.startsWith('team2'))
          .map(([betKey, bet]) => renderBetContainer(betKey, bet))}

        {/* Draw */}
        <TableRow>
          <TeamCell>The Draw</TeamCell>
          <OddsCell 
            type="back"
            onClick={() => handleOddsClick('draw', 'back', data.odds.x.back, '209')}
            selected={selectedBets['draw-back']}
          >
            <span className="odds">{data.odds.x.back}</span>
            <span className="volume">{data.odds.x.lay}</span>
          </OddsCell>
          <OddsCell 
            type="lay"
            onClick={() => handleOddsClick('draw', 'lay', data.odds.x.lay, '2.9')}
            selected={selectedBets['draw-lay']}
          >
            <span className="odds">{data.odds.x.lay}</span>
            <span className="volume">{data.odds.x.lay}</span>
          </OddsCell>
        </TableRow>
        {Object.entries(selectedBets)
          .filter(([key]) => key.startsWith('draw'))
          .map(([betKey, bet]) => renderBetContainer(betKey, bet))}
      </Table>
    </Container>
  );
};

export default InPlayBetMobile;