import React from 'react';
import styled from 'styled-components';

const StyledSVG = styled.svg`
  width: ${props => props.size || '25px'};
  height: ${props => props.size || '25px'};
  flex-none: 1;
  fill: white;
`;

const Path1 = styled.path`
  d: path("M18.1681 13.8548H26.9489C27.4334 13.8548 27.8272 14.2476 27.8272 14.7331V14.8706C27.8272 15.3551 27.4344 15.7488 26.9489 15.7488H18.1681C17.6836 15.7488 17.2898 15.356 17.2898 14.8706V14.7331C17.2898 14.2486 17.6827 13.8548 18.1681 13.8548ZM18.1681 5.33398H26.9489C27.4334 5.33398 27.8272 5.72682 27.8272 6.21226V6.34975C27.8272 6.83425 27.4344 7.22802 26.9489 7.22802H18.1681C17.6836 7.22802 17.2898 6.83518 17.2898 6.34975V6.21226C17.2898 5.72776 17.6827 5.33398 18.1681 5.33398ZM4.99682 13.8548H13.7777C14.2622 13.8548 14.6559 14.2476 14.6559 14.7331V14.8706C14.6559 15.3551 14.2631 15.7488 13.7777 15.7488H4.99682C4.51232 15.7488 4.11855 15.356 4.11855 14.8706V14.7331C4.11855 14.2486 4.51138 13.8548 4.99682 13.8548ZM18.1681 11.0152H26.9489C27.4334 11.0152 27.8272 11.408 27.8272 11.8934V12.0309C27.8272 12.5154 27.4344 12.9092 26.9489 12.9092H18.1681C17.6836 12.9092 17.2898 12.5164 17.2898 12.0309V11.8934C17.2898 11.4089 17.6827 11.0152 18.1681 11.0152ZM4.99682 11.0152H13.7777C14.2622 11.0152 14.6559 11.408 14.6559 11.8934V12.0309C14.6559 12.5154 14.2631 12.9092 13.7777 12.9092H4.99682C4.51232 12.9092 4.11855 12.5164 4.11855 12.0309V11.8934C4.11855 11.4089 4.51138 11.0152 4.99682 11.0152ZM18.1681 8.17457H26.9489C27.4334 8.17457 27.8272 8.56741 27.8272 9.05284V9.19034C27.8272 9.67483 27.4344 10.0686 26.9489 10.0686H18.1681C17.6836 10.0686 17.2898 9.67577 17.2898 9.19034V9.05284C17.2898 8.56834 17.6827 8.17457 18.1681 8.17457ZM4.99682 8.17457H13.7777C14.2622 8.17457 14.6559 8.56741 14.6559 9.05284V9.19034C14.6559 9.67483 14.2631 10.0686 13.7777 10.0686H4.99682C4.51232 10.0686 4.11855 9.67577 4.11855 9.19034V9.05284C4.11855 8.56834 4.51138 8.17457 4.99682 8.17457ZM3.24121 17.6419H28.7055C28.7055 18.6876 27.8581 19.535 26.8124 19.535H5.13525C4.08955 19.535 3.24121 18.6876 3.24121 17.6419ZM16.6585 20.3918L20.5382 25.2377C20.8412 25.6165 20.7805 26.1693 20.4016 26.4724C20.2464 26.5968 20.0528 26.665 19.8526 26.665H12.0931C11.6086 26.665 11.2149 26.2722 11.2149 25.7868C11.2149 25.5875 11.2831 25.3939 11.4075 25.2377L15.2873 20.3918C15.5903 20.013 16.1431 19.9522 16.5219 20.2552C16.5724 20.2955 16.6182 20.3413 16.6585 20.3918");
`;

const ProvablyFairIcon = ({ size }) => {
  return (
    <StyledSVG viewBox="0 0 32 32" size={size}>
      <Path1 />
    </StyledSVG>
  );
};

export default ProvablyFairIcon;