import React, { useState, useEffect, useRef } from 'react';
import { Switch, Route, useLocation, useParams, Redirect } from "react-router-dom";

import Index from "./App/Pages";
import Home from "./App/Pages/Parts/Home";
import NotFound from "./App/Pages/404";
import Rakeback from "./App/Pages/Rakeback";
import BonusAff from "./App/Pages/Affiliate/Bonus";
import Bonus from "./App/Pages/Bonus";
import AboutUs from "./App/Pages/AboutUs";
import Rules from "./App/Pages/Rules";
import Faq from "./App/Pages/Faq";
import Login from "./App/Pages/Auth/Login";
import Register from "./App/Pages/Auth/Register";
import LoginPage from "./App/Pages/Auth/LoginPage";
import RegisterPage from "./App/Pages/Auth/RegisterPage";
import UserStat from "./App/Components/User/Stat/Modal";
import GameStat from "./App/Components/Game/Stat";
import UserSetting from "./App/Components/User/Setting";
import GamesHome from "./App/Games";
import Wingo from './App/Games/Wingo/Wingo';
import SlotsHome from "./App/Slots/index";
import Slots from "./App/Slots/Game";
import Crash from "./App/Games/Crash";
import Keno from "./App/Games/Keno";
import Wheel from "./App/Games/Wheel";
import Limbo from "./App/Games/Limbo";
import Mine from "./App/Games/Mine";
import Hilo from "./App/Games/Hilo";
import Hashdice from "./App/Games/HashDice";
import ClassicDice from "./App/Games/ClassicDice";
import SingleKeno from "./App/Games/SingleKeno";
import Plinko from "./App/Games/Plinko";
import VideoPoker from "./App/Games/VideoPoker";
import Blackjack from "./App/Games/BlackJack";
import Goal from "./App/Games/Goal";
import Roulette from "./App/Games/Roulette";
import SnackAndLadders from "./App/Games/SnakeAndLadders";
import ThreeCardMonte from "./App/Games/ThreeCardMonte";
import MagicWheel from "./App/Games/MagicWheel";
import Tower from "./App/Games/Tower";
import Diamond from "./App/Games/Diamond";
import HighLow from "./App/Games/HighLow";
import Lottery from "./App/Games/Lottery";
import VipClub from "./App/Pages/VipClub";
import Promotions from "./App/Components/Promotions";
import ProvablyFair from "./App/Pages/Parts/ProvableFair";
import GlobalSettings from "./App/Pages/Parts/GlobalSettings";
import ClubMembership from "./App/Pages/ClubMembership";
import BonusNew from "./App/Pages/BonusNew";
import CreateOwnClub from "./App/Pages/CreateOwnClub";
import SkylaWallet from "./App/Pages/Wallet";
import SkylaMobileMenu from "./App/Pages/SkylaMobileMenu";
import SkylaMobileUserProfile from "./App/Pages/Parts/SkylaHeaderComponents/SkylaMobileProfile";
import { getUID, isMobile, sendNotfication } from "./Helper";
import { clubService } from "./utils/Services";
import SkylaWithdraw from "./App/Pages/Wallet/Withdraw";
import SkylaMobileWithdraw from "./App/Pages/Wallet/SkylaMobileWithdraw";
import Affiliate from "./App/Pages/Affiliate";
import AffiliateDashboard from "./App/Components/AffiliateDashboard";
import SportsPage from "./App/Pages/Sports";
import Casino from "./App/Pages/Casino";
import GlobalSearch from "./App/Pages/GlobalSearch";
import ClubMembershipPage from "./App/Pages/ClubMembership/MobileJoinClub";
import JoinClubPageMobile from "./App/Pages/ClubMembership/JoinClubModal";
import Sports from "./App/Pages/Sports";
import MobileCricketBettingUI from "./App/Pages/Sports/components/MobileUis/MobileCricketUi";
import CricketBetUiComponent from "./App/Pages/Sports/components/CricketUi/CricketBetUi";
import ComingSoon from "./App/Components/ComingSoon";
import CrashLiveGames from "./App/Games/CrashLiveGames";
import AllSlotsLiveGames from "./App/Games/AllSlotsLiveGames";
import GlobalSearchMobile from "./App/Pages/GolbalSearchMobile";
import MobileNotification from "./App/Components/MobileNotifcation/indx";
import EvolutionPlayingProviders from './App/providers/EvolutionPlaying';
import NetEntProviders from './App/providers/NetEnt';
import BetSoftProviders from './App/providers/betsoft';
import BGamingProviders from './App/providers/bgaming';
import KaGamingProviders from './App/providers/KaGaming';
import PlatipusProviders from './App/providers/platipus';
import QuickSpinProviders from './App/providers/quickspin';
import WazdanProviders from './App/providers/wazdan';
import LiveGames from './App/Games/LiveGames';
import EvolutionGaming from './App/Pages/Parts/Home/EvolutionGaming';
import PragmaticSlots from './App/Pages/Parts/Home/PmSlots';
import Spribe from './App/Pages/Parts/Home/Spribe';
import Ezugi from './App/Pages/Parts/Home/Ezugi';
import NetentByProvider from './App/Pages/Parts/Home/ProviderGames/Netent';
import EvolutionGaimgByProvider from './App/Pages/Parts/Home/ProviderGames/EvolutionProvider';
import PragmeticSlots from './App/Pages/Parts/Home/ProviderGames/PragmeticSlots';
import PragmaticLiveProvider from './App/Pages/Parts/Home/ProviderGames/PragmaticLiveProvider';
import IdealGameProvider from './App/Pages/Parts/Home/ProviderGames/IdealGameProvider';
import MicrogamingByProvider from './App/Pages/Parts/Home/ProviderGames/MicrogamingByProvider';
import PgSoftProvider from './App/Pages/Parts/Home/ProviderGames/PgSoftProvider';
import JiliGameProvider from './App/Pages/Parts/Home/ProviderGames/JiliGameProvider';
import AgentLoginModal from './App/Pages/Auth/AgentLogin';

const ReferralRoute = (props) => {
  const { referralCode } = useParams();
  console.log("code", referralCode);
  return (
    <Index
      t={props.t}
      content={
        <Home
          t={props.t}
          content={
            <RegisterPage referral={referralCode} history={props.history} show={true} />
          }
        />
      }
    />
  );
};

// function Redirector() {
//   return <Redirect to="/agent/signin" />;
// }

// export const joinClub = async (clubid) => {
//   try {
//     const loginStatus = localStorage.getItem('logged');
//     if (!loginStatus) {
//       localStorage.setItem('pendingClubJoin', `/club/${clubid}`);
//       return { success: false, requireLogin: true };
//     }
//     const requestBody = {
//       userId: getUID,
//       clubId: clubid,
//       type: 'club'
//     };
//     const data = await clubService.joinClub(requestBody);
//     if (!data.success) {
//       sendNotfication(data.error, 'error', 'bottom-left');
//       throw new Error(data.error || 'Failed to join club');
//     }
//     sendNotfication('club joined successfully', 'sucesss', 'bottom-left');
//     return { success: true, data };
//   } catch (err) {
//     throw new Error(err.message);
//   }
// };

// const ClubJoin = (props) => {
//   const { clubid } = useParams();
//   console.log("cid", clubid);
//   const [isLoading, setIsLoading] = useState(false);
//   const [error, setError] = useState(null);
//   let location = useLocation();
//   let loc = location.pathname;

//   useEffect(() => {
//     const handleClubJoin = async () => {
//       if (!clubid) {
//         setError('Club ID is required');
//         return;
//       }
//       const loginStatus = localStorage.getItem('logged');
//       if (!loginStatus) {
//         props.history.push(`/login?redirect=/club/${clubid}`);
//         return;
//       }
//       try {
//         await joinClub(clubid);
//       } catch (err) {
//         console.error('Failed to join club:', err);
//         setError(err.message);
//       }
//     };
//     handleClubJoin();
//   }, [clubid, props.history]);

//   return (
//     <Index
//       t={props.t}
//       location={loc}
//       content={
//         <Home
//           t={props.t}
//         />
//       }
//     />
//   );
// };

// ProtectedRoute component to check for token
const ProtectedRoute = ({ children, ...rest }) => {
  const isAuthenticated = !!localStorage.getItem('token'); // Adjust 'logged' to your token key if different
  return (
    <Route
      {...rest}
      render={({ location }) =>
        isAuthenticated ? (
          children
        ) : (
          <Redirect
            to={{
              pathname: '/',
              state: { from: location }
            }}
          />
        )
      }
    />
  );
};

function Router(props) {
  let location = useLocation();
  let background = location.state && location.state.background;
  let loc = location.pathname;
  const { t } = props;

  const checkPath = () => {
    if (isMobile()) {
      return '/mobile-user';
    } else {
      return '/';
    }
  };

  return (
    <>
      <Switch history={props.history} location={background || location}>
        <Route
          exact
          path="/"
          children={<Index t={t} location={loc} content={<Home t={t} />} />}
        />
        <Route
          path="/register"
          children={
            <Index
              t={t}
              content={
                <Home
                  t={t}
                  content={
                    <RegisterPage  t={t} history={props.history} show={true} />
                  }
                />
              }
            />
          }
        />
        <Route
          path="/agent/signup"
          children={
            <Index
              t={t}
              content={
                <Home
                  t={t}
                  content={<AgentLoginModal t={t} history={props.history} show={true} />}
                />
              }
            />
          }
        />
        <Route path="/referal/:referralCode" component={ReferralRoute} />
        {/* <Route path="/agent/*" children={<Redirector />} />
        <Route path="/agent" children={<Redirector />} /> */}
        {/* <Route
          path="/login"
          children={
            <Index
              t={t}
              content={
                <Home
                  t={t}
                  content={<Login t={t} history={props.history} show={true} />}
                />
              }
            />
          }
        /> */}
        <Route
          path="/signin"
          children={
            <Index
              t={t}
              content={
                <Home
                  t={t}
                  content={<LoginPage t={t} show={true} history={props.history} />}
                />
              }
            />
          }
        />
        <Route
          path="/signup"
          children={
            <Index
              t={t}
              content={
                <Home
                  t={t}
                  content={<RegisterPage t={t} history={props.history} />}
                />
              }
            />
          }
        />
        {/* <ProtectedRoute path="/club/:clubid" component={ClubJoin} /> */}
        {/* <Route path="/club">
          <Redirect to="/clubs" />
        </Route> */}
        {/* <Route path="/club/">
          <Redirect to="/clubs" />
        </Route> */}
        <ProtectedRoute
          path="/wingo"
          children={
            <Index
              t={t}
              content={
                <Wingo
                  t={t}
                  content={<Login t={t} history={props.history} show={true} />}
                />
              }
            />
          }
        />
        <ProtectedRoute
          path="/setting"
          children={
            <Index
              t={t}
              content={<UserSetting t={t} history={props.history} />}
            />
          }
        />
        <ProtectedRoute
          path="/wallet"
          children={
            <Index
              t={t}
              content={<SkylaWallet t={t} history={props.history} />}
            />
          }
        />
        <ProtectedRoute
          path="/withdraw"
          children={
            <Index
              t={t}
              content={<SkylaWallet t={t} history={props.history} />}
            />
          }
        />
        <ProtectedRoute
          path="/swap"
          children={
            <Index
              t={t}
              content={<SkylaWallet t={t} history={props.history} />}
            />
          }
        />
        <ProtectedRoute
          path="/vault-pro"
          children={
            <Index
              t={t}
              content={<SkylaWallet t={t} history={props.history} />}
            />
          }
        />
        <ProtectedRoute
          path="/menu"
          children={
            <Index
              t={t}
              content={<SkylaMobileMenu t={t} history={props.history} />}
            />
          }
        />
        <ProtectedRoute
          path="/notification"
          children={
            <Index
              t={t}
              content={<MobileNotification t={t} history={props.history} />}
            />
          }
        />
        <ProtectedRoute
          path="/withdraw-mobile"
          children={
            <Index
              t={t}
              content={<SkylaMobileWithdraw t={t} history={props.history} />}
            />
          }
        />
        <ProtectedRoute
          path="/affiliate-dashbaord"
          children={
            <Index
              t={t}
              content={<AffiliateDashboard />}
            />
          }
        />
        <ProtectedRoute
          path="/mobile-user"
          children={
            <Index
              t={t}
              content={<SkylaMobileUserProfile t={t} history={props.history} />}
            />
          }
        />
        <ProtectedRoute
          path="/explore"
          children={
            <Index
              t={t}
              content={<GlobalSearchMobile t={t} history={props.history} />}
            />
          }
        />
        <ProtectedRoute
          path="/transactions"
          children={
            <Index
              t={t}
              content={<SkylaWallet t={t} history={props.history} />}
            />
          }
        />
        <ProtectedRoute
          path="/affiliate"
          children={
            <Index
              t={t}
              content={<Affiliate t={t} history={props.history} />}
            />
          }
        />
        <ProtectedRoute
          path="/sports/markets/:tab"
          children={
            <Index
              t={t}
              content={<Sports />}
            />
          }
        />
        <ProtectedRoute
          path="/sports/markets/history"
          children={
            <Index
              t={t}
              content={<Sports />}
            />
          }
        />
        <ProtectedRoute
          path="/match/fullmarket/event/:id"
          children={
            <Index
              t={t}
              content={<MobileCricketBettingUI />}
            />
          }
        />
        <ProtectedRoute
          path="/casino"
          children={
            <Index
              t={t}
              content={<Casino />}
            />
          }
        />
        <ProtectedRoute
          path="/join-mobile"
          children={
            <Index
              t={t}
              content={<JoinClubPageMobile />}
            />
          }
        />
        <ProtectedRoute
          path="/global-search"
          children={
            <Index
              t={t}
              content={<GlobalSearch />}
            />
          }
        />
        <ProtectedRoute
          path="/provably-fair"
          children={
            <Index
              t={t}
              content={<ProvablyFair />}
            />
          }
        />
        <ProtectedRoute
          path="/global-settings"
          children={
            <Index
              t={t}
              content={<GlobalSettings />}
            />
          }
        />
        <ProtectedRoute
          path="/racing"
          children={
            <Index
              t={t}
              content={<ComingSoon />}
            />
          }
        />
        <ProtectedRoute
          path="/up-down"
          children={
            <Index
              t={t}
              content={<ComingSoon />}
            />
          }
        />
        <ProtectedRoute
          path="/bingo"
          children={
            <Index
              t={t}
              content={<ComingSoon />}
            />
          }
        />
        <ProtectedRoute
          path="/promotions"
          children={
            <Index
              t={t}
              content={<Promotions t={t} history={props.history} />}
            />
          }
        />
        <ProtectedRoute
          path="/rakeback"
          children={
            <Index t={t} content={<Rakeback t={t} history={props.history} />} />
          }
        />
        <ProtectedRoute
          path="/lottery"
          children={
            <Index t={t} content={<Lottery t={t} history={props.history} />} />
          }
        />
        <ProtectedRoute
          path="/crash-games"
          children={
            <Index t={t} content={<CrashLiveGames t={t} history={props.history} />} />
          }
        />
        <ProtectedRoute
          path="/all-slots"
          children={
            <Index t={t} content={<AllSlotsLiveGames t={t} history={props.history} />} />
          }
        />
        <ProtectedRoute
          path="/aff"
          children={
            <Index
              t={t}
              content={
                <BonusAff params={location} history={props.history} t={t} />
              }
            />
          }
        />
        <ProtectedRoute
          path="/bonus-page"
          children={
            <Index
              t={t}
              content={
                <BonusNew params={location} history={props.history} t={t} />
              }
            />
          }
        />
        <ProtectedRoute
          path="/club-membership"
          children={
            <Index
              t={t}
              content={
                <ClubMembership params={location} history={props.history} t={t} />
              }
            />
          }
        />
        <ProtectedRoute
          path="/create-own-club"
          children={
            <Index
              t={t}
              content={
                <CreateOwnClub params={location} history={props.history} t={t} />
              }
            />
          }
        />
        <ProtectedRoute
          path="/rules"
          children={
            <Index
              t={t}
              content={
                <Rules params={location} history={props.history} t={t} />
              }
            />
          }
        />
        <ProtectedRoute
          path="/faq"
          children={
            <Index
              t={t}
              content={<Faq params={location} history={props.history} t={t} />}
            />
          }
        />
        <ProtectedRoute
          path="/user/:id"
          children={
            <Index
              t={t}
              content={
                <Home
                  t={t}
                  content={
                    <UserStat
                      t={t}
                      history={props.history}
                      params={location}
                      byLink={true}
                    />
                  }
                />
              }
            />
          }
        />
        <ProtectedRoute
          path="/game/:id"
          children={
            <Index t={t} content={<GameStat t={t} params={location} />} />
          }
        />
        <ProtectedRoute
          path="/crash"
          children={<Index t={t} content={<Crash t={t} />} />}
        />
        <ProtectedRoute
          path="/keno"
          children={<Index t={t} content={<Keno t={t} />} />}
        />
        <ProtectedRoute
          path="/wheel"
          children={<Index t={t} content={<Wheel t={t} />} />}
        />
        <ProtectedRoute
          path="/limbo"
          children={<Index t={t} content={<Limbo t={t} />} />}
        />
        <ProtectedRoute
          path="/hash-dice"
          children={<Index t={t} content={<Hashdice t={t} />} />}
        />
        <ProtectedRoute
          path="/classic-dice"
          children={
            <Index
              t={t}
              content={<ClassicDice t={t} history={props.history} />}
            />
          }
        />
        <ProtectedRoute
          path="/mine"
          children={
            <Index t={t} content={<Mine t={t} history={props.history} />} />
          }
        />
        <ProtectedRoute
          path="/singlekeno"
          children={
            <Index
              t={t}
              content={<SingleKeno t={t} history={props.history} />}
            />
          }
        />
        <ProtectedRoute
          path="/hilo"
          children={
            <Index t={t} content={<Hilo t={t} history={props.history} />} />
          }
        />
        <ProtectedRoute
          path="/roulette"
          children={
            <Index t={t} content={<Roulette t={t} history={props.history} />} />
          }
        />
        <ProtectedRoute
          path="/plinko"
          children={<Index t={t} content={<Plinko t={t} />} />}
        />
        <ProtectedRoute
          path="/videopoker"
          children={<Index t={t} content={<VideoPoker t={t} />} />}
        />
        <ProtectedRoute
          path="/blackjack"
          children={
            <Index t={t} content={<Blackjack history={props.history} />} />
          }
        />
        <ProtectedRoute
          path="/goal"
          children={<Index t={t} content={<Goal history={props.history} />} />}
        />
        <ProtectedRoute
          path="/snake-and-ladders"
          children={
            <Index
              t={t}
              content={<SnackAndLadders history={props.history} />}
            />
          }
        />
        <ProtectedRoute
          path="/3-card-monte"
          children={
            <Index t={t} content={<ThreeCardMonte history={props.history} />} />
          }
        />
        <ProtectedRoute
          path="/magic-wheel"
          children={
            <Index t={t} content={<MagicWheel history={props.history} />} />
          }
        />
        <ProtectedRoute
          path="/tower"
          children={<Index t={t} content={<Tower history={props.history} />} />}
        />
        <ProtectedRoute
          path="/diamond"
          children={
            <Index t={t} content={<Diamond history={props.history} />} />
          }
        />
        <ProtectedRoute
          path="/high-or-low"
          children={
            <Index t={t} content={<HighLow history={props.history} />} />}
        />
        <ProtectedRoute
          path="/slots/:id"
          children={
            <Index t={t} content={<Slots t={t} history={props.history} />} />
          }
        />
        <ProtectedRoute
          path="/slots"
          children={<Index t={t} content={<SlotsHome t={t} />} />}
        />
        <ProtectedRoute
          path="/games"
          children={<Index t={t} content={<GamesHome t={t} />} />}
        />
        <ProtectedRoute
          path="/bonus"
          children={<Index t={t} content={<Bonus t={t} />} />}
        />
        <ProtectedRoute
          path="/about-us"
          children={<Index t={t} content={<AboutUs t={t} />} />}
        />
        <ProtectedRoute
          path="/vip-club"
          children={<Index t={t} content={<VipClub t={t} />} />}
        />
        <ProtectedRoute
          path="/providers/evolution-gaming"
          children={
            <Index t={t} content={<EvolutionGaimgByProvider t={t} history={props.history} />} />
          }
        />
        <ProtectedRoute
          path="/providers/pp"
          children={
            <Index t={t} content={<PragmeticSlots t={t} history={props.history} />} />
          }
        />
        <ProtectedRoute
          path="/providers/pglive"
          children={
            <Index t={t} content={<PragmaticLiveProvider t={t} history={props.history} />} />
          }
        />
        <ProtectedRoute
          path="/providers/ig"
          children={
            <Index t={t} content={<IdealGameProvider t={t} history={props.history} />} />
          }
        />
        <ProtectedRoute
          path="/providers/mg"
          children={
            <Index t={t} content={<MicrogamingByProvider t={t} history={props.history} />} />
          }
        />
        <ProtectedRoute
          path="/providers/pg-soft"
          children={
            <Index t={t} content={<PgSoftProvider t={t} history={props.history} />} />
          }
        />
        <ProtectedRoute
          path="/pm-slots"
          children={
            <Index t={t} content={<PragmaticSlots t={t} history={props.history} />} />
          }
        />
        <ProtectedRoute
          path="/providers/pg-slots"
          children={
            <Index t={t} content={<PragmaticSlots t={t} history={props.history} />} />
          }
        />
        <ProtectedRoute
          path="/spribe-games"
          children={
            <Index t={t} content={<Spribe t={t} history={props.history} />} />
          }
        />
        <ProtectedRoute
          path="/providers/spribe"
          children={
            <Index t={t} content={<Spribe t={t} history={props.history} />} />
          }
        />
        <ProtectedRoute
          path="/ezugi-games"
          children={
            <Index t={t} content={<Ezugi t={t} history={props.history} />} />
          }
        />
        <ProtectedRoute
          path="/providers/ezugi-games"
          children={
            <Index t={t} content={<Ezugi t={t} history={props.history} />} />
          }
        />
        <ProtectedRoute
          path="/live"
          children={
            <Index t={t} content={<EvolutionGaming t={t} history={props.history} />} />
          }
        />
        <ProtectedRoute
          path="/providers/netent"
          children={
            <Index t={t} content={<NetentByProvider t={t} history={props.history} />} />
          }
        />
        <ProtectedRoute
          path="/providers/microgaming"
          children={
            <Index t={t} content={<MicrogamingByProvider t={t} history={props.history} />} />
          }
        />
        <ProtectedRoute
          path="/providers/jili"
          children={
            <Index t={t} content={<JiliGameProvider t={t} history={props.history} />} />
          }
        />
        <ProtectedRoute
          path="/providers/ideal"
          children={
            <Index t={t} content={<IdealGameProvider t={t} history={props.history} />} />
          }
        />
        <ProtectedRoute
          path="/providers/betsoft"
          children={
            <Index t={t} content={<BetSoftProviders t={t} history={props.history} />} />
          }
        />
        <ProtectedRoute
          path="/live-games"
          children={
            <Index t={t} content={<LiveGames t={t} history={props.history} />} />
          }
        />
        <ProtectedRoute
          path="/providers/bgaming"
          children={
            <Index t={t} content={<BGamingProviders t={t} history={props.history} />} />
          }
        />
        <ProtectedRoute
          path="/providers/Ka"
          children={
            <Index t={t} content={<KaGamingProviders t={t} history={props.history} />} />
          }
        />
        <ProtectedRoute
          path="/providers/platipus"
          children={
            <Index t={t} content={<PlatipusProviders t={t} history={props.history} />} />
          }
        />
        <ProtectedRoute
          path="/providers/quickspin"
          children={
            <Index t={t} content={<QuickSpinProviders t={t} history={props.history} />} />
          }
        />
        <ProtectedRoute
          path="/providers/wazdan"
          children={
            <Index t={t} content={<WazdanProviders t={t} history={props.history} />} />
          }
        />
        <Route path="*">
          <NotFound history={props.history} />
        </Route>
      </Switch>
    </>
  );
}

export default Router;