import React, { createContext, useState, useContext, useCallback } from 'react';

// Check if user is authenticated
const isAuthenticated = () => {
  const token = localStorage.getItem('token');
  const logged = localStorage.getItem('logged');
  return token && logged === 'true';
};

// Create the context
const GameLaunchContext = createContext({
  gameUrl: null,
  setGameUrl: () => { },
  isGameOpen: false,
  setIsGameOpen: () => { },
  isAuthenticated: false,
  requireAuth: () => { }
});

// Provider component
export const GameLaunchProvider = ({ children }) => {
  const [gameUrl, setGameUrl] = useState(null);
  const [isGameOpen, setIsGameOpen] = useState(false);

  // Function to require authentication for game actions
  const requireAuth = useCallback((action) => {
    if (!isAuthenticated()) {
      console.log('🔐 GameLaunchProvider: Authentication required for', action);
      // You can emit an event to show login modal or notification
      if (window.Event) {
        window.Event.emit('show_login_modal', { 
          message: 'Please login to access this feature' 
        });
      }
      return false;
    }
    return true;
  }, []);

  return (
    <GameLaunchContext.Provider value={{
      gameUrl,
      setGameUrl,
      isGameOpen,
      setIsGameOpen,
      isAuthenticated: isAuthenticated(),
      requireAuth
    }}>
      {children}
    </GameLaunchContext.Provider>
  );
};

// Custom hook for using the context
export const useGameLaunch = () => useContext(GameLaunchContext);