// First, let's create a custom hook to manage team values
import { useState, useEffect } from 'react';
import { useBetting } from '../context/BettingContext';

export const useTeamValues = (team1, team2) => {
  const [teamValues, setTeamValues] = useState({
    [team1]: { left: 0, right: 0 },
    [team2]: { left: 0, right: 0 }
  });
  const { selectedBets } = useBetting();

  useEffect(() => {
    const calculateValues = () => {
      const newValues = {
        [team1]: { left: 0, right: 0 },
        [team2]: { left: 0, right: 0 }
      };

      selectedBets.forEach(bet => {
        if (!bet.stake) return;

        const stake = parseFloat(bet.stake) || 0;
        const odds = parseFloat(bet.odds) || 0;
        const potentialWin = stake * (odds - 1);
        
        if (bet.type === 'back') {
          // For back bets
          if (bet.selectionName === team1) {
            newValues[team1].right += potentialWin;
            newValues[team1].left -= stake;
            newValues[team2].right -= stake;
            newValues[team2].left += 0;
          } else {
            newValues[team2].right += potentialWin;
            newValues[team2].left -= stake;
            newValues[team1].right -= stake;
            newValues[team1].left += 0;
          }
        } else {
          // For lay bets
          if (bet.selectionName === team1) {
            newValues[team1].right -= stake;
            newValues[team1].left += potentialWin;
            newValues[team2].right += potentialWin;
            newValues[team2].left -= stake;
          } else {
            newValues[team2].right -= stake;
            newValues[team2].left += potentialWin;
            newValues[team1].right += potentialWin;
            newValues[team1].left -= stake;
          }
        }
      });

      setTeamValues(newValues);
    };

    calculateValues();
  }, [selectedBets, team1, team2]);

  return teamValues;
};