import apiService from './apiService';

// Get token from localStorage
const getAuthToken = () => {
  return localStorage.getItem('token');
};

export const clubService = {
  // Create club
  createClub: async (data) => {
    const token = getAuthToken();
    return await apiService.post('/clubmembership/create', data, {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Join club
  joinClub: async (data) => {
    const token = getAuthToken();
    return await apiService.post('/clubmembership/join', data, {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Get user affiliations
  getUserAffiliations: async (userId) => {
    const token = getAuthToken();
    return await apiService.get(`/clubmembership/user-affiliations/${userId}`, {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Update club
  updateClub: async (data) => {
    const token = getAuthToken();
    return await apiService.post('/clubmembership/update', data, {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Get club hierarchy
  getClubHierarchy: async (clubId) => {
    const token = getAuthToken();
    return await apiService.get(`/clubmembership/${clubId}/hierarchy`, {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Change member role
  changeMemberRole: async (data) => {
    const token = getAuthToken();
    return await apiService.post('/clubmembership/change-role', data, {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Get club notifications
  getClubNotifications: async (clubId) => {
    const token = getAuthToken();
    return await apiService.get(`/clubnotification/clubs/${clubId}/notifications`, {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Create club notification
  createClubNotification: async (clubId, data) => {
    const token = getAuthToken();
    return await apiService.post(`/clubnotification/clubs/${clubId}/notifications`, data, {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Get user profile
  getUserProfile: async (userId) => {
    const token = getAuthToken();
    return await apiService.get(`/clubmembership/userprofile/${userId}`, {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Delete club
  deleteClub: async (clubId) => {
    const token = getAuthToken();
    return await apiService.delete(`/clubmembership/${clubId}/delete`, {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },
};

export default clubService; 