import apiService from './apiService';

// Get token from localStorage
const getAuthToken = () => {
  return localStorage.getItem('token');
};

export const gamesService = {
  // Get games by vendor
  getGamesByVendor: async (vendorName, page, perPage) => {
    const token = getAuthToken();
    return await apiService.get(`/jsGames/games?vendor=${vendorName}&page=${page}&per_page=${perPage}`, {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Launch game
  launchGame: async (data) => {
    const token = getAuthToken();
    return await apiService.post('/jsGamesv2/launch', data, {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Get games list
  getGamesList: async () => {
    const token = getAuthToken();
    return await apiService.get('https://gamerun.gaminghub360.com/api/casino/games/list', {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Get casino balance
  getCasinoBalance: async () => {
    const token = getAuthToken();
    return await apiService.get('/api/casino/balance', {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Get EGT jackpot info
  getEGTJackpotInfo: async () => {
    const token = getAuthToken();
    return await apiService.get('/api/jackpots/egt-jackpot-info', {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Get available products
  getAvailableProducts: async () => {
    const token = getAuthToken();
    return await apiService.get('/available-products', {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Get provider games
  getProviderGames: async () => {
    const token = getAuthToken();
    return await apiService.get('/provider-games', {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Launch game
  launchProviderGame: async (data) => {
    const token = getAuthToken();
    return await apiService.post('/launch-game', data, {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Get game history
  getGameHistory: async (userId) => {
    const token = getAuthToken();
    return await apiService.get(`/jsGamesv2/history?userid=${userId}`, {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Get admin game history
  getAdminGameHistory: async () => {
    const token = getAuthToken();
    return await apiService.get('/jsGamesv2/historyAdmin', {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },
};

export default gamesService; 