import apiService from './apiService';

// Get token from localStorage
const getAuthToken = () => {
  return localStorage.getItem('token');
};

export const sportsService = {
  // Get site configuration
  getSiteConfig: async () => {
    const token = getAuthToken();
    return await apiService.get('/siteconfig', {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Get all in-play matches
  getAllInPlay: async () => {
    const token = getAuthToken();
    return await apiService.get('/sports/allinplay', {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Get all matches
  getAllMatches: async () => {
    const token = getAuthToken();
    return await apiService.get('/sports/all-matches', {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Get market odds
  getMarketOdds: async (marketId) => {
    const token = getAuthToken();
    return await apiService.get(`/sports/market-odds?market_id=${marketId}`, {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Get bookmaker fancy
  getBookmakerFancy: async (eventId) => {
    const token = getAuthToken();
    return await apiService.get(`/sports/bookmakerFancy?eventid=${eventId}`, {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Place bet
  placeBet: async (data) => {
    const token = getAuthToken();
    return await apiService.post('/place', data, {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Get exposures
  getExposures: async (userId, matchId) => {
    const token = getAuthToken();
    return await apiService.get(`/exposures/${userId}/${matchId}`, {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Get user exposures
  getUserExposures: async (uuid) => {
    const token = getAuthToken();
    return await apiService.get(`/exposures/${uuid}`, {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Get wallet info
  getWalletInfo: async (uuid) => {
    const token = getAuthToken();
    return await apiService.get(`/wallet/${uuid}`, {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },
};

export default sportsService; 