import apiService from './apiService';

// Get token from localStorage
const getAuthToken = () => {
  return localStorage.getItem('token');
};

export const walletService = {
  // Get coin details
  getCoinDetails: async (data) => {
    const token = getAuthToken();
    return await apiService.post('/getCoinDetails', data, {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Create deposit
  createDeposit: async (payload) => {
    const token = getAuthToken();
    return await apiService.post('/createDeposit', payload, {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Create UPI order
  createOrderUPI: async (data) => {
    const token = getAuthToken();
    return await apiService.post('/createorderupi', data, {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Get INR history
  getINRHistory: async (data) => {
    return await apiService.post('https://api.winstreak.games/inrhistory', data);
  },

  // Get 2FA status
  get2FAStatus: async (userId) => {
    const token = getAuthToken();
    return await apiService.get(`/2fa/status/${userId}`, {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Enable 2FA
  enable2FA: async (data) => {
    const token = getAuthToken();
    return await apiService.post('/2fa/enable', data, {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Setup and verify 2FA
  setupVerify2FA: async (data) => {
    const token = getAuthToken();
    return await apiService.post('/2fa/setup-verify', data, {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Disable 2FA
  disable2FA: async (data) => {
    const token = getAuthToken();
    return await apiService.post('/2fa/disable', data, {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Verify 2FA
  verify2FA: async (data) => {
    const token = getAuthToken();
    return await apiService.post('/2fa/verify', data, {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Change password
  changePassword: async (data) => {
    const token = getAuthToken();
    return await apiService.post('/user/change-password', data, {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Create fiat withdrawal
  createFiatWithdrawal: async (payload) => {
    const token = getAuthToken();
    return await apiService.post('/createFiatWithdrawal', payload, {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Get bank details
  getBankDetails: async (selectedCoin) => {
    const token = getAuthToken();
    return await apiService.get(`/bankDetails/${selectedCoin}`, {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Create remote deposit
  createRemoteDeposit: async (data) => {
    const token = getAuthToken();
    return await apiService.post('/remotes/create-deposit', data, {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Create CricPay payment request
  createCricPayPayment: async (data) => {
    const token = getAuthToken();
    return await apiService.post('/cricpay/payment-request', data, {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Initiate PayIn payment
  initiatePayIn: async (data) => {
    const token = getAuthToken();
    return await apiService.post('/api/payments/payin/initiate', data, {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Create deposit with form data
  createDepositWithForm: async (formData) => {
    return await apiService.post('/api/deposits/create', formData, {
      headers: {
        'Content-Type': 'multipart/form-data',
      },
    });
  },

  // Get bonus config
  getBonusConfig: async () => {
    const token = getAuthToken();
    return await apiService.get('/api/bonus/config-public', {
      headers: {
        Authorization: `Bearer ${token}`,
        'Content-Type': 'application/json'
      }
    });
  },

  // Get transaction history
  getTransactionHistory: async (params) => {
    return await apiService.get('https://api.winstreak.games/inrhistory', { params });
  },
};

export default walletService; 