import React, { useState, useRef, useEffect } from 'react';
import Slider from 'react-slick';
import 'slick-carousel/slick/slick.css';
import 'slick-carousel/slick/slick-theme.css';
import { useDispatch, useSelector } from 'react-redux';
import { ourSlides } from '../../redux/_reducers/_reducers';

const CasinoSlider = () => {
    const dispatch = useDispatch()
    const { ourSlidesData, } = useSelector(
        (state) => state.authentication
    );
    const [sliderData, setslideData] = useState([])

    useEffect(() => {
        const payload = { domain_id: 1 };
        dispatch(ourSlides(payload));
    }, [dispatch]);

    useEffect(() => {
        if (ourSlidesData) {
            const sliderFinaldata = ourSlidesData?.map(data => {
                return {
                    gameName: data?.title,
                    gameImg: data?.attachment,
                }
            })
              setslideData(sliderFinaldata);
        }
    }, [ourSlidesData]);

    const settings = {
        dots: true,
        autoplay: true,
        autoplaySpeed: 2500,
        arrows: false,
        centerMode: false,
        slidesToShow: 8,
        slidesToScroll: 1.5,
        responsive: [
            {
                breakpoint: 2560,
                settings: {
                    slidesToShow: 1,
                    slidesToScroll: 1,
                    autoplay: true,
                    infinite: true,

                }
            },
            {
                breakpoint: 1440,
                settings: {
                    slidesToShow: 1,
                    slidesToScroll: 1,
                    autoplay: true,
                    infinite: true,

                }
            },
            {
                breakpoint: 1024,
                settings: {
                    slidesToShow: 1,
                    slidesToScroll: 1,
                    autoplay: true,
                    infinite: true,

                }
            },
            {
                breakpoint: 600,
                settings: {
                    slidesToShow: 1,
                    slidesToScroll: 1,
                    autoplay: true,
                    initialSlide: 3
                }
            },
            {
                breakpoint: 480,
                settings: {
                    slidesToShow: 1,
                    autoplay: true,
                    slidesToScroll: 1
                }
            }
        ]
    };

    return (
        <>
            <section className="lg:pt-1 pb-8 pt-0 lg:mt-1 mt-0 lg:bg-transparent bg-[var(--secondary)]">
                <Slider {...settings}>
                    {sliderData?.map((item, index) => (
                        <div key={index} className="cursor-pointer">
                            <a
                                className='flex gap-4'>
                                {/* href={item.gameLink} */}
                                <img src={item.gameImg} alt={item.gameName} className='px-0' />
                            </a>
                        </div>
                    ))}
                </Slider>
            </section>
        </>
    )
}
export default CasinoSlider;


// export const sliderData = [

//     {
//         gameId: 3030,
//         gameName: 'star casino teep patti',
//         gameLink: '/admin/iframe-casino/900003',
//         gameImg: '/assets/dashboard/image_218937.jpg',
//         gameOrder: 1,
//         gameSortName: 'teen20'
//     },

//     {
//         gameId: 3048,
//         gameName: 'world casino teen pati',
//         gameLink: '/admin/iframe-casino/900003',
//         gameImg: '/assets/dashboard/image_218937.jpg',
//         gameOrder: 2,
//         gameSortName: 'teen9'
//     },

//     {
//         gameId: 3031,
//         gameName: 'world casino Poker',
//         gameLink: '/admin/iframe-casino/500001',
//         gameImg: '/assets/dashboard/image_218937.jpg',
//         gameOrder: 3,
//         gameSortName: 'teen'
//     },

//     {
//         gameId: 3031,
//         gameName: 'world casino virtual game',
//         gameLink: '/admin/iframe-casino/500001',
//         gameImg: '/assets/dashboard/image_218937.jpg',
//         gameOrder: 4,
//         gameSortName: 'teen'
//     },
//     {
//         gameId: 3056,
//         gameName: 'World casino roleate',
//         // gameLink: '/admin/aaa/3056',
//         gameLink: '/admin/iframe-casino/900002',
//         gameImg: '/assets/dashboard/image_218937.jpg',
//         gameOrder: 5,
//         gameSortName: 'aaa'
//     },



//     {
//         gameId: 3031,
//         gameName: 'world casino 32 card',
//         gameLink: '/admin/iframe-casino/500001',
//         gameImg: '/assets/dashboard/image_218937.jpg',
//         gameOrder: 6,
//         gameSortName: 'teen'
//     },

//     {
//         gameId: 3056,
//         gameName: 'Eropean Rollate',
//         // gameLink: '/admin/aaa/3056',
//         gameLink: '/admin/iframe-casino/900002',
//         gameImg: '/assets/dashboard/image_218937.jpg',
//         gameOrder: 7,
//         gameSortName: 'aaa'
//     },

//     {
//         gameId: 3054,
//         gameName: 'Casino TeenPatti',
//         gameLink: '/admin/iframe-casino/900003',
//         gameImg: '/assets/dashboard/image_218937.jpg',
//         gameOrder: 8,
//         gameSortName: 'worli'
//     },



//     {
//         gameId: 3034,
//         gameName: 'state casino down',
//         gameLink: '/admin/iframe-casino/900001',
//         gameImg: '/assets/dashboard/image_218937.jpg',
//         gameOrder: 9,
//         gameSortName: 'card32eu'
//     },

//     {
//         gameId: 3055,
//         gameName: 'star casino vircual game',
//         gameLink: '/admin/iframe-casino/900014',
//         gameImg: '/assets/dashboard/image_218937.jpg',
//         gameOrder: 10,
//         gameSortName: 'card32-a'
//     },


//     {
//         gameId: 100001,
//         gameName: 'Ezugi',
//         gameLink: '/admin/iframe-casino/100001',
//         gameImg: '/assets/dashboard/image_218937.jpg',
//         gameOrder: 13,
//         gameSortName: ''
//     },



//     {
//         gameId: 201206,
//         gameName: 'Aviator',
//         gameLink: '/admin/iframe-casino/201206',
//         gameImg: 'public/assets/dashboard/image_218937.jpg',
//         gameOrder: 11,
//         gameSortName: ''
//     },



//     {
//         gameId: 600000,
//         gameName: 'Jili',
//         gameLink: '/admin/iframe-casino/600000',
//         gameImg: 'public/assets/dashboard/image_218937.jpg',
//         gameOrder: 12,
//         gameSortName: ''
//     },
// ]