import { useEffect, useState } from "react";
import { useDispatch, useSelector } from "react-redux";
import { useNavigate } from "react-router-dom";
import { casinoListByCategory, getCasinoProvider, walletBalance, } from "../../redux/_reducers/_reducers";
import { AiOutlineLoading3Quarters } from "react-icons/ai";




function DashboardInplay() {
  const [tab, setTab] = useState();
  const [sportsId, setSportsId] = useState(4);
  const dispatch = useDispatch();
  const navigate = useNavigate();
  const [apiData, setApiData] = useState([]);
  const [isLoading, setIsLoading] = useState(false);

  const [providers, setProviders] = useState([]);

  const { getCasinoProviderData } = useSelector(state => state.authentication)
 
  useEffect(() => {
    if (getCasinoProviderData && getCasinoProviderData.length > 0) {
      const updatedProviders = getCasinoProviderData.map((provider) => {
        let imageUrl = "/assets/dashboard/provider-awcmpt.png";

        if (provider.provider_name === "AWC") imageUrl = "/assets/dashboard/provider-awcmsg.png";
        else if (provider.provider_name === "BETGAMES") imageUrl = "/assets/dashboard/provider-bg.png";
        else if (provider.provider_name === "CRASH88") imageUrl = "/assets/dashboard/provider-awcmpt.png";
        else if (provider.provider_name === "EZUGI") imageUrl = "/assets/dashboard/provider-evo.png";
        else if (provider.provider_name === "JiLi") imageUrl = "/assets/dashboard/provider-awcmjili.png";
        else if (provider.provider_name === "KINGMIDAS") imageUrl = "/assets/dashboard/provider-awcmkm.png";
        else if (provider.provider_name === "MAC88") imageUrl = "/assets/dashboard/provider-mg.png";
        else if (provider.provider_name === "RG") imageUrl = "/assets/dashboard/provider-awcmrt.png";
        else if (provider.provider_name === "SAP") imageUrl = "/assets/dashboard/provider-wm.png";
        else if (provider.provider_name === "SPRIBE") imageUrl = "/assets/dashboard/provider-jdbaspribe.png";
        else if (provider.provider_name === "SUNO") imageUrl = "/assets/dashboard/provider-awcmladyluck.png";
        return { ...provider, image: imageUrl };
      });
      setProviders(updatedProviders);
    }
  }, [getCasinoProviderData]);

  useEffect(() => {
    const oldtab = localStorage.getItem("desktopTab")
    if (oldtab) {
      setTab(+ oldtab)
      const activeTabScrollTab = document.getElementById(oldtab);
      if (activeTabScrollTab) {
        activeTabScrollTab.scrollIntoView({
          behavior: "smooth",
          block: "center",
          inline: "center",
        });
      }
      handleGetCasinoListByCategory(oldtab, tabData?.find(data => data?.id == oldtab)?.name)
    } else {
      setTab(1)
    }
    dispatch(walletBalance())
  }, [dispatch]);


  const handleProviderClick = (type, providerName) => {
    window.location.href = `/casino-provider/${type}/${providerName}`;
 
  }


  // useEffect(() => {
  //   const reqpayload = {
  //     name: "SUNO"
  //   }
  //   dispatch(getCasinoProvider(reqpayload))
  // }, [])

  const handleClick = async (id, name, label) => {
    setTab(id)
    localStorage.setItem("desktopTab", id)
    const activeTabScrollTab = document.getElementById(id);
    if (activeTabScrollTab) {
      activeTabScrollTab.scrollIntoView({
        behavior: "smooth",
        block: "center",
        inline: "center",
      });
    }
    // const payload = {
    //   category: type,
    // };
    // handleGetCasinoListByCategory(id, label, name)
    dispatch(getCasinoProvider())
  }

  useEffect(() => {
    setTab(4001)
  }, [])

  const handleGetCasinoListByCategory = async (id, label) => {
    if (id == 4001 || id == 4002 || id == 4003 || id == 4004) return
    setIsLoading(true)
    const payload = {
      category: label.toLowerCase().replace(/\s+/g, '-'),
      limit: 1000,
    };
    await dispatch(casinoListByCategory(payload))
      .unwrap()
      .then((response) => {
        if (response && response) {
          setApiData(response);
        } else {
          console.warn('No data found in response:', response);
          setApiData([]);
        }
      })
      .catch((error) => {
        console.error('API call failed:', error);
        setApiData([]);
      })
    setIsLoading(false)
  }

  return (
    <section className="">
      <div className="">
        <div className=" text-white">
          <div className="flex justify-start gap-0 bg-[var(--dark-header)] md:rounded-md overflow-x-auto ">
            {tabData?.map((item) => (
              <button
                key={item.id}
                id={item.id}
                // onClick={() => {
                //   setTab(item.id)
                //   localStorage.setItem("desktopTab", item?.id)
                // }}
                onClick={() => handleClick(item.id, item.name, item.payload)}
                className={`flex flex-col items-center justify-center px-6 py-2 uppercase ${tab === item.id ? "bg-[var(--primary)]" : "bg-transparent"
                  }`}
              >
                <img src={item.icon} alt={item.name} className="w-[40px] h-[40px] mb-1" />
                <p className="text-[13px] font-[600] whitespace-nowrap"> {item.name}</p>
              </button>
            ))}
          </div>

          {tab == 4001 && (
            <div className="">
              <h2 className="text-gray-600 text-sm font-semibold border-l-4 border-[var(--light-header)]   my-2.5 px-2 lg:ml-0 ml-2">SPORTS</h2>
              <div className="flex justify-start items-center overflow-x-auto gap-2 px-1 py-[10px] ">

                <button
                  onClick={() => {
                    setSportsId(4)
                    window.location.href = `/inplay/${4}`;
                  }}
                  className={`bg-secondary text-black flex flex-col justify-center items-center bg-white w-[147px] h-[77px] md:text-[12px] text-[9px] px-2 py-1 rounded outline-none ${sportsId === 4 ? "border-gray-300" : ""
                    }`}
                >
                  <img alt="" className="w-[40px] h-[40px]" src="/assets/dashboard/icon-exchange.png" />
                  <p className="md:my-0 text-sm my-1">Cricket</p>
                </button>

                <button
                  onClick={() => {
                    setSportsId(1)
                    window.location.href = `/inplay/${1}`;
                  }}
                  className={`bg-secondary text-black flex flex-col justify-center items-center bg-white w-[147px] h-[77px] md:text-[12px] text-[9px] px-2 py-1 rounded outline-none ${sportsId === 1 ? "border-gray-300" : ""
                    }`}
                >
                  <img alt="" className="w-[40px] h-[40px]" src="/assets/dashboard/soccer.png" />
                  <p className="md:my-0 text-sm my-1">Soccer</p>
                </button>
                <button
                  onClick={() => {
                    setSportsId(2)
                    window.location.href = `/inplay/${2}`;
                  }}
                  className={`bg-secondary text-black flex flex-col justify-center items-center bg-white w-[147px] h-[77px] md:text-[12px] text-[9px] px-2 py-1 rounded outline-none ${sportsId === 2 ? "border-gray-300" : ""
                    }`}
                >
                  <img alt="" className="w-[40px] h-[40px]" src="/assets/dashboard/tennis.png" />
                  <p className="md:my-0 text-sm my-1">Tennis</p>
                </button>
              </div>
            </div>
          )}
          {tab == 4002 && (
            <div className="">
              <h2 className="text-gray-600 text-sm font-semibold border-l-4 border-[var(--light-header)]   my-2.5 px-2 lg:ml-0 ml-2">CASINO</h2>
              <div className="xl:grid-cols-7 lg:grid-cols-7 grid md:grid-cols-5 sm:grid-cols-4 grid-cols-3 justify-start items-center overflow-x-auto md:gap-2 gap-1 px-1 py-[10px]">
                {providers?.map((game) => (
                  <button
                    key={game.eventId}
                    onClick={() => handleProviderClick("casino", game.provider_name)}
                    className={`bg-secondary text-black flex flex-col justify-center items-center bg-white md:w-[147px] h-[77px] md:text-[12px] text-[9px] px-2 py-1 rounded outline-none `}>
                    <img alt={game.provider_name} className="w-[40px] h-[40px]" src={game.image} />
                    <p className="md:my-0 text-sm my-1 whitespace-nowrap">{game.provider_name}</p>
                  </button>
                ))}
              </div>
            </div>
          )}

          {tab == 4003 && (
            <div>
              <h2 className="text-gray-600 text-sm font-semibold border-l-4 border-[var(--light-header)]   my-2.5 px-2 lg:ml-0 ml-2">SLOTS</h2>
              <div className="md:flex grid sm:grid-cols-4 grid-cols-3 justify-start items-center overflow-x-auto md:gap-2 gap-1 px-1 py-[10px]">
                <button
                  onClick={() => handleProviderClick("slots", "JiLi")}
                  className={`bg-secondary text-black flex flex-col justify-center items-center bg-white w-[147px] h-[77px] md:text-[12px] text-[9px] px-2 py-1 rounded outline-none `}>
                  <img alt="" className="w-[40px] h-[40px]" src="/assets/dashboard/provider-awcmjili.png" />
                  <p className="md:my-0 text-sm my-1">JILI</p>
                </button>
              </div>
            </div>
          )}

          {tab == 4004 && (
            <div>
              <h2 className="text-gray-600 text-sm font-semibold border-l-4 border-[var(--light-header)] uppercase  my-2.5 px-2 lg:ml-0 ml-2">Table</h2>
              <div className="md:flex grid sm:grid-cols-4 grid-cols-3 justify-start items-center overflow-x-auto md:gap-2 gap-1 px-1 py-[10px]">
                <button
                  onClick={() => handleProviderClick("table", "JiLi")}
                  className={`bg-secondary text-black flex flex-col justify-center items-center bg-white w-[147px] h-[77px] md:text-[12px] text-[9px] px-2 py-1 rounded outline-none`}
                >
                  <img alt="" className="w-[40px] h-[40px]" src="/assets/dashboard/provider-awcmjili.png" />
                  <p className="md:my-0 text-sm my-1">JILI</p>
                </button>
              </div>
            </div>
          )}

          {tab == 4005 && (
            <div>
              <h2 className="text-gray-600 text-sm font-semibold border-l-4 border-[var(--light-header)] uppercase  my-2.5 px-2 lg:ml-0 ml-2">crash</h2>
              <div className="md:flex grid sm:grid-cols-4 grid-cols-3 justify-start items-center overflow-x-auto md:gap-2 gap-1 px-1 py-[10px]">
                <button
                  onClick={() => handleProviderClick("crash", "JiLi")}
                  className={`bg-secondary text-black flex flex-col justify-center items-center bg-white w-[147px] h-[77px] md:text-[12px] text-[9px] px-2 py-1 rounded outline-none`}
                >
                  <img alt="" className="w-[40px] h-[40px]" src="/assets/dashboard/provider-awcmjili.png" />
                  <p className="md:my-0 text-sm my-1">JILI</p>
                </button>
              </div>
            </div>
          )}

          {tab == 4006 && (
            <div>
              <h2 className="text-gray-600 text-sm font-semibold border-l-4 border-[var(--light-header)] uppercase  my-2.5 px-2 lg:ml-0 ml-2">fishing</h2>
              <div className="md:flex grid sm:grid-cols-4 grid-cols-3 justify-start items-center overflow-x-auto md:gap-2 gap-1 px-1 py-[10px]">
                <button
                  onClick={() => handleProviderClick("fishing", "JiLi")}
                  className={`bg-secondary text-black flex flex-col justify-center items-center bg-white w-[147px] h-[77px] md:text-[12px] text-[9px] px-2 py-1 rounded outline-none`}
                >
                  <img alt="" className="w-[40px] h-[40px]" src="/assets/dashboard/provider-awcmjili.png" />
                  <p className="md:my-0 text-sm my-1">JILI</p>
                </button>
              </div>
            </div>
          )}

          {tab == 4007 && (
            <div>
              <h2 className="text-gray-600 text-sm font-semibold border-l-4 border-[var(--light-header)] uppercase  my-2.5 px-2 lg:ml-0 ml-2">Arcade</h2>
              <div className="md:flex grid sm:grid-cols-4 grid-cols-3 justify-start items-center overflow-x-auto md:gap-2 gap-1 px-1 py-[10px]">
                <button
                  onClick={() => handleProviderClick("Arcade", "JiLi")}
                  className={`bg-secondary text-black flex flex-col justify-center items-center bg-white w-[147px] h-[77px] md:text-[12px] text-[9px] px-2 py-1 rounded outline-none`}
                >
                  <img alt="" className="w-[40px] h-[40px]" src="/assets/dashboard/provider-awcmjili.png" />
                  <p className="md:my-0 text-sm my-1">JILI</p>
                </button>
              </div>
            </div>
          )}

          {tab == 4008 && (
            <div>
              <h2 className="text-gray-600 text-sm font-semibold border-l-4 border-[var(--light-header)] uppercase  my-2.5 px-2 lg:ml-0 ml-2">lottery</h2>
              <div className="md:flex grid sm:grid-cols-4 grid-cols-3 justify-start items-center overflow-x-auto md:gap-2 gap-1 px-1 py-[10px]">
                <button
                  onClick={() => handleProviderClick("lottery", "JiLi")}
                  className={`bg-secondary text-black flex flex-col justify-center items-center bg-white w-[147px] h-[77px] md:text-[12px] text-[9px] px-2 py-1 rounded outline-none`}
                >
                  <img alt="" className="w-[40px] h-[40px]" src="/assets/dashboard/provider-awcmjili.png" />
                  <p className="md:my-0 text-sm my-1">JILI</p>
                </button>
              </div>
            </div>
          )}

          {/* {tab == 4005 && (
            <div className="">
              <h2 className="text-gray-600 text-sm font-semibold border-l-4 border-[var(--light-header)] uppercase  my-2.5 px-2 lg:ml-0 ml-2">crash</h2>
              <div className="md:flex grid sm:grid-cols-5 grid-cols-4 justify-start items-center overflow-x-auto md:gap-2 gap-1 px-1 py-[10px]">
                {slotData?.map((game) => (
                  <button
                    key={game.eventId}
                    onClick={() => navigate(`/iframe-casino-new/${game.provider}/${game.iframeID}`)}
                    className={`bg-secondary text-black flex flex-col justify-center items-center bg-white sm:w-[147px] w-[90px] h-[77px] md:text-[12px] text-[9px] px-2 py-1 rounded outline-none `}>
                    <img alt={game.provider} className="w-[40px] h-[40px]" src={game.pathName} />
                    <p className="md:my-0 text-sm my-1 whitespace-nowrap ">{game.provider}</p>
                  </button>
                ))}
              </div>
            </div>
          )} */}


          {/* {
            (tab !== 4001 && tab !== 4002 && tab !== 4003 && tab !== 4004 && tab !== 4005 && tab !== 4006 && tab !== 4007 && tab !== 4008) && (
              isLoading ?
                <div className="text-[var(--dark-header)]  flex justify-center items-center py-2 animate-spin">
                  <AiOutlineLoading3Quarters size={20} />
                </div>
                :
                <div>
                  <h2 className="text-gray-600 uppercase text-sm font-semibold border-l-4 border-[var(--light-header)]   my-2.5 px-2 lg:ml-0 ml-2">{tabData?.find(data => data?.id === tab)?.name}</h2>
                  <div className="grid md:grid-cols-7 sm:grid-cols-5 grid-cols-3 justify-start items-center overflow-hidden md:gap-2 gap-1 px-1 py-[10px]">
                    {apiData?.length > 0 ? (
                      apiData?.map((item, index) => (
                        <button
                          key={index}
                          onClick={() => window.location.href = `/iframe-casino-new/${item?.provider_name}/${item?.game_id}`}
                          className={`bg-secondary text-black flex flex-col justify-center items-center md:w-[150px] h-[77px] md:text-[12px] text-[9px] rounded outline-none `}>
                          <img alt={item?.provider_name} className="w-[150px] h-[77px]" src={item?.Image} />
                        </button>
                      ))
                    ) : (
                      <p className="text-center col-span-full text-gray-500">No data available. Click a tab to load content.</p>
                    )}
                  </div>
                </div>
            )
          } */}

        </div>
      </div>
    </section>
  );
}

export default DashboardInplay;

const tabData = [
  {
    id: 4001,
    name: "Sports",
    icon: "/assets/dashboard/icon-sport.png",
    payload: 'Sports'
  },

  {
    id: 4002,
    name: "Casino",
    icon: "/assets/dashboard/icon-casino.png"
  },

  {
    id: 4003,
    name: "Slots",
    icon: "/assets/dashboard/icon-slot.png"
  },

  {
    id: 4004,
    name: "Table",
    icon: "/assets/dashboard/icon-table.png"
  },

  {
    id: 4005,
    name: "Crash",
    icon: "/assets/dashboard/icon-crash.png"
  },

  {
    id: 4006,
    name: "Fishing",
    icon: "/assets/dashboard/icon-fish.png"
  },

  {
    id: 4007,
    name: "Arcade",
    icon: "/assets/dashboard/icon-arcade.png"
  },

  {
    id: 4008,
    name: "Lottery",
    icon: "/assets/dashboard/icon-lottery.png"
  },
  // {
  //   id: 5000,
  //   icon: "/casinoimages/22.png",
  //   name: 'baccarat',
  // },
  // {
  //   id: 5001,
  //   name: "Casino",
  //   payload: "live-casino",
  //   icon: "/casinoimages/111.png"
  // },
  // {
  //   id: 5002,
  //   name: "Slots",
  //   payload: "JILI",
  //   icon: "/casinoimages/slot.png"
  // },
  // {
  //   id: 5003,
  //   icon: "/casinoimages/20.png",
  //   name: 'teen-patti',
  //   payload: 'teen-patti'
  // },
  // {
  //   id: 5004,
  //   icon: "/casinoimages/27.png",
  //   name: 'lucky7',
  //   payload: 'lucky7'
  // },
  // {
  //   id: 5005,
  //   icon: "/casinoimages/23.png",
  //   name: 'dragon-tiger',
  //   payload: 'dragon-tiger',
  // },
  // {
  //   id: 5006,
  //   icon: "/casinoimages/22.png",
  //   name: 'baccarat',
  //   payload: 'baccarat'
  // },
  // {
  //   id: 5007,
  //   icon: "/casinoimages/26.png",
  //   name: 'andar-bahar',
  //   payload: 'andar-bahar'
  // },
  // {
  //   id: 5008,
  //   icon: "/casinoimages/21.png",
  //   name: 'poker',
  //   payload: 'poker'
  // },
  // {
  //   id: 5009,
  //   icon: "/casinoimages/32.png",
  //   name: 'Bollywood',
  // },
  // {
  //   id: 5010,
  //   icon: "/casinoimages/73.png",
  //   name: 'Region',
  // },
  // {
  //   id: 5011,
  //   icon: "/casinoimages/23.png",
  //   name: 'holdem',
  //   payload: 'holdem'
  // },
];

export const casinoData = [
  {
    eventId: "600112",
    provider: "JiLi",
    shortImgPath: "/assets/dashboard/provider-awcmsg.png",
    shortName: "teen20",
    title: "20 20 teenpatti",
    pathName: "150033.webp",
    section2: "liveCasino",
    casinoSort: "marketWhite",
  },
  {
    eventId: "100061",
    provider: "EZUGI",
    shortImgPath: "/assets/dashboard/provider-awcmladyluck.png",
    shortName: "dt20",
    title: "20 20 dragon tiger",
    pathName: "3926.webp",
    section: "indian",
    section2: "liveCasino",
    casinoSort: "marketWhite",
  },
  // {
  //   pathName: "3935.webp",
  //   section: "indian",
  //   section2: "liveCasino",
  //   shortImgPath: "/assets/dashboard/icon-casino.png",
  //   title: "Ander Bahar",
  //   eventId: "3043",
  //   shortName: "abj",
  //   img: "/images/casino/dt20.jpg",
  //   casinoSort: "marketWhite",
  //   iframeID: 225014,
  //   provider: "DC"
  // },
  {
    eventId: "220011",
    provider: "DC",
    shortImgPath: "/assets/dashboard/provider-awcmsg.png",
    shortName: "teen",
    title: "teenpatti 1-day",
    pathName: "4361.webp",
    section: "trending",
    section2: "liveCasino",
    casinoSort: "marketWhite",
  },
  {
    eventId: "201149",
    provider: "DC",
    shortImgPath: "/assets/dashboard/provider-ka.png",
    shortName: "lucky7eu",
    title: "lucky 7 - b",
    pathName: "4364.webp",
    section: "trending",
    section2: "liveCasino",
    casinoSort: "marketWhite",
  },
  {
    eventId: "425029",
    provider: "KINGMIDAS",
    shortImgPath: "/assets/dashboard/provider-awcmpt.png",
    shortName: "card32-a",
    title: "32 cards a",
    pathName: "150010.webp",
    section2: "liveCasino",
    casinoSort: "marketWhite",
  },
  // {
  //   eventId: "500006",
  //   provider: "SUNO",
  //   shortImgPath: "/assets/dashboard/provider-awcmpt.png",
  //   shortName: "card32eu",
  //   title: "32 cards b",
  //   pathName: "150010.webp",
  //   section2: "liveCasino",
  //   casinoSort: "marketWhite",
  // },
  // {
  //   eventId: "870299",
  //   provider: "EVOLUTION",
  //   shortImgPath: "/assets/dashboard/provider-awcmladyluck.png",
  //   shortName: "dt202",
  //   title: "20-20 Dargon tiger 2",
  //   pathName: "900027.webp",
  //   section2: "liveCasino",
  //   casinoSort: "marketWhite",
  // },
  {
    eventId: "226718",
    provider: "DC",
    shortImgPath: "/assets/dashboard/provider-mg.png",
    shortName: "aaa",
    title: "amar akbar anthony",
    pathName: "150014.webp",
    section2: "liveCasino",
    casinoSort: "marketWhite",
  },
  {
    eventId: "226718",
    provider: "DC",
    shortImgPath: "/assets/dashboard/provider-awcmsg.png",
    shortName: "teen9",
    title: "teenpatti test",
    pathName: "150023.webp",
    section2: "liveCasino",
    casinoSort: "marketWhite",
  },
  {
    eventId: "900010",
    provider: "RG",
    shortImgPath: "/assets/dashboard/provider-wm.png",
    shortName: "worli",
    title: "worli matka",
    pathName: "3920.webp",
    section2: "liveCasino",
    section: "indian",
    casinoSort: "marketWhite",
  },
];

export const slotsData = [
  // {
  //   pathName: "/assets/dashboard/provider-awcmpt.png",
  //   section: "providers",
  //   iframeID: 100001,
  //   provider: "EZUGI",
  //   link: 'iframe-casino'

  // },
  {
    pathName: "/assets/dashboard/provider-awcmjili.png",
    section: "providers",
    iframeID: 600000,
    provider: "JILLI",
    link: 'iframe-casino'
  },
  // {
  //   pathName: "/assets/dashboard/provider-mg.png",

  //   section: "providers",
  //   iframeID: "SPB-aviator",
  //   provider: "Qtech",
  //   link: 'iframe-qtech-casino'
  // },
  // {
  //   pathName: "/assets/dashboard/soccer.png",
  //   section: "providers",
  //   iframeID: 201153,
  //   provider: "Wheel",
  //   link: 'iframe-casino'
  // },
  // {
  //   pathName: "/assets/dashboard/provider-evo.png",
  //   section: "providers",
  //   iframeID: 200215,
  //   provider: "Evolution",
  //   link: 'iframe-casino'
  // },
  // {
  //   pathName: "/assets/dashboard/provider-jdbaspribe.png",
  //   section: "providers",
  //   iframeID: 201206,
  //   provider: "AVIATOR",
  //   link: 'iframe-casino'
  // },
  // {
  //   pathName: "/assets/dashboard/provider-rg.png",
  //   section: "providers",
  //   iframeID: 900000,
  //   provider: " Royal Gaming",
  //   link: 'iframe-casino'
  // },
  // {
  //   pathName: "/assets/dashboard/provider-awcmsexy.png",
  //   section: "providers",
  //   iframeID: 400000,
  //   provider: "AE SEXY",
  //   link: 'iframe-casino'
  // },
  // {
  //   pathName: "/assets/dashboard/provider-supernova.png",
  //   section: "providers",
  //   iframeID: 500001,
  //   provider: "Supernova",
  //   link: 'iframe-casino'
  // },

];

export const slotData = [
  {
    pathName: "/assets/dashboard/provider-jdbaspribe.png",
    section: "providers",
    iframeID: 201206,
    provider: "AVIATOR",
    link: 'iframe-casino'
  },
  {
    pathName: "/assets/dashboard/provider-nextspin.png",
    section: "providers",
    iframeID: 204111,
    provider: "JETX3",
    link: 'iframe-casino'

  },
  {
    pathName: "/assets/dashboard/provider-awcmjili.png",
    section: "providers",
    iframeID: 204112,
    provider: "BALOON",
    link: 'iframe-casino'
  },
  {
    pathName: "/assets/dashboard/provider-awcmfc.png",
    section: "providers",
    iframeID: "SPB-aviator",
    provider: "FOOTBALLX",
    link: 'iframe-qtech-casino'
  },
  {
    pathName: "/assets/dashboard/provider-supernova.png",
    section: "providers",
    iframeID: 201153,
    provider: "Wheel",
    link: 'iframe-casino'
  },
  {
    pathName: "/assets/dashboard/provider-evo.png",
    section: "providers",
    iframeID: 200215,
    provider: "Evolution",
    link: 'iframe-casino'
  },

  {
    pathName: "/assets/dashboard/icon-sbov2.png",
    section: "providers",
    iframeID: 204113,
    provider: " CRICKETX",
    link: 'iframe-casino'
  },
  {
    pathName: "/assets/dashboard/provider-awcmsexy.png",
    section: "providers",
    iframeID: 204141,
    provider: "MULTI HOT 5",
    link: 'iframe-casino'
  },
  {
    pathName: "/assets/dashboard/provider-awcmyl.png",
    section: "providers",
    iframeID: 225358,
    provider: "BLOCKS",
    link: 'iframe-casino'
  },

];